/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.Flow;
import javax.net.ssl.SSLContext;
import org.apache.nifi.web.client.StandardHttpEntityHeaders;
import org.apache.nifi.web.client.StandardHttpResponseEntity;
import org.apache.nifi.web.client.api.HttpRequestBodySpec;
import org.apache.nifi.web.client.api.HttpRequestHeadersSpec;
import org.apache.nifi.web.client.api.HttpRequestMethod;
import org.apache.nifi.web.client.api.HttpRequestUriSpec;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.StandardHttpRequestMethod;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.api.WebClientServiceException;
import org.apache.nifi.web.client.proxy.ProxyContext;
import org.apache.nifi.web.client.redirect.RedirectHandling;
import org.apache.nifi.web.client.ssl.SSLContextProvider;
import org.apache.nifi.web.client.ssl.StandardSSLContextProvider;
import org.apache.nifi.web.client.ssl.TlsContext;

public class StandardWebClientService
implements WebClientService,
Closeable {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final SSLContextProvider sslContextProvider = new StandardSSLContextProvider();
    private HttpClient httpClient = HttpClient.newBuilder().build();
    private Duration connectTimeout;
    private Duration readTimeout;
    private Duration writeTimeout;
    private RedirectHandling redirectHandling;
    private ProxyContext proxyContext;
    private TlsContext tlsContext;

    public void setConnectTimeout(Duration connectTimeout) {
        Objects.requireNonNull(connectTimeout, "Connect Timeout required");
        this.connectTimeout = connectTimeout;
        this.httpClient = this.buildHttpClient();
    }

    public void setReadTimeout(Duration readTimeout) {
        Objects.requireNonNull(readTimeout, "Read Timeout required");
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        Objects.requireNonNull(writeTimeout, "Write Timeout required");
        this.writeTimeout = writeTimeout;
    }

    public void setProxyContext(ProxyContext proxyContext) {
        Objects.requireNonNull(proxyContext, "Proxy Context required");
        Objects.requireNonNull(proxyContext.getProxy(), "Proxy required");
        this.proxyContext = proxyContext;
        this.httpClient = this.buildHttpClient();
    }

    public void setRedirectHandling(RedirectHandling redirectHandling) {
        Objects.requireNonNull(redirectHandling, "Redirect Handling required");
        this.redirectHandling = redirectHandling;
        this.httpClient = this.buildHttpClient();
    }

    public void setTlsContext(TlsContext tlsContext) {
        Objects.requireNonNull(tlsContext, "TLS Context required");
        Objects.requireNonNull(tlsContext.getTrustManager(), "Trust Manager required");
        this.tlsContext = tlsContext;
        this.httpClient = this.buildHttpClient();
    }

    public HttpRequestUriSpec method(HttpRequestMethod httpRequestMethod) {
        Objects.requireNonNull(httpRequestMethod, "HTTP Request Method required");
        return new StandardHttpRequestUriSpec(httpRequestMethod);
    }

    public HttpRequestUriSpec delete() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.DELETE);
    }

    public HttpRequestUriSpec get() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.GET);
    }

    public HttpRequestUriSpec head() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.HEAD);
    }

    public HttpRequestUriSpec patch() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.PATCH);
    }

    public HttpRequestUriSpec post() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.POST);
    }

    public HttpRequestUriSpec put() {
        return this.method((HttpRequestMethod)StandardHttpRequestMethod.PUT);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    private HttpClient buildHttpClient() {
        Proxy proxy;
        SocketAddress proxyAddress;
        HttpClient.Builder builder = HttpClient.newBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.tlsContext != null) {
            SSLContext sslContext = sslContextProvider.getSslContext(this.tlsContext);
            builder.sslContext(sslContext);
        }
        if (RedirectHandling.FOLLOWED == this.redirectHandling) {
            builder.followRedirects(HttpClient.Redirect.ALWAYS);
        } else if (RedirectHandling.IGNORED == this.redirectHandling) {
            builder.followRedirects(HttpClient.Redirect.NEVER);
        }
        if (this.proxyContext != null && (proxyAddress = (proxy = this.proxyContext.getProxy()).address()) instanceof InetSocketAddress) {
            InetSocketAddress proxySocketAddress = (InetSocketAddress)proxyAddress;
            ProxySelector proxySelector = ProxySelector.of(proxySocketAddress);
            builder.proxy(proxySelector);
            Optional<String> proxyUsername = this.proxyContext.getUsername();
            if (proxyUsername.isPresent()) {
                ProxyPasswordAuthenticator passwordAuthenticator = this.getProxyPasswordAuthenticator(proxyUsername.get());
                builder.authenticator(passwordAuthenticator);
            }
        }
        return builder.build();
    }

    private ProxyPasswordAuthenticator getProxyPasswordAuthenticator(String proxyUsername) {
        Optional<String> proxyPassword = this.proxyContext.getPassword();
        if (!proxyPassword.isPresent()) {
            throw new IllegalArgumentException("Proxy Password not configured");
        }
        char[] password = proxyPassword.get().toCharArray();
        PasswordAuthentication passwordAuthentication = new PasswordAuthentication(proxyUsername, password);
        return new ProxyPasswordAuthenticator(passwordAuthentication);
    }

    class StandardHttpRequestUriSpec
    implements HttpRequestUriSpec {
        private final HttpRequestMethod httpRequestMethod;

        StandardHttpRequestUriSpec(HttpRequestMethod httpRequestMethod) {
            this.httpRequestMethod = httpRequestMethod;
        }

        public HttpRequestBodySpec uri(URI uri) {
            Objects.requireNonNull(uri, "URI required");
            return new StandardHttpRequestBodySpec(this.httpRequestMethod, uri);
        }
    }

    static class ProxyPasswordAuthenticator
    extends Authenticator {
        private final PasswordAuthentication passwordAuthentication;

        ProxyPasswordAuthenticator(PasswordAuthentication passwordAuthentication) {
            this.passwordAuthentication = passwordAuthentication;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }
    }

    class StandardHttpRequestBodySpec
    implements HttpRequestBodySpec {
        private static final long UNKNOWN_CONTENT_LENGTH = -1L;
        private final HttpRequestMethod httpRequestMethod;
        private final URI uri;
        private final HttpRequest.Builder requestBuilder;
        private long contentLength = -1L;
        private InputStream body;

        StandardHttpRequestBodySpec(HttpRequestMethod httpRequestMethod, URI uri) {
            this.httpRequestMethod = httpRequestMethod;
            this.uri = uri;
            this.requestBuilder = HttpRequest.newBuilder();
        }

        public HttpRequestHeadersSpec body(InputStream body, OptionalLong contentLength) {
            this.body = Objects.requireNonNull(body, "Body required");
            this.contentLength = Objects.requireNonNull(contentLength, "Content Length required").orElse(-1L);
            return this;
        }

        public HttpRequestHeadersSpec body(String body) {
            byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
            return this.body(new ByteArrayInputStream(bytes), OptionalLong.of(bytes.length));
        }

        public HttpRequestBodySpec header(String headerName, String headerValue) {
            Objects.requireNonNull(headerName, "Header Name required");
            Objects.requireNonNull(headerValue, "Header Value required");
            this.requestBuilder.header(headerName, headerValue);
            return this;
        }

        public HttpResponseEntity retrieve() {
            HttpRequest request = this.getRequest();
            HttpResponse<InputStream> response = this.getResponse(request);
            int code = response.statusCode();
            HttpHeaders responseHeaders = response.headers();
            StandardHttpEntityHeaders headers = new StandardHttpEntityHeaders(responseHeaders.map());
            InputStream responseBody = response.body();
            InputStream body = responseBody == null ? new ByteArrayInputStream(EMPTY_BYTES) : responseBody;
            return new StandardHttpResponseEntity(code, headers, body, response.uri());
        }

        private HttpResponse<InputStream> getResponse(HttpRequest request) {
            try {
                return StandardWebClientService.this.httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            }
            catch (IOException e) {
                throw new WebClientServiceException("Request execution failed", (Throwable)e, this.uri, this.httpRequestMethod);
            }
            catch (InterruptedException e) {
                throw new WebClientServiceException("Request execution interrupted", (Throwable)e, this.uri, this.httpRequestMethod);
            }
        }

        private HttpRequest getRequest() {
            if (StandardWebClientService.this.writeTimeout != null) {
                this.requestBuilder.timeout(StandardWebClientService.this.writeTimeout);
            }
            if (StandardWebClientService.this.readTimeout != null) {
                this.requestBuilder.timeout(StandardWebClientService.this.readTimeout);
            }
            HttpRequest.BodyPublisher bodyPublisher = this.getBodyPublisher();
            return this.requestBuilder.method(this.httpRequestMethod.getMethod(), bodyPublisher).uri(this.uri).build();
        }

        private HttpRequest.BodyPublisher getBodyPublisher() {
            HttpRequest.BodyPublisher bodyPublisher;
            if (this.body == null) {
                bodyPublisher = HttpRequest.BodyPublishers.noBody();
            } else {
                final HttpRequest.BodyPublisher inputStreamPublisher = HttpRequest.BodyPublishers.ofInputStream(() -> this.body);
                bodyPublisher = new HttpRequest.BodyPublisher(){

                    @Override
                    public long contentLength() {
                        return StandardHttpRequestBodySpec.this.contentLength;
                    }

                    @Override
                    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
                        inputStreamPublisher.subscribe(subscriber);
                    }
                };
            }
            return bodyPublisher;
        }
    }
}

