/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.web.client.api.HttpContentType;
import org.apache.nifi.web.client.api.MultipartFormDataStreamBuilder;

public class StandardMultipartFormDataStreamBuilder
implements MultipartFormDataStreamBuilder {
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition: form-data; name=\"%s\"";
    private static final String CONTENT_DISPOSITION_FILE_HEADER = "Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"";
    private static final String CONTENT_TYPE_HEADER = "Content-Type: %s";
    private static final Pattern ALLOWED_NAME_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final String CARRIAGE_RETURN_LINE_FEED = "\r\n";
    private static final String BOUNDARY_SEPARATOR = "--";
    private static final String BOUNDARY_FORMAT = "FormDataBoundary-%s";
    private static final String MULTIPART_FORM_DATA_FORMAT = "multipart/form-data; boundary=\"%s\"";
    private static final Charset HEADERS_CHARACTER_SET = StandardCharsets.US_ASCII;
    private final String boundary = "FormDataBoundary-%s".formatted(UUID.randomUUID());
    private final List<Part> parts = new ArrayList<Part>();

    @Override
    public InputStream build() {
        if (this.parts.isEmpty()) {
            throw new IllegalStateException("Parts required");
        }
        ArrayList<InputStream> streams = new ArrayList<InputStream>();
        for (int index = 0; index < this.parts.size(); ++index) {
            Part part = this.parts.get(index);
            String boundaryPrefix = this.getBoundaryPrefix(index);
            streams.add(new ByteArrayInputStream(boundaryPrefix.getBytes(HEADERS_CHARACTER_SET)));
            String partHeaders = this.getPartHeaders(part);
            streams.add(new ByteArrayInputStream(partHeaders.getBytes(HEADERS_CHARACTER_SET)));
            streams.add(part.inputStream);
        }
        streams.add(new ByteArrayInputStream(this.getFooter().getBytes(HEADERS_CHARACTER_SET)));
        Enumeration enumeratedStreams = Collections.enumeration(streams);
        return new SequenceInputStream(enumeratedStreams);
    }

    @Override
    public HttpContentType getHttpContentType() {
        String contentType = MULTIPART_FORM_DATA_FORMAT.formatted(this.boundary);
        return new MultipartHttpContentType(contentType);
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, HttpContentType httpContentType, InputStream inputStream) {
        return this.addPartInternal(name, null, httpContentType, inputStream);
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, String fileName, HttpContentType httpContentType, InputStream inputStream) {
        String sanitizedFileName = this.sanitizeFileName(fileName);
        return this.addPartInternal(name, sanitizedFileName, httpContentType, inputStream);
    }

    private MultipartFormDataStreamBuilder addPartInternal(String name, String fileName, HttpContentType httpContentType, InputStream inputStream) {
        Objects.requireNonNull(name, "Name required");
        Objects.requireNonNull(httpContentType, "Content Type required");
        Objects.requireNonNull(inputStream, "Input Stream required");
        Matcher nameMatcher = ALLOWED_NAME_PATTERN.matcher(name);
        if (!nameMatcher.matches()) {
            throw new IllegalArgumentException("Name contains characters outside of ASCII character set");
        }
        Part part = new Part(name, fileName, httpContentType, inputStream);
        this.parts.add(part);
        return this;
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, HttpContentType httpContentType, byte[] bytes) {
        Objects.requireNonNull(bytes, "Byte Array required");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return this.addPart(name, httpContentType, inputStream);
    }

    @Override
    public MultipartFormDataStreamBuilder addPart(String name, String fileName, HttpContentType httpContentType, byte[] bytes) {
        Objects.requireNonNull(bytes, "Byte Array required");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return this.addPart(name, fileName, httpContentType, inputStream);
    }

    private String getPartHeaders(Part part) {
        StringBuilder headersBuilder = new StringBuilder();
        String contentDispositionHeader = this.getContentDispositionHeader(part);
        headersBuilder.append(contentDispositionHeader);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        String contentType = part.httpContentType.getContentType();
        String contentTypeHeader = CONTENT_TYPE_HEADER.formatted(contentType);
        headersBuilder.append(contentTypeHeader);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        headersBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        return headersBuilder.toString();
    }

    private String getBoundaryPrefix(int index) {
        StringBuilder prefixBuilder = new StringBuilder();
        if (index > 0) {
            prefixBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        }
        prefixBuilder.append(BOUNDARY_SEPARATOR);
        prefixBuilder.append(this.boundary);
        prefixBuilder.append(CARRIAGE_RETURN_LINE_FEED);
        return prefixBuilder.toString();
    }

    private String getFooter() {
        return "\r\n--" + this.boundary + BOUNDARY_SEPARATOR;
    }

    private String getContentDispositionHeader(Part part) {
        if (part.fileName == null) {
            return CONTENT_DISPOSITION_HEADER.formatted(part.name);
        }
        return CONTENT_DISPOSITION_FILE_HEADER.formatted(part.name, part.fileName);
    }

    private String sanitizeFileName(String fileName) {
        if (fileName == null || fileName.isBlank()) {
            throw new IllegalArgumentException("File Name required");
        }
        String sanitized = fileName;
        Matcher fileNameMatcher = ALLOWED_NAME_PATTERN.matcher(sanitized);
        if (!fileNameMatcher.matches()) {
            throw new IllegalArgumentException("File Name contains characters outside of ASCII character set");
        }
        return sanitized;
    }

    private record Part(String name, String fileName, HttpContentType httpContentType, InputStream inputStream) {
    }

    private record MultipartHttpContentType(String contentType) implements HttpContentType
    {
        @Override
        public String getContentType() {
            return this.contentType;
        }
    }
}

