/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.query;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.search.query.SearchQuery;

public class MapBasedSearchQuery
implements SearchQuery {
    private final String term;
    private final Map<String, String> filters = new HashMap();
    private final NiFiUser user;
    private final ProcessGroup rootGroup;
    private final ProcessGroup activeGroup;

    public MapBasedSearchQuery(String term, Map<String, String> filters, NiFiUser user, ProcessGroup rootGroup, ProcessGroup activeGroup) {
        this.term = term;
        this.filters.putAll(filters);
        this.user = user;
        this.rootGroup = rootGroup;
        this.activeGroup = activeGroup;
    }

    public String getTerm() {
        return this.term;
    }

    public boolean hasFilter(String filterName) {
        return this.filters.containsKey(filterName);
    }

    public String getFilter(String filterName) {
        return (String)this.filters.get(filterName);
    }

    public NiFiUser getUser() {
        return this.user;
    }

    public ProcessGroup getRootGroup() {
        return this.rootGroup;
    }

    public ProcessGroup getActiveGroup() {
        return this.activeGroup;
    }
}

