/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.configuration;

import java.util.List;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.web.controller.ControllerSearchService;
import org.apache.nifi.web.search.ComponentMatcherFactory;
import org.apache.nifi.web.search.attributematchers.BackPressureMatcher;
import org.apache.nifi.web.search.attributematchers.BasicMatcher;
import org.apache.nifi.web.search.attributematchers.BundleMatcher;
import org.apache.nifi.web.search.attributematchers.ConnectionMatcher;
import org.apache.nifi.web.search.attributematchers.ConnectionRelationshipMatcher;
import org.apache.nifi.web.search.attributematchers.ConnectivityMatcher;
import org.apache.nifi.web.search.attributematchers.ControllerServiceNodeMatcher;
import org.apache.nifi.web.search.attributematchers.ExecutionMatcher;
import org.apache.nifi.web.search.attributematchers.ExpirationMatcher;
import org.apache.nifi.web.search.attributematchers.ExtendedMatcher;
import org.apache.nifi.web.search.attributematchers.LabelMatcher;
import org.apache.nifi.web.search.attributematchers.ParameterContextMatcher;
import org.apache.nifi.web.search.attributematchers.ParameterMatcher;
import org.apache.nifi.web.search.attributematchers.ParameterProviderNodeMatcher;
import org.apache.nifi.web.search.attributematchers.PortScheduledStateMatcher;
import org.apache.nifi.web.search.attributematchers.PrioritiesMatcher;
import org.apache.nifi.web.search.attributematchers.ProcessGroupMatcher;
import org.apache.nifi.web.search.attributematchers.ProcessorMetadataMatcher;
import org.apache.nifi.web.search.attributematchers.PropertyMatcher;
import org.apache.nifi.web.search.attributematchers.RelationshipMatcher;
import org.apache.nifi.web.search.attributematchers.RemoteProcessGroupMatcher;
import org.apache.nifi.web.search.attributematchers.ScheduledStateMatcher;
import org.apache.nifi.web.search.attributematchers.SchedulingMatcher;
import org.apache.nifi.web.search.attributematchers.SearchableMatcher;
import org.apache.nifi.web.search.attributematchers.TargetUriMatcher;
import org.apache.nifi.web.search.attributematchers.TransmissionStatusMatcher;
import org.apache.nifi.web.search.resultenrichment.ComponentSearchResultEnricherFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebSearchConfiguration {
    private final Authorizer authorizer;
    private final FlowController flowController;

    public WebSearchConfiguration(Authorizer authorizer, FlowController flowController) {
        this.authorizer = authorizer;
        this.flowController = flowController;
    }

    @Bean
    public ComponentSearchResultEnricherFactory resultEnricherFactory() {
        ComponentSearchResultEnricherFactory factory = new ComponentSearchResultEnricherFactory();
        factory.setAuthorizer(this.authorizer);
        return factory;
    }

    @Bean
    public ControllerSearchService controllerSearchService() {
        ControllerSearchService controllerSearchService = new ControllerSearchService();
        controllerSearchService.setAuthorizer(this.authorizer);
        controllerSearchService.setFlowController(this.flowController);
        controllerSearchService.setResultEnricherFactory(this.resultEnricherFactory());
        ComponentMatcherFactory factory = new ComponentMatcherFactory();
        controllerSearchService.setMatcherForConnection(factory.getInstanceForConnection(List.of(new ConnectionMatcher(), new ConnectionRelationshipMatcher(), new PrioritiesMatcher(), new ExpirationMatcher(), new BackPressureMatcher(), new ConnectivityMatcher())));
        controllerSearchService.setMatcherForControllerServiceNode(factory.getInstanceForControllerServiceNode(List.of(new ControllerServiceNodeMatcher(), new BundleMatcher(), new PropertyMatcher())));
        controllerSearchService.setMatcherForFunnel(factory.getInstanceForConnectable(List.of(new BasicMatcher())));
        controllerSearchService.setMatcherForProcessGroup(factory.getInstanceForProcessGroup(List.of(new ProcessGroupMatcher())));
        controllerSearchService.setMatcherForRemoteProcessGroup(factory.getInstanceForRemoteProcessGroup(List.of(new RemoteProcessGroupMatcher(), new TargetUriMatcher(), new TransmissionStatusMatcher())));
        controllerSearchService.setMatcherForLabel(factory.getInstanceForLabel(List.of(new LabelMatcher())));
        controllerSearchService.setMatcherForParameter(factory.getInstanceForParameter(List.of(new ParameterMatcher())));
        controllerSearchService.setMatcherForParameterContext(factory.getInstanceForParameterContext(List.of(new ParameterContextMatcher())));
        controllerSearchService.setMatcherForParameterProviderNode(factory.getInstanceForParameterProviderNode(List.of(new ParameterProviderNodeMatcher(), new PropertyMatcher())));
        controllerSearchService.setMatcherForPort(factory.getInstanceForConnectable(List.of(new ExtendedMatcher(), new PortScheduledStateMatcher())));
        SearchableMatcher searchableMatcher = new SearchableMatcher();
        searchableMatcher.setFlowController(this.flowController);
        controllerSearchService.setMatcherForProcessor(factory.getInstanceForConnectable(List.of(new ExtendedMatcher(), new SchedulingMatcher(), new ExecutionMatcher(), new ScheduledStateMatcher(), new RelationshipMatcher(), new ProcessorMetadataMatcher(), new BundleMatcher(), new PropertyMatcher(), searchableMatcher)));
        return controllerSearchService;
    }
}

