/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.nifi.cluster.manager.exception.NoConnectedNodesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NoConnectedNodesExceptionMapper
implements ExceptionMapper<NoConnectedNodesException> {
    private static final Logger logger = LoggerFactory.getLogger(NoConnectedNodesException.class);

    public Response toResponse(NoConnectedNodesException ex) {
        logger.info("Cluster failed processing request: {}. Returning {} response.", (Object)ex, (Object)Response.Status.INTERNAL_SERVER_ERROR);
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"Action was performed, but no nodes are connected.").type("text/plain").build();
    }
}

