/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AccessDeniedExceptionMapper
implements ExceptionMapper<AccessDeniedException> {
    private static final Logger logger = LoggerFactory.getLogger(AccessDeniedExceptionMapper.class);

    public Response toResponse(AccessDeniedException exception) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Response.Status status = user == null || user.isAnonymous() ? Response.Status.UNAUTHORIZED : Response.Status.FORBIDDEN;
        String identity = user == null ? "<no user found>" : user.toString();
        logger.info("{} does not have permission to access the requested resource. {} Returning {} response.", new Object[]{identity, exception.getMessage(), status});
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)status).entity((Object)String.format("%s Contact the system administrator.", exception.getMessage())).type("text/plain").build();
    }
}

