/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.flow.ExecutionEngine;
import org.apache.nifi.flow.VersionedFlowCoordinates;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryUtils;
import org.apache.nifi.registry.flow.FlowSnapshotContainer;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FlowUpdateResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ProcessGroupResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.ParameterContextHandlingStrategy;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessGroupReplaceRequestDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.CopySnippetRequestEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowComparisonEntity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.FunnelsEntity;
import org.apache.nifi.web.api.entity.InputPortsEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.LabelsEntity;
import org.apache.nifi.web.api.entity.OutputPortsEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupDescriptorEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupImportEntity;
import org.apache.nifi.web.api.entity.ProcessGroupRecursivity;
import org.apache.nifi.web.api.entity.ProcessGroupReplaceRequestEntity;
import org.apache.nifi.web.api.entity.ProcessGroupUploadEntity;
import org.apache.nifi.web.api.entity.ProcessGroupsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.util.ParameterContextReplacer;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/process-groups")
@Tag(name="ProcessGroups")
public class ProcessGroupResource
extends FlowUpdateResource<ProcessGroupImportEntity, ProcessGroupReplaceRequestEntity> {
    private static final Logger logger = LoggerFactory.getLogger(ProcessGroupResource.class);
    private static final String FLOW_ANALYSIS_REQUEST_TYPE = "flow-analysis-requests";
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private ControllerServiceResource controllerServiceResource;
    private ParameterContextReplacer parameterContextReplacer;
    public RequestManager<String, Void> flowAnalysisAsyncRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "On-demand Flow Analysis");
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Set<ProcessGroupEntity> populateRemainingProcessGroupEntitiesContent(Set<ProcessGroupEntity> processGroupEntities) {
        for (ProcessGroupEntity processGroupEntity : processGroupEntities) {
            this.populateRemainingProcessGroupEntityContent(processGroupEntity);
        }
        return processGroupEntities;
    }

    public ProcessGroupEntity populateRemainingProcessGroupEntityContent(ProcessGroupEntity processGroupEntity) {
        processGroupEntity.setUri(this.generateResourceUri(new String[]{"process-groups", processGroupEntity.getId()}));
        return processGroupEntity;
    }

    private FlowDTO populateRemainingSnippetContent(FlowDTO flow) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flow.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flow.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flow.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flow.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flow.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flow.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flow.getLabels());
        if (flow.getProcessGroups() != null) {
            this.populateRemainingProcessGroupEntitiesContent(flow.getProcessGroups());
        }
        return flow;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessGroup(@Parameter(description="The process group id.") @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessGroupEntity entity = this.serviceFacade.getProcessGroup(groupId);
        this.populateRemainingProcessGroupEntityContent(entity);
        if (entity.getComponent() != null) {
            entity.getComponent().setContents(null);
        }
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/download")
    @Operation(summary="Gets a process group for download", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=String.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response exportProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="If referenced services from outside the target group should be included") @QueryParam(value="includeReferencedServices") @DefaultValue(value="false") boolean includeReferencedServices) {
        this.serviceFacade.authorizeAccess(lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, true, false, false, true);
        });
        RegisteredFlowSnapshot currentVersionedFlowSnapshot = includeReferencedServices ? this.serviceFacade.getCurrentFlowSnapshotByGroupIdWithReferencedControllerServices(groupId) : this.serviceFacade.getCurrentFlowSnapshotByGroupId(groupId);
        VersionedProcessGroup currentVersionedProcessGroup = currentVersionedFlowSnapshot.getFlowContents();
        String flowName = currentVersionedProcessGroup.getName();
        String filename = flowName.replaceAll("\\s", "_") + ".json";
        return this.generateOkResponse((Object)currentVersionedFlowSnapshot).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", filename)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/local-modifications")
    @Operation(summary="Gets a list of local modifications to the Process Group since it was last synchronized with the Flow Registry", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowComparisonEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}"), @SecurityRequirement(name="Read - /{component-type}/{uuid} - For all encapsulated components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getLocalModifications(@Parameter(description="The process group id.") @PathParam(value="id") String groupId) throws IOException, NiFiRegistryException {
        this.serviceFacade.authorizeAccess(lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            this.authorizeProcessGroup(groupAuthorizable, this.authorizer, lookup, RequestAction.READ, false, false, false, false);
        });
        FlowComparisonEntity entity = this.serviceFacade.getLocalModifications(groupId);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String id, @Parameter(description="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity) {
        Integer maxConcurrentTasks;
        String statelessTimeout;
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ProcessGroupDTO requestProcessGroupDTO = requestProcessGroupEntity.getComponent();
        if (!id.equals(requestProcessGroupDTO.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestProcessGroupDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        String processGroupUpdateStrategy = requestProcessGroupEntity.getProcessGroupUpdateStrategy();
        ProcessGroupRecursivity updateStrategy = processGroupUpdateStrategy == null ? ProcessGroupRecursivity.DIRECT_CHILDREN : ProcessGroupRecursivity.valueOf((String)processGroupUpdateStrategy);
        String executionEngine = requestProcessGroupDTO.getExecutionEngine();
        if (executionEngine != null) {
            try {
                ExecutionEngine.valueOf((String)executionEngine);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Illegal value proposed for Execution Engine: " + executionEngine);
            }
        }
        if ((statelessTimeout = requestProcessGroupDTO.getStatelessFlowTimeout()) != null) {
            try {
                FormatUtils.getPreciseTimeDuration((String)statelessTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Illegal value proposed for Stateless Flow Timeout: " + statelessTimeout);
            }
        }
        if ((maxConcurrentTasks = requestProcessGroupDTO.getMaxConcurrentTasks()) != null && maxConcurrentTasks < 1) {
            throw new IllegalArgumentException("Illegal value proposed for Max Concurrent Tasks: " + maxConcurrentTasks);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        ParameterContextReferenceEntity requestParamContext = requestProcessGroupDTO.getParameterContext();
        String requestGroupId = requestProcessGroupDTO.getId();
        HashMap<ProcessGroupEntity, Revision> updatableProcessGroups = new HashMap<ProcessGroupEntity, Revision>();
        updatableProcessGroups.put(requestProcessGroupEntity, this.getRevision((ComponentEntity)requestProcessGroupEntity, requestGroupId));
        if (updateStrategy == ProcessGroupRecursivity.ALL_DESCENDANTS) {
            for (ProcessGroupEntity processGroupEntity : this.serviceFacade.getProcessGroups(requestGroupId, updateStrategy)) {
                String processGroupId;
                ProcessGroupDTO processGroupDTO = processGroupEntity.getComponent();
                String string = processGroupId = processGroupDTO == null ? processGroupEntity.getId() : processGroupDTO.getId();
                if (processGroupDTO != null) {
                    processGroupDTO.setParameterContext(requestParamContext);
                }
                updatableProcessGroups.put(processGroupEntity, this.getRevision((ComponentEntity)processGroupEntity, processGroupId));
            }
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, new HashSet(updatableProcessGroups.values()), lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            for (ProcessGroupEntity updatableGroupEntity : updatableProcessGroups.keySet()) {
                ProcessGroupDTO updatableGroupDto = updatableGroupEntity.getComponent();
                String groupId = updatableGroupDto == null ? updatableGroupEntity.getId() : updatableGroupDto.getId();
                Authorizable authorizable = lookup.getProcessGroup(groupId).getAuthorizable();
                authorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                ParameterContextReferenceEntity referencedParamContext = updatableGroupDto.getParameterContext();
                if (referencedParamContext == null) continue;
                ProcessGroupEntity currentGroupEntity = this.serviceFacade.getProcessGroup(groupId);
                ProcessGroupDTO groupDto = currentGroupEntity.getComponent();
                ParameterContextReferenceEntity currentParamContext = groupDto.getParameterContext();
                String currentParamContextId = currentParamContext == null ? null : currentParamContext.getId();
                boolean parameterContextChanging = !Objects.equals(referencedParamContext.getId(), currentParamContextId);
                if (!parameterContextChanging) continue;
                if (referencedParamContext.getId() != null) {
                    lookup.getParameterContext(referencedParamContext.getId()).authorize(this.authorizer, RequestAction.READ, user);
                }
                if (currentParamContextId != null) {
                    lookup.getParameterContext(currentParamContextId).authorize(this.authorizer, RequestAction.READ, user);
                }
                for (AffectedComponentEntity affectedComponentEntity : this.serviceFacade.getProcessorsReferencingParameter(groupId)) {
                    Authorizable processorAuthorizable = lookup.getProcessor(affectedComponentEntity.getId()).getAuthorizable();
                    processorAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                    processorAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                }
                for (AffectedComponentEntity affectedComponentEntity : this.serviceFacade.getControllerServicesReferencingParameter(groupId)) {
                    Authorizable serviceAuthorizable = lookup.getControllerService(affectedComponentEntity.getId()).getAuthorizable();
                    serviceAuthorizable.authorize(this.authorizer, RequestAction.READ, user);
                    serviceAuthorizable.authorize(this.authorizer, RequestAction.WRITE, user);
                }
            }
        }, () -> {
            for (ProcessGroupEntity entity : updatableProcessGroups.keySet()) {
                this.serviceFacade.verifyUpdateProcessGroup(entity.getComponent());
            }
        }, (revisions, entities) -> {
            ProcessGroupEntity responseEntity = null;
            for (Map.Entry entry : updatableProcessGroups.entrySet()) {
                ProcessGroupDTO groupDTO;
                Revision revision = (Revision)entry.getValue();
                ProcessGroupEntity entity = this.serviceFacade.updateProcessGroup(revision, groupDTO = ((ProcessGroupEntity)entry.getKey()).getComponent());
                if (!requestGroupId.equals(entity.getId())) continue;
                responseEntity = entity;
                this.populateRemainingProcessGroupEntityContent(responseEntity);
                if (responseEntity.getComponent() == null) continue;
                responseEntity.getComponent().setContents(null);
            }
            return this.generateOkResponse(responseEntity).build();
        });
    }

    protected <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/empty-all-connections-requests")
    @Operation(summary="Creates a request to drop all flowfiles of all connection queues in this process group.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid} - For this and all encapsulated process groups"), @SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid} - For all encapsulated connections")})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The request has been accepted. An HTTP response header will contain the URI where the status can be polled."), @ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createEmptyAllConnectionsRequest(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String processGroupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ProcessGroupEntity requestProcessGroupEntity = new ProcessGroupEntity();
        requestProcessGroupEntity.setId(processGroupId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, lookup -> this.authorizeHandleDropAllFlowFilesRequest(processGroupId, lookup), null, processGroupEntity -> {
            String dropRequestId = this.generateUuid();
            DropRequestDTO dropRequest = this.serviceFacade.createDropAllFlowFilesInProcessGroup(processGroupEntity.getId(), dropRequestId);
            dropRequest.setUri(this.generateResourceUri(new String[]{"process-groups", processGroupEntity.getId(), "empty-all-connections-requests", dropRequest.getId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            URI location = URI.create(dropRequest.getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/empty-all-connections-requests/{drop-request-id}")
    @Operation(summary="Gets the current status of a drop all flowfiles request.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid} - For this and all encapsulated process groups"), @SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid} - For all encapsulated connections")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getDropAllFlowfilesRequest(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String processGroupId, @Parameter(description="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeHandleDropAllFlowFilesRequest(processGroupId, lookup));
        DropRequestDTO dropRequest = this.serviceFacade.getDropAllFlowFilesRequest(processGroupId, dropRequestId);
        dropRequest.setUri(this.generateResourceUri(new String[]{"process-groups", processGroupId, "empty-all-connections-requests", dropRequest.getId()}));
        DropRequestEntity entity = new DropRequestEntity();
        entity.setDropRequest(dropRequest);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/empty-all-connections-requests/{drop-request-id}")
    @Operation(summary="Cancels and/or removes a request to drop all flowfiles.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid} - For this and all encapsulated process groups"), @SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid} - For all encapsulated connections")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeDropRequest(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String processGroupId, @Parameter(description="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new DropEntity(processGroupId, dropRequestId), lookup -> this.authorizeHandleDropAllFlowFilesRequest(processGroupId, lookup), null, dropEntity -> {
            DropRequestDTO dropRequest = this.serviceFacade.deleteDropAllFlowFilesRequest(dropEntity.getEntityId(), dropEntity.getDropRequestId());
            dropRequest.setUri(this.generateResourceUri(new String[]{"process-groups", dropEntity.getEntityId(), "empty-all-connections-requests", dropRequest.getId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private void authorizeHandleDropAllFlowFilesRequest(String processGroupId, AuthorizableLookup lookup) {
        ProcessGroupAuthorizable processGroup = lookup.getProcessGroup(processGroupId);
        this.authorizeProcessGroup(processGroup, this.authorizer, lookup, RequestAction.READ, false, false, false, false);
        processGroup.getEncapsulatedProcessGroups().forEach(encapsulatedProcessGroup -> this.authorizeProcessGroup(encapsulatedProcessGroup, this.authorizer, lookup, RequestAction.READ, false, false, false, false));
        processGroup.getEncapsulatedConnections().stream().map(ConnectionAuthorizable::getSourceData).forEach(connectionSourceData -> connectionSourceData.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser()));
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services by any encapsulated components - /controller-services/{uuid}"), @SecurityRequirement(name="Write - /{component-type}/{uuid} - For all encapsulated components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeProcessGroup(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The process group id.") @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ProcessGroupEntity requestProcessGroupEntity = new ProcessGroupEntity();
        requestProcessGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable processGroupAuthorizable = lookup.getProcessGroup(id);
            this.authorizeProcessGroup(processGroupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, true, false, false);
            Authorizable parentAuthorizable = processGroupAuthorizable.getAuthorizable().getParentAuthorizable();
            if (parentAuthorizable != null) {
                parentAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyDeleteProcessGroup(id), (revision, processGroupEntity) -> {
            ProcessGroupEntity entity = this.serviceFacade.deleteProcessGroup(revision, processGroupEntity.getId());
            if (entity.getComponent() != null) {
                entity.getComponent().setContents(null);
            }
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @Operation(summary="Creates a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity, @Parameter(description="Handling Strategy controls whether to keep or replace Parameter Contexts") @QueryParam(value="parameterContextHandlingStrategy") @DefaultValue(value="KEEP_EXISTING") ParameterContextHandlingStrategy parameterContextHandlingStrategy) {
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null || requestProcessGroupEntity.getRevision().getVersion() == null || requestProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Process group.");
        }
        if (requestProcessGroupEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Process group ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestProcessGroupEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestProcessGroupEntity.getComponent().getName()) && requestProcessGroupEntity.getComponent().getVersionControlInformation() == null) {
            throw new IllegalArgumentException("The group name is required when the group is not imported from version control.");
        }
        if (requestProcessGroupEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestProcessGroupEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessGroupEntity.getComponent().getParentGroupId(), groupId));
        }
        requestProcessGroupEntity.getComponent().setParentGroupId(groupId);
        VersionControlInformationDTO versionControlInfo = requestProcessGroupEntity.getComponent().getVersionControlInformation();
        if (versionControlInfo != null && requestProcessGroupEntity.getVersionedFlowSnapshot() == null) {
            VersionedFlowCoordinates versionedFlowCoordinates;
            FlowSnapshotContainer flowSnapshotContainer = this.getFlowFromRegistry(versionControlInfo);
            RegisteredFlowSnapshot flowSnapshot = flowSnapshotContainer.getFlowSnapshot();
            if (flowSnapshot.getFlowContents() != null && (versionedFlowCoordinates = flowSnapshot.getFlowContents().getVersionedFlowCoordinates()) != null) {
                versionControlInfo.setStorageLocation(versionedFlowCoordinates.getStorageLocation());
            }
            if (flowSnapshot.getSnapshotMetadata() != null && flowSnapshot.getSnapshotMetadata().getBranch() != null && versionControlInfo.getBranch() == null) {
                versionControlInfo.setBranch(flowSnapshot.getSnapshotMetadata().getBranch());
            }
            if (ParameterContextHandlingStrategy.REPLACE.equals((Object)parameterContextHandlingStrategy)) {
                this.parameterContextReplacer.replaceParameterContexts(flowSnapshot, (Collection)this.serviceFacade.getParameterContexts());
            }
            this.serviceFacade.discoverCompatibleBundles(flowSnapshot.getFlowContents());
            this.serviceFacade.resolveInheritedControllerServices(flowSnapshotContainer, groupId, NiFiUserUtils.getNiFiUser());
            this.serviceFacade.resolveParameterProviders(flowSnapshot, NiFiUserUtils.getNiFiUser());
            requestProcessGroupEntity.setVersionedFlowSnapshot(flowSnapshot);
        }
        if (versionControlInfo != null) {
            RegisteredFlowSnapshot flowSnapshot = requestProcessGroupEntity.getVersionedFlowSnapshot();
            this.serviceFacade.verifyImportProcessGroup(versionControlInfo, flowSnapshot.getFlowContents(), groupId);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, lookup -> this.authorizeAccess(groupId, requestProcessGroupEntity, lookup), () -> {
            RegisteredFlowSnapshot versionedFlowSnapshot = requestProcessGroupEntity.getVersionedFlowSnapshot();
            if (versionedFlowSnapshot != null) {
                this.serviceFacade.verifyComponentTypes(versionedFlowSnapshot.getFlowContents());
            }
        }, processGroupEntity -> {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            processGroup.setId(this.generateUuid());
            RegisteredFlowSnapshot flowSnapshot = processGroupEntity.getVersionedFlowSnapshot();
            if (flowSnapshot != null && StringUtils.isNotBlank((CharSequence)flowSnapshot.getFlowContents().getName()) && StringUtils.isBlank((CharSequence)processGroup.getName())) {
                processGroup.setName(flowSnapshot.getFlowContents().getName());
            }
            Revision revision = this.getRevision((ComponentEntity)processGroupEntity, processGroup.getId());
            ProcessGroupEntity entity = this.serviceFacade.createProcessGroup(revision, groupId, processGroup);
            if (flowSnapshot != null) {
                RevisionDTO revisionDto = entity.getRevision();
                String newGroupId = entity.getId();
                Revision newGroupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), newGroupId);
                flowSnapshot.getFlowContents().setPosition(null);
                entity = this.serviceFacade.updateProcessGroupContents(newGroupRevision, newGroupId, versionControlInfo, flowSnapshot, (String)this.getIdGenerationSeed().orElse(null), false, true, true);
            }
            this.populateRemainingProcessGroupEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    private FlowSnapshotContainer getFlowFromRegistry(VersionControlInformationDTO versionControlInfo) {
        FlowSnapshotContainer flowSnapshotContainer = this.serviceFacade.getVersionedFlowSnapshot(versionControlInfo, true);
        RegisteredFlowSnapshot flowSnapshot = flowSnapshotContainer.getFlowSnapshot();
        FlowRegistryBucket bucket = flowSnapshot.getBucket();
        RegisteredFlow flow = flowSnapshot.getFlow();
        versionControlInfo.setBucketName(bucket.getName());
        versionControlInfo.setFlowName(flow.getName());
        versionControlInfo.setFlowDescription(flow.getDescription());
        versionControlInfo.setRegistryName(this.serviceFacade.getFlowRegistryName(versionControlInfo.getRegistryId()));
        VersionedFlowState flowState = flowSnapshot.isLatest() ? VersionedFlowState.UP_TO_DATE : VersionedFlowState.STALE;
        versionControlInfo.setState(flowState.name());
        return flowSnapshotContainer;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @Operation(summary="Gets all process groups", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessGroups(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set entities = this.serviceFacade.getProcessGroups(groupId, ProcessGroupRecursivity.DIRECT_CHILDREN);
        for (ProcessGroupEntity entity : entities) {
            if (entity.getComponent() == null) continue;
            entity.getComponent().setContents(null);
        }
        ProcessGroupsEntity entity = new ProcessGroupsEntity();
        entity.setProcessGroups(this.populateRemainingProcessGroupEntitiesContent(entities));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @Operation(summary="Creates a new processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Processor is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createProcessor(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The processor configuration details.", required=true) ProcessorEntity requestProcessorEntity) {
        if (requestProcessorEntity == null || requestProcessorEntity.getComponent() == null) {
            throw new IllegalArgumentException("Processor details must be specified.");
        }
        if (requestProcessorEntity.getRevision() == null || requestProcessorEntity.getRevision().getVersion() == null || requestProcessorEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Processor.");
        }
        ProcessorDTO requestProcessor = requestProcessorEntity.getComponent();
        if (requestProcessor.getId() != null) {
            throw new IllegalArgumentException("Processor ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestProcessor.getType())) {
            throw new IllegalArgumentException("The type of processor to create must be specified.");
        }
        PositionDTO proposedPosition = requestProcessor.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestProcessor.getParentGroupId() != null && !groupId.equals(requestProcessor.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessor.getParentGroupId(), groupId));
        }
        requestProcessor.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessorEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessorEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ParameterContext parameterContext = groupAuthorizable.getProcessGroup().getParameterContext();
            ProcessorConfigDTO configDto = requestProcessor.getConfig();
            if (parameterContext != null && configDto != null) {
                AuthorizeParameterReference.authorizeParameterReferences((Map)configDto.getProperties(), (Authorizer)this.authorizer, (Authorizable)parameterContext, (NiFiUser)user);
            }
            ComponentAuthorizable authorizable = null;
            try {
                ProcessorConfigDTO config;
                authorizable = lookup.getConfigurableComponent(requestProcessor.getType(), requestProcessor.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if ((config = requestProcessor.getConfig()) != null && config.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)config.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateProcessor(requestProcessor), processorEntity -> {
            ProcessorDTO processor = processorEntity.getComponent();
            processor.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)processorEntity, processor.getId());
            ProcessorEntity entity = this.serviceFacade.createProcessor(revision, groupId, processor);
            this.processorResource.populateRemainingProcessorEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @Operation(summary="Gets all processors", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessors(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="Whether or not to include processors from descendant process groups") @QueryParam(value="includeDescendantGroups") @DefaultValue(value="false") boolean includeDescendantGroups) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set processors = this.serviceFacade.getProcessors(groupId, includeDescendantGroups);
        ProcessorsEntity entity = new ProcessorsEntity();
        entity.setProcessors(this.processorResource.populateRemainingProcessorEntitiesContent(processors));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @Operation(summary="Creates an input port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createInputPort(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The input port configuration details.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Input port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Input port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestPortEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createInputPort(revision, groupId, portEntity.getComponent());
            this.inputPortResource.populateRemainingInputPortEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @Operation(summary="Gets all input ports", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=InputPortsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getInputPorts(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set inputPorts = this.serviceFacade.getInputPorts(groupId);
        InputPortsEntity entity = new InputPortsEntity();
        entity.setInputPorts(this.inputPortResource.populateRemainingInputPortEntitiesContent(inputPorts));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @Operation(summary="Creates an output port", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PortEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createOutputPort(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The output port configuration.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Output port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Output port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestPortEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createOutputPort(revision, groupId, portEntity.getComponent());
            this.outputPortResource.populateRemainingOutputPortEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @Operation(summary="Gets all output ports", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=OutputPortsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getOutputPorts(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set outputPorts = this.serviceFacade.getOutputPorts(groupId);
        OutputPortsEntity entity = new OutputPortsEntity();
        entity.setOutputPorts(this.outputPortResource.populateRemainingOutputPortEntitiesContent(outputPorts));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @Operation(summary="Creates a funnel", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FunnelEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createFunnel(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The funnel configuration details.", required=true) FunnelEntity requestFunnelEntity) {
        if (requestFunnelEntity == null || requestFunnelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Funnel details must be specified.");
        }
        if (requestFunnelEntity.getRevision() == null || requestFunnelEntity.getRevision().getVersion() == null || requestFunnelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Funnel.");
        }
        if (requestFunnelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Funnel ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestFunnelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestFunnelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestFunnelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestFunnelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestFunnelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestFunnelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFunnelEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestFunnelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, funnelEntity -> {
            funnelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)funnelEntity, funnelEntity.getComponent().getId());
            FunnelEntity entity = this.serviceFacade.createFunnel(revision, groupId, funnelEntity.getComponent());
            this.funnelResource.populateRemainingFunnelEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @Operation(summary="Gets all funnels", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FunnelsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFunnels(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set funnels = this.serviceFacade.getFunnels(groupId);
        FunnelsEntity entity = new FunnelsEntity();
        entity.setFunnels(this.funnelResource.populateRemainingFunnelEntitiesContent(funnels));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @Operation(summary="Creates a label", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LabelEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createLabel(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The label configuration details.", required=true) LabelEntity requestLabelEntity) {
        if (requestLabelEntity == null || requestLabelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Label details must be specified.");
        }
        if (requestLabelEntity.getRevision() == null || requestLabelEntity.getRevision().getVersion() == null || requestLabelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Label.");
        }
        if (requestLabelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Label ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestLabelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestLabelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestLabelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestLabelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestLabelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestLabelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestLabelEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, labelEntity -> {
            labelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)labelEntity, labelEntity.getComponent().getId());
            LabelEntity entity = this.serviceFacade.createLabel(revision, groupId, labelEntity.getComponent());
            this.labelResource.populateRemainingLabelEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @Operation(summary="Gets all labels", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LabelsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getLabels(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set labels = this.serviceFacade.getLabels(groupId);
        LabelsEntity entity = new LabelsEntity();
        entity.setLabels(this.labelResource.populateRemainingLabelEntitiesContent(labels));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @Operation(summary="Creates a new process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=RemoteProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createRemoteProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The remote process group configuration details.", required=true) RemoteProcessGroupEntity requestRemoteProcessGroupEntity) {
        if (requestRemoteProcessGroupEntity == null || requestRemoteProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Remote process group details must be specified.");
        }
        if (requestRemoteProcessGroupEntity.getRevision() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Remote process group.");
        }
        RemoteProcessGroupDTO requestRemoteProcessGroupDTO = requestRemoteProcessGroupEntity.getComponent();
        if (requestRemoteProcessGroupDTO.getId() != null) {
            throw new IllegalArgumentException("Remote process group ID cannot be specified.");
        }
        if (requestRemoteProcessGroupDTO.getTargetUri() == null) {
            throw new IllegalArgumentException("The URI of the process group must be specified.");
        }
        PositionDTO proposedPosition = requestRemoteProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestRemoteProcessGroupDTO.getParentGroupId() != null && !groupId.equals(requestRemoteProcessGroupDTO.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestRemoteProcessGroupDTO.getParentGroupId(), groupId));
        }
        requestRemoteProcessGroupDTO.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestRemoteProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemoteProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, remoteProcessGroupEntity -> {
            RemoteProcessGroupDTO remoteProcessGroupDTO = remoteProcessGroupEntity.getComponent();
            remoteProcessGroupDTO.setId(this.generateUuid());
            String targetUris = remoteProcessGroupDTO.getTargetUris();
            SiteToSiteRestApiClient.parseClusterUrls((String)targetUris);
            remoteProcessGroupDTO.setTargetUris(targetUris);
            Revision revision = this.getRevision((ComponentEntity)remoteProcessGroupEntity, remoteProcessGroupDTO.getId());
            RemoteProcessGroupEntity entity = this.serviceFacade.createRemoteProcessGroup(revision, groupId, remoteProcessGroupDTO);
            this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @Operation(summary="Gets all remote process groups", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=RemoteProcessGroupsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRemoteProcessGroups(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set remoteProcessGroups = this.serviceFacade.getRemoteProcessGroups(groupId);
        for (RemoteProcessGroupEntity remoteProcessGroupEntity : remoteProcessGroups) {
            if (remoteProcessGroupEntity.getComponent() == null) continue;
            remoteProcessGroupEntity.getComponent().setContents(null);
        }
        RemoteProcessGroupsEntity entity = new RemoteProcessGroupsEntity();
        entity.setRemoteProcessGroups(this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(remoteProcessGroups));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @Operation(summary="Creates a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Write Source - /{component-type}/{uuid}"), @SecurityRequirement(name="Write Destination - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createConnection(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The connection configuration details.", required=true) ConnectionEntity requestConnectionEntity) {
        ConnectableType destinationConnectableType;
        ConnectableType sourceConnectableType;
        if (requestConnectionEntity == null || requestConnectionEntity.getComponent() == null) {
            throw new IllegalArgumentException("Connection details must be specified.");
        }
        if (requestConnectionEntity.getRevision() == null || requestConnectionEntity.getRevision().getVersion() == null || requestConnectionEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Connection.");
        }
        if (requestConnectionEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Connection ID cannot be specified.");
        }
        List proposedBends = requestConnectionEntity.getComponent().getBends();
        if (proposedBends != null) {
            for (PositionDTO proposedBend : proposedBends) {
                if (proposedBend.getX() != null && proposedBend.getY() != null) continue;
                throw new IllegalArgumentException("The x and y coordinate of the each bend must be specified.");
            }
        }
        if (requestConnectionEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestConnectionEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestConnectionEntity.getComponent().getParentGroupId(), groupId));
        }
        requestConnectionEntity.getComponent().setParentGroupId(groupId);
        ConnectionDTO requestConnection = requestConnectionEntity.getComponent();
        if (requestConnection.getSource() == null || requestConnection.getSource().getId() == null) {
            throw new IllegalArgumentException("The source of the connection must be specified.");
        }
        if (requestConnection.getSource().getType() == null) {
            throw new IllegalArgumentException("The type of the source of the connection must be specified.");
        }
        try {
            sourceConnectableType = ConnectableType.valueOf((String)requestConnection.getSource().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized source type %s. Expected values are [%s]", requestConnection.getSource().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (requestConnection.getDestination() == null || requestConnection.getDestination().getId() == null) {
            throw new IllegalArgumentException("The destination of the connection must be specified.");
        }
        if (requestConnection.getDestination().getType() == null) {
            throw new IllegalArgumentException("The type of the destination of the connection must be specified.");
        }
        try {
            destinationConnectableType = ConnectableType.valueOf((String)requestConnection.getDestination().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized destination type %s. Expected values are [%s]", requestConnection.getDestination().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestConnectionEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestConnectionEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable source = ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)sourceConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getSource().getGroupId()) : lookup.getLocalConnectable(requestConnection.getSource().getId());
            if (source == null) {
                throw new ResourceNotFoundException("Cannot find source component with ID [" + requestConnection.getSource().getId() + "]");
            }
            source.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable destination = ConnectableType.REMOTE_INPUT_PORT.equals((Object)destinationConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getDestination().getGroupId()) : lookup.getLocalConnectable(requestConnection.getDestination().getId());
            if (destination == null) {
                throw new ResourceNotFoundException("Cannot find destination component with ID [" + requestConnection.getDestination().getId() + "]");
            }
            destination.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCreateConnection(groupId, requestConnection), connectionEntity -> {
            ConnectionDTO connection = connectionEntity.getComponent();
            connection.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)connectionEntity, connection.getId());
            ConnectionEntity entity = this.serviceFacade.createConnection(revision, groupId, connection);
            this.connectionResource.populateRemainingConnectionEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @Operation(summary="Gets all connections", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionsEntity.class))})}, security={@SecurityRequirement(name="Read - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getConnections(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set connections = this.serviceFacade.getConnections(groupId);
        ConnectionsEntity entity = new ConnectionsEntity();
        entity.setConnections(this.connectionResource.populateRemainingConnectionEntitiesContent(connections));
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/snippet-instance")
    @Operation(summary="Copies a snippet and discards it.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Read - /{component-type}/{uuid} - For each component in the snippet and their descendant components"), @SecurityRequirement(name="Write - if the snippet contains any restricted Processors - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response copySnippet(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The copy snippet request.", required=true) CopySnippetRequestEntity requestCopySnippetEntity) {
        if (requestCopySnippetEntity == null || requestCopySnippetEntity.getOriginX() == null || requestCopySnippetEntity.getOriginY() == null) {
            throw new IllegalArgumentException("The  origin position (x, y) must be specified");
        }
        if (requestCopySnippetEntity.getSnippetId() == null) {
            throw new IllegalArgumentException("The snippet id must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestCopySnippetEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestCopySnippetEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestCopySnippetEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            SnippetAuthorizable snippet = this.authorizeSnippetUsage(lookup, groupId, requestCopySnippetEntity.getSnippetId(), false, true);
            Consumer<ComponentAuthorizable> authorizeRestricted = authorizable -> {
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
            };
            snippet.getSelectedProcessors().forEach(authorizeRestricted);
            for (ProcessGroupAuthorizable groupAuthorizable : snippet.getSelectedProcessGroups()) {
                groupAuthorizable.getEncapsulatedProcessors().forEach(authorizeRestricted);
                ParameterContext parameterContext = groupAuthorizable.getProcessGroup().getParameterContext();
                if (parameterContext != null) {
                    parameterContext.authorize(this.authorizer, RequestAction.READ, user);
                }
                for (ProcessGroupAuthorizable encapsulatedGroupAuth : groupAuthorizable.getEncapsulatedProcessGroups()) {
                    ParameterContext encapsulatedGroupParameterContext = encapsulatedGroupAuth.getProcessGroup().getParameterContext();
                    if (encapsulatedGroupParameterContext == null) continue;
                    encapsulatedGroupParameterContext.authorize(this.authorizer, RequestAction.READ, user);
                }
            }
        }, null, copySnippetRequestEntity -> {
            FlowEntity flowEntity = this.serviceFacade.copySnippet(groupId, copySnippetRequestEntity.getSnippetId(), copySnippetRequestEntity.getOriginX(), copySnippetRequestEntity.getOriginY(), (String)this.getIdGenerationSeed().orElse(null));
            FlowDTO flow = flowEntity.getFlow();
            for (ProcessGroupEntity childGroupEntity : flow.getProcessGroups()) {
                childGroupEntity.getComponent().setContents(null);
            }
            this.populateRemainingSnippetContent(flow);
            return this.generateCreatedResponse(this.getAbsolutePath(), (Object)flowEntity).build();
        });
    }

    private SnippetAuthorizable authorizeSnippetUsage(AuthorizableLookup lookup, String groupId, String snippetId, boolean authorizeTransitiveServices, boolean authorizeParameterReferences) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        lookup.getProcessGroup(groupId).getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
        SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
        this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.READ, true, authorizeTransitiveServices, authorizeParameterReferences);
        return snippet;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/controller-services")
    @Operation(summary="Creates a new controller service", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServiceEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Controller Service is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createControllerService(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (requestControllerService.getParentGroupId() != null && !groupId.equals(requestControllerService.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestControllerService.getParentGroupId(), groupId));
        }
        requestControllerService.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestControllerServiceEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ParameterContext parameterContext = groupAuthorizable.getProcessGroup().getParameterContext();
            if (parameterContext != null) {
                AuthorizeParameterReference.authorizeParameterReferences((Map)requestControllerService.getProperties(), (Authorizer)this.authorizer, (Authorizable)parameterContext, (NiFiUser)user);
            }
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestControllerService.getType(), requestControllerService.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestControllerService.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateControllerService(requestControllerService), controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, groupId, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/replace-requests")
    @Operation(summary="Initiate the Replace Request of a Process Group with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupReplaceRequestEntity.class))})}, description="This will initiate the action of replacing a process group with the given process group. This can be a lengthy process, as it will stop any Processors and disable any Controller Services necessary to perform the action and then restart them. As a result, the endpoint will immediately return a ProcessGroupReplaceRequestEntity, and the process of replacing the flow will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /process-groups/replace-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /process-groups/replace-requests/{requestId}. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", security={@SecurityRequirement(name="Read - /process-groups/{uuid}"), @SecurityRequirement(name="Write - /process-groups/{uuid}"), @SecurityRequirement(name="Read - /{component-type}/{uuid} - For all encapsulated components"), @SecurityRequirement(name="Write - /{component-type}/{uuid} - For all encapsulated components"), @SecurityRequirement(name="Write - if the snapshot contains any restricted components - /restricted-components"), @SecurityRequirement(name="Read - /parameter-contexts/{uuid} - For any Parameter Context that is referenced by a Property that is changed, added, or removed")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response initiateReplaceProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The process group replace request entity", required=true) ProcessGroupImportEntity importEntity) {
        if (importEntity == null) {
            throw new IllegalArgumentException("Process Group Import Entity is required");
        }
        if (this.serviceFacade.isAnyProcessGroupUnderVersionControl(groupId)) {
            throw new IllegalStateException("Cannot replace a Process Group via import while it or its descendants are under Version Control.");
        }
        RegisteredFlowSnapshot versionedFlowSnapshot = importEntity.getVersionedFlowSnapshot();
        if (versionedFlowSnapshot == null) {
            throw new IllegalArgumentException("Versioned Flow Snapshot must be supplied");
        }
        versionedFlowSnapshot.setFlow(null);
        versionedFlowSnapshot.setBucket(null);
        versionedFlowSnapshot.setSnapshotMetadata(null);
        this.sanitizeRegistryInfo(versionedFlowSnapshot.getFlowContents());
        FlowSnapshotContainer flowSnapshotContainer = new FlowSnapshotContainer(versionedFlowSnapshot);
        return this.initiateFlowUpdate(groupId, (ProcessGroupDescriptorEntity)importEntity, true, "replace-requests", "/nifi-api/process-groups/" + groupId + "/flow-contents", () -> flowSnapshotContainer);
    }

    private void sanitizeRegistryInfo(VersionedProcessGroup versionedProcessGroup) {
        versionedProcessGroup.setVersionedFlowCoordinates(null);
        for (VersionedProcessGroup innerVersionedProcessGroup : versionedProcessGroup.getProcessGroups()) {
            this.sanitizeRegistryInfo(innerVersionedProcessGroup);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups/upload")
    @Operation(summary="Uploads a versioned flow definition and creates a process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response uploadProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The process group name.", required=true) @FormDataParam(value="groupName") String groupName, @Parameter(description="The process group X position.", required=true) @FormDataParam(value="positionX") Double positionX, @Parameter(description="The process group Y position.", required=true) @FormDataParam(value="positionY") Double positionY, @Parameter(description="The client id.", required=true) @FormDataParam(value="clientId") String clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @FormDataParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @FormDataParam(value="file") InputStream in) throws InterruptedException {
        RegisteredFlowSnapshot deserializedSnapshot;
        if (StringUtils.isBlank((CharSequence)groupName)) {
            throw new IllegalArgumentException("The process group name is required.");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            throw new IllegalArgumentException("The parent process group id is required");
        }
        if (positionX == null) {
            throw new IllegalArgumentException("The x coordinate of the proposed position must be specified.");
        }
        if (positionY == null) {
            throw new IllegalArgumentException("The y coordinate of the proposed position must be specified.");
        }
        if (StringUtils.isBlank((CharSequence)clientId)) {
            throw new IllegalArgumentException("The client id must be specified");
        }
        try {
            deserializedSnapshot = (RegisteredFlowSnapshot)MAPPER.readValue(in, RegisteredFlowSnapshot.class);
        }
        catch (IOException e) {
            logger.warn("Deserialization of uploaded JSON failed", (Throwable)e);
            throw new IllegalArgumentException("Deserialization of uploaded JSON failed", e);
        }
        this.sanitizeRegistryInfo(deserializedSnapshot.getFlowContents());
        this.serviceFacade.discoverCompatibleBundles(deserializedSnapshot.getFlowContents());
        FlowSnapshotContainer flowSnapshotContainer = new FlowSnapshotContainer(deserializedSnapshot);
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshotContainer, groupId, NiFiUserUtils.getNiFiUser());
        this.serviceFacade.resolveParameterProviders(deserializedSnapshot, NiFiUserUtils.getNiFiUser());
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        PositionDTO positionDTO = new PositionDTO();
        positionDTO.setX(positionX);
        positionDTO.setY(positionY);
        RevisionDTO revisionDTO = new RevisionDTO();
        revisionDTO.setClientId(clientId);
        revisionDTO.setVersion(Long.valueOf(0L));
        ProcessGroupUploadEntity pgUploadEntity = new ProcessGroupUploadEntity();
        pgUploadEntity.setGroupId(groupId);
        pgUploadEntity.setGroupName(groupName);
        pgUploadEntity.setDisconnectedNodeAcknowledged(disconnectedNodeAcknowledged);
        pgUploadEntity.setFlowSnapshot(deserializedSnapshot);
        pgUploadEntity.setPositionDTO(positionDTO);
        pgUploadEntity.setRevisionDTO(revisionDTO);
        if (this.isReplicateRequest()) {
            UriBuilder uriBuilder = this.uriInfo.getBaseUriBuilder();
            uriBuilder.segment(new String[]{"process-groups", groupId, "process-groups", "import"});
            URI importUri = uriBuilder.build(new Object[0]);
            HashMap<String, String> headersToOverride = new HashMap<String, String>();
            headersToOverride.put("content-type", "application/json");
            if (this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES) {
                return this.getRequestReplicator().replicate("POST", importUri, (Object)pgUploadEntity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
            }
            return this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "POST", importUri, (Object)pgUploadEntity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
        }
        return this.importProcessGroup(groupId, pgUploadEntity);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups/import")
    @Operation(summary="Imports a specified process group", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupEntity.class))})}, security={@SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response importProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, ProcessGroupUploadEntity processGroupUploadEntity) {
        if (processGroupUploadEntity == null || processGroupUploadEntity.getFlowSnapshot() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        RegisteredFlowSnapshot versionedFlowSnapshot = processGroupUploadEntity.getFlowSnapshot();
        this.sanitizeRegistryInfo(versionedFlowSnapshot.getFlowContents());
        this.serviceFacade.discoverCompatibleBundles(versionedFlowSnapshot.getFlowContents());
        FlowSnapshotContainer flowSnapshotContainer = new FlowSnapshotContainer(versionedFlowSnapshot);
        this.serviceFacade.resolveInheritedControllerServices(flowSnapshotContainer, groupId, NiFiUserUtils.getNiFiUser());
        this.serviceFacade.resolveParameterProviders(versionedFlowSnapshot, NiFiUserUtils.getNiFiUser());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)processGroupUploadEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(processGroupUploadEntity.getDisconnectedNodeAcknowledged());
        }
        ProcessGroupEntity newProcessGroupEntity = this.createProcessGroupEntity(groupId, processGroupUploadEntity.getGroupName(), processGroupUploadEntity.getPositionDTO(), versionedFlowSnapshot);
        return this.withWriteLock(this.serviceFacade, (Entity)newProcessGroupEntity, lookup -> this.authorizeAccess(groupId, newProcessGroupEntity, lookup), () -> {
            RegisteredFlowSnapshot newVersionedFlowSnapshot = newProcessGroupEntity.getVersionedFlowSnapshot();
            if (newVersionedFlowSnapshot != null) {
                this.serviceFacade.verifyComponentTypes(newVersionedFlowSnapshot.getFlowContents());
            }
        }, processGroupEntity -> {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            processGroup.setId(this.generateUuid());
            RegisteredFlowSnapshot flowSnapshot = processGroupEntity.getVersionedFlowSnapshot();
            Revision revision = new Revision(Long.valueOf(0L), processGroupUploadEntity.getRevisionDTO().getClientId(), processGroup.getId());
            ProcessGroupEntity entity = this.serviceFacade.createProcessGroup(revision, groupId, processGroup);
            if (flowSnapshot != null) {
                RevisionDTO revisionDto = entity.getRevision();
                String newGroupId = entity.getComponent().getId();
                Revision newGroupRevision = new Revision(revisionDto.getVersion(), revisionDto.getClientId(), newGroupId);
                flowSnapshot.getFlowContents().setPosition(null);
                flowSnapshot.getFlowContents().setName(processGroupUploadEntity.getGroupName());
                entity = this.serviceFacade.updateProcessGroupContents(newGroupRevision, newGroupId, null, flowSnapshot, (String)this.getIdGenerationSeed().orElse(null), false, false, true);
            }
            this.populateRemainingProcessGroupEntityContent(entity);
            String uri = entity.getUri();
            return this.generateCreatedResponse(URI.create(uri), (Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/flow-contents")
    @Operation(summary="Replace Process Group contents with the given ID with the specified Process Group contents", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupImportEntity.class))})}, description="This endpoint is used for replication within a cluster, when replacing a flow with a new flow. It expects that the flow beingreplaced is not under version control and that the given snapshot will not modify any Processor that is currently running or any Controller Service that is enabled. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", security={@SecurityRequirement(name="Read - /process-groups/{uuid}"), @SecurityRequirement(name="Write - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response replaceProcessGroup(@Parameter(description="The process group id.", required=true) @PathParam(value="id") String groupId, @Parameter(description="The process group replace request entity.", required=true) ProcessGroupImportEntity importEntity) {
        if (importEntity == null) {
            throw new IllegalArgumentException("Process Group Import Entity is required");
        }
        RevisionDTO revisionDto = importEntity.getProcessGroupRevision();
        if (revisionDto == null) {
            throw new IllegalArgumentException("Process Group Revision must be specified.");
        }
        RegisteredFlowSnapshot requestFlowSnapshot = importEntity.getVersionedFlowSnapshot();
        if (requestFlowSnapshot == null) {
            throw new IllegalArgumentException("Versioned Flow Snapshot must be supplied.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)importEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(importEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(importEntity.getProcessGroupRevision(), groupId);
        return this.withWriteLock(this.serviceFacade, (Entity)importEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable groupAuthorizable = lookup.getProcessGroup(groupId);
            Authorizable processGroup = groupAuthorizable.getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanUpdate(groupId, requestFlowSnapshot, true, false), (revision, entity) -> {
            ProcessGroupEntity updatedGroup = this.performUpdateFlow(groupId, revision, importEntity, entity.getVersionedFlowSnapshot(), (String)this.getIdGenerationSeed().orElse(null), false, true);
            ProcessGroupImportEntity responseEntity = new ProcessGroupImportEntity();
            responseEntity.setProcessGroupRevision(updatedGroup.getRevision());
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="replace-requests/{id}")
    @Operation(summary="Returns the Replace Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupReplaceRequestEntity.class))})}, description="Returns the Replace Request with the given ID. Once a Replace Request has been created by performing a POST to /process-groups/{id}/replace-requests, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getReplaceProcessGroupRequest(@Parameter(description="The ID of the Replace Request") @PathParam(value="id") String replaceRequestId) {
        return this.retrieveFlowUpdateRequest("replace-requests", replaceRequestId);
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="replace-requests/{id}")
    @Operation(summary="Deletes the Replace Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessGroupReplaceRequestEntity.class))})}, description="Deletes the Replace Request with the given ID. After a request is created via a POST to /process-groups/{id}/replace-requests, it is expected that the client will properly clean up the request by DELETE'ing it, once the Replace process has completed. If the request is deleted before the request completes, then the Replace request will finish the step that it is currently performing and then will cancel any subsequent steps. Note: This endpoint is subject to change as NiFi and it's REST API evolve.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteReplaceProcessGroupRequest(@Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The ID of the Update Request") @PathParam(value="id") String replaceRequestId) {
        return this.deleteFlowUpdateRequest("replace-requests", replaceRequestId, disconnectedNodeAcknowledged.booleanValue());
    }

    protected ProcessGroupEntity performUpdateFlow(String groupId, Revision revision, ProcessGroupImportEntity requestEntity, RegisteredFlowSnapshot flowSnapshot, String idGenerationSeed, boolean verifyNotModified, boolean updateDescendantVersionedFlows) {
        logger.info("Replacing Process Group with ID {} with imported Process Group with ID {}", (Object)groupId, (Object)flowSnapshot.getFlowContents().getIdentifier());
        return this.serviceFacade.updateProcessGroupContents(revision, groupId, null, flowSnapshot, idGenerationSeed, verifyNotModified, true, updateDescendantVersionedFlows);
    }

    protected Entity createReplicateUpdateFlowEntity(Revision revision, ProcessGroupImportEntity requestEntity, RegisteredFlowSnapshot flowSnapshot) {
        return requestEntity;
    }

    protected ProcessGroupReplaceRequestEntity createUpdateRequestEntity() {
        return new ProcessGroupReplaceRequestEntity();
    }

    protected void finalizeCompletedUpdateRequest(ProcessGroupReplaceRequestEntity requestEntity) {
        ProcessGroupReplaceRequestDTO updateRequestDto = requestEntity.getRequest();
        if (updateRequestDto.isComplete()) {
            RegisteredFlowSnapshot versionedFlowSnapshot = this.serviceFacade.getCurrentFlowSnapshotByGroupId(updateRequestDto.getProcessGroupId());
            requestEntity.setVersionedFlowSnapshot(versionedFlowSnapshot);
        }
    }

    private ProcessGroupEntity createProcessGroupEntity(String groupId, String groupName, PositionDTO positionDTO, RegisteredFlowSnapshot deserializedSnapshot) {
        ProcessGroupEntity processGroupEntity = new ProcessGroupEntity();
        ProcessGroupDTO processGroupDTO = new ProcessGroupDTO();
        processGroupDTO.setParentGroupId(groupId);
        processGroupDTO.setName(groupName);
        processGroupEntity.setComponent(processGroupDTO);
        processGroupEntity.setVersionedFlowSnapshot(deserializedSnapshot);
        processGroupEntity.getComponent().setPosition(positionDTO);
        return processGroupEntity;
    }

    private void authorizeAccess(String groupId, ProcessGroupEntity processGroupEntity, AuthorizableLookup lookup) {
        RegisteredFlowSnapshot versionedFlowSnapshot;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
        processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
        ParameterContextReferenceEntity referencedParamContext = processGroupEntity.getComponent().getParameterContext();
        if (referencedParamContext != null && referencedParamContext.getId() != null) {
            lookup.getParameterContext(referencedParamContext.getId()).authorize(this.authorizer, RequestAction.READ, user);
        }
        if ((versionedFlowSnapshot = processGroupEntity.getVersionedFlowSnapshot()) != null) {
            Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedProcessGroup)versionedFlowSnapshot.getFlowContents(), (NiFiServiceFacade)this.serviceFacade);
            restrictedComponents.forEach(restrictedComponent -> {
                ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
                this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
            });
            Map parameterContexts = versionedFlowSnapshot.getParameterContexts();
            if (parameterContexts != null) {
                parameterContexts.values().forEach(context -> AuthorizeParameterReference.authorizeParameterContextAddition((VersionedParameterContext)context, (NiFiServiceFacade)this.serviceFacade, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (NiFiUser)user));
            }
        }
    }

    @Autowired
    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    @Autowired
    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    @Autowired
    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    @Autowired
    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    @Autowired
    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    @Autowired
    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    @Autowired
    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    @Autowired
    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    @Autowired
    public void setParameterContextReplacer(ParameterContextReplacer parameterContextReplacer) {
        this.parameterContextReplacer = parameterContextReplacer;
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.setDefaultPropertyInclusion(JsonInclude.Value.construct((JsonInclude.Include)JsonInclude.Include.NON_NULL, (JsonInclude.Include)JsonInclude.Include.NON_NULL));
        MAPPER.setAnnotationIntrospector((AnnotationIntrospector)new JakartaXmlBindAnnotationIntrospector(MAPPER.getTypeFactory()));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

