/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.UploadRequest;
import org.apache.nifi.cluster.coordination.http.replication.UploadRequestReplicator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.flow.VersionedReportingTaskSnapshot;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.registry.flow.FlowRegistryUtils;
import org.apache.nifi.stream.io.MaxLengthInputStream;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ControllerResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.ParameterProviderResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ConfigurationAnalysisDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.NarCoordinateDTO;
import org.apache.nifi.web.api.dto.NarSummaryDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentHistoryEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ConfigurationAnalysisEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleRunStatusEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRulesEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientTypesEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientsEntity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.NarDetailsEntity;
import org.apache.nifi.web.api.entity.NarSummariesEntity;
import org.apache.nifi.web.api.entity.NarSummaryEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportRequestEntity;
import org.apache.nifi.web.api.entity.VersionedReportingTaskImportResponseEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.DateTimeParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.client.api.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/controller")
@Tag(name="Controller")
public class ControllerResource
extends ApplicationResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerResource.class);
    public static final String VERIFICATION_REQUEST_TYPE = "verification-request";
    private static final String FILENAME_HEADER = "Filename";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String UPLOAD_CONTENT_TYPE = "application/octet-stream";
    public RequestManager<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> configVerificationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Verify Flow Analysis Rule Config Thread");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private UploadRequestReplicator uploadRequestReplicator;
    private ReportingTaskResource reportingTaskResource;
    private ParameterProviderResource parameterProviderResource;
    private ControllerServiceResource controllerServiceResource;

    private void authorizeController(RequestAction action) {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable controller = lookup.getController();
            controller.authorize(this.authorizer, action, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @Operation(summary="Retrieves the configuration for this NiFi Controller", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerConfigurationEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getControllerConfig() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerConfigurationEntity entity = this.serviceFacade.getControllerConfiguration();
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @Operation(summary="Retrieves the configuration for this NiFi", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerConfigurationEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateControllerConfig(@Parameter(description="The controller configuration.", required=true) ControllerConfigurationEntity requestConfigEntity) {
        if (requestConfigEntity == null || requestConfigEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        if (requestConfigEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestConfigEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestConfigEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestConfigEntity.getRevision(), FlowController.class.getSimpleName());
        return this.withWriteLock(this.serviceFacade, (Entity)requestConfigEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), null, (revision, configEntity) -> {
            ControllerConfigurationEntity entity = this.serviceFacade.updateControllerConfiguration(revision, configEntity.getComponent());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="parameter-providers")
    @Operation(summary="Creates a new parameter provider", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ParameterProviderEntity.class))})}, security={@SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Parameter Provider is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createParameterProvider(@Parameter(description="The parameter provider configuration details.", required=true) ParameterProviderEntity requestParameterProviderEntity) {
        if (requestParameterProviderEntity == null || requestParameterProviderEntity.getComponent() == null) {
            throw new IllegalArgumentException("Parameter provider details must be specified.");
        }
        if (requestParameterProviderEntity.getRevision() == null || requestParameterProviderEntity.getRevision().getVersion() == null || requestParameterProviderEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Parameter provider.");
        }
        ParameterProviderDTO requestParameterProvider = requestParameterProviderEntity.getComponent();
        if (requestParameterProvider.getId() != null) {
            throw new IllegalArgumentException("Parameter provider ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestParameterProvider.getType())) {
            throw new IllegalArgumentException("The type of parameter provider to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestParameterProviderEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestParameterProviderEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestParameterProviderEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestParameterProvider.getType(), requestParameterProvider.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestParameterProvider.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestParameterProvider.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateParameterProvider(requestParameterProvider), parameterProviderEntity -> {
            ParameterProviderDTO parameterProvider = parameterProviderEntity.getComponent();
            parameterProvider.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)parameterProviderEntity, parameterProvider.getId());
            ParameterProviderEntity entity = this.serviceFacade.createParameterProvider(revision, parameterProvider);
            this.parameterProviderResource.populateRemainingParameterProviderEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @Operation(summary="Creates a new reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskEntity.class))})}, security={@SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Reporting Task is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createReportingTask(@Parameter(description="The reporting task configuration details.", required=true) ReportingTaskEntity requestReportingTaskEntity) {
        if (requestReportingTaskEntity == null || requestReportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Reporting task details must be specified.");
        }
        if (requestReportingTaskEntity.getRevision() == null || requestReportingTaskEntity.getRevision().getVersion() == null || requestReportingTaskEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Reporting task.");
        }
        ReportingTaskDTO requestReportingTask = requestReportingTaskEntity.getComponent();
        if (requestReportingTask.getId() != null) {
            throw new IllegalArgumentException("Reporting task ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestReportingTask.getType())) {
            throw new IllegalArgumentException("The type of reporting task to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestReportingTaskEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestReportingTaskEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestReportingTask.getType(), requestReportingTask.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestReportingTask.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestReportingTask.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateReportingTask(requestReportingTask), reportingTaskEntity -> {
            ReportingTaskDTO reportingTask = reportingTaskEntity.getComponent();
            reportingTask.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)reportingTaskEntity, reportingTask.getId());
            ReportingTaskEntity entity = this.serviceFacade.createReportingTask(revision, reportingTask);
            this.reportingTaskResource.populateRemainingReportingTaskEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks/import")
    @Operation(summary="Imports a reporting task snapshot", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VersionedReportingTaskImportResponseEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response importReportingTaskSnapshot(@Parameter(description="The import request containing the reporting task snapshot to import.", required=true) VersionedReportingTaskImportRequestEntity importRequestEntity) {
        if (importRequestEntity == null || importRequestEntity.getReportingTaskSnapshot() == null) {
            throw new IllegalArgumentException("Reporting task snapshot is required");
        }
        VersionedReportingTaskSnapshot requestSnapshot = importRequestEntity.getReportingTaskSnapshot();
        this.serviceFacade.discoverCompatibleBundles(requestSnapshot);
        this.serviceFacade.generateIdentifiersForImport(requestSnapshot, () -> this.generateUuid());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)importRequestEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(importRequestEntity.getDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)importRequestEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            Set restrictedComponents = FlowRegistryUtils.getRestrictedComponents((VersionedReportingTaskSnapshot)requestSnapshot, (NiFiServiceFacade)this.serviceFacade);
            restrictedComponents.forEach(restrictedComponent -> {
                ComponentAuthorizable restrictedComponentAuthorizable = lookup.getConfigurableComponent(restrictedComponent);
                this.authorizeRestrictions(this.authorizer, restrictedComponentAuthorizable);
            });
        }, () -> {}, importRequest -> {
            VersionedReportingTaskSnapshot snapshot = importRequest.getReportingTaskSnapshot();
            VersionedReportingTaskImportResponseEntity responseEntity = this.serviceFacade.importReportingTasks(snapshot);
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules")
    @Operation(summary="Creates a new flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleEntity.class))})}, security={@SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Flow Analysis Rule is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createFlowAnalysisRule(@Parameter(description="The flow analysis rule configuration details.", required=true) FlowAnalysisRuleEntity requestFlowAnalysisRuleEntity) {
        if (requestFlowAnalysisRuleEntity == null || requestFlowAnalysisRuleEntity.getComponent() == null) {
            throw new IllegalArgumentException("Flow analysis rule details must be specified.");
        }
        if (requestFlowAnalysisRuleEntity.getRevision() == null || requestFlowAnalysisRuleEntity.getRevision().getVersion() == null || requestFlowAnalysisRuleEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Flow analysis rule.");
        }
        FlowAnalysisRuleDTO requestFlowAnalysisRule = requestFlowAnalysisRuleEntity.getComponent();
        if (requestFlowAnalysisRule.getId() != null) {
            throw new IllegalArgumentException("Flow analysis rule ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestFlowAnalysisRule.getType())) {
            throw new IllegalArgumentException("The type of flow analysis rule to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestFlowAnalysisRuleEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFlowAnalysisRuleEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowAnalysisRuleEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestFlowAnalysisRule.getType(), requestFlowAnalysisRule.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestFlowAnalysisRule.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestFlowAnalysisRule.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateFlowAnalysisRule(requestFlowAnalysisRule), flowAnalysisRuleEntity -> {
            FlowAnalysisRuleDTO flowAnalysisRule = flowAnalysisRuleEntity.getComponent();
            flowAnalysisRule.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)flowAnalysisRuleEntity, flowAnalysisRule.getId());
            FlowAnalysisRuleEntity entity = this.serviceFacade.createFlowAnalysisRule(revision, flowAnalysisRule);
            this.populateRemainingFlowAnalysisRuleEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/state/clear-requests")
    @Operation(summary="Clears the state for a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response clearState(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        FlowAnalysisRuleEntity requestFlowAnalysisRuleEntity = new FlowAnalysisRuleEntity();
        requestFlowAnalysisRuleEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowAnalysisRuleEntity, lookup -> this.authorizeController(RequestAction.WRITE), () -> this.serviceFacade.verifyCanClearFlowAnalysisRuleState(id), flowAnalysisRuleEntity -> {
            this.serviceFacade.clearFlowAnalysisRuleState(flowAnalysisRuleEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}")
    @Operation(summary="Updates a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleEntity.class))})}, security={@SecurityRequirement(name="Write - /flow-analysis-rules/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateFlowAnalysisRule(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id, @Parameter(description="The flow analysis rule configuration details.", required=true) FlowAnalysisRuleEntity requestFlowAnalysisRuleEntity) {
        if (requestFlowAnalysisRuleEntity == null || requestFlowAnalysisRuleEntity.getComponent() == null) {
            throw new IllegalArgumentException("Flow analysis rule details must be specified.");
        }
        if (requestFlowAnalysisRuleEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        FlowAnalysisRuleDTO requestFlowAnalysisRuleDTO = requestFlowAnalysisRuleEntity.getComponent();
        if (!id.equals(requestFlowAnalysisRuleDTO.getId())) {
            throw new IllegalArgumentException(String.format("The flow analysis rule id (%s) in the request body does not equal the flow analysis rule id of the requested resource (%s).", requestFlowAnalysisRuleDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestFlowAnalysisRuleEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFlowAnalysisRuleEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestFlowAnalysisRuleEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowAnalysisRuleEntity, requestRevision, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = lookup.getFlowAnalysisRule(id);
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestFlowAnalysisRuleDTO.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
        }, () -> this.serviceFacade.verifyUpdateFlowAnalysisRule(requestFlowAnalysisRuleDTO), (revision, flowAnalysisRuleEntity) -> {
            FlowAnalysisRuleDTO flowAnalysisRuleDTO = flowAnalysisRuleEntity.getComponent();
            FlowAnalysisRuleEntity entity = this.serviceFacade.updateFlowAnalysisRule(revision, flowAnalysisRuleDTO);
            this.populateRemainingFlowAnalysisRuleEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}")
    @Operation(summary="Deletes a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleEntity.class))})}, security={@SecurityRequirement(name="Write - /flow-analysis-rules/{uuid}"), @SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeFlowAnalysisRule(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        FlowAnalysisRuleEntity requestFlowAnalysisRuleEntity = new FlowAnalysisRuleEntity();
        requestFlowAnalysisRuleEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowAnalysisRuleEntity, requestRevision, lookup -> {
            ComponentAuthorizable flowAnalysisRule = lookup.getFlowAnalysisRule(id);
            this.authorizeController(RequestAction.WRITE);
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)flowAnalysisRule, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteFlowAnalysisRule(id), (revision, flowAnalysisRuleEntity) -> {
            FlowAnalysisRuleEntity entity = this.serviceFacade.deleteFlowAnalysisRule(revision, flowAnalysisRuleEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/run-status")
    @Operation(summary="Updates run status of a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleEntity.class))})}, security={@SecurityRequirement(name="Write - /flow-analysis-rules/{uuid} or  or /operation/flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateRunStatus(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id, @Parameter(description="The flow analysis rule run status.", required=true) FlowAnalysisRuleRunStatusEntity requestRunStatus) {
        if (requestRunStatus == null) {
            throw new IllegalArgumentException("Flow analysis rule run status must be specified.");
        }
        if (requestRunStatus.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRunStatus.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRunStatus);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRunStatus.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRunStatus.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRunStatus, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), () -> this.serviceFacade.verifyUpdateFlowAnalysisRule(this.createFlowAnalysisRuleDtoWithDesiredRunStatus(id, requestRunStatus.getState())), (revision, flowAnalysisRuleRunStatusEntity) -> {
            FlowAnalysisRuleEntity entity = this.serviceFacade.updateFlowAnalysisRule(revision, this.createFlowAnalysisRuleDtoWithDesiredRunStatus(id, flowAnalysisRuleRunStatusEntity.getState()));
            this.populateRemainingFlowAnalysisRuleEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private FlowAnalysisRuleDTO createFlowAnalysisRuleDtoWithDesiredRunStatus(String id, String runStatus) {
        FlowAnalysisRuleDTO dto = new FlowAnalysisRuleDTO();
        dto.setId(id);
        dto.setState(runStatus);
        return dto;
    }

    private Set<FlowAnalysisRuleEntity> populateRemainingFlowAnalysisRuleEntitiesContent(Set<FlowAnalysisRuleEntity> flowAnalysisRuleEntities) {
        for (FlowAnalysisRuleEntity flowAnalysisRuleEntity : flowAnalysisRuleEntities) {
            this.populateRemainingFlowAnalysisRuleEntityContent(flowAnalysisRuleEntity);
        }
        return flowAnalysisRuleEntities;
    }

    private FlowAnalysisRuleEntity populateRemainingFlowAnalysisRuleEntityContent(FlowAnalysisRuleEntity flowAnalysisRuleEntity) {
        flowAnalysisRuleEntity.setUri(this.generateResourceUri(new String[]{"controller/flow-analysis-rules", flowAnalysisRuleEntity.getId()}));
        return flowAnalysisRuleEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules")
    @Operation(summary="Gets all flow analysis rules", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRulesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRules() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set flowAnalysisRules = this.serviceFacade.getFlowAnalysisRules();
        this.populateRemainingFlowAnalysisRuleEntitiesContent(flowAnalysisRules);
        FlowAnalysisRulesEntity entity = new FlowAnalysisRulesEntity();
        entity.setFlowAnalysisRules(flowAnalysisRules);
        entity.setCurrentTime(new Date());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}")
    @Operation(summary="Gets a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowAnalysisRuleEntity.class))})}, security={@SecurityRequirement(name="Read - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRule(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        FlowAnalysisRuleEntity flowAnalysisRule = this.serviceFacade.getFlowAnalysisRule(id);
        this.populateRemainingFlowAnalysisRuleEntityContent(flowAnalysisRule);
        return this.generateOkResponse((Object)flowAnalysisRule).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/descriptors")
    @Operation(summary="Gets a flow analysis rule property descriptor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PropertyDescriptorEntity.class))})}, security={@SecurityRequirement(name="Read - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRulePropertyDescriptor(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id, @Parameter(description="The property name.", required=true) @QueryParam(value="propertyName") String propertyName, @Parameter(description="Property Descriptor requested sensitive status") @QueryParam(value="sensitive") boolean sensitive) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        PropertyDescriptorDTO descriptor = this.serviceFacade.getFlowAnalysisRulePropertyDescriptor(id, propertyName, sensitive);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/state")
    @Operation(summary="Gets the state for a flow analysis rule", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRuleState(@Parameter(description="The flow analysis rule id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        ComponentStateDTO state = this.serviceFacade.getFlowAnalysisRuleState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/config/analysis")
    @Operation(summary="Performs analysis of the component's configuration, providing information about which attributes are referenced.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConfigurationAnalysisEntity.class))})}, security={@SecurityRequirement(name="Read - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response analyzeFlowAnalysisRuleConfiguration(@Parameter(description="The flow analysis rules id.", required=true) @PathParam(value="id") String flowAnalysisRuleId, @Parameter(description="The configuration analysis request.", required=true) ConfigurationAnalysisEntity configurationAnalysis) {
        if (configurationAnalysis == null || configurationAnalysis.getConfigurationAnalysis() == null) {
            throw new IllegalArgumentException("Flow Analysis Rules's configuration must be specified");
        }
        ConfigurationAnalysisDTO dto = configurationAnalysis.getConfigurationAnalysis();
        if (dto.getComponentId() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule's identifier must be specified in the request");
        }
        if (!dto.getComponentId().equals(flowAnalysisRuleId)) {
            throw new IllegalArgumentException("Flow Analysis Rule's identifier in the request must match the identifier provided in the URL");
        }
        if (dto.getProperties() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule's properties must be specified in the request");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)configurationAnalysis);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)configurationAnalysis, lookup -> this.authorizeController(RequestAction.READ), () -> {}, entity -> {
            ConfigurationAnalysisDTO analysis = entity.getConfigurationAnalysis();
            ConfigurationAnalysisEntity resultsEntity = this.serviceFacade.analyzeFlowAnalysisRuleConfiguration(analysis.getComponentId(), analysis.getProperties());
            return this.generateOkResponse((Object)resultsEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/config/verification-requests")
    @Operation(summary="Performs verification of the Flow Analysis Rule's configuration", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="This will initiate the process of verifying a given Flow Analysis Rule configuration. This may be a long-running task. As a result, this endpoint will immediately return a FlowAnalysisRuleConfigVerificationRequestEntity, and the process of performing the verification will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /flow-analysis-rules/{taskId}/verification-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /flow-analysis-rules/{serviceId}/verification-requests/{requestId}.", security={@SecurityRequirement(name="Read - /flow-analysis-rules/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitFlowAnalysisRuleConfigVerificationRequest(@Parameter(description="The flow analysis rules id.", required=true) @PathParam(value="id") String flowAnalysisRuleId, @Parameter(description="The flow analysis rules configuration verification request.", required=true) VerifyConfigRequestEntity flowAnalysisRuleConfigRequest) {
        if (flowAnalysisRuleConfigRequest == null) {
            throw new IllegalArgumentException("Flow Analysis Rule's configuration must be specified");
        }
        VerifyConfigRequestDTO requestDto = flowAnalysisRuleConfigRequest.getRequest();
        if (requestDto == null || requestDto.getProperties() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule Properties must be specified");
        }
        if (requestDto.getComponentId() == null) {
            throw new IllegalArgumentException("Flow Analysis Rule's identifier must be specified in the request");
        }
        if (!requestDto.getComponentId().equals(flowAnalysisRuleId)) {
            throw new IllegalArgumentException("Flow Analysis Rule's identifier in the request must match the identifier provided in the URL");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)flowAnalysisRuleConfigRequest);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)flowAnalysisRuleConfigRequest, lookup -> this.authorizeController(RequestAction.READ), () -> this.serviceFacade.verifyCanVerifyFlowAnalysisRuleConfig(flowAnalysisRuleId), entity -> this.performAsyncFlowAnalysisRuleConfigVerification(entity, user));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/config/verification-requests/{requestId}")
    @Operation(summary="Returns the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Returns the Verification Request with the given ID. Once an Verification Request has been created, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowAnalysisRuleVerificationRequest(@Parameter(description="The ID of the Flow Analysis Rule") @PathParam(value="id") String flowAnalysisRuleId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
        VerifyConfigRequestEntity updateRequestEntity = this.createVerifyFlowAnalysisRuleConfigRequestEntity(asyncRequest, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="flow-analysis-rules/{id}/config/verification-requests/{requestId}")
    @Operation(summary="Deletes the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Deletes the Verification Request with the given ID. After a request is created, it is expected that the client will properly clean up the request by DELETE'ing it, once the Verification process has completed. If the request is deleted before the request completes, then the Verification request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteFlowAnalysisRuleVerificationRequest(@Parameter(description="The ID of the Flow Analysis Rule") @PathParam(value="id") String flowAnalysisRuleId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        boolean twoPhaseRequest = this.isTwoPhaseRequest(this.httpServletRequest);
        boolean executionPhase = this.isExecutionPhase(this.httpServletRequest);
        if (!twoPhaseRequest || executionPhase) {
            AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.removeRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            if (asyncRequest == null) {
                throw new ResourceNotFoundException("Could not find request of type verification-request with ID " + requestId);
            }
            if (!asyncRequest.isComplete()) {
                asyncRequest.cancel();
            }
            VerifyConfigRequestEntity updateRequestEntity = this.createVerifyFlowAnalysisRuleConfigRequestEntity(asyncRequest, requestId);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        }
        if (this.isValidationPhase(this.httpServletRequest)) {
            this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            return this.generateContinueResponse().build();
        }
        if (this.isCancellationPhase(this.httpServletRequest)) {
            return this.generateOkResponse().build();
        }
        throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
    }

    public Response performAsyncFlowAnalysisRuleConfigVerification(VerifyConfigRequestEntity configRequest, NiFiUser user) {
        String requestId = this.generateUuid();
        VerifyConfigRequestDTO requestDto = configRequest.getRequest();
        String taskId = requestDto.getComponentId();
        List<StandardUpdateStep> updateSteps = Collections.singletonList(new StandardUpdateStep("Verify Flow Analysis Rule Configuration"));
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)configRequest, taskId, user, updateSteps);
        Consumer<AsynchronousWebRequest> verificationTask = asyncRequest -> {
            try {
                List results = this.serviceFacade.performFlowAnalysisRuleConfigVerification(taskId, requestDto.getProperties());
                asyncRequest.markStepComplete((Object)results);
            }
            catch (Exception e) {
                LOGGER.error("Failed to verify Flow Analysis Rule configuration", (Throwable)e);
                asyncRequest.fail("Failed to verify Flow Analysis Rule configuration due to " + String.valueOf(e));
            }
        };
        this.configVerificationRequestManager.submitRequest(VERIFICATION_REQUEST_TYPE, requestId, (AsynchronousWebRequest)request, verificationTask);
        VerifyConfigRequestEntity resultsEntity = this.createVerifyFlowAnalysisRuleConfigRequestEntity((AsynchronousWebRequest)request, requestId);
        return this.generateOkResponse((Object)resultsEntity).build();
    }

    private VerifyConfigRequestEntity createVerifyFlowAnalysisRuleConfigRequestEntity(AsynchronousWebRequest<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> asyncRequest, String requestId) {
        VerifyConfigRequestDTO requestDto = ((VerifyConfigRequestEntity)asyncRequest.getRequest()).getRequest();
        List resultsList = (List)asyncRequest.getResults();
        VerifyConfigRequestDTO dto = new VerifyConfigRequestDTO();
        dto.setComponentId(requestDto.getComponentId());
        dto.setProperties(requestDto.getProperties());
        dto.setResults(resultsList);
        dto.setComplete(asyncRequest.isComplete());
        dto.setFailureReason(asyncRequest.getFailureReason());
        dto.setLastUpdated(asyncRequest.getLastUpdated());
        dto.setPercentCompleted(asyncRequest.getPercentComplete());
        dto.setRequestId(requestId);
        dto.setState(asyncRequest.getState());
        dto.setUri(this.generateResourceUri(new String[]{"controller/flow-analysis-rules", requestDto.getComponentId(), "config", "verification-requests", requestId}));
        VerifyConfigRequestEntity entity = new VerifyConfigRequestEntity();
        entity.setRequest(dto);
        return entity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registry-clients")
    @Operation(summary="Gets the listing of available flow registry clients", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientsEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowRegistryClients() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set flowRegistryClients = this.serviceFacade.getRegistryClients();
        FlowRegistryClientsEntity flowRegistryClientEntities = new FlowRegistryClientsEntity();
        flowRegistryClientEntities.setCurrentTime(new Date());
        flowRegistryClientEntities.setRegistries(flowRegistryClients);
        return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(flowRegistryClientEntities)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="registry-clients")
    @Operation(summary="Creates a new flow registry client", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createFlowRegistryClient(@Parameter(description="The flow registry client configuration details.", required=true) FlowRegistryClientEntity requestFlowRegistryClientEntity) {
        this.authorizeController(RequestAction.READ);
        if (requestFlowRegistryClientEntity == null || requestFlowRegistryClientEntity.getComponent() == null) {
            throw new IllegalArgumentException("Flow Registry client details must be specified.");
        }
        if (requestFlowRegistryClientEntity.getRevision() == null || requestFlowRegistryClientEntity.getRevision().getVersion() == null || requestFlowRegistryClientEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Flow Registry.");
        }
        FlowRegistryClientDTO requestRegistryClient = requestFlowRegistryClientEntity.getComponent();
        if (requestRegistryClient.getId() != null) {
            throw new IllegalArgumentException("Flow Registry ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestRegistryClient.getName())) {
            throw new IllegalArgumentException("Flow Registry name must be specified.");
        }
        if (requestRegistryClient.getType() == null) {
            throw new IllegalArgumentException("The flow registry client type must be specified.");
        }
        if (this.serviceFacade.getRegistryClients().stream().anyMatch(rce -> requestRegistryClient.getName().equals(rce.getComponent().getName()))) {
            throw new IllegalArgumentException("A Flow Registry already exists with the name " + requestRegistryClient.getName());
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestFlowRegistryClientEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFlowRegistryClientEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowRegistryClientEntity, lookup -> this.authorizeController(RequestAction.WRITE), null, registryClientEntity -> {
            FlowRegistryClientDTO flowRegistryClient = registryClientEntity.getComponent();
            flowRegistryClient.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)registryClientEntity, flowRegistryClient.getId());
            FlowRegistryClientEntity entity = this.serviceFacade.createRegistryClient(revision, flowRegistryClient);
            this.populateRemainingRegistryClientEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @Operation(summary="Gets a flow registry client", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowRegistryClient(@Parameter(description="The flow registry client id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        FlowRegistryClientEntity entity = this.serviceFacade.getRegistryClient(id);
        return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @Operation(summary="Updates a flow registry client", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateFlowRegistryClient(@Parameter(description="The flow registry client id.", required=true) @PathParam(value="id") String id, @Parameter(description="The flow registry client configuration details.", required=true) FlowRegistryClientEntity requestFlowRegistryClientEntity) {
        if (requestFlowRegistryClientEntity == null || requestFlowRegistryClientEntity.getComponent() == null) {
            throw new IllegalArgumentException("Flow registry client details must be specified.");
        }
        if (requestFlowRegistryClientEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        this.authorizeController(RequestAction.WRITE);
        FlowRegistryClientDTO requestRegistryClient = requestFlowRegistryClientEntity.getComponent();
        if (!id.equals(requestRegistryClient.getId())) {
            throw new IllegalArgumentException(String.format("The flow registry client id (%s) in the request body does not equal the  id of the requested resource (%s).", requestRegistryClient.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestFlowRegistryClientEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestFlowRegistryClientEntity.isDisconnectedNodeAcknowledged());
        }
        if (requestRegistryClient.getName() != null && StringUtils.isBlank((CharSequence)requestRegistryClient.getName())) {
            throw new IllegalArgumentException("Flow registry client name must be specified.");
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestFlowRegistryClientEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowRegistryClientEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), null, (revision, registryClientEntity) -> {
            FlowRegistryClientDTO registry = registryClientEntity.getComponent();
            FlowRegistryClientEntity entity = this.serviceFacade.updateRegistryClient(revision, registry);
            return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}")
    @Operation(summary="Deletes a flow registry client", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteFlowRegistryClient(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The flow registry client id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        this.authorizeController(RequestAction.WRITE);
        FlowRegistryClientEntity requestFlowRegistryClientEntity = new FlowRegistryClientEntity();
        requestFlowRegistryClientEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestFlowRegistryClientEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), () -> this.serviceFacade.verifyDeleteRegistry(id), (revision, registryClientEntity) -> {
            FlowRegistryClientEntity entity = this.serviceFacade.deleteRegistryClient(revision, registryClientEntity.getId());
            return this.generateOkResponse((Object)this.populateRemainingRegistryClientEntityContent(entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/registry-clients/{id}/descriptors")
    @Operation(summary="Gets a flow registry client property descriptor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PropertyDescriptorEntity.class))})}, security={@SecurityRequirement(name="Read - /controller/registry-clients/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getPropertyDescriptor(@Parameter(description="The flow registry client id.", required=true) @PathParam(value="id") String id, @Parameter(description="The property name.", required=true) @QueryParam(value="propertyName") String propertyName, @Parameter(description="Property Descriptor requested sensitive status") @QueryParam(value="sensitive") boolean sensitive) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeController(RequestAction.READ);
        PropertyDescriptorDTO descriptor = this.serviceFacade.getRegistryClientPropertyDescriptor(id, propertyName, sensitive);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="registry-types")
    @Operation(summary="Retrieves the types of flow  that this NiFi supports", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowRegistryClientTypesEntity.class))})}, security={@SecurityRequirement(name="Read - /flow")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getRegistryClientTypes() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowRegistryClientTypesEntity entity = new FlowRegistryClientTypesEntity();
        entity.setFlowRegistryClientTypes(this.serviceFacade.getFlowRegistryTypes());
        return this.generateOkResponse((Object)entity).build();
    }

    private FlowRegistryClientEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientEntity flowRegistryClientEntity) {
        flowRegistryClientEntity.setUri(this.generateResourceUri(new String[]{"controller", "registry-clients", flowRegistryClientEntity.getId()}));
        return flowRegistryClientEntity;
    }

    private FlowRegistryClientsEntity populateRemainingRegistryClientEntityContent(FlowRegistryClientsEntity flowRegistryClientsEntity) {
        for (FlowRegistryClientEntity entity : flowRegistryClientsEntity.getRegistries()) {
            this.populateRemainingRegistryClientEntityContent(entity);
        }
        return flowRegistryClientsEntity;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="bulletin")
    @Operation(summary="Creates a new bulletin", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=BulletinEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createBulletin(@Parameter(description="The reporting task configuration details.", required=true) BulletinEntity requestBulletinEntity) {
        if (requestBulletinEntity == null || requestBulletinEntity.getBulletin() == null) {
            throw new IllegalArgumentException("Bulletin details must be specified.");
        }
        BulletinDTO requestBulletin = requestBulletinEntity.getBulletin();
        if (requestBulletin.getId() != null) {
            throw new IllegalArgumentException("A bulletin ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestBulletin.getMessage())) {
            throw new IllegalArgumentException("The bulletin message must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestBulletinEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestBulletinEntity, lookup -> this.authorizeController(RequestAction.WRITE), null, bulletinEntity -> {
            BulletinDTO bulletin = bulletinEntity.getBulletin();
            BulletinEntity entity = this.serviceFacade.createBulletin(bulletin, Boolean.valueOf(true));
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="controller-services")
    @Operation(summary="Creates a new controller service", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ControllerServiceEntity.class))})}, security={@SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}"), @SecurityRequirement(name="Write - if the Controller Service is restricted - /restricted-components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createControllerService(@Parameter(description="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (requestControllerService.getParentGroupId() != null) {
            throw new IllegalArgumentException("Parent process group ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestControllerServiceEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestControllerService.getType(), requestControllerService.getBundle());
                if (authorizable.isRestricted()) {
                    this.authorizeRestrictions(this.authorizer, authorizable);
                }
                if (requestControllerService.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateControllerService(requestControllerService), controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, null, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster")
    @Operation(summary="Gets the contents of the cluster", description="Returns the contents of the cluster including all nodes and their status.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ClusterEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getCluster() {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET", this.getClusterCoordinatorNode());
        }
        ClusterDTO dto = this.serviceFacade.getCluster();
        ClusterEntity entity = new ClusterEntity();
        entity.setCluster(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @Operation(summary="Gets a node in the cluster", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NodeEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getNode(@Parameter(description="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET", this.getClusterCoordinatorNode());
        }
        NodeDTO dto = this.serviceFacade.getNode(id);
        NodeEntity entity = new NodeEntity();
        entity.setNode(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @Operation(summary="Updates a node in the cluster", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NodeEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateNode(@Parameter(description="The node id.", required=true) @PathParam(value="id") String id, @Parameter(description="The node configuration. The only configuration that will be honored at this endpoint is the status.", required=true) NodeEntity nodeEntity) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (nodeEntity == null || nodeEntity.getNode() == null) {
            throw new IllegalArgumentException("Node details must be specified.");
        }
        NodeDTO requestNodeDTO = nodeEntity.getNode();
        if (!id.equals(requestNodeDTO.getNodeId())) {
            throw new IllegalArgumentException(String.format("The node id (%s) in the request body does not equal the node id of the requested resource (%s).", requestNodeDTO.getNodeId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("PUT", (Object)nodeEntity);
        }
        NodeDTO node = this.serviceFacade.updateNode(requestNodeDTO);
        NodeEntity entity = new NodeEntity();
        entity.setNode(node);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @Operation(summary="Removes a node from the cluster", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NodeEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteNode(@Parameter(description="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("DELETE", (Object)this.getRequestParameters());
        }
        this.serviceFacade.deleteNode(id);
        NodeEntity entity = new NodeEntity();
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="status/history")
    @Operation(summary="Gets status history for the node", description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentHistoryEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getNodeStatusHistory() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        return this.generateOkResponse((Object)this.serviceFacade.getNodeStatusHistory()).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @Operation(summary="Purges history", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=HistoryEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteHistory(@Parameter(description="Purge actions before this date/time.", required=true) @QueryParam(value="endDate") DateTimeParameter endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("The end date must be specified.");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new EndDateEntity(this, endDate.getDateTime()), lookup -> this.authorizeController(RequestAction.WRITE), null, endDateEntity -> {
            this.serviceFacade.deleteActions(endDateEntity.getEndDate());
            return this.generateOkResponse((Object)new HistoryEntity()).build();
        });
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Path(value="nar-manager/nars/content")
    @Operation(summary="Uploads a NAR and requests for it to be installed", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NarSummaryEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response uploadNar(@HeaderParam(value="Filename") String filename, @Parameter(description="The contents of the NAR file.", required=true) InputStream inputStream) throws IOException {
        Set disconnectedNodes;
        this.authorizeController(RequestAction.WRITE);
        if (StringUtils.isBlank((CharSequence)filename)) {
            throw new IllegalArgumentException("Filename header is required");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("NAR contents are required");
        }
        ClusterCoordinator clusterCoordinator = this.getClusterCoordinator();
        if (clusterCoordinator != null && !(disconnectedNodes = clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[]{NodeConnectionState.CONNECTING, NodeConnectionState.DISCONNECTED, NodeConnectionState.DISCONNECTING})).isEmpty()) {
            throw new IllegalStateException("Cannot upload NAR because the following %s nodes are not currently connected: %s".formatted(disconnectedNodes.size(), disconnectedNodes));
        }
        long startTime = System.currentTimeMillis();
        MaxLengthInputStream maxLengthInputStream = new MaxLengthInputStream(inputStream, (long)DataUnit.GB.toB(1.0));
        if (this.isReplicateRequest()) {
            UploadRequest uploadRequest = new UploadRequest.Builder().user(NiFiUserUtils.getNiFiUser()).filename(filename).identifier(UUID.randomUUID().toString()).contents((InputStream)maxLengthInputStream).header(FILENAME_HEADER, filename).header(CONTENT_TYPE_HEADER, UPLOAD_CONTENT_TYPE).exampleRequestUri(this.getAbsolutePath()).responseClass(NarSummaryEntity.class).successfulResponseStatus(HttpResponseStatus.OK.getCode()).build();
            NarSummaryEntity summaryEntity = (NarSummaryEntity)this.uploadRequestReplicator.upload(uploadRequest);
            return this.generateOkResponse((Object)summaryEntity).build();
        }
        NarSummaryEntity summaryEntity = this.serviceFacade.uploadNar((InputStream)maxLengthInputStream);
        NarSummaryDTO summary = summaryEntity.getNarSummary();
        long elapsedTime = System.currentTimeMillis() - startTime;
        LOGGER.info("Upload completed for NAR [{}] in {} ms", (Object)summary.getIdentifier(), (Object)elapsedTime);
        return this.generateOkResponse((Object)summaryEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/nar-manager/nars")
    @Operation(summary="Retrieves summary information for installed NARs", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NarSummariesEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getNarSummaries() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NarSummariesEntity summariesEntity = new NarSummariesEntity();
        summariesEntity.setNarSummaries((Collection)this.serviceFacade.getNarSummaries());
        summariesEntity.setCurrentTime(new Date());
        return this.generateOkResponse((Object)summariesEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/nar-manager/nars/{id}")
    @Operation(summary="Retrieves the summary information for the NAR with the given identifier", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NarDetailsEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getNarSummary(@PathParam(value="id") @Parameter(description="The id of the NAR.", required=true) String id) {
        this.authorizeController(RequestAction.READ);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is required");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NarSummaryEntity summaryEntity = this.serviceFacade.getNarSummary(id);
        return this.generateOkResponse((Object)summaryEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/nar-manager/nars/{id}/details")
    @Operation(summary="Retrieves the component types available from the installed NARs", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NarDetailsEntity.class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getNarDetails(@PathParam(value="id") @Parameter(description="The id of the NAR.", required=true) String id) {
        this.authorizeController(RequestAction.READ);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is required");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NarDetailsEntity detailsEntity = this.serviceFacade.getNarDetails(id);
        return this.generateOkResponse((Object)detailsEntity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    @Path(value="/nar-manager/nars/{id}/content")
    @Operation(summary="Retrieves the content of the NAR with the given id", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=byte[].class))})}, security={@SecurityRequirement(name="Read - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response downloadNar(@PathParam(value="id") @Parameter(description="The id of the NAR.", required=true) String id) {
        this.authorizeController(RequestAction.READ);
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is required");
        }
        NarSummaryEntity summaryEntity = this.serviceFacade.getNarSummary(id);
        NarSummaryDTO summaryDTO = summaryEntity.getNarSummary();
        NarCoordinateDTO coordinateDTO = summaryDTO.getCoordinate();
        String filename = coordinateDTO.getArtifact() + "-" + coordinateDTO.getVersion() + ".nar";
        StreamingOutput streamingOutput = outputStream -> {
            try (InputStream narInputStream = this.serviceFacade.readNar(id);){
                narInputStream.transferTo(outputStream);
            }
        };
        return this.generateOkResponse((Object)streamingOutput).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", filename)).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/nar-manager/nars/{id}")
    @Operation(summary="Deletes an installed NAR", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=NarSummaryEntity.class))})}, security={@SecurityRequirement(name="Write - /controller")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteNar(@QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @QueryParam(value="force") @DefaultValue(value="false") Boolean forceDelete, @PathParam(value="id") @Parameter(description="The id of the NAR.", required=true) String id) throws IOException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException("Id is required");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        NarSummaryEntity summaryEntity = new NarSummaryEntity(new NarSummaryDTO(id));
        return this.withWriteLock(this.serviceFacade, (Entity)summaryEntity, lookup -> this.authorizeController(RequestAction.WRITE), () -> this.serviceFacade.verifyDeleteNar(id, forceDelete.booleanValue()), requestEntity -> {
            try {
                String requestId = requestEntity.getNarSummary().getIdentifier();
                NarSummaryEntity deletedNarSummary = this.serviceFacade.deleteNar(requestId);
                return this.generateOkResponse((Object)deletedNarSummary).build();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    @Autowired
    public void setParameterProviderResource(ParameterProviderResource parameterProviderResource) {
        this.parameterProviderResource = parameterProviderResource;
    }

    @Autowired
    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    @Autowired(required=false)
    public void setUploadRequestReplicator(UploadRequestReplicator uploadRequestReplicator) {
        this.uploadRequestReplicator = uploadRequestReplicator;
    }
}

