/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Objects;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AuthenticationConfigurationDTO;
import org.apache.nifi.web.api.entity.AuthenticationConfigurationEntity;
import org.apache.nifi.web.configuration.AuthenticationConfiguration;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;

@Controller
@Path(value="/authentication")
@Tag(name="Authentication")
public class AuthenticationResource
extends ApplicationResource {
    private final AuthenticationConfiguration authenticationConfiguration;

    public AuthenticationResource(AuthenticationConfiguration authenticationConfiguration, NiFiProperties properties, RequestReplicator requestReplicator, ClusterCoordinator clusterCoordinator, FlowController flowController) {
        this.authenticationConfiguration = Objects.requireNonNull(authenticationConfiguration);
        this.setProperties(properties);
        this.setRequestReplicator(requestReplicator);
        this.setClusterCoordinator(clusterCoordinator);
        this.setFlowController(flowController);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/configuration")
    @Operation(summary="Retrieves the authentication configuration endpoint and status information", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AuthenticationConfigurationEntity.class))})})
    public Response getAuthenticationConfiguration() {
        URI configuredLogoutUri;
        AuthenticationConfigurationDTO configuration = new AuthenticationConfigurationDTO();
        configuration.setExternalLoginRequired(this.authenticationConfiguration.externalLoginRequired());
        configuration.setLoginSupported(this.authenticationConfiguration.loginSupported());
        URI configuredLoginUri = this.authenticationConfiguration.loginUri();
        if (configuredLoginUri != null) {
            String loginUri = this.getAuthenticationUri(configuredLoginUri);
            configuration.setLoginUri(loginUri);
        }
        if ((configuredLogoutUri = this.authenticationConfiguration.logoutUri()) != null) {
            String logoutUri = this.getAuthenticationUri(configuredLogoutUri);
            configuration.setLogoutUri(logoutUri);
        }
        AuthenticationConfigurationEntity entity = new AuthenticationConfigurationEntity();
        entity.setAuthenticationConfiguration(configuration);
        return this.generateOkResponse((Object)entity).build();
    }

    private String getAuthenticationUri(URI configuredUri) {
        RequestUriBuilder builder = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)this.httpServletRequest);
        builder.path(configuredUri.getPath());
        String fragment = configuredUri.getFragment();
        if (StringUtils.hasText((String)fragment)) {
            builder.fragment(fragment);
        }
        return builder.build().toString();
    }
}

