/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import java.net.URI;
import java.util.Map;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParameterResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(AbstractParameterResource.class);

    public NodeResponse updateParameterContext(ParameterContextEntity parameterContext, URI updateUri, Map<String, String> headers, NiFiUser user) throws LifecycleManagementException {
        NodeResponse clusterResponse;
        try {
            logger.debug("Replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
            clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", updateUri, (Object)parameterContext, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", updateUri, (Object)parameterContext, headers).awaitMergedResponse();
        }
        catch (InterruptedException ie) {
            logger.warn("Interrupted while replicating PUT request to {} for user {}", (Object)updateUri, (Object)user);
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while updating flows across cluster", (Throwable)ie);
        }
        return clusterResponse;
    }
}

