/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.prometheusutil;

import io.prometheus.client.CollectorRegistry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.prometheusutil.BulletinMetricsRegistry;
import org.apache.nifi.prometheusutil.ClusterMetricsRegistry;
import org.apache.nifi.prometheusutil.ConnectionAnalyticsMetricsRegistry;
import org.apache.nifi.prometheusutil.JvmMetricsRegistry;
import org.apache.nifi.prometheusutil.NiFiMetricsRegistry;
import org.apache.nifi.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrometheusMetricsUtil {
    public static final AllowableValue METRICS_STRATEGY_PG = new AllowableValue("All Process Groups", "All Process Groups", "Send metrics for each process group");
    public static final AllowableValue METRICS_STRATEGY_COMPONENTS = new AllowableValue("All Components", "All Components", "Send metrics for each component in the system, to include processors, connections, controller services, etc.");
    protected static final String DEFAULT_LABEL_STRING = "";
    private static final double MAXIMUM_BACKPRESSURE = 1.0;
    private static final double UNDEFINED_BACKPRESSURE = -1.0;

    public static CollectorRegistry createNifiMetrics(NiFiMetricsRegistry nifiMetricsRegistry, ProcessGroupStatus status, String instId, String parentProcessGroupId, String compType, String metricsStrategy) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        String parentPGId = StringUtils.isEmpty((String)parentProcessGroupId) ? "" : parentProcessGroupId;
        String componentType = StringUtils.isEmpty((String)compType) ? "" : compType;
        String componentId = StringUtils.isEmpty((String)status.getId()) ? "" : status.getId();
        String componentName = StringUtils.isEmpty((String)status.getName()) ? "" : status.getName();
        nifiMetricsRegistry.setDataPoint((double)status.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getFlowFilesTransferred(), "AMOUNT_FLOWFILES_TRANSFERRED", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getBytesSent(), "AMOUNT_BYTES_SENT", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getBytesRead().longValue(), "AMOUNT_BYTES_READ", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getBytesWritten().longValue(), "AMOUNT_BYTES_WRITTEN", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getBytesTransferred(), "AMOUNT_BYTES_TRANSFERRED", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint((double)status.getOutputContentSize().longValue(), "SIZE_CONTENT_OUTPUT_TOTAL", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint((double)status.getInputContentSize().longValue(), "SIZE_CONTENT_INPUT_TOTAL", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint((double)status.getQueuedContentSize().longValue(), "SIZE_CONTENT_QUEUED_TOTAL", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint((double)status.getOutputCount().intValue(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint((double)status.getInputCount().intValue(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint((double)status.getQueuedCount().intValue(), "AMOUNT_ITEMS_QUEUED", new String[]{instanceId, componentType, componentName, componentId, parentPGId, "", "", "", ""});
        nifiMetricsRegistry.setDataPoint(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        nifiMetricsRegistry.setDataPoint(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_TERMINATED", new String[]{instanceId, componentType, componentName, componentId, parentPGId});
        if (METRICS_STRATEGY_PG.getValue().equals(metricsStrategy) || METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            status.getProcessGroupStatus().forEach(childGroupStatus -> PrometheusMetricsUtil.createNifiMetrics((NiFiMetricsRegistry)nifiMetricsRegistry, (ProcessGroupStatus)childGroupStatus, (String)instanceId, (String)componentId, (String)"ProcessGroup", (String)metricsStrategy));
        }
        if (METRICS_STRATEGY_COMPONENTS.getValue().equals(metricsStrategy)) {
            Boolean isTransmitting;
            String portComponentType;
            String parentId;
            String portComponentName;
            String portComponentId;
            for (ProcessorStatus processorStatus : status.getProcessorStatus()) {
                Map counters = processorStatus.getCounters();
                if (counters != null) {
                    counters.entrySet().stream().forEach(entry -> nifiMetricsRegistry.setDataPoint((double)((Long)entry.getValue()).longValue(), "PROCESSOR_COUNTERS", new String[]{processorStatus.getName(), (String)entry.getKey(), processorStatus.getId(), instanceId}));
                }
                String procComponentType = "Processor";
                String procComponentId = StringUtils.isEmpty((String)processorStatus.getId()) ? "" : processorStatus.getId();
                String procComponentName = StringUtils.isEmpty((String)processorStatus.getName()) ? "" : processorStatus.getName();
                String parentId2 = StringUtils.isEmpty((String)processorStatus.getGroupId()) ? "" : processorStatus.getGroupId();
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getFlowFilesRemoved(), "AMOUNT_FLOWFILES_REMOVED", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getBytesSent(), "AMOUNT_BYTES_SENT", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getBytesRead(), "AMOUNT_BYTES_READ", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getBytesWritten(), "AMOUNT_BYTES_WRITTEN", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getOutputBytes(), "SIZE_CONTENT_OUTPUT_TOTAL", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getInputBytes(), "SIZE_CONTENT_INPUT_TOTAL", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)processorStatus.getAverageLineageDuration(), "AVERAGE_LINEAGE_DURATION", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint(status.getActiveThreadCount() == null ? 0.0 : (double)status.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
                nifiMetricsRegistry.setDataPoint(status.getTerminatedThreadCount() == null ? 0.0 : (double)status.getTerminatedThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_TERMINATED", new String[]{instanceId, "Processor", procComponentName, procComponentId, parentId2});
            }
            for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
                String connComponentId = StringUtils.isEmpty((String)connectionStatus.getId()) ? "" : connectionStatus.getId();
                String connComponentName = StringUtils.isEmpty((String)connectionStatus.getName()) ? "" : connectionStatus.getName();
                String sourceId = StringUtils.isEmpty((String)connectionStatus.getSourceId()) ? "" : connectionStatus.getSourceId();
                String sourceName = StringUtils.isEmpty((String)connectionStatus.getSourceName()) ? "" : connectionStatus.getSourceName();
                String destinationId = StringUtils.isEmpty((String)connectionStatus.getDestinationId()) ? "" : connectionStatus.getDestinationId();
                String destinationName = StringUtils.isEmpty((String)connectionStatus.getDestinationName()) ? "" : connectionStatus.getDestinationName();
                String parentId3 = StringUtils.isEmpty((String)connectionStatus.getGroupId()) ? "" : connectionStatus.getGroupId();
                String connComponentType = "Connection";
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getOutputBytes(), "SIZE_CONTENT_OUTPUT_TOTAL", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getInputBytes(), "SIZE_CONTENT_INPUT_TOTAL", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getQueuedBytes(), "SIZE_CONTENT_QUEUED_TOTAL", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getQueuedCount(), "AMOUNT_ITEMS_QUEUED", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getBackPressureBytesThreshold(), "BACKPRESSURE_BYTES_THRESHOLD", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint((double)connectionStatus.getBackPressureObjectThreshold(), "BACKPRESSURE_OBJECT_THRESHOLD", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint(PrometheusMetricsUtil.getUtilization((double)connectionStatus.getQueuedBytes(), (double)connectionStatus.getBackPressureBytesThreshold()), "PERCENT_USED_BYTES", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                nifiMetricsRegistry.setDataPoint(PrometheusMetricsUtil.getUtilization((double)connectionStatus.getQueuedCount(), (double)connectionStatus.getBackPressureObjectThreshold()), "PERCENT_USED_COUNT", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
                boolean isBackpressureEnabled = connectionStatus.getBackPressureObjectThreshold() > 0L && connectionStatus.getBackPressureObjectThreshold() <= (long)connectionStatus.getQueuedCount() || connectionStatus.getBackPressureBytesThreshold() > 0L && connectionStatus.getBackPressureBytesThreshold() <= connectionStatus.getQueuedBytes();
                nifiMetricsRegistry.setDataPoint(isBackpressureEnabled ? 1.0 : 0.0, "IS_BACKPRESSURE_ENABLED", new String[]{instanceId, "Connection", connComponentName, connComponentId, parentId3, sourceId, sourceName, destinationId, destinationName});
            }
            for (PortStatus portStatus : status.getInputPortStatus()) {
                portComponentId = StringUtils.isEmpty((String)portStatus.getId()) ? "" : portStatus.getId();
                portComponentName = StringUtils.isEmpty((String)portStatus.getName()) ? "" : portStatus.getId();
                parentId = StringUtils.isEmpty((String)portStatus.getGroupId()) ? "" : portStatus.getId();
                portComponentType = "InputPort";
                nifiMetricsRegistry.setDataPoint((double)portStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getBytesSent(), "AMOUNT_BYTES_SENT", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getInputBytes(), "AMOUNT_BYTES_READ", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getOutputBytes(), "AMOUNT_BYTES_WRITTEN", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, "", "", "", ""});
                isTransmitting = portStatus.isTransmitting();
                nifiMetricsRegistry.setDataPoint(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0), "IS_TRANSMITTING", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name()});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", new String[]{instanceId, "InputPort", portComponentName, portComponentId, parentId});
            }
            for (PortStatus portStatus : status.getOutputPortStatus()) {
                portComponentId = StringUtils.isEmpty((String)portStatus.getId()) ? "" : portStatus.getId();
                portComponentName = StringUtils.isEmpty((String)portStatus.getName()) ? "" : portStatus.getName();
                parentId = StringUtils.isEmpty((String)portStatus.getGroupId()) ? "" : portStatus.getGroupId();
                portComponentType = "OutputPort";
                nifiMetricsRegistry.setDataPoint((double)portStatus.getFlowFilesSent(), "AMOUNT_FLOWFILES_SENT", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getFlowFilesReceived(), "AMOUNT_FLOWFILES_RECEIVED", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getBytesSent(), "AMOUNT_BYTES_SENT", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getInputBytes(), "AMOUNT_BYTES_READ", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getOutputBytes(), "AMOUNT_BYTES_WRITTEN", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getBytesReceived(), "AMOUNT_BYTES_RECEIVED", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getOutputCount(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getInputCount(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, "", "", "", ""});
                isTransmitting = portStatus.isTransmitting();
                nifiMetricsRegistry.setDataPoint(isTransmitting == null ? 0.0 : (double)(isTransmitting != false ? 1 : 0), "IS_TRANSMITTING", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId, portStatus.getRunStatus().name()});
                nifiMetricsRegistry.setDataPoint((double)portStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", new String[]{instanceId, "OutputPort", portComponentName, portComponentId, parentId});
            }
            for (RemoteProcessGroupStatus remoteProcessGroupStatus : status.getRemoteProcessGroupStatus()) {
                String rpgComponentId = StringUtils.isEmpty((String)remoteProcessGroupStatus.getId()) ? "" : remoteProcessGroupStatus.getId();
                String rpgComponentName = StringUtils.isEmpty((String)remoteProcessGroupStatus.getName()) ? "" : remoteProcessGroupStatus.getName();
                parentId = StringUtils.isEmpty((String)remoteProcessGroupStatus.getGroupId()) ? "" : remoteProcessGroupStatus.getGroupId();
                String rpgComponentType = "RemoteProcessGroup";
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getSentContentSize().longValue(), "AMOUNT_BYTES_WRITTEN", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getReceivedContentSize().longValue(), "AMOUNT_BYTES_RECEIVED", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getSentCount().intValue(), "AMOUNT_ITEMS_OUTPUT", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getReceivedCount().intValue(), "AMOUNT_ITEMS_INPUT", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getActiveRemotePortCount().intValue(), "ACTIVE_REMOTE_PORT_COUNT", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getInactiveRemotePortCount().intValue(), "INACTIVE_REMOTE_PORT_COUNT", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getAverageLineageDuration(), "AVERAGE_LINEAGE_DURATION", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, "", "", "", ""});
                nifiMetricsRegistry.setDataPoint(TransmissionStatus.Transmitting.equals((Object)remoteProcessGroupStatus.getTransmissionStatus()) ? 1.0 : 0.0, "IS_TRANSMITTING", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId, remoteProcessGroupStatus.getTransmissionStatus().name()});
                nifiMetricsRegistry.setDataPoint((double)remoteProcessGroupStatus.getActiveThreadCount().intValue(), "AMOUNT_THREADS_TOTAL_ACTIVE", new String[]{instanceId, "RemoteProcessGroup", rpgComponentName, rpgComponentId, parentId});
            }
        }
        return nifiMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createJvmMetrics(JvmMetricsRegistry jvmMetricsRegistry, JvmMetrics jvmMetrics, String instId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        jvmMetricsRegistry.setDataPoint(jvmMetrics.heapUsed(DataUnit.B), "JVM_HEAP_USED", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint(jvmMetrics.heapUsage(), "JVM_HEAP_USAGE", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint(jvmMetrics.nonHeapUsage(), "JVM_HEAP_NON_USAGE", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint((double)jvmMetrics.threadCount(), "JVM_THREAD_COUNT", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint((double)jvmMetrics.daemonThreadCount(), "JVM_DAEMON_THREAD_COUNT", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint((double)jvmMetrics.uptime(), "JVM_UPTIME", new String[]{instanceId});
        jvmMetricsRegistry.setDataPoint(jvmMetrics.fileDescriptorUsage(), "JVM_FILE_DESCRIPTOR_USAGE", new String[]{instanceId});
        jvmMetrics.garbageCollectors().forEach((name, stat) -> {
            jvmMetricsRegistry.setDataPoint((double)stat.getRuns(), "JVM_GC_RUNS", new String[]{instanceId, name});
            jvmMetricsRegistry.setDataPoint((double)stat.getTime(TimeUnit.MILLISECONDS), "JVM_GC_TIME", new String[]{instanceId, name});
        });
        return jvmMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createConnectionStatusAnalyticsMetrics(ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry, StatusAnalytics statusAnalytics, String instId, String connComponentType, String connName, String connId, String pgId, String srcId, String srcName, String destId, String destName) {
        if (statusAnalytics != null) {
            String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
            String connComponentId = StringUtils.isEmpty((String)connId) ? "" : connId;
            String connComponentName = StringUtils.isEmpty((String)connName) ? "" : connName;
            String sourceId = StringUtils.isEmpty((String)srcId) ? "" : srcId;
            String sourceName = StringUtils.isEmpty((String)srcName) ? "" : srcName;
            String destinationId = StringUtils.isEmpty((String)destId) ? "" : destId;
            String destinationName = StringUtils.isEmpty((String)destName) ? "" : destName;
            String parentId = StringUtils.isEmpty((String)pgId) ? "" : pgId;
            Map predictions = statusAnalytics.getPredictions();
            connectionAnalyticsMetricsRegistry.setDataPoint((double)((Long)predictions.get("timeToBytesBackpressureMillis")).longValue(), "TIME_TO_BYTES_BACKPRESSURE_PREDICTION", new String[]{instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName});
            connectionAnalyticsMetricsRegistry.setDataPoint((double)((Long)predictions.get("timeToCountBackpressureMillis")).longValue(), "TIME_TO_COUNT_BACKPRESSURE_PREDICTION", new String[]{instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName});
            connectionAnalyticsMetricsRegistry.setDataPoint((double)((Long)predictions.get("nextIntervalBytes")).longValue(), "BYTES_AT_NEXT_INTERVAL_PREDICTION", new String[]{instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName});
            connectionAnalyticsMetricsRegistry.setDataPoint((double)((Long)predictions.get("nextIntervalCount")).longValue(), "COUNT_AT_NEXT_INTERVAL_PREDICTION", new String[]{instanceId, connComponentType, connComponentName, connComponentId, parentId, sourceId, sourceName, destinationId, destinationName});
        }
        return connectionAnalyticsMetricsRegistry.getRegistry();
    }

    private static double getUtilization(double used, double total) {
        return used / total * 100.0;
    }

    public static CollectorRegistry createBulletinMetrics(BulletinMetricsRegistry bulletinMetricsRegistry, String instId, String compType, String compId, String pgId, String nodeAddr, String cat, String srcName, String srcId, String lvl) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? "" : compType;
        String componentId = StringUtils.isEmpty((String)compId) ? "" : compId;
        String sourceId = StringUtils.isEmpty((String)srcId) ? "" : srcId;
        String sourceName = StringUtils.isEmpty((String)srcName) ? "" : srcName;
        String nodeAddress = StringUtils.isEmpty((String)nodeAddr) ? "" : nodeAddr;
        String category = StringUtils.isEmpty((String)cat) ? "" : cat;
        String parentId = StringUtils.isEmpty((String)pgId) ? "" : pgId;
        String level = StringUtils.isEmpty((String)lvl) ? "" : lvl;
        bulletinMetricsRegistry.setDataPoint(1.0, "BULLETIN", new String[]{instanceId, componentType, componentId, parentId, nodeAddress, category, sourceName, sourceId, level});
        return bulletinMetricsRegistry.getRegistry();
    }

    public static void aggregatePercentUsed(ProcessGroupStatus status, Map<String, Double> aggregatedMetrics) {
        status.getProcessGroupStatus().forEach(childGroupStatus -> PrometheusMetricsUtil.aggregatePercentUsed((ProcessGroupStatus)childGroupStatus, (Map)aggregatedMetrics));
        for (ConnectionStatus connectionStatus : status.getConnectionStatus()) {
            double percentUsedBytes = PrometheusMetricsUtil.getUtilization((double)connectionStatus.getQueuedBytes(), (double)connectionStatus.getBackPressureBytesThreshold());
            double percentUsedCount = PrometheusMetricsUtil.getUtilization((double)connectionStatus.getQueuedCount(), (double)connectionStatus.getBackPressureObjectThreshold());
            PrometheusMetricsUtil.determineMaxValueForPercentUsed(aggregatedMetrics, (String)"nifi_percent_used_bytes", (double)percentUsedBytes);
            PrometheusMetricsUtil.determineMaxValueForPercentUsed(aggregatedMetrics, (String)"nifi_percent_used_count", (double)percentUsedCount);
            PrometheusMetricsUtil.setBackpressure(aggregatedMetrics, (double)percentUsedBytes, (String)"bytesAtBackpressure");
            PrometheusMetricsUtil.setBackpressure(aggregatedMetrics, (double)percentUsedCount, (String)"countAtBackpressure");
        }
    }

    public static void aggregateConnectionPredictionMetrics(Map<String, Double> aggregatedMetrics, Map<String, Long> predictions) {
        PrometheusMetricsUtil.determineMinValueForPredictions(aggregatedMetrics, (String)"nifi_time_to_bytes_backpressure_prediction", (double)predictions.get("timeToBytesBackpressureMillis").longValue(), (String)"bytesAtBackpressure");
        PrometheusMetricsUtil.determineMinValueForPredictions(aggregatedMetrics, (String)"nifi_time_to_count_backpressure_prediction", (double)predictions.get("timeToCountBackpressureMillis").longValue(), (String)"countAtBackpressure");
    }

    private static void setBackpressure(Map<String, Double> aggregatedMetrics, double percentUsed, String atBackpressureKey) {
        if (percentUsed >= 100.0) {
            aggregatedMetrics.put(atBackpressureKey, 1.0);
        } else if (!aggregatedMetrics.containsKey(atBackpressureKey)) {
            aggregatedMetrics.put(atBackpressureKey, 0.0);
        }
    }

    private static void determineMinValueForPredictions(Map<String, Double> aggregatedMetrics, String metricFamilySamplesName, double metricSampleValue, String atBackpressureKey) {
        Double currentValue = aggregatedMetrics.get(metricFamilySamplesName);
        if (aggregatedMetrics.get(atBackpressureKey) != null && aggregatedMetrics.get(atBackpressureKey) == 1.0) {
            aggregatedMetrics.put(metricFamilySamplesName, 0.0);
        } else if (currentValue == null) {
            aggregatedMetrics.put(metricFamilySamplesName, metricSampleValue);
        } else if (metricSampleValue > -1.0) {
            if (currentValue == -1.0) {
                aggregatedMetrics.put(metricFamilySamplesName, metricSampleValue);
            } else {
                aggregatedMetrics.put(metricFamilySamplesName, Math.min(metricSampleValue, currentValue));
            }
        }
    }

    private static void determineMaxValueForPercentUsed(Map<String, Double> aggregatedMetrics, String metricFamilySamplesName, double metricSampleValue) {
        Double currentValue = aggregatedMetrics.get(metricFamilySamplesName);
        if (currentValue == null) {
            currentValue = 0.0;
        }
        aggregatedMetrics.put(metricFamilySamplesName, Math.max(metricSampleValue, currentValue));
    }

    public static CollectorRegistry createAggregatedConnectionStatusAnalyticsMetrics(ConnectionAnalyticsMetricsRegistry connectionAnalyticsMetricsRegistry, Map<String, Double> aggregatedMetrics, String instId, String compType, String compName, String compId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? "" : compType;
        String componentName = StringUtils.isEmpty((String)compName) ? "" : compName;
        String componentId = StringUtils.isEmpty((String)compId) ? "" : compId;
        Double bytesValue = aggregatedMetrics.get("nifi_time_to_bytes_backpressure_prediction");
        Double countsValue = aggregatedMetrics.get("nifi_time_to_count_backpressure_prediction");
        double bytesBackpressure = bytesValue == null ? -1.0 : bytesValue;
        double countsBackpressure = countsValue == null ? -1.0 : countsValue;
        connectionAnalyticsMetricsRegistry.setDataPoint(bytesBackpressure, "TIME_TO_BYTES_BACKPRESSURE_PREDICTION", new String[]{instanceId, componentType, componentName, componentId, "", "", "", "", ""});
        connectionAnalyticsMetricsRegistry.setDataPoint(countsBackpressure, "TIME_TO_COUNT_BACKPRESSURE_PREDICTION", new String[]{instanceId, componentType, componentName, componentId, "", "", "", "", ""});
        return connectionAnalyticsMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createAggregatedNifiMetrics(NiFiMetricsRegistry niFiMetricsRegistry, Map<String, Double> aggregatedMetrics, String instId, String compType, String compName, String compId) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        String componentType = StringUtils.isEmpty((String)compType) ? "" : compType;
        String componentName = StringUtils.isEmpty((String)compName) ? "" : compName;
        String componentId = StringUtils.isEmpty((String)compId) ? "" : compId;
        Double bytesValue = aggregatedMetrics.get("nifi_percent_used_bytes");
        Double countsValue = aggregatedMetrics.get("nifi_percent_used_count");
        double percentBytes = bytesValue == null ? 0.0 : bytesValue;
        double percentCount = countsValue == null ? 0.0 : countsValue;
        niFiMetricsRegistry.setDataPoint(percentBytes, "PERCENT_USED_BYTES", new String[]{instanceId, componentType, componentName, componentId, "", "", "", "", ""});
        niFiMetricsRegistry.setDataPoint(percentCount, "PERCENT_USED_COUNT", new String[]{instanceId, componentType, componentName, componentId, "", "", "", "", ""});
        return niFiMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createClusterMetrics(ClusterMetricsRegistry clusterMetricsRegistry, String instId, boolean isClustered, boolean isConnectedToCluster, String connectedNodes, int connectedNodeCount, int totalNodeCount) {
        String instanceId = StringUtils.isEmpty((String)instId) ? "" : instId;
        clusterMetricsRegistry.setDataPoint(isClustered ? 1.0 : 0.0, "IS_CLUSTERED", new String[]{instanceId});
        clusterMetricsRegistry.setDataPoint(isConnectedToCluster ? 1.0 : 0.0, "IS_CONNECTED_TO_CLUSTER", new String[]{instanceId});
        clusterMetricsRegistry.setDataPoint((double)connectedNodeCount, "CONNECTED_NODE_COUNT", new String[]{instanceId, connectedNodes});
        clusterMetricsRegistry.setDataPoint((double)totalNodeCount, "TOTAL_NODE_COUNT", new String[]{instanceId});
        return clusterMetricsRegistry.getRegistry();
    }

    public static CollectorRegistry createStorageUsageMetrics(NiFiMetricsRegistry nifiMetricsRegistry, StorageUsage flowFileRepositoryUsage, Map<String, StorageUsage> contentRepositoryUsage, Map<String, StorageUsage> provenanceRepositoryUsage, String instanceId, String componentType, String componentName, String componentId, String parentId) {
        PrometheusMetricsUtil.addStorageUsageMetric((NiFiMetricsRegistry)nifiMetricsRegistry, (StorageUsage)flowFileRepositoryUsage, (String)instanceId, (String)componentType, (String)componentName, (String)componentId, (String)parentId, (String)"FLOW_FILE_REPO_TOTAL_SPACE_BYTES", (String)"FLOW_FILE_REPO_FREE_SPACE_BYTES", (String)"FLOW_FILE_REPO_USED_SPACE_BYTES");
        for (StorageUsage usage : contentRepositoryUsage.values()) {
            PrometheusMetricsUtil.addStorageUsageMetric((NiFiMetricsRegistry)nifiMetricsRegistry, (StorageUsage)usage, (String)instanceId, (String)componentType, (String)componentName, (String)componentId, (String)parentId, (String)"CONTENT_REPO_TOTAL_SPACE_BYTES", (String)"CONTENT_REPO_FREE_SPACE_BYTES", (String)"CONTENT_REPO_USED_SPACE_BYTES");
        }
        for (StorageUsage usage : provenanceRepositoryUsage.values()) {
            PrometheusMetricsUtil.addStorageUsageMetric((NiFiMetricsRegistry)nifiMetricsRegistry, (StorageUsage)usage, (String)instanceId, (String)componentType, (String)componentName, (String)componentId, (String)parentId, (String)"PROVENANCE_REPO_TOTAL_SPACE_BYTES", (String)"PROVENANCE_REPO_FREE_SPACE_BYTES", (String)"PROVENANCE_REPO_USED_SPACE_BYTES");
        }
        return nifiMetricsRegistry.getRegistry();
    }

    private static void addStorageUsageMetric(NiFiMetricsRegistry nifiMetricsRegistry, StorageUsage storageUsage, String instanceId, String componentType, String componentName, String componentId, String parentId, String totalSpaceLabel, String freeSpaceLabel, String usedSpaceLabel) {
        nifiMetricsRegistry.setDataPoint((double)storageUsage.getTotalSpace(), totalSpaceLabel, new String[]{instanceId, componentType, componentName, componentId, parentId, storageUsage.getIdentifier()});
        nifiMetricsRegistry.setDataPoint((double)storageUsage.getFreeSpace(), freeSpaceLabel, new String[]{instanceId, componentType, componentName, componentId, parentId, storageUsage.getIdentifier()});
        nifiMetricsRegistry.setDataPoint((double)storageUsage.getUsedSpace(), usedSpaceLabel, new String[]{instanceId, componentType, componentName, componentId, parentId, storageUsage.getIdentifier()});
    }
}

