/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.prometheusutil;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import java.util.HashMap;
import java.util.Map;

public class AbstractMetricsRegistry {
    protected final CollectorRegistry registry = new CollectorRegistry();
    protected final Map<String, Gauge> nameToGaugeMap = new HashMap();
    protected final Map<String, Counter> nameToCounterMap = new HashMap();

    public CollectorRegistry getRegistry() {
        return this.registry;
    }

    public void setDataPoint(double val, String gaugeName, String ... labels) {
        Gauge gauge = (Gauge)this.nameToGaugeMap.get(gaugeName);
        if (gauge == null) {
            throw new IllegalArgumentException("Gauge '" + gaugeName + "' does not exist in this registry");
        }
        ((Gauge.Child)gauge.labels(labels)).set(val);
    }

    public void incrementCounter(double val, String counterName, String ... labels) {
        Counter counter = (Counter)this.nameToCounterMap.get(counterName);
        if (counter == null) {
            throw new IllegalArgumentException("Counter '" + counterName + "' does not exist in this registry");
        }
        ((Counter.Child)counter.labels(labels)).inc(val);
    }

    public void clear() {
        for (Gauge gauge : this.nameToGaugeMap.values()) {
            gauge.clear();
        }
        for (Counter counter : this.nameToCounterMap.values()) {
            counter.clear();
        }
    }
}

