/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class RelationshipAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(RelationshipAuditor.class);
    private static final String NAME = "Name";
    private static final String FLOW_FILE_EXPIRATION = "File Expiration";
    private static final String BACK_PRESSURE_OBJECT_THRESHOLD = "Back Pressure Object Threshold";
    private static final String BACK_PRESSURE_DATA_SIZE_THRESHOLD = "Back Pressure Data Size Threshold";
    private static final String PRIORITIZERS = "Prioritizers";

    @Around(value="within(org.apache.nifi.web.dao.ConnectionDAO+) && execution(org.apache.nifi.connectable.Connection createConnection(java.lang.String, org.apache.nifi.web.api.dto.ConnectionDTO))")
    public Connection createConnectionAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ConnectDetails connectDetails;
        Connection connection = (Connection)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecordForConnection(connection, Operation.Connect, (ActionDetails)(connectDetails = this.createConnectDetails(connection, connection.getRelationships())));
        if (action != null) {
            this.saveAction(action, logger);
        }
        return connection;
    }

    @Around(value="within(org.apache.nifi.web.dao.ConnectionDAO+) && execution(org.apache.nifi.connectable.Connection updateConnection(org.apache.nifi.web.api.dto.ConnectionDTO)) && args(connectionDTO) && target(connectionDAO)")
    public Connection updateConnectionAdvice(ProceedingJoinPoint proceedingJoinPoint, ConnectionDTO connectionDTO, ConnectionDAO connectionDAO) throws Throwable {
        Connection connection = connectionDAO.getConnection(connectionDTO.getId());
        Connectable previousDestination = connection.getDestination();
        Collection previousRelationships = connection.getRelationships();
        Map values = this.extractConfiguredPropertyValues(connection, connectionDTO);
        connection = (Connection)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ConnectDetails connectDetails;
            Collection newRelationships;
            ArrayList<Object> actions = new ArrayList<Object>();
            Map updatedValues = this.extractConfiguredPropertyValues(connection, connectionDTO);
            Connectable source = connection.getSource();
            Connectable destination = connection.getDestination();
            if (destination != null && !previousDestination.getIdentifier().equals(destination.getIdentifier())) {
                ConnectDetails disconnectDetails = this.createConnectDetails(connection, source, previousRelationships, previousDestination);
                actions.add(this.generateAuditRecordForConnection(connection, Operation.Disconnect, (ActionDetails)disconnectDetails));
                ConnectDetails connectDetails2 = this.createConnectDetails(connection, connection.getRelationships());
                actions.add(this.generateAuditRecordForConnection(connection, Operation.Connect, (ActionDetails)connectDetails2));
            }
            if ((newRelationships = connection.getRelationships()) != null) {
                ArrayList relationshipsToAdd = new ArrayList(newRelationships);
                if (previousRelationships != null) {
                    relationshipsToAdd.removeAll(previousRelationships);
                }
                if (!relationshipsToAdd.isEmpty()) {
                    connectDetails = this.createConnectDetails(connection, relationshipsToAdd);
                    actions.add(this.generateAuditRecordForConnection(connection, Operation.Connect, (ActionDetails)connectDetails));
                }
            }
            if (previousRelationships != null) {
                ArrayList relationshipsToRemove = new ArrayList(previousRelationships);
                if (newRelationships != null) {
                    relationshipsToRemove.removeAll(newRelationships);
                }
                if (!relationshipsToRemove.isEmpty()) {
                    connectDetails = this.createConnectDetails(connection, relationshipsToRemove);
                    actions.add(this.generateAuditRecordForConnection(connection, Operation.Disconnect, (ActionDetails)connectDetails));
                }
            }
            Date actionTimestamp = new Date();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                if (oldValue != null && newValue != null && newValue.equals(oldValue)) continue;
                FlowChangeConfigureDetails configurationDetails = new FlowChangeConfigureDetails();
                configurationDetails.setName(property);
                configurationDetails.setValue(newValue);
                configurationDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(Operation.Configure);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(connection.getIdentifier());
                configurationAction.setSourceName(connection.getName());
                configurationAction.setSourceType(Component.Connection);
                configurationAction.setActionDetails((ActionDetails)configurationDetails);
                actions.add(configurationAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return connection;
    }

    @Around(value="within(org.apache.nifi.web.dao.ConnectionDAO+) && execution(void deleteConnection(java.lang.String)) && args(id) && target(connectionDAO)")
    public void removeConnectionAdvice(ProceedingJoinPoint proceedingJoinPoint, String id, ConnectionDAO connectionDAO) throws Throwable {
        Connection connection = connectionDAO.getConnection(id);
        proceedingJoinPoint.proceed();
        ConnectDetails connectDetails = this.createConnectDetails(connection, connection.getRelationships());
        Action action = this.generateAuditRecordForConnection(connection, Operation.Disconnect, (ActionDetails)connectDetails);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public ConnectDetails createConnectDetails(Connection connection, Collection<Relationship> relationships) {
        return this.createConnectDetails(connection, connection.getSource(), relationships, connection.getDestination());
    }

    public ConnectDetails createConnectDetails(Connection connection, Connectable source, Collection<Relationship> relationships, Connectable destination) {
        Component sourceType = this.determineConnectableType(source);
        Component destiantionType = this.determineConnectableType(destination);
        HashSet<String> relationshipNames = new HashSet<String>(connection.getRelationships().size());
        for (Relationship relationship : relationships) {
            relationshipNames.add(relationship.getName());
        }
        String formattedRelationships = relationshipNames.isEmpty() ? "" : StringUtils.join(relationshipNames, (String)", ");
        FlowChangeConnectDetails connectDetails = new FlowChangeConnectDetails();
        connectDetails.setSourceId(source.getIdentifier());
        connectDetails.setSourceName(source.getName());
        connectDetails.setSourceType(sourceType);
        connectDetails.setRelationship(formattedRelationships);
        connectDetails.setDestinationId(destination.getIdentifier());
        connectDetails.setDestinationName(destination.getName());
        connectDetails.setDestinationType(destiantionType);
        return connectDetails;
    }

    private Map<String, String> extractConfiguredPropertyValues(Connection connection, ConnectionDTO connectionDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (connectionDTO.getName() != null) {
            values.put(NAME, connection.getName());
        }
        if (connectionDTO.getFlowFileExpiration() != null) {
            values.put(FLOW_FILE_EXPIRATION, String.valueOf(connection.getFlowFileQueue().getFlowFileExpiration()));
        }
        if (connectionDTO.getBackPressureObjectThreshold() != null) {
            values.put(BACK_PRESSURE_OBJECT_THRESHOLD, String.valueOf(connection.getFlowFileQueue().getBackPressureObjectThreshold()));
        }
        if (connectionDTO.getBackPressureDataSizeThreshold() != null) {
            values.put(BACK_PRESSURE_DATA_SIZE_THRESHOLD, String.valueOf(connection.getFlowFileQueue().getBackPressureDataSizeThreshold()));
        }
        if (connectionDTO.getPrioritizers() != null) {
            ArrayList<String> prioritizers = new ArrayList<String>();
            for (FlowFilePrioritizer prioritizer : connection.getFlowFileQueue().getPriorities()) {
                prioritizers.add(prioritizer.getClass().getCanonicalName());
            }
            values.put(PRIORITIZERS, StringUtils.join(prioritizers, (String)", "));
        }
        return values;
    }

    public Action generateAuditRecordForConnection(Connection connection, Operation operation) {
        return this.generateAuditRecordForConnection(connection, operation, null);
    }

    public Action generateAuditRecordForConnection(Connection connection, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            String connectionId = connection.getIdentifier();
            String connectionName = connection.getName();
            if (StringUtils.isBlank((CharSequence)connectionName)) {
                HashSet<String> relationshipNames = new HashSet<String>(connection.getRelationships().size());
                for (Relationship relationship : connection.getRelationships()) {
                    relationshipNames.add(relationship.getName());
                }
                connectionName = StringUtils.join(relationshipNames, (String)", ");
            }
            Date actionTimestamp = new Date();
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(actionTimestamp);
            action.setSourceId(connectionId);
            action.setSourceName(connectionName);
            action.setSourceType(Component.Connection);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Component determineConnectableType(Connectable connectable) {
        String sourceId = connectable.getIdentifier();
        Component componentType = Component.Controller;
        if (connectable instanceof ProcessorNode) {
            componentType = Component.Processor;
        } else if (connectable instanceof RemoteGroupPort) {
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)connectable;
            componentType = TransferDirection.RECEIVE.equals((Object)remoteGroupPort.getTransferDirection()) ? (remoteGroupPort.getRemoteProcessGroup() == null ? Component.InputPort : Component.OutputPort) : (remoteGroupPort.getRemoteProcessGroup() == null ? Component.OutputPort : Component.InputPort);
        } else if (connectable instanceof Port) {
            ProcessGroup processGroup = connectable.getProcessGroup();
            if (processGroup.getInputPort(sourceId) != null) {
                componentType = Component.InputPort;
            } else if (processGroup.getOutputPort(sourceId) != null) {
                componentType = Component.OutputPort;
            }
        } else if (connectable instanceof Funnel) {
            componentType = Component.Funnel;
        }
        return componentType;
    }
}

