/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.flowanalysis.EnforcementPolicy;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleState;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.dao.FlowAnalysisRuleDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class FlowAnalysisRuleAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(FlowAnalysisRuleAuditor.class);
    private static final String COMMENTS = "Comments";
    private static final String NAME = "Name";
    private static final String ANNOTATION_DATA = "Annotation Data";
    private static final String EXTENSION_VERSION = "Extension Version";
    private static final String ENFORCEMENT_POLICY = "Enforcement Policy";

    @Around(value="within(org.apache.nifi.web.dao.FlowAnalysisRuleDAO+) && execution(org.apache.nifi.controller.FlowAnalysisRuleNode createFlowAnalysisRule(org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO))")
    public FlowAnalysisRuleNode createFlowAnalysisRuleAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        FlowAnalysisRuleNode flowAnalysisRule = (FlowAnalysisRuleNode)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(flowAnalysisRule, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return flowAnalysisRule;
    }

    @Around(value="within(org.apache.nifi.web.dao.FlowAnalysisRuleDAO+) && execution(org.apache.nifi.controller.FlowAnalysisRuleNode updateFlowAnalysisRule(org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO)) && args(flowAnalysisRuleDTO) && target(flowAnalysisRuleDAO)")
    public Object updateFlowAnalysisRuleAdvice(ProceedingJoinPoint proceedingJoinPoint, FlowAnalysisRuleDTO flowAnalysisRuleDTO, FlowAnalysisRuleDAO flowAnalysisRuleDAO) throws Throwable {
        FlowAnalysisRuleNode flowAnalysisRule = flowAnalysisRuleDAO.getFlowAnalysisRule(flowAnalysisRuleDTO.getId());
        Map values = this.extractConfiguredPropertyValues(flowAnalysisRule, flowAnalysisRuleDTO);
        FlowAnalysisRuleState state = flowAnalysisRule.getState();
        EnforcementPolicy enforcementPolicy = flowAnalysisRule.getEnforcementPolicy();
        FlowAnalysisRuleNode updatedFlowAnalysisRule = (FlowAnalysisRuleNode)proceedingJoinPoint.proceed();
        flowAnalysisRule = flowAnalysisRuleDAO.getFlowAnalysisRule(updatedFlowAnalysisRule.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowAnalysisRuleState updatedState;
            Set sensitiveDynamicPropertyNames = flowAnalysisRuleDTO.getSensitiveDynamicPropertyNames() == null ? Collections.emptySet() : flowAnalysisRuleDTO.getSensitiveDynamicPropertyNames();
            Map updatedValues = this.extractConfiguredPropertyValues(flowAnalysisRule, flowAnalysisRuleDTO);
            FlowChangeExtensionDetails ruleDetails = new FlowChangeExtensionDetails();
            ruleDetails.setType(flowAnalysisRule.getComponentType());
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                PropertyDescriptor propertyDescriptor = flowAnalysisRule.getPropertyDescriptor(property);
                if (propertyDescriptor != null && (propertyDescriptor.isSensitive() || sensitiveDynamicPropertyNames.contains(property))) {
                    if (newValue != null) {
                        newValue = "********";
                    }
                    if (oldValue != null) {
                        oldValue = "********";
                    }
                } else if (ANNOTATION_DATA.equals(property)) {
                    if (newValue != null) {
                        newValue = "<annotation data not shown>";
                    }
                    if (oldValue != null) {
                        oldValue = "<annotation data not shown>";
                    }
                }
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(flowAnalysisRule.getIdentifier());
                configurationAction.setSourceName(flowAnalysisRule.getName());
                configurationAction.setSourceType(Component.FlowAnalysisRule);
                configurationAction.setComponentDetails((ComponentDetails)ruleDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            EnforcementPolicy updatedEnforcementPolicy = flowAnalysisRule.getEnforcementPolicy();
            if (enforcementPolicy != updatedEnforcementPolicy) {
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(ENFORCEMENT_POLICY);
                actionDetails.setValue(String.valueOf(updatedEnforcementPolicy));
                actionDetails.setPreviousValue(String.valueOf(enforcementPolicy));
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(Operation.Configure);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(flowAnalysisRule.getIdentifier());
                configurationAction.setSourceName(flowAnalysisRule.getName());
                configurationAction.setSourceType(Component.FlowAnalysisRule);
                configurationAction.setComponentDetails((ComponentDetails)ruleDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            if (state != (updatedState = flowAnalysisRule.getState())) {
                FlowChangeAction ruleAction = new FlowChangeAction();
                ruleAction.setUserIdentity(user.getIdentity());
                ruleAction.setTimestamp(new Date());
                ruleAction.setSourceId(flowAnalysisRule.getIdentifier());
                ruleAction.setSourceName(flowAnalysisRule.getName());
                ruleAction.setSourceType(Component.FlowAnalysisRule);
                ruleAction.setComponentDetails((ComponentDetails)ruleDetails);
                if (FlowAnalysisRuleState.ENABLED.equals((Object)updatedState)) {
                    ruleAction.setOperation(Operation.Enable);
                } else if (FlowAnalysisRuleState.DISABLED.equals((Object)updatedState)) {
                    ruleAction.setOperation(Operation.Disable);
                }
                actions.add(ruleAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedFlowAnalysisRule;
    }

    @Around(value="within(org.apache.nifi.web.dao.FlowAnalysisRuleDAO+) && execution(void deleteFlowAnalysisRule(java.lang.String)) && args(flowAnalysisRuleId) && target(flowAnalysisRuleDAO)")
    public void removeFlowAnalysisRuleAdvice(ProceedingJoinPoint proceedingJoinPoint, String flowAnalysisRuleId, FlowAnalysisRuleDAO flowAnalysisRuleDAO) throws Throwable {
        FlowAnalysisRuleNode flowAnalysisRule = flowAnalysisRuleDAO.getFlowAnalysisRule(flowAnalysisRuleId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(flowAnalysisRule, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(FlowAnalysisRuleNode flowAnalysisRule, Operation operation) {
        return this.generateAuditRecord(flowAnalysisRule, operation, null);
    }

    public Action generateAuditRecord(FlowAnalysisRuleNode flowAnalysisRule, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeExtensionDetails ruleDetails = new FlowChangeExtensionDetails();
            ruleDetails.setType(flowAnalysisRule.getComponentType());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(flowAnalysisRule.getIdentifier());
            action.setSourceName(flowAnalysisRule.getName());
            action.setSourceType(Component.FlowAnalysisRule);
            action.setComponentDetails((ComponentDetails)ruleDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(FlowAnalysisRuleNode flowAnalysisRule, FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (flowAnalysisRuleDTO.getName() != null) {
            values.put(NAME, flowAnalysisRule.getName());
        }
        if (flowAnalysisRuleDTO.getBundle() != null) {
            BundleCoordinate bundle = flowAnalysisRule.getBundleCoordinate();
            values.put(EXTENSION_VERSION, this.formatExtensionVersion(flowAnalysisRule.getComponentType(), bundle));
        }
        if (flowAnalysisRuleDTO.getProperties() != null) {
            Map properties = flowAnalysisRuleDTO.getProperties();
            Map configuredProperties = flowAnalysisRule.getRawPropertyValues();
            for (String propertyName : properties.keySet()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor.Builder().name(propertyName).build();
                String configuredPropertyValue = (String)configuredProperties.get(propertyDescriptor);
                if (configuredPropertyValue == null) {
                    propertyDescriptor = this.locatePropertyDescriptor(configuredProperties.keySet(), propertyDescriptor);
                    configuredPropertyValue = propertyDescriptor.getDefaultValue();
                }
                values.put(propertyName, configuredPropertyValue);
            }
        }
        if (flowAnalysisRuleDTO.getComments() != null) {
            values.put(COMMENTS, flowAnalysisRuleDTO.getComments());
        }
        return values;
    }

    private PropertyDescriptor locatePropertyDescriptor(Set<PropertyDescriptor> propertyDescriptors, PropertyDescriptor specDescriptor) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.equals((Object)specDescriptor)) continue;
            return propertyDescriptor;
        }
        return specDescriptor;
    }
}

