/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Aspect
public class ComponentStateAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ComponentStateAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.controller.ProcessorNode)) && args(processor)")
    public StateMap clearProcessorStateAdvice(ProceedingJoinPoint proceedingJoinPoint, ProcessorNode processor) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails processorDetails = new FlowChangeExtensionDetails();
            processorDetails.setType(processor.getComponentType());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(processor.getIdentifier());
            configAction.setSourceName(processor.getName());
            configAction.setSourceType(Component.Processor);
            configAction.setComponentDetails((ComponentDetails)processorDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.controller.service.ControllerServiceNode)) && args(controllerService)")
    public StateMap clearControllerServiceStateAdvice(ProceedingJoinPoint proceedingJoinPoint, ControllerServiceNode controllerService) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails controllerServiceDetails = new FlowChangeExtensionDetails();
            controllerServiceDetails.setType(controllerService.getComponentType());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(controllerService.getIdentifier());
            configAction.setSourceName(controllerService.getName());
            configAction.setSourceType(Component.ControllerService);
            configAction.setComponentDetails((ComponentDetails)controllerServiceDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.controller.ReportingTaskNode)) && args(reportingTask)")
    public StateMap clearReportingTaskStateAdvice(ProceedingJoinPoint proceedingJoinPoint, ReportingTaskNode reportingTask) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails reportingTaskDetails = new FlowChangeExtensionDetails();
            reportingTaskDetails.setType(reportingTask.getReportingTask().getClass().getSimpleName());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(reportingTask.getIdentifier());
            configAction.setSourceName(reportingTask.getName());
            configAction.setSourceType(Component.ReportingTask);
            configAction.setComponentDetails((ComponentDetails)reportingTaskDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.controller.FlowAnalysisRuleNode)) && args(flowAnalysisRule)")
    public StateMap clearFlowAnalysisRuleStateAdvice(ProceedingJoinPoint proceedingJoinPoint, FlowAnalysisRuleNode flowAnalysisRule) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails flowAnalysisRuleDetails = new FlowChangeExtensionDetails();
            flowAnalysisRuleDetails.setType(flowAnalysisRule.getFlowAnalysisRule().getClass().getSimpleName());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(flowAnalysisRule.getIdentifier());
            configAction.setSourceName(flowAnalysisRule.getName());
            configAction.setSourceType(Component.FlowAnalysisRule);
            configAction.setComponentDetails((ComponentDetails)flowAnalysisRuleDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.controller.ParameterProviderNode)) && args(parameterProvider)")
    public StateMap clearParameterProviderStateAdvice(ProceedingJoinPoint proceedingJoinPoint, ParameterProviderNode parameterProvider) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails parameterProviderDetails = new FlowChangeExtensionDetails();
            parameterProviderDetails.setType(parameterProvider.getParameterProvider().getClass().getSimpleName());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(parameterProvider.getIdentifier());
            configAction.setSourceName(parameterProvider.getName());
            configAction.setSourceType(Component.ParameterProvider);
            configAction.setComponentDetails((ComponentDetails)parameterProviderDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }

    @Around(value="within(org.apache.nifi.web.dao.ComponentStateDAO+) && execution(void clearState(org.apache.nifi.registry.flow.FlowRegistryClientNode)) && args(flowRegistryClient)")
    public StateMap clearFlowRegistryClientStateAdvice(ProceedingJoinPoint proceedingJoinPoint, FlowRegistryClientNode flowRegistryClient) throws Throwable {
        StateMap stateMap = (StateMap)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeExtensionDetails flowRegistryClientDetails = new FlowChangeExtensionDetails();
            flowRegistryClientDetails.setType(flowRegistryClient.getComponent().getClass().getSimpleName());
            FlowChangeAction configAction = new FlowChangeAction();
            configAction.setUserIdentity(user.getIdentity());
            configAction.setOperation(Operation.ClearState);
            configAction.setTimestamp(new Date());
            configAction.setSourceId(flowRegistryClient.getIdentifier());
            configAction.setSourceName(flowRegistryClient.getName());
            configAction.setSourceType(Component.FlowRegistryClient);
            configAction.setComponentDetails((ComponentDetails)flowRegistryClientDetails);
            actions.add(configAction);
            this.saveActions(actions, logger);
        }
        return stateMap;
    }
}

