/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.ResumeFlowException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.AbstractParameterResource;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.CancellableTimedPause;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ParameterUpdateManager {
    private static final Logger logger = LoggerFactory.getLogger(ParameterUpdateManager.class);
    private final NiFiServiceFacade serviceFacade;
    private final DtoFactory dtoFactory;
    private final Authorizer authorizer;
    private final AbstractParameterResource parameterResource;

    public ParameterUpdateManager(NiFiServiceFacade serviceFacade, DtoFactory dtoFactory, Authorizer authorizer, AbstractParameterResource parameterResource) {
        this.serviceFacade = serviceFacade;
        this.dtoFactory = dtoFactory;
        this.authorizer = authorizer;
        this.parameterResource = parameterResource;
    }

    public void authorizeAffectedComponent(AffectedComponentEntity entity, AuthorizableLookup lookup, NiFiUser user, boolean requireRead, boolean requireWrite) {
        AffectedComponentDTO dto = entity.getComponent();
        if (dto == null) {
            Authorizable authorizable;
            try {
                authorizable = lookup.getProcessor(entity.getId()).getAuthorizable();
            }
            catch (ResourceNotFoundException rnfe) {
                authorizable = lookup.getControllerService(entity.getId()).getAuthorizable();
            }
            if (requireRead) {
                authorizable.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                authorizable.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        } else if ("PROCESSOR".equals(dto.getReferenceType())) {
            Authorizable processor = lookup.getProcessor(dto.getId()).getAuthorizable();
            if (requireRead) {
                processor.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                processor.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        } else if ("CONTROLLER_SERVICE".equals(dto.getReferenceType())) {
            Authorizable service = lookup.getControllerService(dto.getId()).getAuthorizable();
            if (requireRead) {
                service.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                service.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        } else if ("STATELESS_GROUP".equals(dto.getReferenceType())) {
            Authorizable group = lookup.getProcessGroup(dto.getId()).getAuthorizable();
            if (requireRead) {
                group.authorize(this.authorizer, RequestAction.READ, user);
            }
            if (requireWrite) {
                group.authorize(this.authorizer, RequestAction.WRITE, user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterContextEntity> updateParameterContexts(AsynchronousWebRequest<List<ParameterContextEntity>, List<ParameterContextEntity>> asyncRequest, ComponentLifecycle componentLifecycle, URI uri, Set<AffectedComponentEntity> affectedComponents, boolean replicateRequest, Revision revision, List<ParameterContextEntity> updatedContextEntities) throws LifecycleManagementException, ResumeFlowException {
        Set runningStatelessGroups = affectedComponents.stream().filter(entity -> entity.getComponent() != null).filter(entity -> "STATELESS_GROUP".equals(entity.getComponent().getReferenceType())).filter(component -> "Running".equalsIgnoreCase(component.getComponent().getState())).collect(Collectors.toSet());
        Set runningProcessors = affectedComponents.stream().filter(entity -> entity.getComponent() != null).filter(entity -> "PROCESSOR".equals(entity.getComponent().getReferenceType())).filter(component -> "Running".equalsIgnoreCase(component.getComponent().getState())).collect(Collectors.toSet());
        Set servicesRequiringDisabledState = affectedComponents.stream().filter(entity -> entity.getComponent() != null).filter(dto -> "CONTROLLER_SERVICE".equals(dto.getComponent().getReferenceType())).filter(dto -> {
            String state = dto.getComponent().getState();
            return "Enabling".equalsIgnoreCase(state) || "Enabled".equalsIgnoreCase(state) || "Disabling".equalsIgnoreCase(state);
        }).collect(Collectors.toSet());
        this.stopComponents(runningStatelessGroups, "stateless process group", asyncRequest, componentLifecycle, uri);
        this.stopComponents(runningProcessors, "processor", asyncRequest, componentLifecycle, uri);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        Set enabledControllerServices = servicesRequiringDisabledState.stream().filter(dto -> {
            String state = dto.getComponent().getState();
            return "Enabling".equalsIgnoreCase(state) || "Enabled".equalsIgnoreCase(state);
        }).collect(Collectors.toSet());
        this.disableControllerServices(enabledControllerServices, servicesRequiringDisabledState, asyncRequest, componentLifecycle, uri);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        asyncRequest.markStepComplete();
        ArrayList<ParameterContextEntity> updatedEntities = new ArrayList<ParameterContextEntity>();
        try {
            for (ParameterContextEntity updatedContextEntity : updatedContextEntities) {
                logger.info("Updating Parameter Context with ID {}", (Object)updatedContextEntity.getId());
                updatedEntities.add(this.performParameterContextUpdate(asyncRequest, uri, replicateRequest, revision, updatedContextEntity));
                logger.info("Successfully updated Parameter Context with ID {}", (Object)updatedContextEntity.getId());
            }
            asyncRequest.markStepComplete();
        }
        finally {
            if (!asyncRequest.isCancelled()) {
                this.enableControllerServices(enabledControllerServices, enabledControllerServices, asyncRequest, componentLifecycle, uri);
            }
            if (!asyncRequest.isCancelled()) {
                this.restartComponents(runningProcessors, "processor", asyncRequest, componentLifecycle, uri);
                this.restartComponents(runningStatelessGroups, "stateless process group", asyncRequest, componentLifecycle, uri);
                asyncRequest.markStepComplete();
            }
        }
        asyncRequest.setCancelCallback(null);
        if (asyncRequest.isCancelled()) {
            return null;
        }
        return updatedEntities;
    }

    private ParameterContextEntity performParameterContextUpdate(AsynchronousWebRequest<?, ?> asyncRequest, URI exampleUri, boolean replicateRequest, Revision revision, ParameterContextEntity updatedContext) throws LifecycleManagementException {
        if (replicateRequest) {
            URI updateUri;
            try {
                updateUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/parameter-contexts/" + updatedContext.getId(), null, exampleUri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            NiFiUser user = asyncRequest.getUser();
            NodeResponse clusterResponse = this.parameterResource.updateParameterContext(updatedContext, updateUri, headers, user);
            int updateFlowStatus = clusterResponse.getStatus();
            if (updateFlowStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)ParameterUpdateManager.getResponseEntity((NodeResponse)clusterResponse, String.class);
                logger.error("Failed to update flow across cluster when replicating PUT request to {} for user {}. Received {} response with explanation: {}", new Object[]{updateUri, user, updateFlowStatus, explanation});
                throw new LifecycleManagementException("Failed to update Flow on all nodes in cluster due to " + explanation);
            }
            return this.serviceFacade.getParameterContext(updatedContext.getId(), false, user);
        }
        this.serviceFacade.verifyUpdateParameterContext(updatedContext.getComponent(), true);
        return this.serviceFacade.updateParameterContext(revision, updatedContext.getComponent());
    }

    public static <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse() != null ? nodeResponse.getClientResponse().readEntity(clazz) : nodeResponse.getThrowable().toString();
        }
        return (T)entity;
    }

    private void stopComponents(Set<AffectedComponentEntity> components, String componentType, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException {
        logger.info("Stopping {} {}s in order to update Parameter Context", (Object)components.size(), (Object)componentType);
        CancellableTimedPause stopComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)stopComponentsPause).cancel());
        componentLifecycle.scheduleComponents(uri, "root", components, ScheduledState.STOPPED, (Pause)stopComponentsPause, InvalidComponentAction.SKIP);
    }

    private void restartComponents(Set<AffectedComponentEntity> components, String componentType, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws ResumeFlowException, LifecycleManagementException {
        if (logger.isDebugEnabled()) {
            logger.debug("Restarting {} {}s after having updated Parameter Context: {}", new Object[]{components.size(), componentType, components});
        } else {
            logger.info("Restarting {} {}s after having updated Parameter Context", (Object)components.size(), (Object)componentType);
        }
        Set componentsToStart = this.getUpdatedEntities(components);
        CancellableTimedPause startComponentsPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)startComponentsPause).cancel());
        try {
            componentLifecycle.scheduleComponents(uri, "root", componentsToStart, ScheduledState.RUNNING, (Pause)startComponentsPause, InvalidComponentAction.SKIP);
        }
        catch (IllegalStateException ise) {
            throw new ResumeFlowException("Failed to restart components because " + ise.getMessage(), (Throwable)ise);
        }
    }

    private void disableControllerServices(Set<AffectedComponentEntity> enabledControllerServices, Set<AffectedComponentEntity> controllerServicesRequiringDisabledState, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException {
        asyncRequest.markStepComplete();
        logger.info("Disabling {} Controller Services in order to update Parameter Context", (Object)enabledControllerServices.size());
        CancellableTimedPause disableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)disableServicesPause).cancel());
        componentLifecycle.activateControllerServices(uri, "root", enabledControllerServices, controllerServicesRequiringDisabledState, ControllerServiceState.DISABLED, (Pause)disableServicesPause, InvalidComponentAction.WAIT);
    }

    private void enableControllerServices(Set<AffectedComponentEntity> controllerServices, Set<AffectedComponentEntity> controllerServicesRequiringDisabledState, AsynchronousWebRequest<?, ?> asyncRequest, ComponentLifecycle componentLifecycle, URI uri) throws LifecycleManagementException, ResumeFlowException {
        if (logger.isDebugEnabled()) {
            logger.debug("Re-Enabling {} Controller Services: {}", (Object)controllerServices.size(), controllerServices);
        } else {
            logger.info("Re-Enabling {} Controller Services after having updated Parameter Context", (Object)controllerServices.size());
        }
        CancellableTimedPause enableServicesPause = new CancellableTimedPause(250L, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        asyncRequest.setCancelCallback(() -> ((CancellableTimedPause)enableServicesPause).cancel());
        Set servicesToEnable = this.getUpdatedEntities(controllerServices);
        try {
            componentLifecycle.activateControllerServices(uri, "root", servicesToEnable, controllerServicesRequiringDisabledState, ControllerServiceState.ENABLED, (Pause)enableServicesPause, InvalidComponentAction.SKIP);
            asyncRequest.markStepComplete();
        }
        catch (IllegalStateException ise) {
            throw new ResumeFlowException("Failed to re-enable Controller Services because " + ise.getMessage(), (Throwable)ise);
        }
    }

    private Set<AffectedComponentEntity> getUpdatedEntities(Set<AffectedComponentEntity> originalEntities) {
        LinkedHashSet<AffectedComponentEntity> entities = new LinkedHashSet<AffectedComponentEntity>();
        for (AffectedComponentEntity original : originalEntities) {
            try {
                AffectedComponentEntity updatedEntity = AffectedComponentUtils.updateEntity((AffectedComponentEntity)original, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory);
                if (updatedEntity == null) continue;
                entities.add(updatedEntity);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {}
        }
        return entities;
    }
}

