/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.StatelessGroupScheduledState;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.ProcessorRunStatusDetailsDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.ProcessorsRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.RunStatusDetailsRequestEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.ClusterReplicationComponentLifecycle;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterReplicationComponentLifecycle
implements ComponentLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ClusterReplicationComponentLifecycle.class);
    private ClusterCoordinator clusterCoordinator;
    private RequestReplicator requestReplicator;
    private NiFiServiceFacade serviceFacade;
    private DtoFactory dtoFactory;

    public Set<AffectedComponentEntity> scheduleComponents(URI exampleUri, String groupId, Set<AffectedComponentEntity> components, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        URI scheduleGroupUri;
        if (components.isEmpty()) {
            logger.debug("No components to schedule for group {} so will not issue request", (Object)groupId);
            return Collections.emptySet();
        }
        Set componentIds = components.stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        Map componentMap = components.stream().collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        Map componentRevisionMap = this.getRevisions(groupId, componentIds);
        Map<String, RevisionDTO> componentRevisionDtoMap = componentRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ScheduleComponentsEntity scheduleProcessorsEntity = new ScheduleComponentsEntity();
        scheduleProcessorsEntity.setComponents(componentRevisionDtoMap);
        scheduleProcessorsEntity.setId(groupId);
        scheduleProcessorsEntity.setState(desiredState.name());
        try {
            scheduleGroupUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/flow/process-groups/" + groupId, null, exampleUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (desiredState == ScheduledState.RUNNING) {
            try {
                this.waitForProcessorValidation(user, exampleUri, groupId, componentMap, pause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LifecycleManagementException("Interrupted while waiting for processors to complete validation");
            }
        }
        try {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse();
            int scheduleComponentStatus = clusterResponse.getStatus();
            if (scheduleComponentStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                throw new LifecycleManagementException("Failed to transition components to a state of " + String.valueOf(desiredState) + " due to " + explanation);
            }
            if (desiredState == ScheduledState.STOPPED) {
                boolean processorsTransitioned = this.waitForProcessorStatus(user, exampleUri, componentMap, desiredState, pause, invalidComponentAction);
                if (!processorsTransitioned) {
                    throw new LifecycleManagementException("Failed while waiting for components to transition to state of " + String.valueOf(desiredState));
                }
                boolean statelessGroupsTransitioned = this.waitForStatelessGroupStatus(user, exampleUri, componentMap, desiredState, pause);
                if (!statelessGroupsTransitioned) {
                    throw new LifecycleManagementException("Failed while waiting for Stateless Process Groups to transition to state of " + String.valueOf(desiredState));
                }
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while attempting to transition components to state of " + String.valueOf(desiredState));
        }
        Set<AffectedComponentEntity> updatedEntities = components.stream().map(component -> AffectedComponentUtils.updateEntity((AffectedComponentEntity)component, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory)).collect(Collectors.toSet());
        return updatedEntities;
    }

    private ApplicationResource.ReplicationTarget getReplicationTarget() {
        return this.clusterCoordinator.isActiveClusterCoordinator() ? ApplicationResource.ReplicationTarget.CLUSTER_NODES : ApplicationResource.ReplicationTarget.CLUSTER_COORDINATOR;
    }

    private RequestReplicator getRequestReplicator() {
        return this.requestReplicator;
    }

    protected NodeIdentifier getClusterCoordinatorNode() {
        NodeIdentifier activeClusterCoordinator = this.clusterCoordinator.getElectedActiveCoordinatorNode();
        if (activeClusterCoordinator != null) {
            return activeClusterCoordinator;
        }
        throw new NoClusterCoordinatorException();
    }

    private Map<String, Revision> getRevisions(String groupId, Set<String> componentIds) {
        Set processorRevisions = this.serviceFacade.getRevisionsFromGroup(groupId, group -> componentIds);
        return processorRevisions.stream().collect(Collectors.toMap(Revision::getComponentId, Function.identity()));
    }

    private boolean waitForProcessorValidation(NiFiUser user, URI originalUri, String groupId, Map<String, AffectedComponentEntity> processors, Pause pause) throws InterruptedException {
        URI groupUri;
        if (processors.isEmpty()) {
            logger.debug("No processors to wait for so will not wait for Processor Validation");
            return true;
        }
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/processors/run-status-details/queries", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        RunStatusDetailsRequestEntity requestEntity = new RunStatusDetailsRequestEntity();
        Set processorIds = processors.values().stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        requestEntity.setProcessorIds(processorIds);
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "POST", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "POST", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ProcessorsRunStatusDetailsEntity runStatusDetailsEntity = (ProcessorsRunStatusDetailsEntity)this.getResponseEntity(clusterResponse, ProcessorsRunStatusDetailsEntity.class);
            if (this.isProcessorValidationComplete(runStatusDetailsEntity, processors)) {
                logger.debug("All {} processors of interest now have been validated: {}", (Object)processors.size(), processorIds);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isProcessorValidationComplete(ProcessorsRunStatusDetailsEntity runStatusDetailsEntity, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedProcessors((Collection)runStatusDetailsEntity.getRunStatusDetails(), affectedComponents);
        for (ProcessorRunStatusDetailsEntity statusDetailsEntity : runStatusDetailsEntity.getRunStatusDetails()) {
            ProcessorRunStatusDetailsDTO runStatusDetails = statusDetailsEntity.getRunStatusDetails();
            logger.debug("Processor {} now has Run Status of {}", (Object)runStatusDetails.getId(), (Object)runStatusDetails.getRunStatus());
            if (!affectedComponents.containsKey(runStatusDetails.getId()) || !"Validating".equals(runStatusDetails.getRunStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForStatelessGroupStatus(NiFiUser user, URI originalUri, Map<String, AffectedComponentEntity> affectedComponents, ScheduledState desiredState, Pause pause) throws InterruptedException {
        List affectedStatelessGroups = affectedComponents.values().stream().filter(component -> "STATELESS_GROUP".equals(component.getReferenceType())).collect(Collectors.toList());
        if (affectedStatelessGroups.isEmpty()) {
            logger.debug("There are no Stateless Group in the set of affected components so considering all groups to have reached state of {}", (Object)desiredState);
            return true;
        }
        boolean continuePolling = true;
        while (continuePolling) {
            boolean statesReached = true;
            for (AffectedComponentEntity affectedComponent : affectedStatelessGroups) {
                boolean stateReached = this.isStatelessGroupStateReached(originalUri, affectedComponent.getId(), user, desiredState);
                if (stateReached) {
                    logger.debug("Stateless Group with ID {} has reached desired state of {}", (Object)affectedComponent.getId(), (Object)desiredState);
                    continue;
                }
                statesReached = false;
                break;
            }
            if (statesReached) {
                logger.info("All {} Stateless Groups have reached the desired state of {}", (Object)affectedStatelessGroups.size(), (Object)desiredState);
                return true;
            }
            logger.debug("Not all Stateless Groups have reached the desired state of {}", (Object)desiredState);
            continuePolling = pause.pause();
        }
        logger.info("After waiting the maximum amount of time, not all Stateless Groups have reached the desired state of {}", (Object)desiredState);
        return false;
    }

    private boolean isStatelessGroupStateReached(URI originalUri, String groupId, NiFiUser user, ScheduledState desiredState) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/process-groups/" + groupId, null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, Collections.emptyMap(), headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, Collections.emptyMap(), headers).awaitMergedResponse();
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            logger.warn("While waiting for Stateless Groups to transition to a state of {}, received unexpected HTTP status code {}", (Object)desiredState, (Object)clusterResponse.getStatus());
            return false;
        }
        ProcessGroupEntity groupEntity = (ProcessGroupEntity)this.getResponseEntity(clusterResponse, ProcessGroupEntity.class);
        if (desiredState == ScheduledState.RUNNING) {
            Integer stoppedCount = groupEntity.getStoppedCount();
            return stoppedCount == null || stoppedCount <= 0;
        }
        Integer runningCount = groupEntity.getRunningCount();
        if (runningCount != null && runningCount > 0) {
            return false;
        }
        String statelessState = groupEntity.getComponent().getStatelessGroupScheduledState();
        if (!StatelessGroupScheduledState.STOPPED.name().equals(statelessState)) {
            return false;
        }
        int activeThreadCount = this.getStatelessGroupActiveThreadCount(originalUri, groupId, user);
        logger.debug("Stateless Group with ID {} currently has an active thread count of {}", (Object)groupId, (Object)activeThreadCount);
        return activeThreadCount == 0;
    }

    private int getStatelessGroupActiveThreadCount(URI originalUri, String groupId, NiFiUser user) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/status", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, Collections.emptyMap(), Collections.emptyMap()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, Collections.emptyMap(), Collections.emptyMap()).awaitMergedResponse();
        if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            logger.warn("While waiting for Stateless Groups to transition to a state of STOPPED, received unexpected HTTP status code {} when checking active thread count", (Object)clusterResponse.getStatus());
            return 1;
        }
        ProcessGroupStatusEntity groupStatus = (ProcessGroupStatusEntity)this.getResponseEntity(clusterResponse, ProcessGroupStatusEntity.class);
        ProcessGroupStatusSnapshotDTO statusSnapshot = groupStatus.getProcessGroupStatus().getAggregateSnapshot();
        return statusSnapshot.getActiveThreadCount();
    }

    private boolean waitForProcessorStatus(NiFiUser user, URI originalUri, Map<String, AffectedComponentEntity> processors, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws InterruptedException, LifecycleManagementException {
        URI groupUri;
        if (processors.isEmpty()) {
            logger.debug("No processors to wait for, so will not wait for processors to reach state of {}", (Object)desiredState);
            return true;
        }
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/processors/run-status-details/queries", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        Set processorIds = processors.values().stream().filter(component -> "PROCESSOR".equals(component.getReferenceType())).map(ComponentEntity::getId).collect(Collectors.toSet());
        RunStatusDetailsRequestEntity requestEntity = new RunStatusDetailsRequestEntity();
        requestEntity.setProcessorIds(processorIds);
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "POST", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "POST", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                logger.warn("While waiting for Processors to transition to a state of {}, received unexpected HTTP status code {}", (Object)desiredState, (Object)clusterResponse.getStatus());
                return false;
            }
            ProcessorsRunStatusDetailsEntity runStatusDetailsEntity = (ProcessorsRunStatusDetailsEntity)this.getResponseEntity(clusterResponse, ProcessorsRunStatusDetailsEntity.class);
            if (this.isProcessorActionComplete(runStatusDetailsEntity, processors, desiredState, invalidComponentAction)) {
                logger.debug("All {} processors of interest now have the desired state of {}", (Object)processors.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Entity entity = nodeResponse.getUpdatedEntity();
        if (entity != null) {
            return (T)entity;
        }
        Response clientResponse = nodeResponse.getClientResponse();
        if (clientResponse == null) {
            return null;
        }
        return (T)clientResponse.readEntity(clazz);
    }

    private void updateAffectedProcessors(Collection<ProcessorRunStatusDetailsEntity> runStatusDetailsEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        runStatusDetailsEntities.stream().filter(entity -> affectedComponents.containsKey(entity.getRunStatusDetails().getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedComponents.get(entity.getRunStatusDetails().getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            ProcessorRunStatusDetailsDTO runStatusDetailsDto = entity.getRunStatusDetails();
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(runStatusDetailsDto.getRunStatus());
                affectedComponent.setActiveThreadCount(Integer.valueOf(runStatusDetailsDto.getActiveThreadCount()));
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors((Collection)runStatusDetailsDto.getValidationErrors());
                }
            }
        });
    }

    private boolean isProcessorActionComplete(ProcessorsRunStatusDetailsEntity runStatusDetailsEntity, Map<String, AffectedComponentEntity> affectedComponents, ScheduledState desiredState, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        this.updateAffectedProcessors((Collection)runStatusDetailsEntity.getRunStatusDetails(), affectedComponents);
        boolean allReachedDesiredState = true;
        block5: for (ProcessorRunStatusDetailsEntity entity : runStatusDetailsEntity.getRunStatusDetails()) {
            ProcessorRunStatusDetailsDTO runStatusDetailsDto = entity.getRunStatusDetails();
            if (!affectedComponents.containsKey(runStatusDetailsDto.getId())) continue;
            boolean desiredStateReached = this.isDesiredProcessorStateReached(runStatusDetailsDto, desiredState);
            logger.debug("Processor[id={}, name={}] now has a state of {} with {} Active Threads, Validation Errors: {}; desired state = {}; invalid component action: {}; desired state reached = {}", new Object[]{runStatusDetailsDto.getId(), runStatusDetailsDto.getName(), runStatusDetailsDto.getRunStatus(), runStatusDetailsDto.getActiveThreadCount(), runStatusDetailsDto.getValidationErrors(), desiredState, invalidComponentAction, desiredStateReached});
            if (desiredStateReached) continue;
            if (desiredState == ScheduledState.STOPPED && runStatusDetailsDto.getActiveThreadCount() != 0) {
                return false;
            }
            if ("Invalid".equalsIgnoreCase(runStatusDetailsDto.getRunStatus())) {
                switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 3: {
                        String action = desiredState == ScheduledState.RUNNING ? "start" : "stop";
                        throw new LifecycleManagementException("Could not " + action + " " + runStatusDetailsDto.getName() + " because it is invalid");
                    }
                }
            }
            allReachedDesiredState = false;
        }
        if (allReachedDesiredState) {
            logger.debug("All {} Processors of interest now have the desired state of {}", (Object)runStatusDetailsEntity.getRunStatusDetails().size(), (Object)desiredState);
            return true;
        }
        return false;
    }

    private boolean isDesiredProcessorStateReached(ProcessorRunStatusDetailsDTO runStatusDetailsDto, ScheduledState desiredState) {
        String runStatus = runStatusDetailsDto.getRunStatus();
        boolean stateMatches = desiredState.name().equalsIgnoreCase(runStatus);
        if (!stateMatches) {
            return false;
        }
        return desiredState != ScheduledState.STOPPED || runStatusDetailsDto.getActiveThreadCount() == 0;
    }

    public Set<AffectedComponentEntity> activateControllerServices(URI originalUri, String groupId, Set<AffectedComponentEntity> affectedServices, Set<AffectedComponentEntity> servicesRequiringDesiredState, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        URI controllerServicesUri;
        if (affectedServices.isEmpty() && servicesRequiringDesiredState.isEmpty()) {
            logger.debug("No Controller Services to activate for group {} so will not issue request", (Object)groupId);
            return Collections.emptySet();
        }
        Set affectedServiceIds = affectedServices.stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        Set idsOfServicesRequiringDesiredState = servicesRequiringDesiredState.stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        Map serviceRevisionMap = this.getRevisions(groupId, affectedServiceIds);
        Map<String, RevisionDTO> serviceRevisionDtoMap = serviceRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ActivateControllerServicesEntity activateServicesEntity = new ActivateControllerServicesEntity();
        activateServicesEntity.setComponents(serviceRevisionDtoMap);
        activateServicesEntity.setId(groupId);
        activateServicesEntity.setState(desiredState.name());
        try {
            controllerServicesUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (desiredState == ControllerServiceState.ENABLED) {
            try {
                this.waitForControllerServiceValidation(user, originalUri, groupId, affectedServiceIds, pause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LifecycleManagementException("Interrupted while waiting for Controller Services to complete validation");
            }
        }
        try {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse();
            int disableServicesStatus = clusterResponse.getStatus();
            if (disableServicesStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                throw new LifecycleManagementException("Failed to update Controller Services to a state of " + String.valueOf(desiredState) + " due to " + explanation);
            }
            boolean serviceTransitioned = this.waitForControllerServiceStatus(user, originalUri, groupId, idsOfServicesRequiringDesiredState, desiredState, pause, invalidComponentAction);
            if (!serviceTransitioned) {
                throw new LifecycleManagementException("Failed while waiting for Controller Services to finish transitioning to a state of " + String.valueOf(desiredState));
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while transitioning Controller Services to a state of " + String.valueOf(desiredState));
        }
        return affectedServices.stream().map(componentEntity -> this.serviceFacade.getControllerService(componentEntity.getId(), false)).map(arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)).collect(Collectors.toSet());
    }

    private boolean waitForControllerServiceValidation(NiFiUser user, URI originalUri, String groupId, Set<String> serviceIds, Pause pause) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", "includeAncestorGroups=false&includeDescendantGroups=true&includeReferencingComponents=false", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ControllerServicesEntity controllerServicesEntity = (ControllerServicesEntity)this.getResponseEntity(clusterResponse, ControllerServicesEntity.class);
            Set serviceEntities = controllerServicesEntity.getControllerServices();
            Map<String, AffectedComponentEntity> affectedServices = serviceEntities.stream().filter(s -> serviceIds.contains(s.getId())).collect(Collectors.toMap(ComponentEntity::getId, arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)));
            if (this.isControllerServiceValidationComplete(serviceEntities, affectedServices)) {
                logger.debug("All {} controller services of interest have completed validation", (Object)affectedServices.size());
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isControllerServiceValidationComplete(Set<ControllerServiceEntity> controllerServiceEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedControllerServices(controllerServiceEntities, affectedComponents);
        for (ControllerServiceEntity entity : controllerServiceEntities) {
            if (!affectedComponents.containsKey(entity.getId()) || !"VALIDATING".equals(entity.getComponent().getValidationStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForControllerServiceStatus(NiFiUser user, URI originalUri, String groupId, Set<String> serviceIds, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws InterruptedException, LifecycleManagementException {
        URI groupUri;
        if (serviceIds.isEmpty()) {
            return true;
        }
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", "includeAncestorGroups=false&includeDescendantGroups=true&includeReferencingComponents=false", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ControllerServicesEntity controllerServicesEntity = (ControllerServicesEntity)this.getResponseEntity(clusterResponse, ControllerServicesEntity.class);
            Set serviceEntities = controllerServicesEntity.getControllerServices();
            Map<String, AffectedComponentEntity> affectedServices = serviceEntities.stream().collect(Collectors.toMap(ComponentEntity::getId, arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)));
            this.updateAffectedControllerServices(serviceEntities, affectedServices);
            String desiredStateName = desiredState.name();
            boolean allReachedDesiredState = true;
            block8: for (ControllerServiceEntity serviceEntity : serviceEntities) {
                ControllerServiceDTO serviceDto = serviceEntity.getComponent();
                if (serviceDto == null || !serviceIds.contains(serviceDto.getId())) continue;
                String validationStatus = serviceDto.getValidationStatus();
                boolean desiredStateReached = desiredStateName.equals(serviceDto.getState());
                logger.debug("ControllerService[id={}, name={}] now has a state of {} with a Validation Status of {}; desired state = {}; invalid component action is {}; desired state reached = {}", new Object[]{serviceDto.getId(), serviceDto.getName(), serviceDto.getState(), validationStatus, desiredState, invalidComponentAction, desiredStateReached});
                if (desiredStateReached) continue;
                if ("INVALID".equalsIgnoreCase(validationStatus)) {
                    switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            continue block8;
                        }
                        case 3: {
                            String action = desiredState == ControllerServiceState.ENABLED ? "enable" : "disable";
                            throw new LifecycleManagementException("Could not " + action + " " + serviceEntity.getComponent().getName() + " because it is invalid");
                        }
                    }
                }
                allReachedDesiredState = false;
            }
            if (allReachedDesiredState) {
                logger.debug("All {} controller services of interest now have the desired state of {}", (Object)affectedServices.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private void updateAffectedControllerServices(Set<ControllerServiceEntity> serviceEntities, Map<String, AffectedComponentEntity> affectedServices) {
        serviceEntities.stream().filter(entity -> affectedServices.containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedServices.get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getComponent().getState());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }
}

