/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class TransmissionStatusMatcher
implements AttributeMatcher<RemoteProcessGroup> {
    private static final Set<String> ON_KEYWORDS = new HashSet<String>(Arrays.asList("transmitting", "transmission enabled"));
    private static final Set<String> OFF_KEYWORDS = new HashSet<String>(Arrays.asList("not transmitting", "transmission disabled"));

    public void match(RemoteProcessGroup component, SearchQuery query, List<String> matches) {
        if (this.containsKeyword(query, ON_KEYWORDS) && component.isTransmitting()) {
            matches.add("Transmission: On");
        } else if (this.containsKeyword(query, OFF_KEYWORDS) && !this.containsKeyword(query, ON_KEYWORDS) && !component.isTransmitting()) {
            matches.add("Transmission: Off");
        }
    }

    private boolean containsKeyword(SearchQuery query, Set<String> keywords) {
        return keywords.stream().anyMatch(keyword -> StringUtils.containsIgnoreCase((CharSequence)keyword, (CharSequence)query.getTerm()));
    }
}

