/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search;

import java.util.List;
import java.util.function.Function;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.web.search.AttributeBasedComponentMatcher;
import org.apache.nifi.web.search.ComponentMatcher;
import org.apache.nifi.web.search.ComponentMatcherFactory;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;

public class ComponentMatcherFactory {
    public ComponentMatcher<Connectable> getInstanceForConnectable(List<AttributeMatcher<Connectable>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }

    public ComponentMatcher<Connection> getInstanceForConnection(List<AttributeMatcher<Connection>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), (Function)new GetConnectionName());
    }

    public ComponentMatcher<Parameter> getInstanceForParameter(List<AttributeMatcher<Parameter>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getDescriptor().getName(), component -> component.getDescriptor().getName());
    }

    public ComponentMatcher<ParameterContext> getInstanceForParameterContext(List<AttributeMatcher<ParameterContext>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }

    public ComponentMatcher<ProcessGroup> getInstanceForProcessGroup(List<AttributeMatcher<ProcessGroup>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }

    public ComponentMatcher<RemoteProcessGroup> getInstanceForRemoteProcessGroup(List<AttributeMatcher<RemoteProcessGroup>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }

    public ComponentMatcher<Label> getInstanceForLabel(List<AttributeMatcher<Label>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getValue());
    }

    public ComponentMatcher<ControllerServiceNode> getInstanceForControllerServiceNode(List<AttributeMatcher<ControllerServiceNode>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }

    public ComponentMatcher<ParameterProviderNode> getInstanceForParameterProviderNode(List<AttributeMatcher<ParameterProviderNode>> attributeMatchers) {
        return new AttributeBasedComponentMatcher(attributeMatchers, component -> component.getIdentifier(), component -> component.getName());
    }
}

