/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ReloadComponent;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleInstantiationException;
import org.apache.nifi.controller.flowanalysis.FlowAnalysisRuleProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.flowanalysis.EnforcementPolicy;
import org.apache.nifi.flowanalysis.FlowAnalysisRuleState;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.logging.repository.NopLogRepository;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.apache.nifi.web.dao.FlowAnalysisRuleDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardFlowAnalysisRuleDAO;

public class StandardFlowAnalysisRuleDAO
extends ComponentDAO
implements FlowAnalysisRuleDAO {
    private FlowAnalysisRuleProvider flowAnalysisRuleProvider;
    private ComponentStateDAO componentStateDAO;
    private ReloadComponent reloadComponent;
    private FlowController flowController;

    private FlowAnalysisRuleNode locateFlowAnalysisRule(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode flowAnalysisRule = this.flowAnalysisRuleProvider.getFlowAnalysisRuleNode(flowAnalysisRuleId);
        if (flowAnalysisRule == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate flow analysis rule with id '%s'.", flowAnalysisRuleId));
        }
        return flowAnalysisRule;
    }

    public void verifyCreate(FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        this.verifyCreate(this.flowAnalysisRuleProvider.getExtensionManager(), flowAnalysisRuleDTO.getType(), flowAnalysisRuleDTO.getBundle());
    }

    public FlowAnalysisRuleNode createFlowAnalysisRule(FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        if (flowAnalysisRuleDTO.getType() == null) {
            throw new IllegalArgumentException("The flow analysis rule type must be specified.");
        }
        try {
            ExtensionManager extensionManager = this.flowAnalysisRuleProvider.getExtensionManager();
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)flowAnalysisRuleDTO.getType(), (BundleDTO)flowAnalysisRuleDTO.getBundle());
            FlowAnalysisRuleNode flowAnalysisRule = this.flowAnalysisRuleProvider.createFlowAnalysisRule(flowAnalysisRuleDTO.getType(), flowAnalysisRuleDTO.getId(), bundleCoordinate, true);
            this.verifyUpdate(flowAnalysisRule, flowAnalysisRuleDTO);
            this.configureFlowAnalysisRule(flowAnalysisRule, flowAnalysisRuleDTO);
            this.flowController.getFlowManager().getFlowAnalyzer().ifPresent(flowAnalyzer -> flowAnalyzer.setFlowAnalysisRequired(true));
            return flowAnalysisRule;
        }
        catch (FlowAnalysisRuleInstantiationException rtie) {
            throw new NiFiCoreException(rtie.getMessage(), (Throwable)rtie);
        }
    }

    public FlowAnalysisRuleNode getFlowAnalysisRule(String flowAnalysisRuleId) {
        return this.locateFlowAnalysisRule(flowAnalysisRuleId);
    }

    public boolean hasFlowAnalysisRule(String flowAnalysisRuleId) {
        return this.flowAnalysisRuleProvider.getFlowAnalysisRuleNode(flowAnalysisRuleId) != null;
    }

    public Set<FlowAnalysisRuleNode> getFlowAnalysisRules() {
        return this.flowAnalysisRuleProvider.getAllFlowAnalysisRules();
    }

    public FlowAnalysisRuleNode updateFlowAnalysisRule(FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        FlowAnalysisRuleState purposedState;
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleDTO.getId());
        this.verifyUpdate(flowAnalysisRule, flowAnalysisRuleDTO);
        this.configureFlowAnalysisRule(flowAnalysisRule, flowAnalysisRuleDTO);
        this.updateBundle(flowAnalysisRule, flowAnalysisRuleDTO);
        if (this.isNotNull((Object)flowAnalysisRuleDTO.getState()) && !(purposedState = FlowAnalysisRuleState.valueOf((String)flowAnalysisRuleDTO.getState())).equals((Object)flowAnalysisRule.getState())) {
            try {
                switch (1.$SwitchMap$org$apache$nifi$flowanalysis$FlowAnalysisRuleState[purposedState.ordinal()]) {
                    case 1: {
                        this.flowAnalysisRuleProvider.enableFlowAnalysisRule(flowAnalysisRule);
                        break;
                    }
                    case 2: {
                        this.flowAnalysisRuleProvider.disableFlowAnalysisRule(flowAnalysisRule);
                    }
                }
            }
            catch (IllegalStateException | ComponentLifeCycleException ise) {
                throw new NiFiCoreException(ise.getMessage(), ise);
            }
            catch (NullPointerException npe) {
                throw new NiFiCoreException("Unable to update flow analysis rule state.", (Throwable)npe);
            }
            catch (Exception e) {
                throw new NiFiCoreException("Unable to update flow analysis rule state: " + String.valueOf(e), (Throwable)e);
            }
        }
        this.flowController.getFlowManager().getFlowAnalyzer().ifPresent(flowAnalyzer -> flowAnalyzer.setFlowAnalysisRequired(true));
        return flowAnalysisRule;
    }

    private void updateBundle(FlowAnalysisRuleNode flowAnalysisRule, FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        BundleDTO bundleDTO = flowAnalysisRuleDTO.getBundle();
        if (bundleDTO != null) {
            ExtensionManager extensionManager = this.flowAnalysisRuleProvider.getExtensionManager();
            BundleCoordinate incomingCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)flowAnalysisRule.getCanonicalClassName(), (BundleDTO)bundleDTO);
            BundleCoordinate existingCoordinate = flowAnalysisRule.getBundleCoordinate();
            if (!existingCoordinate.getCoordinate().equals(incomingCoordinate.getCoordinate())) {
                try {
                    ConfigurableComponent tempComponent = extensionManager.getTempComponent(flowAnalysisRule.getCanonicalClassName(), incomingCoordinate);
                    Set additionalUrls = flowAnalysisRule.getAdditionalClasspathResources(tempComponent.getPropertyDescriptors());
                    this.reloadComponent.reload(flowAnalysisRule, flowAnalysisRule.getCanonicalClassName(), incomingCoordinate, additionalUrls);
                }
                catch (FlowAnalysisRuleInstantiationException e) {
                    throw new NiFiCoreException(String.format("Unable to update flow analysis rule %s from %s to %s due to: %s", flowAnalysisRuleDTO.getId(), flowAnalysisRule.getBundleCoordinate().getCoordinate(), incomingCoordinate.getCoordinate(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private List<String> validateProposedConfiguration(FlowAnalysisRuleNode flowAnalysisRule, FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        return validationErrors;
    }

    public void verifyDelete(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        flowAnalysisRule.verifyCanDelete();
    }

    public void verifyUpdate(FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleDTO.getId());
        this.verifyUpdate(flowAnalysisRule, flowAnalysisRuleDTO);
    }

    private void verifyUpdate(FlowAnalysisRuleNode flowAnalysisRule, FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        BundleDTO bundleDTO;
        if (this.isNotNull((Object)flowAnalysisRuleDTO.getState())) {
            try {
                FlowAnalysisRuleState purposedState = FlowAnalysisRuleState.valueOf((String)flowAnalysisRuleDTO.getState());
                if (!purposedState.equals((Object)flowAnalysisRule.getState())) {
                    switch (1.$SwitchMap$org$apache$nifi$flowanalysis$FlowAnalysisRuleState[purposedState.ordinal()]) {
                        case 1: {
                            flowAnalysisRule.verifyCanEnable();
                            break;
                        }
                        case 2: {
                            flowAnalysisRule.verifyCanDisable();
                        }
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(String.format("The specified flow analysis rule state (%s) is not valid. Valid options are 'ENABLED' or 'DISABLED'.", flowAnalysisRuleDTO.getState()));
            }
        }
        boolean modificationRequest = false;
        if (this.isAnyNotNull(new Object[]{flowAnalysisRuleDTO.getName(), flowAnalysisRuleDTO.getProperties(), flowAnalysisRuleDTO.getBundle()})) {
            modificationRequest = true;
            List requestValidation = this.validateProposedConfiguration(flowAnalysisRule, flowAnalysisRuleDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
        }
        if ((bundleDTO = flowAnalysisRuleDTO.getBundle()) != null) {
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowAnalysisRuleProvider.getExtensionManager(), (String)flowAnalysisRule.getCanonicalClassName(), (BundleDTO)bundleDTO);
            flowAnalysisRule.verifyCanUpdateBundle(bundleCoordinate);
        }
        if (modificationRequest) {
            flowAnalysisRule.verifyCanUpdate();
        }
    }

    public void verifyConfigVerification(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode ruleNode = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        ruleNode.verifyCanPerformVerification();
    }

    public List<ConfigVerificationResultDTO> verifyConfiguration(String flowAnalysisRuleId, Map<String, String> properties) {
        FlowAnalysisRuleNode ruleNode = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        NopLogRepository logRepository = new NopLogRepository();
        SimpleProcessLogger configVerificationLog = new SimpleProcessLogger((Object)ruleNode.getFlowAnalysisRule(), (LogRepository)logRepository, (LoggingContext)new StandardLoggingContext(null));
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        ParameterLookup parameterLookup = ParameterLookup.EMPTY;
        StandardConfigurationContext configurationContext = new StandardConfigurationContext((ComponentNode)ruleNode, properties, ruleNode.getAnnotationData(), parameterLookup, (ControllerServiceLookup)this.flowController.getControllerServiceProvider(), null);
        List verificationResults = ruleNode.verifyConfiguration((ConfigurationContext)configurationContext, (ComponentLog)configVerificationLog, extensionManager);
        List<ConfigVerificationResultDTO> resultsDtos = verificationResults.stream().map(arg_0 -> this.createConfigVerificationResultDto(arg_0)).collect(Collectors.toList());
        return resultsDtos;
    }

    private ConfigVerificationResultDTO createConfigVerificationResultDto(ConfigVerificationResult result) {
        ConfigVerificationResultDTO dto = new ConfigVerificationResultDTO();
        dto.setExplanation(result.getExplanation());
        dto.setOutcome(result.getOutcome().name());
        dto.setVerificationStepName(result.getVerificationStepName());
        return dto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFlowAnalysisRule(FlowAnalysisRuleNode flowAnalysisRule, FlowAnalysisRuleDTO flowAnalysisRuleDTO) {
        String name = flowAnalysisRuleDTO.getName();
        String comments = flowAnalysisRuleDTO.getComments();
        String enforcementPolicy = flowAnalysisRuleDTO.getEnforcementPolicy();
        Map properties = flowAnalysisRuleDTO.getProperties();
        flowAnalysisRule.pauseValidationTrigger();
        try {
            if (this.isNotNull((Object)enforcementPolicy)) {
                flowAnalysisRule.setEnforcementPolicy(EnforcementPolicy.valueOf((String)enforcementPolicy));
            }
            if (this.isNotNull((Object)name)) {
                flowAnalysisRule.setName(name);
            }
            if (this.isNotNull((Object)comments)) {
                flowAnalysisRule.setComments(comments);
            }
            if (this.isNotNull((Object)properties)) {
                Set sensitiveDynamicPropertyNames = flowAnalysisRuleDTO.getSensitiveDynamicPropertyNames();
                flowAnalysisRule.setProperties(properties, false, sensitiveDynamicPropertyNames == null ? Collections.emptySet() : sensitiveDynamicPropertyNames);
            }
        }
        finally {
            flowAnalysisRule.resumeValidationTrigger();
        }
    }

    public void deleteFlowAnalysisRule(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        this.flowAnalysisRuleProvider.removeFlowAnalysisRule(flowAnalysisRule);
        this.flowController.getFlowManager().getFlowAnalyzer().ifPresent(flowAnalyzer -> flowAnalyzer.setFlowAnalysisRequired(true));
    }

    public StateMap getState(String flowAnalysisRuleId, Scope scope) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        return this.componentStateDAO.getState(flowAnalysisRule, scope);
    }

    public void verifyClearState(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        flowAnalysisRule.verifyCanClearState();
    }

    public void clearState(String flowAnalysisRuleId) {
        FlowAnalysisRuleNode flowAnalysisRule = this.locateFlowAnalysisRule(flowAnalysisRuleId);
        this.componentStateDAO.clearState(flowAnalysisRule);
    }

    public void setFlowAnalysisRuleProvider(FlowAnalysisRuleProvider flowAnalysisRuleProvider) {
        this.flowAnalysisRuleProvider = flowAnalysisRuleProvider;
    }

    public void setComponentStateDAO(ComponentStateDAO componentStateDAO) {
        this.componentStateDAO = componentStateDAO;
    }

    public void setReloadComponent(ReloadComponent reloadComponent) {
        this.reloadComponent = reloadComponent;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

