/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.components.PortFunction;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.impl.AbstractPortDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPortDAO
extends ComponentDAO
implements PortDAO {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPortDAO.class);
    protected FlowController flowController;

    protected abstract Port locatePort(String var1);

    public void verifyUpdate(PortDTO portDTO) {
        Port port = this.locatePort(portDTO.getId());
        this.verifyUpdate(port, portDTO);
    }

    protected void verifyUpdate(Port port, PortDTO portDTO) {
        ScheduledState purposedScheduledState;
        if (this.isNotNull((Object)portDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)port.getScheduledState())) {
            switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                case 1: {
                    port.getProcessGroup().verifyCanScheduleComponentsIndividually();
                    port.verifyCanStart();
                    break;
                }
                case 3: {
                    switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[port.getScheduledState().ordinal()]) {
                        case 1: {
                            port.getProcessGroup().verifyCanScheduleComponentsIndividually();
                            port.verifyCanStop();
                            break;
                        }
                        case 2: {
                            port.verifyCanEnable();
                        }
                    }
                    break;
                }
                case 2: {
                    port.verifyCanDisable();
                }
            }
        }
        if (this.isAnyNotNull((Object[])new Serializable[]{portDTO.getConcurrentlySchedulableTaskCount(), portDTO.getName(), portDTO.getComments(), portDTO.getAllowRemoteAccess()})) {
            List requestValidation = this.validateProposedConfiguration(port, portDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
            port.verifyCanUpdate();
        }
    }

    private List<String> validateProposedConfiguration(Port port, PortDTO portDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)portDTO.getName()) && portDTO.getName().trim().isEmpty()) {
            validationErrors.add("The name of the port must be specified.");
        }
        if (this.isNotNull((Object)portDTO.getConcurrentlySchedulableTaskCount()) && portDTO.getConcurrentlySchedulableTaskCount() <= 0) {
            validationErrors.add("Concurrent tasks must be a positive integer.");
        }
        if (port instanceof PublicPort) {
            String portName;
            String string = portName = this.isNotNull((Object)portDTO.getName()) ? portDTO.getName() : port.getName();
            if (this.getPublicPorts().stream().anyMatch(p -> portName.equals(p.getName()) && !port.getIdentifier().equals(p.getIdentifier()))) {
                throw new IllegalStateException("Public port name must be unique throughout the flow.");
            }
        }
        return validationErrors;
    }

    public void verifyPublicPortUniqueness(String portId, String portName) {
        for (Port port : this.getPublicPorts()) {
            if (portId.equals(port.getIdentifier())) {
                throw new IllegalStateException("Public port identifier must be unique throughout the flow.");
            }
            if (!portName.equals(port.getName())) continue;
            throw new IllegalStateException("Public port name must be unique throughout the flow.");
        }
    }

    protected abstract Set<Port> getPublicPorts();

    protected abstract void handleStateTransition(Port var1, ScheduledState var2) throws IllegalStateException;

    public Port updatePort(PortDTO portDTO) {
        ScheduledState proposedScheduledState;
        Port port = this.locatePort(portDTO.getId());
        ProcessGroup processGroup = port.getProcessGroup();
        this.verifyUpdate(port, portDTO);
        if (this.isNotNull((Object)portDTO.getState()) && !(proposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)port.getScheduledState())) {
            try {
                this.handleStateTransition(port, proposedScheduledState);
            }
            catch (IllegalStateException ise) {
                throw new NiFiCoreException(ise.getMessage(), (Throwable)ise);
            }
        }
        String name = portDTO.getName();
        String comments = portDTO.getComments();
        Integer concurrentTasks = portDTO.getConcurrentlySchedulableTaskCount();
        String portFunction = portDTO.getPortFunction();
        if (this.isNotNull((Object)portDTO.getPosition())) {
            port.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)name)) {
            port.setName(name);
        }
        if (this.isNotNull((Object)comments)) {
            port.setComments(comments);
        }
        if (this.isNotNull((Object)concurrentTasks)) {
            port.setMaxConcurrentTasks(concurrentTasks.intValue());
        }
        if (this.isNotNull((Object)portFunction)) {
            try {
                PortFunction function = PortFunction.valueOf((String)portFunction);
                port.setPortFunction(function);
            }
            catch (IllegalArgumentException e) {
                logger.warn("Cannot update Port Function for {} because provided value is invalid: {}", (Object)port, (Object)portFunction);
            }
        }
        processGroup.onComponentModified();
        return port;
    }

    public void verifyDelete(String portId) {
        Port inputPort = this.locatePort(portId);
        inputPort.verifyCanDelete();
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

