/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import jakarta.ws.rs.WebApplicationException;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.ExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.component.details.RemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Restriction;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.cluster.coordination.heartbeat.NodeHeartbeat;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.event.NodeEvent;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDependency;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.components.validation.ValidationState;
import org.apache.nifi.components.validation.ValidationStatus;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ActiveThreadInfo;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.ThreadDetails;
import org.apache.nifi.controller.flow.FlowManager;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileSummary;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.LoadBalanceStrategy;
import org.apache.nifi.controller.queue.LocalQueuePartitionDiagnostics;
import org.apache.nifi.controller.queue.QueueDiagnostics;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.queue.RemoteQueuePartitionDiagnostics;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.state.SortedStateUtils;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.analytics.ConnectionStatusPredictions;
import org.apache.nifi.controller.status.analytics.StatusAnalytics;
import org.apache.nifi.controller.status.history.GarbageCollectionHistory;
import org.apache.nifi.controller.status.history.GarbageCollectionStatus;
import org.apache.nifi.diagnostics.DiagnosticLevel;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.flowanalysis.FlowAnalysisRule;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupCounts;
import org.apache.nifi.history.History;
import org.apache.nifi.nar.ExtensionDefinition;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.PythonBundle;
import org.apache.nifi.parameter.Parameter;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterContextLookup;
import org.apache.nifi.parameter.ParameterDescriptor;
import org.apache.nifi.parameter.ParameterGroupConfiguration;
import org.apache.nifi.parameter.ParameterProvider;
import org.apache.nifi.parameter.ParameterReferenceManager;
import org.apache.nifi.parameter.ParameterSensitivity;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.lineage.ComputeLineageResult;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.LineageEdge;
import org.apache.nifi.provenance.lineage.LineageNode;
import org.apache.nifi.provenance.lineage.ProvenanceEventLineageNode;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryClient;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.VersionControlInformation;
import org.apache.nifi.registry.flow.VersionedFlowState;
import org.apache.nifi.registry.flow.VersionedFlowStatus;
import org.apache.nifi.registry.flow.diff.FlowComparison;
import org.apache.nifi.registry.flow.diff.FlowDifference;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedComponent;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedConnection;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedControllerService;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedFunnel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedLabel;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessGroup;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedProcessor;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteGroupPort;
import org.apache.nifi.registry.flow.mapping.InstantiatedVersionedRemoteProcessGroup;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FlowDifferenceFilters;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.AccessPolicySummaryDTO;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.AllowableValueDTO;
import org.apache.nifi.web.api.dto.BatchSettingsDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentDifferenceDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ComponentValidationResultDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerConfigurationDTO;
import org.apache.nifi.web.api.dto.ControllerServiceApiDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersSnapshotDTO;
import org.apache.nifi.web.api.dto.DifferenceDTO;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.EntityFactory;
import org.apache.nifi.web.api.dto.ExplicitRestrictionDTO;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.api.dto.FlowConfigurationDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.FlowRegistryBranchDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.NodeEventDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextReferenceDTO;
import org.apache.nifi.web.api.dto.ParameterDTO;
import org.apache.nifi.web.api.dto.ParameterProviderConfigurationDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.ParameterProviderReferencingComponentDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessGroupNameDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.ProcessorRunStatusDetailsDTO;
import org.apache.nifi.web.api.dto.PropertyDependencyDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.QueueSizeDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.RequiredPermissionDTO;
import org.apache.nifi.web.api.dto.ResourceDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.dto.StateEntryDTO;
import org.apache.nifi.web.api.dto.StateMapDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.action.ActionDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.component.details.ComponentDetailsDTO;
import org.apache.nifi.web.api.dto.action.component.details.ExtensionDetailsDTO;
import org.apache.nifi.web.api.dto.action.component.details.RemoteProcessGroupDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ActionDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ConfigureDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ConnectDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.MoveDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.PurgeDetailsDTO;
import org.apache.nifi.web.api.dto.diagnostics.ClassLoaderDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.ConnectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.ConnectionDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.ControllerServiceDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.GCDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.GarbageCollectionDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMControllerDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMFlowDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.JVMSystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.diagnostics.LocalQueuePartitionDTO;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.diagnostics.RemoteQueuePartitionDTO;
import org.apache.nifi.web.api.dto.diagnostics.RepositoryUsageDTO;
import org.apache.nifi.web.api.dto.diagnostics.ThreadDumpDTO;
import org.apache.nifi.web.api.dto.flow.FlowBreadcrumbDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageRequestDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageResultsDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.ProvenanceLinkDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.ProvenanceNodeDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusPredictionsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.PortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.entity.AccessPolicySummaryEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.AllowableValueEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.FlowBreadcrumbEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterEntity;
import org.apache.nifi.web.api.entity.ParameterGroupConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderConfigurationEntity;
import org.apache.nifi.web.api.entity.ParameterProviderReferencingComponentEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.PortStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.revision.RevisionManager;

public final class DtoFactory {
    private static final Comparator<Class> CLASS_NAME_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    public static final String SENSITIVE_VALUE_MASK = "********";
    private BulletinRepository bulletinRepository;
    private ControllerServiceProvider controllerServiceProvider;
    private EntityFactory entityFactory;
    private Authorizer authorizer;
    private ExtensionManager extensionManager;

    public ControllerConfigurationDTO createControllerConfigurationDto(ControllerFacade controllerFacade) {
        ControllerConfigurationDTO dto = new ControllerConfigurationDTO();
        dto.setMaxTimerDrivenThreadCount(Integer.valueOf(controllerFacade.getMaxTimerDrivenThreadCount()));
        return dto;
    }

    public FlowConfigurationDTO createFlowConfigurationDto(String autoRefreshInterval, Long defaultBackPressureObjectThreshold, String defaultBackPressureDataSizeThreshold) {
        FlowConfigurationDTO dto = new FlowConfigurationDTO();
        long refreshInterval = FormatUtils.getTimeDuration((String)autoRefreshInterval, (TimeUnit)TimeUnit.SECONDS);
        dto.setAutoRefreshIntervalSeconds(Long.valueOf(refreshInterval));
        dto.setSupportsManagedAuthorizer(Boolean.valueOf(AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)this.authorizer)));
        dto.setSupportsConfigurableUsersAndGroups(Boolean.valueOf(AuthorizerCapabilityDetection.isConfigurableUserGroupProvider((Authorizer)this.authorizer)));
        dto.setSupportsConfigurableAuthorizer(Boolean.valueOf(AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider((Authorizer)this.authorizer)));
        Date now = new Date();
        dto.setTimeOffset(Integer.valueOf(TimeZone.getDefault().getOffset(now.getTime())));
        dto.setCurrentTime(now);
        dto.setDefaultBackPressureDataSizeThreshold(defaultBackPressureDataSizeThreshold);
        dto.setDefaultBackPressureObjectThreshold(defaultBackPressureObjectThreshold);
        return dto;
    }

    public ActionDTO createActionDto(Action action) {
        ActionDTO actionDto = new ActionDTO();
        actionDto.setId(action.getId());
        actionDto.setSourceId(action.getSourceId());
        actionDto.setSourceName(action.getSourceName());
        actionDto.setSourceType(action.getSourceType().toString());
        actionDto.setTimestamp(action.getTimestamp());
        actionDto.setUserIdentity(action.getUserIdentity());
        actionDto.setOperation(action.getOperation().toString());
        actionDto.setActionDetails(this.createActionDetailsDto(action.getActionDetails()));
        actionDto.setComponentDetails(this.createComponentDetailsDto(action.getComponentDetails()));
        return actionDto;
    }

    private ActionDetailsDTO createActionDetailsDto(ActionDetails actionDetails) {
        if (actionDetails == null) {
            return null;
        }
        if (actionDetails instanceof FlowChangeConfigureDetails) {
            ConfigureDetailsDTO configureDetails = new ConfigureDetailsDTO();
            configureDetails.setName(((ConfigureDetails)actionDetails).getName());
            configureDetails.setPreviousValue(((ConfigureDetails)actionDetails).getPreviousValue());
            configureDetails.setValue(((ConfigureDetails)actionDetails).getValue());
            return configureDetails;
        }
        if (actionDetails instanceof FlowChangeConnectDetails) {
            ConnectDetailsDTO connectDetails = new ConnectDetailsDTO();
            connectDetails.setSourceId(((ConnectDetails)actionDetails).getSourceId());
            connectDetails.setSourceName(((ConnectDetails)actionDetails).getSourceName());
            connectDetails.setSourceType(((ConnectDetails)actionDetails).getSourceType().toString());
            connectDetails.setRelationship(((ConnectDetails)actionDetails).getRelationship());
            connectDetails.setDestinationId(((ConnectDetails)actionDetails).getDestinationId());
            connectDetails.setDestinationName(((ConnectDetails)actionDetails).getDestinationName());
            connectDetails.setDestinationType(((ConnectDetails)actionDetails).getDestinationType().toString());
            return connectDetails;
        }
        if (actionDetails instanceof FlowChangeMoveDetails) {
            MoveDetailsDTO moveDetails = new MoveDetailsDTO();
            moveDetails.setPreviousGroup(((MoveDetails)actionDetails).getPreviousGroup());
            moveDetails.setPreviousGroupId(((MoveDetails)actionDetails).getPreviousGroupId());
            moveDetails.setGroup(((MoveDetails)actionDetails).getGroup());
            moveDetails.setGroupId(((MoveDetails)actionDetails).getGroupId());
            return moveDetails;
        }
        if (actionDetails instanceof FlowChangePurgeDetails) {
            PurgeDetailsDTO purgeDetails = new PurgeDetailsDTO();
            purgeDetails.setEndDate(((PurgeDetails)actionDetails).getEndDate());
            return purgeDetails;
        }
        throw new WebApplicationException((Throwable)new IllegalArgumentException(String.format("Unrecognized type of action details encountered %s during serialization.", actionDetails.toString())));
    }

    private ComponentDetailsDTO createComponentDetailsDto(ComponentDetails componentDetails) {
        if (componentDetails == null) {
            return null;
        }
        if (componentDetails instanceof FlowChangeExtensionDetails) {
            ExtensionDetailsDTO processorDetails = new ExtensionDetailsDTO();
            processorDetails.setType(((ExtensionDetails)componentDetails).getType());
            return processorDetails;
        }
        if (componentDetails instanceof FlowChangeRemoteProcessGroupDetails) {
            RemoteProcessGroupDetailsDTO remoteProcessGroupDetails = new RemoteProcessGroupDetailsDTO();
            remoteProcessGroupDetails.setUri(((RemoteProcessGroupDetails)componentDetails).getUri());
            return remoteProcessGroupDetails;
        }
        throw new WebApplicationException((Throwable)new IllegalArgumentException(String.format("Unrecognized type of component details encountered %s during serialization. ", componentDetails.toString())));
    }

    public HistoryDTO createHistoryDto(History history) {
        HistoryDTO historyDto = new HistoryDTO();
        historyDto.setTotal(history.getTotal());
        historyDto.setLastRefreshed(history.getLastRefreshed());
        return historyDto;
    }

    public ComponentStateDTO createComponentStateDTO(String componentId, Class<?> componentClass, StateMap localState, StateMap clusterState) {
        ComponentStateDTO dto = new ComponentStateDTO();
        dto.setComponentId(componentId);
        dto.setStateDescription(this.getStateDescription(componentClass));
        dto.setLocalState(this.createStateMapDTO(Scope.LOCAL, localState));
        dto.setClusterState(this.createStateMapDTO(Scope.CLUSTER, clusterState));
        return dto;
    }

    private String getStateDescription(Class<?> componentClass) {
        Stateful capabilityDesc = componentClass.getAnnotation(Stateful.class);
        if (capabilityDesc != null) {
            return capabilityDesc.description();
        }
        return null;
    }

    public StateMapDTO createStateMapDTO(Scope scope, StateMap stateMap) {
        if (stateMap == null) {
            return null;
        }
        StateMapDTO dto = new StateMapDTO();
        dto.setScope(scope.toString());
        TreeMap sortedState = new TreeMap(SortedStateUtils.getKeyComparator());
        Map state = stateMap.toMap();
        sortedState.putAll(state);
        int count = 0;
        ArrayList<StateEntryDTO> stateEntries = new ArrayList<StateEntryDTO>();
        Set entrySet = sortedState.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext() && count++ < 500) {
            Map.Entry entry = iter.next();
            StateEntryDTO entryDTO = new StateEntryDTO();
            entryDTO.setKey((String)entry.getKey());
            entryDTO.setValue((String)entry.getValue());
            stateEntries.add(entryDTO);
        }
        dto.setTotalEntryCount(state.size());
        dto.setState(stateEntries);
        return dto;
    }

    public CountersSnapshotDTO createCountersDto(Collection<CounterDTO> counterDtos) {
        CountersSnapshotDTO dto = new CountersSnapshotDTO();
        dto.setCounters(counterDtos);
        dto.setGenerated(new Date());
        return dto;
    }

    public CounterDTO createCounterDto(Counter counter) {
        CounterDTO dto = new CounterDTO();
        dto.setId(counter.getIdentifier());
        dto.setContext(counter.getContext());
        dto.setName(counter.getName());
        dto.setValueCount(Long.valueOf(counter.getValue()));
        dto.setValue(FormatUtils.formatCount((long)counter.getValue()));
        return dto;
    }

    public PositionDTO createPositionDto(Position position) {
        return new PositionDTO(Double.valueOf(position.getX()), Double.valueOf(position.getY()));
    }

    private boolean isDropRequestComplete(DropFlowFileState state) {
        return DropFlowFileState.COMPLETE.equals((Object)state) || DropFlowFileState.CANCELED.equals((Object)state) || DropFlowFileState.FAILURE.equals((Object)state);
    }

    public DropRequestDTO createDropRequestDTO(DropFlowFileStatus dropRequest) {
        DropRequestDTO dto = new DropRequestDTO();
        dto.setId(dropRequest.getRequestIdentifier());
        dto.setSubmissionTime(new Date(dropRequest.getRequestSubmissionTime()));
        dto.setLastUpdated(new Date(dropRequest.getLastUpdated()));
        dto.setState(dropRequest.getState().toString());
        dto.setFailureReason(dropRequest.getFailureReason());
        dto.setFinished(Boolean.valueOf(this.isDropRequestComplete(dropRequest.getState())));
        QueueSize dropped = dropRequest.getDroppedSize();
        dto.setDroppedCount(Integer.valueOf(dropped.getObjectCount()));
        dto.setDroppedSize(Long.valueOf(dropped.getByteCount()));
        dto.setDropped(FormatUtils.formatCount((long)dropped.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)dropped.getByteCount()));
        QueueSize current = dropRequest.getCurrentSize();
        dto.setCurrentCount(Integer.valueOf(current.getObjectCount()));
        dto.setCurrentSize(Long.valueOf(current.getByteCount()));
        dto.setCurrent(FormatUtils.formatCount((long)current.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)current.getByteCount()));
        QueueSize original = dropRequest.getOriginalSize();
        dto.setOriginalCount(Integer.valueOf(original.getObjectCount()));
        dto.setOriginalSize(Long.valueOf(original.getByteCount()));
        dto.setOriginal(FormatUtils.formatCount((long)original.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)original.getByteCount()));
        if (this.isDropRequestComplete(dropRequest.getState())) {
            dto.setPercentCompleted(Integer.valueOf(100));
        } else {
            dto.setPercentCompleted(Integer.valueOf(dropped.getObjectCount() * 100 / original.getObjectCount()));
        }
        return dto;
    }

    private boolean isListingRequestComplete(ListFlowFileState state) {
        return ListFlowFileState.COMPLETE.equals((Object)state) || ListFlowFileState.CANCELED.equals((Object)state) || ListFlowFileState.FAILURE.equals((Object)state);
    }

    private QueueSizeDTO createQueueSizeDTO(QueueSize queueSize) {
        QueueSizeDTO dto = new QueueSizeDTO();
        dto.setByteCount(queueSize.getByteCount());
        dto.setObjectCount(queueSize.getObjectCount());
        return dto;
    }

    public ListingRequestDTO createListingRequestDTO(ListFlowFileStatus listingRequest) {
        List flowFileSummaries;
        ListingRequestDTO dto = new ListingRequestDTO();
        dto.setId(listingRequest.getRequestIdentifier());
        dto.setSubmissionTime(new Date(listingRequest.getRequestSubmissionTime()));
        dto.setLastUpdated(new Date(listingRequest.getLastUpdated()));
        dto.setState(listingRequest.getState().toString());
        dto.setFailureReason(listingRequest.getFailureReason());
        dto.setFinished(Boolean.valueOf(this.isListingRequestComplete(listingRequest.getState())));
        dto.setMaxResults(Integer.valueOf(listingRequest.getMaxResults()));
        dto.setPercentCompleted(Integer.valueOf(listingRequest.getCompletionPercentage()));
        dto.setQueueSize(this.createQueueSizeDTO(listingRequest.getQueueSize()));
        if (this.isListingRequestComplete(listingRequest.getState()) && (flowFileSummaries = listingRequest.getFlowFileSummaries()) != null) {
            Date now = new Date();
            ArrayList<FlowFileSummaryDTO> summaryDtos = new ArrayList<FlowFileSummaryDTO>(flowFileSummaries.size());
            for (FlowFileSummary summary : flowFileSummaries) {
                summaryDtos.add(this.createFlowFileSummaryDTO(summary, now));
            }
            dto.setFlowFileSummaries(summaryDtos);
        }
        return dto;
    }

    public FlowFileSummaryDTO createFlowFileSummaryDTO(FlowFileSummary summary, Date now) {
        FlowFileSummaryDTO dto = new FlowFileSummaryDTO();
        dto.setUuid(summary.getUuid());
        dto.setFilename(summary.getFilename());
        dto.setPenalized(Boolean.valueOf(summary.isPenalized()));
        long penaltyExpiration = summary.getPenaltyExpirationMillis() - now.getTime();
        dto.setPenaltyExpiresIn(Long.valueOf(penaltyExpiration >= 0L ? penaltyExpiration : 0L));
        dto.setPosition(Integer.valueOf(summary.getPosition()));
        dto.setSize(Long.valueOf(summary.getSize()));
        long queuedDuration = now.getTime() - summary.getLastQueuedTime();
        dto.setQueuedDuration(Long.valueOf(queuedDuration));
        long age = now.getTime() - summary.getLineageStartDate();
        dto.setLineageDuration(Long.valueOf(age));
        return dto;
    }

    public FlowFileDTO createFlowFileDTO(FlowFileRecord record) {
        Date now = new Date();
        FlowFileDTO dto = new FlowFileDTO();
        dto.setUuid(record.getAttribute(CoreAttributes.UUID.key()));
        dto.setFilename(record.getAttribute(CoreAttributes.FILENAME.key()));
        dto.setPenalized(Boolean.valueOf(record.isPenalized()));
        long penaltyExpiration = record.getPenaltyExpirationMillis() - now.getTime();
        dto.setPenaltyExpiresIn(Long.valueOf(penaltyExpiration >= 0L ? penaltyExpiration : 0L));
        dto.setSize(Long.valueOf(record.getSize()));
        dto.setAttributes(record.getAttributes());
        long queuedDuration = now.getTime() - record.getLastQueueDate();
        dto.setQueuedDuration(Long.valueOf(queuedDuration));
        long age = now.getTime() - record.getLineageStartDate();
        dto.setLineageDuration(Long.valueOf(age));
        ContentClaim contentClaim = record.getContentClaim();
        if (contentClaim != null) {
            ResourceClaim resourceClaim = contentClaim.getResourceClaim();
            dto.setContentClaimSection(resourceClaim.getSection());
            dto.setContentClaimContainer(resourceClaim.getContainer());
            dto.setContentClaimIdentifier(resourceClaim.getId());
            dto.setContentClaimOffset(Long.valueOf(contentClaim.getOffset() + record.getContentClaimOffset()));
            dto.setContentClaimFileSizeBytes(Long.valueOf(record.getSize()));
            dto.setContentClaimFileSize(FormatUtils.formatDataSize((double)record.getSize()));
        }
        return dto;
    }

    public ConnectionDTO createConnectionDto(Connection connection) {
        if (connection == null) {
            return null;
        }
        ConnectionDTO dto = new ConnectionDTO();
        dto.setId(connection.getIdentifier());
        dto.setParentGroupId(connection.getProcessGroup().getIdentifier());
        ArrayList<PositionDTO> bendPoints = new ArrayList<PositionDTO>();
        for (Object bendPoint : connection.getBendPoints()) {
            bendPoints.add(this.createPositionDto((Position)bendPoint));
        }
        dto.setBends(bendPoints);
        dto.setName(connection.getName());
        dto.setLabelIndex(Integer.valueOf(connection.getLabelIndex()));
        dto.setzIndex(Long.valueOf(connection.getZIndex()));
        dto.setSource(this.createConnectableDto(connection.getSource()));
        dto.setDestination(this.createConnectableDto(connection.getDestination()));
        dto.setVersionedComponentId((String)connection.getVersionedComponentId().orElse(null));
        FlowFileQueue flowFileQueue = connection.getFlowFileQueue();
        dto.setBackPressureObjectThreshold(Long.valueOf(flowFileQueue.getBackPressureObjectThreshold()));
        dto.setBackPressureDataSizeThreshold(flowFileQueue.getBackPressureDataSizeThreshold());
        dto.setFlowFileExpiration(flowFileQueue.getFlowFileExpiration());
        dto.setPrioritizers(new ArrayList());
        for (FlowFilePrioritizer comparator : flowFileQueue.getPriorities()) {
            dto.getPrioritizers().add(comparator.getClass().getCanonicalName());
        }
        for (Relationship selectedRelationship : connection.getRelationships()) {
            if (Relationship.ANONYMOUS.equals((Object)selectedRelationship)) continue;
            if (dto.getSelectedRelationships() == null) {
                dto.setSelectedRelationships(new TreeSet<Object>(Collator.getInstance(Locale.US)));
            }
            dto.getSelectedRelationships().add(selectedRelationship.getName());
        }
        for (Relationship availableRelationship : connection.getSource().getRelationships()) {
            if (Relationship.ANONYMOUS.equals((Object)availableRelationship)) continue;
            if (dto.getAvailableRelationships() == null) {
                dto.setAvailableRelationships(new TreeSet<Object>(Collator.getInstance(Locale.US)));
            }
            dto.getAvailableRelationships().add(availableRelationship.getName());
        }
        LoadBalanceStrategy loadBalanceStrategy = flowFileQueue.getLoadBalanceStrategy();
        dto.setLoadBalancePartitionAttribute(flowFileQueue.getPartitioningAttribute());
        dto.setLoadBalanceStrategy(loadBalanceStrategy.name());
        dto.setLoadBalanceCompression(flowFileQueue.getLoadBalanceCompression().name());
        if (loadBalanceStrategy == LoadBalanceStrategy.DO_NOT_LOAD_BALANCE) {
            dto.setLoadBalanceStatus("LOAD_BALANCE_NOT_CONFIGURED");
        } else if (flowFileQueue.isActivelyLoadBalancing()) {
            dto.setLoadBalanceStatus("LOAD_BALANCE_ACTIVE");
        } else {
            dto.setLoadBalanceStatus("LOAD_BALANCE_INACTIVE");
        }
        return dto;
    }

    public ConnectableDTO createConnectableDto(Connectable connectable) {
        if (connectable == null) {
            return null;
        }
        boolean isAuthorized = connectable.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        ConnectableDTO dto = new ConnectableDTO();
        dto.setId(connectable.getIdentifier());
        dto.setName(isAuthorized ? connectable.getName() : connectable.getIdentifier());
        dto.setType(connectable.getConnectableType().name());
        dto.setVersionedComponentId((String)connectable.getVersionedComponentId().orElse(null));
        if (connectable instanceof RemoteGroupPort) {
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)connectable;
            RemoteProcessGroup remoteGroup = remoteGroupPort.getRemoteProcessGroup();
            dto.setGroupId(remoteGroup.getIdentifier());
            dto.setRunning(Boolean.valueOf(remoteGroupPort.isTargetRunning()));
            dto.setTransmitting(Boolean.valueOf(remoteGroupPort.isRunning()));
            dto.setExists(Boolean.valueOf(remoteGroupPort.getTargetExists()));
            if (isAuthorized) {
                dto.setComments(remoteGroup.getComments());
            }
        } else {
            dto.setGroupId(connectable.getProcessGroup().getIdentifier());
            dto.setRunning(Boolean.valueOf(connectable.isRunning()));
            if (isAuthorized) {
                dto.setComments(connectable.getComments());
            }
        }
        return dto;
    }

    public LabelDTO createLabelDto(Label label) {
        if (label == null) {
            return null;
        }
        LabelDTO dto = new LabelDTO();
        dto.setId(label.getIdentifier());
        dto.setPosition(this.createPositionDto(label.getPosition()));
        dto.setStyle(label.getStyle());
        dto.setHeight(Double.valueOf(label.getSize().getHeight()));
        dto.setWidth(Double.valueOf(label.getSize().getWidth()));
        dto.setLabel(label.getValue());
        dto.setParentGroupId(label.getProcessGroup().getIdentifier());
        dto.setVersionedComponentId((String)label.getVersionedComponentId().orElse(null));
        dto.setzIndex(Long.valueOf(label.getZIndex()));
        return dto;
    }

    public UserDTO createUserDto(User user, Set<TenantEntity> groups, Set<AccessPolicySummaryEntity> accessPolicies) {
        if (user == null) {
            return null;
        }
        UserDTO dto = new UserDTO();
        dto.setId(user.getIdentifier());
        dto.setUserGroups(groups);
        dto.setIdentity(user.getIdentity());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable((Authorizer)this.authorizer, (User)user)));
        dto.setAccessPolicies(accessPolicies);
        return dto;
    }

    public TenantDTO createTenantDTO(User user) {
        if (user == null) {
            return null;
        }
        TenantDTO dto = new TenantDTO();
        dto.setId(user.getIdentifier());
        dto.setIdentity(user.getIdentity());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable((Authorizer)this.authorizer, (User)user)));
        return dto;
    }

    public UserGroupDTO createUserGroupDto(Group userGroup, Set<TenantEntity> users, Set<AccessPolicySummaryEntity> accessPolicies) {
        if (userGroup == null) {
            return null;
        }
        Set policies = accessPolicies.stream().map(summaryEntity -> {
            AccessPolicyDTO policy = new AccessPolicyDTO();
            policy.setId(summaryEntity.getId());
            if (summaryEntity.getPermissions().getCanRead().booleanValue()) {
                AccessPolicySummaryDTO summary = summaryEntity.getComponent();
                policy.setResource(summary.getResource());
                policy.setAction(summary.getAction());
                policy.setConfigurable(summary.getConfigurable());
                policy.setComponentReference(summary.getComponentReference());
            }
            return this.entityFactory.createAccessPolicyEntity(policy, summaryEntity.getRevision(), summaryEntity.getPermissions());
        }).collect(Collectors.toSet());
        UserGroupDTO dto = new UserGroupDTO();
        dto.setId(userGroup.getIdentifier());
        dto.setUsers(users);
        dto.setIdentity(userGroup.getName());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable((Authorizer)this.authorizer, (Group)userGroup)));
        dto.setAccessPolicies(policies);
        return dto;
    }

    public TenantDTO createTenantDTO(Group userGroup) {
        if (userGroup == null) {
            return null;
        }
        TenantDTO dto = new TenantDTO();
        dto.setId(userGroup.getIdentifier());
        dto.setIdentity(userGroup.getName());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable((Authorizer)this.authorizer, (Group)userGroup)));
        return dto;
    }

    public FunnelDTO createFunnelDto(Funnel funnel) {
        if (funnel == null) {
            return null;
        }
        FunnelDTO dto = new FunnelDTO();
        dto.setId(funnel.getIdentifier());
        dto.setPosition(this.createPositionDto(funnel.getPosition()));
        dto.setParentGroupId(funnel.getProcessGroup().getIdentifier());
        dto.setVersionedComponentId((String)funnel.getVersionedComponentId().orElse(null));
        return dto;
    }

    public SnippetDTO createSnippetDto(Snippet snippet) {
        SnippetDTO dto = new SnippetDTO();
        dto.setId(snippet.getId());
        dto.setParentGroupId(snippet.getParentGroupId());
        dto.setConnections(this.mapRevisionToDto(snippet.getConnections()));
        dto.setFunnels(this.mapRevisionToDto(snippet.getFunnels()));
        dto.setInputPorts(this.mapRevisionToDto(snippet.getInputPorts()));
        dto.setLabels(this.mapRevisionToDto(snippet.getLabels()));
        dto.setOutputPorts(this.mapRevisionToDto(snippet.getOutputPorts()));
        dto.setProcessGroups(this.mapRevisionToDto(snippet.getProcessGroups()));
        dto.setProcessors(this.mapRevisionToDto(snippet.getProcessors()));
        dto.setRemoteProcessGroups(this.mapRevisionToDto(snippet.getRemoteProcessGroups()));
        return dto;
    }

    private Map<String, RevisionDTO> mapRevisionToDto(Map<String, Revision> revisionMap) {
        HashMap<String, RevisionDTO> dtos = new HashMap<String, RevisionDTO>(revisionMap.size());
        for (Map.Entry<String, Revision> entry : revisionMap.entrySet()) {
            Revision revision = entry.getValue();
            RevisionDTO revisionDto = new RevisionDTO();
            revisionDto.setClientId(revision.getClientId());
            revisionDto.setVersion(revision.getVersion());
            dtos.put(entry.getKey(), revisionDto);
        }
        return dtos;
    }

    public RemoteProcessGroupStatusDTO createRemoteProcessGroupStatusDto(RemoteProcessGroup remoteProcessGroup, RemoteProcessGroupStatus remoteProcessGroupStatus) {
        RemoteProcessGroupStatusDTO dto = new RemoteProcessGroupStatusDTO();
        dto.setId(remoteProcessGroupStatus.getId());
        dto.setGroupId(remoteProcessGroupStatus.getGroupId());
        dto.setTargetUri(remoteProcessGroupStatus.getTargetUri());
        dto.setName(remoteProcessGroupStatus.getName());
        dto.setTransmissionStatus(remoteProcessGroupStatus.getTransmissionStatus().toString());
        dto.setStatsLastRefreshed(new Date());
        dto.setValidationStatus(this.getRemoteProcessGroupValidationStatus(remoteProcessGroup).name());
        RemoteProcessGroupStatusSnapshotDTO snapshot = new RemoteProcessGroupStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(remoteProcessGroupStatus.getId());
        snapshot.setGroupId(remoteProcessGroupStatus.getGroupId());
        snapshot.setName(remoteProcessGroupStatus.getName());
        snapshot.setTargetUri(remoteProcessGroupStatus.getTargetUri());
        snapshot.setTransmissionStatus(remoteProcessGroupStatus.getTransmissionStatus().toString());
        snapshot.setActiveThreadCount(remoteProcessGroupStatus.getActiveThreadCount());
        snapshot.setFlowFilesSent(remoteProcessGroupStatus.getSentCount());
        snapshot.setBytesSent(remoteProcessGroupStatus.getSentContentSize());
        snapshot.setFlowFilesReceived(remoteProcessGroupStatus.getReceivedCount());
        snapshot.setBytesReceived(remoteProcessGroupStatus.getReceivedContentSize());
        StatusMerger.updatePrettyPrintedFields((RemoteProcessGroupStatusSnapshotDTO)snapshot);
        return dto;
    }

    private ValidationStatus getRemoteProcessGroupValidationStatus(RemoteProcessGroup remoteProcessGroup) {
        boolean hasAuthIssue = remoteProcessGroup.getAuthorizationIssue() != null && !remoteProcessGroup.getAuthorizationIssue().isEmpty();
        Collection validationResults = remoteProcessGroup.validate();
        boolean hasValidationIssue = validationResults != null && !validationResults.isEmpty();
        return hasAuthIssue || hasValidationIssue ? ValidationStatus.INVALID : ValidationStatus.VALID;
    }

    public ProcessGroupStatusDTO createConciseProcessGroupStatusDto(ProcessGroupStatus processGroupStatus) {
        ProcessGroupStatusDTO processGroupStatusDto = new ProcessGroupStatusDTO();
        processGroupStatusDto.setId(processGroupStatus.getId());
        processGroupStatusDto.setName(processGroupStatus.getName());
        processGroupStatusDto.setStatsLastRefreshed(new Date());
        ProcessGroupStatusSnapshotDTO snapshot = new ProcessGroupStatusSnapshotDTO();
        processGroupStatusDto.setAggregateSnapshot(snapshot);
        snapshot.setId(processGroupStatus.getId());
        snapshot.setName(processGroupStatus.getName());
        if (processGroupStatus.getVersionedFlowState() != null) {
            snapshot.setVersionedFlowState(processGroupStatus.getVersionedFlowState().name());
        }
        snapshot.setStatelessActiveThreadCount(processGroupStatus.getStatelessActiveThreadCount().intValue());
        snapshot.setFlowFilesQueued(processGroupStatus.getQueuedCount());
        snapshot.setBytesQueued(processGroupStatus.getQueuedContentSize());
        snapshot.setBytesRead(processGroupStatus.getBytesRead());
        snapshot.setBytesWritten(processGroupStatus.getBytesWritten());
        snapshot.setFlowFilesIn(processGroupStatus.getInputCount());
        snapshot.setBytesIn(processGroupStatus.getInputContentSize());
        snapshot.setFlowFilesOut(processGroupStatus.getOutputCount());
        snapshot.setBytesOut(processGroupStatus.getOutputContentSize());
        snapshot.setFlowFilesTransferred(Integer.valueOf(processGroupStatus.getFlowFilesTransferred()));
        snapshot.setBytesTransferred(Long.valueOf(processGroupStatus.getBytesTransferred()));
        snapshot.setFlowFilesSent(Integer.valueOf(processGroupStatus.getFlowFilesSent()));
        snapshot.setBytesSent(Long.valueOf(processGroupStatus.getBytesSent()));
        snapshot.setFlowFilesReceived(Integer.valueOf(processGroupStatus.getFlowFilesReceived()));
        snapshot.setBytesReceived(Long.valueOf(processGroupStatus.getBytesReceived()));
        snapshot.setProcessingNanos(Long.valueOf(processGroupStatus.getProcessingNanos()));
        snapshot.setActiveThreadCount(processGroupStatus.getActiveThreadCount());
        snapshot.setTerminatedThreadCount(processGroupStatus.getTerminatedThreadCount());
        StatusMerger.updatePrettyPrintedFields((ProcessGroupStatusSnapshotDTO)snapshot);
        return processGroupStatusDto;
    }

    public ProcessGroupStatusDTO createProcessGroupStatusDto(ProcessGroup processGroup, ProcessGroupStatus processGroupStatus) {
        ProcessGroupStatusDTO processGroupStatusDto = this.createConciseProcessGroupStatusDto(processGroupStatus);
        ProcessGroupStatusSnapshotDTO snapshot = processGroupStatusDto.getAggregateSnapshot();
        ArrayList<ProcessorStatusSnapshotEntity> processorStatusSnapshotEntities = new ArrayList<ProcessorStatusSnapshotEntity>();
        snapshot.setProcessorStatusSnapshots(processorStatusSnapshotEntities);
        Collection processorStatusCollection = processGroupStatus.getProcessorStatus();
        if (processorStatusCollection != null) {
            for (ProcessorStatus processorStatus : processorStatusCollection) {
                ProcessorStatusDTO processorStatusDto = this.createProcessorStatusDto(processorStatus);
                ProcessorNode processor = processGroup.findProcessor(processorStatusDto.getId());
                PermissionsDTO processorPermissions = this.createPermissionsDto((Authorizable)processor);
                processorStatusSnapshotEntities.add(this.entityFactory.createProcessorStatusSnapshotEntity(processorStatusDto.getAggregateSnapshot(), processorPermissions));
            }
        }
        ArrayList<ConnectionStatusSnapshotEntity> connectionStatusDtoCollection = new ArrayList<ConnectionStatusSnapshotEntity>();
        snapshot.setConnectionStatusSnapshots(connectionStatusDtoCollection);
        Collection connectionStatusCollection = processGroupStatus.getConnectionStatus();
        if (connectionStatusCollection != null) {
            for (ConnectionStatus connectionStatus : connectionStatusCollection) {
                ConnectionStatusDTO connectionStatusDto = this.createConnectionStatusDto(connectionStatus);
                Connection connection = processGroup.findConnection(connectionStatusDto.getId());
                PermissionsDTO connectionPermissions = this.createPermissionsDto((Authorizable)connection);
                connectionStatusDtoCollection.add(this.entityFactory.createConnectionStatusSnapshotEntity(connectionStatusDto.getAggregateSnapshot(), connectionPermissions));
            }
        }
        ArrayList<ProcessGroupStatusSnapshotEntity> childProcessGroupStatusDtoCollection = new ArrayList<ProcessGroupStatusSnapshotEntity>();
        snapshot.setProcessGroupStatusSnapshots(childProcessGroupStatusDtoCollection);
        Collection childProcessGroupStatusCollection = processGroupStatus.getProcessGroupStatus();
        if (childProcessGroupStatusCollection != null) {
            for (ProcessGroupStatus childProcessGroupStatus : childProcessGroupStatusCollection) {
                ProcessGroupStatusDTO childProcessGroupStatusDto = this.createProcessGroupStatusDto(processGroup, childProcessGroupStatus);
                ProcessGroup childProcessGroup = processGroup.findProcessGroup(childProcessGroupStatusDto.getId());
                PermissionsDTO childProcessGroupPermissions = this.createPermissionsDto((Authorizable)childProcessGroup);
                childProcessGroupStatusDtoCollection.add(this.entityFactory.createProcessGroupStatusSnapshotEntity(childProcessGroupStatusDto.getAggregateSnapshot(), childProcessGroupPermissions));
            }
        }
        ArrayList<RemoteProcessGroupStatusSnapshotEntity> childRemoteProcessGroupStatusDtoCollection = new ArrayList<RemoteProcessGroupStatusSnapshotEntity>();
        snapshot.setRemoteProcessGroupStatusSnapshots(childRemoteProcessGroupStatusDtoCollection);
        Collection childRemoteProcessGroupStatusCollection = processGroupStatus.getRemoteProcessGroupStatus();
        if (childRemoteProcessGroupStatusCollection != null) {
            for (RemoteProcessGroupStatus childRemoteProcessGroupStatus : childRemoteProcessGroupStatusCollection) {
                RemoteProcessGroup remoteProcessGroup = processGroup.findRemoteProcessGroup(childRemoteProcessGroupStatus.getId());
                RemoteProcessGroupStatusDTO childRemoteProcessGroupStatusDto = this.createRemoteProcessGroupStatusDto(remoteProcessGroup, childRemoteProcessGroupStatus);
                PermissionsDTO remoteProcessGroupPermissions = this.createPermissionsDto((Authorizable)remoteProcessGroup);
                childRemoteProcessGroupStatusDtoCollection.add(this.entityFactory.createRemoteProcessGroupStatusSnapshotEntity(childRemoteProcessGroupStatusDto.getAggregateSnapshot(), remoteProcessGroupPermissions));
            }
        }
        ArrayList<PortStatusSnapshotEntity> inputPortStatusDtoCollection = new ArrayList<PortStatusSnapshotEntity>();
        snapshot.setInputPortStatusSnapshots(inputPortStatusDtoCollection);
        Collection inputPortStatusCollection = processGroupStatus.getInputPortStatus();
        if (inputPortStatusCollection != null) {
            for (PortStatus portStatus : inputPortStatusCollection) {
                PortStatusDTO portStatusDto = this.createPortStatusDto(portStatus);
                Port inputPort = processGroup.findInputPort(portStatus.getId());
                PermissionsDTO inputPortPermissions = this.createPermissionsDto((Authorizable)inputPort);
                inputPortStatusDtoCollection.add(this.entityFactory.createPortStatusSnapshotEntity(portStatusDto.getAggregateSnapshot(), inputPortPermissions));
            }
        }
        ArrayList<PortStatusSnapshotEntity> outputPortStatusDtoCollection = new ArrayList<PortStatusSnapshotEntity>();
        snapshot.setOutputPortStatusSnapshots(outputPortStatusDtoCollection);
        Collection outputPortStatusCollection = processGroupStatus.getOutputPortStatus();
        if (outputPortStatusCollection != null) {
            for (PortStatus portStatus : outputPortStatusCollection) {
                PortStatusDTO portStatusDto = this.createPortStatusDto(portStatus);
                Port outputPort = processGroup.findOutputPort(portStatus.getId());
                PermissionsDTO outputPortPermissions = this.createPermissionsDto((Authorizable)outputPort);
                outputPortStatusDtoCollection.add(this.entityFactory.createPortStatusSnapshotEntity(portStatusDto.getAggregateSnapshot(), outputPortPermissions));
            }
        }
        return processGroupStatusDto;
    }

    public ConnectionStatusDTO createConnectionStatusDto(ConnectionStatus connectionStatus) {
        ConnectionStatusDTO connectionStatusDto = new ConnectionStatusDTO();
        connectionStatusDto.setGroupId(connectionStatus.getGroupId());
        connectionStatusDto.setId(connectionStatus.getId());
        connectionStatusDto.setName(connectionStatus.getName());
        connectionStatusDto.setSourceId(connectionStatus.getSourceId());
        connectionStatusDto.setSourceName(connectionStatus.getSourceName());
        connectionStatusDto.setDestinationId(connectionStatus.getDestinationId());
        connectionStatusDto.setDestinationName(connectionStatus.getDestinationName());
        connectionStatusDto.setStatsLastRefreshed(new Date());
        ConnectionStatusSnapshotDTO snapshot = new ConnectionStatusSnapshotDTO();
        connectionStatusDto.setAggregateSnapshot(snapshot);
        snapshot.setId(connectionStatus.getId());
        snapshot.setGroupId(connectionStatus.getGroupId());
        snapshot.setName(connectionStatus.getName());
        snapshot.setSourceName(connectionStatus.getSourceName());
        snapshot.setDestinationName(connectionStatus.getDestinationName());
        snapshot.setFlowFilesQueued(Integer.valueOf(connectionStatus.getQueuedCount()));
        snapshot.setBytesQueued(Long.valueOf(connectionStatus.getQueuedBytes()));
        snapshot.setFlowFileAvailability(connectionStatus.getFlowFileAvailability().name());
        snapshot.setFlowFilesIn(Integer.valueOf(connectionStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(connectionStatus.getInputBytes()));
        snapshot.setFlowFilesOut(Integer.valueOf(connectionStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(connectionStatus.getOutputBytes()));
        ConnectionStatusPredictions predictions = connectionStatus.getPredictions();
        ConnectionStatusPredictionsSnapshotDTO predictionsDTO = null;
        if (predictions != null) {
            predictionsDTO = new ConnectionStatusPredictionsSnapshotDTO();
        }
        if (connectionStatus.getBackPressureObjectThreshold() > 0L) {
            snapshot.setPercentUseCount(Integer.valueOf(Math.min(100, StatusMerger.getUtilization((double)connectionStatus.getQueuedCount(), (double)connectionStatus.getBackPressureObjectThreshold()))));
            if (predictionsDTO != null) {
                snapshot.setPredictions(predictionsDTO);
                predictionsDTO.setPredictionIntervalSeconds(Integer.valueOf(Long.valueOf(predictions.getPredictionIntervalMillis() / 1000L).intValue()));
                predictionsDTO.setPredictedMillisUntilCountBackpressure(Long.valueOf(predictions.getPredictedTimeToCountBackpressureMillis()));
                predictionsDTO.setPredictedCountAtNextInterval(Integer.valueOf(predictions.getNextPredictedQueuedCount()));
                predictionsDTO.setPredictedPercentCount(Integer.valueOf(predictions.getPredictedPercentCount()));
                predictionsDTO.setPredictedPercentBytes(Integer.valueOf(predictions.getPredictedPercentBytes()));
                predictionsDTO.setPredictionIntervalSeconds(Integer.valueOf(Long.valueOf(predictions.getPredictionIntervalMillis() / 1000L).intValue()));
            }
        }
        if (connectionStatus.getBackPressureBytesThreshold() > 0L) {
            snapshot.setPercentUseBytes(Integer.valueOf(Math.min(100, StatusMerger.getUtilization((double)connectionStatus.getQueuedBytes(), (double)connectionStatus.getBackPressureBytesThreshold()))));
            if (predictionsDTO != null) {
                snapshot.setPredictions(predictionsDTO);
                predictionsDTO.setPredictionIntervalSeconds(Integer.valueOf(Long.valueOf(predictions.getPredictionIntervalMillis() / 1000L).intValue()));
                predictionsDTO.setPredictedMillisUntilBytesBackpressure(Long.valueOf(predictions.getPredictedTimeToBytesBackpressureMillis()));
                predictionsDTO.setPredictedBytesAtNextInterval(Long.valueOf(predictions.getNextPredictedQueuedBytes()));
                predictionsDTO.setPredictedPercentCount(Integer.valueOf(predictions.getPredictedPercentCount()));
                predictionsDTO.setPredictedPercentBytes(Integer.valueOf(predictions.getPredictedPercentBytes()));
                predictionsDTO.setPredictionIntervalSeconds(Integer.valueOf(Long.valueOf(predictions.getPredictionIntervalMillis() / 1000L).intValue()));
            }
        }
        StatusMerger.updatePrettyPrintedFields((ConnectionStatusSnapshotDTO)snapshot);
        return connectionStatusDto;
    }

    public ConnectionStatisticsDTO createConnectionStatisticsDto(Connection connection, StatusAnalytics statusAnalytics) {
        ConnectionStatisticsDTO connectionStatisticsDTO = new ConnectionStatisticsDTO();
        connectionStatisticsDTO.setId(connection.getIdentifier());
        connectionStatisticsDTO.setStatsLastRefreshed(new Date());
        ConnectionStatisticsSnapshotDTO snapshot = new ConnectionStatisticsSnapshotDTO();
        connectionStatisticsDTO.setAggregateSnapshot(snapshot);
        snapshot.setId(connection.getIdentifier());
        Map predictions = statusAnalytics.getPredictions();
        snapshot.setPredictedMillisUntilBytesBackpressure((Long)predictions.get("timeToBytesBackpressureMillis"));
        snapshot.setPredictedMillisUntilCountBackpressure((Long)predictions.get("timeToCountBackpressureMillis"));
        snapshot.setPredictedBytesAtNextInterval((Long)predictions.get("nextIntervalBytes"));
        snapshot.setPredictedCountAtNextInterval(Integer.valueOf(((Long)predictions.get("nextIntervalCount")).intValue()));
        snapshot.setPredictedPercentBytes(Integer.valueOf(((Long)predictions.get("nextIntervalPercentageUseBytes")).intValue()));
        snapshot.setPredictedPercentCount(Integer.valueOf(((Long)predictions.get("nextIntervalPercentageUseCount")).intValue()));
        snapshot.setPredictionIntervalMillis((Long)predictions.get("intervalTimeMillis"));
        return connectionStatisticsDTO;
    }

    public ProcessorStatusDTO createProcessorStatusDto(ProcessorStatus procStatus) {
        ProcessorStatusDTO dto = new ProcessorStatusDTO();
        dto.setId(procStatus.getId());
        dto.setGroupId(procStatus.getGroupId());
        dto.setName(procStatus.getName());
        dto.setStatsLastRefreshed(new Date());
        dto.setRunStatus(procStatus.getRunStatus().toString());
        ProcessorStatusSnapshotDTO snapshot = new ProcessorStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(procStatus.getId());
        snapshot.setGroupId(procStatus.getGroupId());
        snapshot.setName(procStatus.getName());
        snapshot.setFlowFilesOut(Integer.valueOf(procStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(procStatus.getOutputBytes()));
        snapshot.setFlowFilesIn(Integer.valueOf(procStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(procStatus.getInputBytes()));
        snapshot.setBytesRead(Long.valueOf(procStatus.getBytesRead()));
        snapshot.setBytesWritten(Long.valueOf(procStatus.getBytesWritten()));
        snapshot.setTaskCount(Integer.valueOf(procStatus.getInvocations()));
        snapshot.setTasksDurationNanos(Long.valueOf(procStatus.getProcessingNanos()));
        snapshot.setTasksDuration(FormatUtils.formatHoursMinutesSeconds((long)procStatus.getProcessingNanos(), (TimeUnit)TimeUnit.NANOSECONDS));
        snapshot.setRunStatus(procStatus.getRunStatus().toString());
        snapshot.setExecutionNode(procStatus.getExecutionNode().toString());
        snapshot.setActiveThreadCount(Integer.valueOf(procStatus.getActiveThreadCount()));
        snapshot.setTerminatedThreadCount(Integer.valueOf(procStatus.getTerminatedThreadCount()));
        snapshot.setType(procStatus.getType());
        StatusMerger.updatePrettyPrintedFields((ProcessorStatusSnapshotDTO)snapshot);
        return dto;
    }

    public ProcessorRunStatusDetailsDTO createProcessorRunStatusDetailsDto(ProcessorNode processor, ProcessorStatus processorStatus) {
        ProcessorRunStatusDetailsDTO dto = new ProcessorRunStatusDetailsDTO();
        dto.setId(processor.getIdentifier());
        dto.setName(processor.getName());
        dto.setActiveThreadCount(processorStatus.getActiveThreadCount());
        dto.setRunStatus(processorStatus.getRunStatus().name());
        dto.setValidationErrors(this.convertValidationErrors(processor.getValidationErrors()));
        return dto;
    }

    private Set<String> convertValidationErrors(Collection<ValidationResult> validationErrors) {
        if (validationErrors == null) {
            return null;
        }
        if (validationErrors.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> errors = new HashSet<String>(validationErrors.size());
        for (ValidationResult result : validationErrors) {
            errors.add(result.toString());
        }
        return errors;
    }

    public PortStatusDTO createPortStatusDto(PortStatus portStatus) {
        PortStatusDTO dto = new PortStatusDTO();
        dto.setId(portStatus.getId());
        dto.setGroupId(portStatus.getGroupId());
        dto.setName(portStatus.getName());
        dto.setRunStatus(portStatus.getRunStatus().toString());
        dto.setTransmitting(portStatus.isTransmitting());
        dto.setStatsLastRefreshed(new Date());
        PortStatusSnapshotDTO snapshot = new PortStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(portStatus.getId());
        snapshot.setGroupId(portStatus.getGroupId());
        snapshot.setName(portStatus.getName());
        snapshot.setRunStatus(portStatus.getRunStatus().toString());
        snapshot.setActiveThreadCount(portStatus.getActiveThreadCount());
        snapshot.setFlowFilesOut(Integer.valueOf(portStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(portStatus.getOutputBytes()));
        snapshot.setFlowFilesIn(Integer.valueOf(portStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(portStatus.getInputBytes()));
        StatusMerger.updatePrettyPrintedFields((PortStatusSnapshotDTO)snapshot);
        return dto;
    }

    public FlowSnippetDTO copySnippetContents(FlowSnippetDTO originalSnippet) {
        FlowSnippetDTO copySnippet = new FlowSnippetDTO();
        if (originalSnippet.getConnections() != null) {
            for (ConnectionDTO connection : originalSnippet.getConnections()) {
                copySnippet.getConnections().add(this.copy(connection));
            }
        }
        if (originalSnippet.getInputPorts() != null) {
            for (PortDTO port : originalSnippet.getInputPorts()) {
                copySnippet.getInputPorts().add(this.copy(port));
            }
        }
        if (originalSnippet.getOutputPorts() != null) {
            for (PortDTO port : originalSnippet.getOutputPorts()) {
                copySnippet.getOutputPorts().add(this.copy(port));
            }
        }
        if (originalSnippet.getProcessGroups() != null) {
            for (ProcessGroupDTO processGroup : originalSnippet.getProcessGroups()) {
                copySnippet.getProcessGroups().add(this.copy(processGroup, true));
            }
        }
        if (originalSnippet.getProcessors() != null) {
            for (ProcessorDTO processor : originalSnippet.getProcessors()) {
                copySnippet.getProcessors().add(this.copy(processor));
            }
        }
        if (originalSnippet.getLabels() != null) {
            for (LabelDTO label : originalSnippet.getLabels()) {
                copySnippet.getLabels().add(this.copy(label));
            }
        }
        if (originalSnippet.getFunnels() != null) {
            for (FunnelDTO funnel : originalSnippet.getFunnels()) {
                copySnippet.getFunnels().add(this.copy(funnel));
            }
        }
        if (originalSnippet.getRemoteProcessGroups() != null) {
            for (RemoteProcessGroupDTO remoteGroup : originalSnippet.getRemoteProcessGroups()) {
                copySnippet.getRemoteProcessGroups().add(this.copy(remoteGroup));
            }
        }
        if (originalSnippet.getControllerServices() != null) {
            for (ControllerServiceDTO controllerService : originalSnippet.getControllerServices()) {
                copySnippet.getControllerServices().add(this.copy(controllerService));
            }
        }
        return copySnippet;
    }

    public PortDTO createPortDto(Port port) {
        Collection validationErrors;
        PublicPort publicPort;
        if (port == null) {
            return null;
        }
        PortDTO dto = new PortDTO();
        dto.setId(port.getIdentifier());
        dto.setPosition(this.createPositionDto(port.getPosition()));
        dto.setName(port.getName());
        dto.setComments(port.getComments());
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(port.getMaxConcurrentTasks()));
        dto.setParentGroupId(port.getProcessGroup().getIdentifier());
        dto.setState(port.getScheduledState().toString());
        dto.setType(port.getConnectableType().name());
        dto.setVersionedComponentId((String)port.getVersionedComponentId().orElse(null));
        dto.setPortFunction(port.getPortFunction().name());
        if (port instanceof PublicPort) {
            publicPort = (PublicPort)port;
            dto.setAllowRemoteAccess(Boolean.valueOf(true));
            dto.setTransmitting(Boolean.valueOf(publicPort.isTransmitting()));
        }
        if (port instanceof PublicPort) {
            publicPort = (PublicPort)port;
            dto.setAllowRemoteAccess(Boolean.valueOf(true));
            dto.setTransmitting(Boolean.valueOf(publicPort.isTransmitting()));
        }
        if ((validationErrors = port.getValidationErrors()) != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public ParameterContextDTO createParameterContextDto(ParameterContext parameterContext, RevisionManager revisionManager, boolean includeInheritedParameters, ParameterContextLookup parameterContextLookup) {
        ParameterContextDTO dto = new ParameterContextDTO();
        dto.setId(parameterContext.getIdentifier());
        dto.setName(parameterContext.getName());
        dto.setDescription(parameterContext.getDescription());
        HashSet<ProcessGroupEntity> boundGroups = new HashSet<ProcessGroupEntity>();
        for (ProcessGroup processGroup : parameterContext.getParameterReferenceManager().getProcessGroupsBound(parameterContext)) {
            ProcessGroupDTO processGroupDto = this.createConciseProcessGroupDto(processGroup);
            RevisionDTO revisionDto = this.createRevisionDTO(revisionManager.getRevision(processGroup.getIdentifier()));
            PermissionsDTO permissionsDto = this.createPermissionsDto((Authorizable)processGroup);
            ProcessGroupEntity processGroupEntity = this.entityFactory.createProcessGroupEntity(processGroupDto, revisionDto, permissionsDto, null, null);
            boundGroups.add(processGroupEntity);
        }
        dto.setBoundProcessGroups(boundGroups);
        LinkedHashSet<ParameterEntity> parameterEntities = new LinkedHashSet<ParameterEntity>();
        Map parameters = includeInheritedParameters ? parameterContext.getEffectiveParameters() : parameterContext.getParameters();
        for (Parameter parameter : parameters.values()) {
            parameterEntities.add(this.createParameterEntity(parameterContext, parameter, revisionManager, parameterContextLookup));
        }
        ArrayList parameterContextRefs = new ArrayList();
        if (parameterContext.getInheritedParameterContexts() != null) {
            parameterContextRefs.addAll(parameterContext.getInheritedParameterContexts().stream().map(pc -> this.entityFactory.createParameterReferenceEntity(this.createParameterContextReference(pc), this.createPermissionsDto((Authorizable)pc))).collect(Collectors.toList()));
        }
        dto.setParameterProviderConfiguration(this.createParameterProviderConfigurationEntity(parameterContext));
        dto.setInheritedParameterContexts(parameterContextRefs);
        dto.setParameters(parameterEntities);
        return dto;
    }

    private ParameterProviderConfigurationEntity createParameterProviderConfigurationEntity(ParameterContext parameterContext) {
        ParameterProvider parameterProvider = parameterContext.getParameterProvider();
        if (parameterProvider == null) {
            return null;
        }
        String parameterProviderId = parameterProvider.getIdentifier();
        ParameterProviderNode parameterProviderNode = parameterContext.getParameterProviderLookup().getParameterProvider(parameterProviderId);
        ParameterProviderConfigurationEntity config = new ParameterProviderConfigurationEntity();
        config.setId(parameterProviderId);
        ParameterProviderConfigurationDTO dto = new ParameterProviderConfigurationDTO();
        config.setComponent(dto);
        dto.setParameterProviderId(parameterProviderId);
        dto.setParameterProviderName(parameterProviderNode.getName());
        dto.setParameterGroupName(parameterContext.getParameterProviderConfiguration().getParameterGroupName());
        dto.setSynchronized(Boolean.valueOf(parameterContext.getParameterProviderConfiguration().isSynchronized()));
        return config;
    }

    public ParameterEntity createParameterEntity(ParameterContext parameterContext, Parameter parameter, RevisionManager revisionManager, ParameterContextLookup parameterContextLookup) {
        ParameterDTO dto = this.createParameterDto(parameterContext, parameter, revisionManager, parameterContextLookup);
        ParameterEntity entity = new ParameterEntity();
        entity.setParameter(dto);
        boolean canWrite = this.isWritable((Collection)dto.getReferencingComponents());
        entity.setCanWrite(Boolean.valueOf(canWrite));
        return entity;
    }

    public ParameterDTO createParameterDto(ParameterContext parameterContext, Parameter parameter, RevisionManager revisionManager, ParameterContextLookup parameterContextLookup) {
        ParameterDescriptor descriptor = parameter.getDescriptor();
        ParameterDTO dto = new ParameterDTO();
        dto.setName(descriptor.getName());
        dto.setDescription(descriptor.getDescription());
        dto.setSensitive(Boolean.valueOf(descriptor.isSensitive()));
        if (parameter.getValue() != null) {
            dto.setValue(descriptor.isSensitive() ? SENSITIVE_VALUE_MASK : parameter.getValue());
        }
        dto.setProvided(Boolean.valueOf(parameter.isProvided()));
        ParameterReferenceManager parameterReferenceManager = parameterContext.getParameterReferenceManager();
        HashSet referencingComponents = new HashSet();
        referencingComponents.addAll(parameterReferenceManager.getProcessorsReferencing(parameterContext, descriptor.getName()));
        referencingComponents.addAll(parameterReferenceManager.getControllerServicesReferencing(parameterContext, descriptor.getName()));
        Set referencingComponentEntities = this.createAffectedComponentEntities(referencingComponents, revisionManager);
        dto.setReferencingComponents(referencingComponentEntities);
        ParameterContext containingParameterContext = parameter.getParameterContextId() == null ? parameterContext : parameterContextLookup.getParameterContext(parameter.getParameterContextId());
        dto.setInherited(Boolean.valueOf(!containingParameterContext.getIdentifier().equals(parameterContext.getIdentifier())));
        ParameterContextReferenceDTO refDto = this.createParameterContextReference(containingParameterContext);
        dto.setParameterContext(this.entityFactory.createParameterReferenceEntity(refDto, this.createPermissionsDto((Authorizable)containingParameterContext)));
        return dto;
    }

    public ReportingTaskDTO createReportingTaskDto(ReportingTaskNode reportingTaskNode) {
        BundleCoordinate bundleCoordinate = reportingTaskNode.getBundleCoordinate();
        List compatibleBundles = this.extensionManager.getBundles(reportingTaskNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        Class reportingTaskClass = reportingTaskNode.getReportingTask().getClass();
        ReportingTaskDTO dto = new ReportingTaskDTO();
        dto.setId(reportingTaskNode.getIdentifier());
        dto.setName(reportingTaskNode.getName());
        dto.setType(reportingTaskNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setSchedulingStrategy(reportingTaskNode.getSchedulingStrategy().name());
        dto.setSchedulingPeriod(reportingTaskNode.getSchedulingPeriod());
        dto.setState(reportingTaskNode.getScheduledState().name());
        dto.setActiveThreadCount(Integer.valueOf(reportingTaskNode.getActiveThreadCount()));
        dto.setAnnotationData(reportingTaskNode.getAnnotationData());
        dto.setComments(reportingTaskNode.getComments());
        dto.setPersistsState(Boolean.valueOf(reportingTaskClass.isAnnotationPresent(Stateful.class)));
        dto.setSupportsSensitiveDynamicProperties(Boolean.valueOf(reportingTaskNode.isSupportsSensitiveDynamicProperties()));
        dto.setRestricted(Boolean.valueOf(reportingTaskNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(reportingTaskNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(reportingTaskNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        HashMap<String, String> defaultSchedulingPeriod = new HashMap<String, String>();
        defaultSchedulingPeriod.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
        defaultSchedulingPeriod.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
        dto.setDefaultSchedulingPeriod(defaultSchedulingPeriod);
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(reportingTaskNode.getRawPropertyValues());
        ReportingTask reportingTask = reportingTaskNode.getReportingTask();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = reportingTask.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, null));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        ValidationStatus validationStatus = reportingTaskNode.getValidationStatus(1L, TimeUnit.MILLISECONDS);
        dto.setValidationStatus(validationStatus.name());
        Collection collection = reportingTaskNode.getValidationErrors();
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : collection) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public ParameterProviderReferencingComponentDTO createParameterProviderReferencingComponentDTO(ParameterContext reference) {
        Objects.requireNonNull(reference, "ParameterContext must be provided in order to create a ParameterProviderReferencingComponentDTO");
        ParameterProviderReferencingComponentDTO dto = new ParameterProviderReferencingComponentDTO();
        dto.setId(reference.getIdentifier());
        dto.setName(reference.getName());
        return dto;
    }

    public ParameterProviderDTO createParameterProviderDto(ParameterProviderNode parameterProviderNode) {
        Collection validationErrors;
        BundleCoordinate bundleCoordinate = parameterProviderNode.getBundleCoordinate();
        List compatibleBundles = this.extensionManager.getBundles(parameterProviderNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        ParameterProviderDTO dto = new ParameterProviderDTO();
        dto.setId(parameterProviderNode.getIdentifier());
        dto.setName(parameterProviderNode.getName());
        dto.setType(parameterProviderNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setAnnotationData(parameterProviderNode.getAnnotationData());
        dto.setComments(parameterProviderNode.getComments());
        dto.setPersistsState(Boolean.valueOf(parameterProviderNode.getParameterProvider().getClass().isAnnotationPresent(Stateful.class)));
        dto.setRestricted(Boolean.valueOf(parameterProviderNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(parameterProviderNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(parameterProviderNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        TreeMap sortedProperties = new TreeMap((o1, o2) -> Collator.getInstance(Locale.US).compare(o1.getName(), o2.getName()));
        sortedProperties.putAll(parameterProviderNode.getRawPropertyValues());
        ParameterProvider parameterProvider = parameterProviderNode.getParameterProvider();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = parameterProvider.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (Object descriptor : descriptors) {
                orderedProperties.put(descriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        Collection parameterGroupConfigurations = parameterProviderNode.getParameterGroupConfigurations();
        dto.setParameterGroupConfigurations(new LinkedHashSet(parameterGroupConfigurations.stream().sorted().map(arg_0 -> this.getParameterGroupConfigurationEntity(arg_0)).collect(Collectors.toList())));
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, null));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        ValidationStatus validationStatus = parameterProviderNode.getValidationStatus(1L, TimeUnit.MILLISECONDS);
        dto.setValidationStatus(validationStatus.name());
        HashSet<ParameterProviderReferencingComponentEntity> hashSet = new HashSet<ParameterProviderReferencingComponentEntity>();
        for (ParameterContext parameterContext : parameterProviderNode.getReferences()) {
            ParameterProviderReferencingComponentDTO referenceDto = this.createParameterProviderReferencingComponentDTO(parameterContext);
            ParameterProviderReferencingComponentEntity referenceEntity = this.entityFactory.createParameterProviderReferencingComponentEntity(parameterContext.getIdentifier(), referenceDto, null, this.createPermissionsDto((Authorizable)parameterContext, NiFiUserUtils.getNiFiUser()), Collections.emptyList());
            hashSet.add(referenceEntity);
        }
        if (!hashSet.isEmpty()) {
            dto.setReferencingParameterContexts(hashSet);
        }
        if ((validationErrors = parameterProviderNode.getValidationErrors()) != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    private ParameterGroupConfigurationEntity getParameterGroupConfigurationEntity(ParameterGroupConfiguration parameterGroupConfiguration) {
        ParameterGroupConfigurationEntity entity = new ParameterGroupConfigurationEntity();
        entity.setGroupName(parameterGroupConfiguration.getGroupName());
        entity.setParameterContextName(parameterGroupConfiguration.getParameterContextName());
        LinkedHashMap parameterSensitivities = new LinkedHashMap();
        parameterGroupConfiguration.getParameterSensitivities().keySet().stream().sorted().forEach(parameterName -> parameterSensitivities.put(parameterName, (ParameterSensitivity)parameterGroupConfiguration.getParameterSensitivities().get(parameterName)));
        entity.setParameterSensitivities(parameterSensitivities);
        entity.setSynchronized(parameterGroupConfiguration.isSynchronized());
        return entity;
    }

    public ControllerServiceDTO createControllerServiceDto(ControllerServiceNode controllerServiceNode) {
        BundleCoordinate bundleCoordinate = controllerServiceNode.getBundleCoordinate();
        List compatibleBundles = this.extensionManager.getBundles(controllerServiceNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        Class controllerServiceClass = controllerServiceNode.getControllerServiceImplementation().getClass();
        ControllerServiceDTO dto = new ControllerServiceDTO();
        dto.setId(controllerServiceNode.getIdentifier());
        dto.setParentGroupId(controllerServiceNode.getProcessGroup() == null ? null : controllerServiceNode.getProcessGroup().getIdentifier());
        dto.setName(controllerServiceNode.getName());
        dto.setType(controllerServiceNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setControllerServiceApis(this.createControllerServiceApiDto(controllerServiceClass));
        dto.setState(controllerServiceNode.getState().name());
        dto.setAnnotationData(controllerServiceNode.getAnnotationData());
        dto.setComments(controllerServiceNode.getComments());
        dto.setBulletinLevel(controllerServiceNode.getBulletinLevel().name());
        dto.setPersistsState(Boolean.valueOf(controllerServiceClass.isAnnotationPresent(Stateful.class)));
        dto.setSupportsSensitiveDynamicProperties(Boolean.valueOf(controllerServiceNode.isSupportsSensitiveDynamicProperties()));
        dto.setRestricted(Boolean.valueOf(controllerServiceNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(controllerServiceNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(controllerServiceNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        dto.setVersionedComponentId((String)controllerServiceNode.getVersionedComponentId().orElse(null));
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(controllerServiceNode.getRawPropertyValues());
        ControllerService controllerService = controllerServiceNode.getControllerServiceImplementation();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = controllerService.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            String groupId = controllerServiceNode.getProcessGroup() == null ? null : controllerServiceNode.getProcessGroup().getIdentifier();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, groupId));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        dto.setValidationStatus(controllerServiceNode.getValidationStatus(1L, TimeUnit.MILLISECONDS).name());
        Collection validationErrors = controllerServiceNode.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                arrayList.add(validationResult.toString());
            }
            dto.setValidationErrors(arrayList);
        }
        return dto;
    }

    public ControllerServiceReferencingComponentDTO createControllerServiceReferencingComponentDTO(ComponentNode component) {
        ControllerServiceReferencingComponentDTO dto = new ControllerServiceReferencingComponentDTO();
        dto.setId(component.getIdentifier());
        dto.setName(component.getName());
        String processGroupId = null;
        List propertyDescriptors = null;
        Collection validationErrors = null;
        if (component instanceof ProcessorNode) {
            node = (ProcessorNode)component;
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setType(node.getComponentType());
            dto.setReferenceType(Processor.class.getSimpleName());
            propertyDescriptors = node.getProcessor().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = node.getProcessGroup().getIdentifier();
        } else if (component instanceof ControllerServiceNode) {
            node = (ControllerServiceNode)component;
            dto.setState(node.getState().name());
            dto.setType(node.getComponentType());
            dto.setReferenceType(ControllerService.class.getSimpleName());
            propertyDescriptors = node.getControllerServiceImplementation().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = node.getProcessGroup() == null ? null : node.getProcessGroup().getIdentifier();
        } else if (component instanceof ReportingTaskNode) {
            node = (ReportingTaskNode)component;
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setType(node.getComponentType());
            dto.setReferenceType(ReportingTask.class.getSimpleName());
            propertyDescriptors = node.getReportingTask().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = null;
        } else if (component instanceof FlowAnalysisRuleNode) {
            node = (FlowAnalysisRuleNode)component;
            dto.setState(node.getState().name());
            dto.setType(node.getComponentType());
            dto.setReferenceType(FlowAnalysisRule.class.getSimpleName());
            propertyDescriptors = node.getFlowAnalysisRule().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = null;
        } else if (component instanceof ParameterProviderNode) {
            node = (ParameterProviderNode)component;
            dto.setType(node.getComponentType());
            dto.setReferenceType(ParameterProvider.class.getSimpleName());
            propertyDescriptors = node.getParameterProvider().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = null;
        } else if (component instanceof FlowRegistryClientNode) {
            node = (FlowRegistryClientNode)component;
            dto.setType(node.getComponentType());
            dto.setReferenceType(FlowRegistryClient.class.getSimpleName());
            propertyDescriptors = node.getComponent().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = null;
        }
        if (propertyDescriptors == null) {
            propertyDescriptors = new ArrayList();
        }
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(component.getRawPropertyValues());
        LinkedHashMap orderedProperties = new LinkedHashMap();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            orderedProperties.put(propertyDescriptor, null);
        }
        orderedProperties.putAll(sortedProperties);
        dto.setGroupId(processGroupId);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, processGroupId));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public RemoteProcessGroupPortDTO createRemoteProcessGroupPortDto(RemoteGroupPort port) {
        if (port == null) {
            return null;
        }
        RemoteProcessGroupPortDTO dto = new RemoteProcessGroupPortDTO();
        dto.setId(port.getIdentifier());
        dto.setGroupId(port.getRemoteProcessGroup().getIdentifier());
        dto.setTargetId(port.getTargetIdentifier());
        dto.setName(port.getName());
        dto.setComments(port.getComments());
        dto.setTransmitting(Boolean.valueOf(port.isRunning()));
        dto.setTargetRunning(Boolean.valueOf(port.isTargetRunning()));
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(port.getMaxConcurrentTasks()));
        dto.setUseCompression(Boolean.valueOf(port.isUseCompression()));
        dto.setExists(Boolean.valueOf(port.getTargetExists()));
        dto.setVersionedComponentId((String)port.getVersionedComponentId().orElse(null));
        BatchSettingsDTO batchDTO = new BatchSettingsDTO();
        batchDTO.setCount(port.getBatchCount());
        batchDTO.setSize(port.getBatchSize());
        batchDTO.setDuration(port.getBatchDuration());
        dto.setBatchSettings(batchDTO);
        if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)port.getConnectableType())) {
            dto.setConnected(Boolean.valueOf(!port.getConnections().isEmpty()));
        } else {
            dto.setConnected(Boolean.valueOf(port.hasIncomingConnection()));
        }
        return dto;
    }

    public RemoteProcessGroupDTO createRemoteProcessGroupDto(RemoteProcessGroup group) {
        Collection validationErrors;
        if (group == null) {
            return null;
        }
        HashSet<RemoteProcessGroupPortDTO> inputPorts = new HashSet<RemoteProcessGroupPortDTO>();
        HashSet<RemoteProcessGroupPortDTO> outputPorts = new HashSet<RemoteProcessGroupPortDTO>();
        int activeRemoteInputPortCount = 0;
        int inactiveRemoteInputPortCount = 0;
        for (Port port : group.getInputPorts()) {
            inputPorts.add(this.createRemoteProcessGroupPortDto((RemoteGroupPort)port));
            if (!port.hasIncomingConnection()) continue;
            if (port.isRunning()) {
                ++activeRemoteInputPortCount;
                continue;
            }
            ++inactiveRemoteInputPortCount;
        }
        int activeRemoteOutputPortCount = 0;
        int inactiveRemoteOutputPortCount = 0;
        for (Port port : group.getOutputPorts()) {
            outputPorts.add(this.createRemoteProcessGroupPortDto((RemoteGroupPort)port));
            if (port.getConnections().isEmpty()) continue;
            if (port.isRunning()) {
                ++activeRemoteOutputPortCount;
                continue;
            }
            ++inactiveRemoteOutputPortCount;
        }
        RemoteProcessGroupContentsDTO contents = new RemoteProcessGroupContentsDTO();
        contents.setInputPorts(inputPorts);
        contents.setOutputPorts(outputPorts);
        RemoteProcessGroupDTO dto = new RemoteProcessGroupDTO();
        dto.setId(group.getIdentifier());
        dto.setName(group.getName());
        dto.setPosition(this.createPositionDto(group.getPosition()));
        dto.setComments(group.getComments());
        dto.setTransmitting(Boolean.valueOf(group.isConfiguredToTransmit()));
        dto.setCommunicationsTimeout(group.getCommunicationsTimeout());
        dto.setYieldDuration(group.getYieldDuration());
        dto.setParentGroupId(group.getProcessGroup().getIdentifier());
        dto.setTargetUris(group.getTargetUris());
        dto.setFlowRefreshed(group.getLastRefreshTime());
        dto.setContents(contents);
        dto.setTransportProtocol(group.getTransportProtocol().name());
        dto.setProxyHost(group.getProxyHost());
        dto.setProxyPort(group.getProxyPort());
        dto.setProxyUser(group.getProxyUser());
        if (!StringUtils.isEmpty((CharSequence)group.getProxyPassword())) {
            dto.setProxyPassword(SENSITIVE_VALUE_MASK);
        }
        if (group.isSiteToSiteEnabled()) {
            dto.setTargetSecure(group.getSecureFlag());
        }
        if (group.getAuthorizationIssue() != null) {
            dto.setAuthorizationIssues(Arrays.asList(group.getAuthorizationIssue()));
        }
        if ((validationErrors = group.validate()) != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        dto.setLocalNetworkInterface(group.getNetworkInterface());
        dto.setActiveRemoteInputPortCount(Integer.valueOf(activeRemoteInputPortCount));
        dto.setInactiveRemoteInputPortCount(Integer.valueOf(inactiveRemoteInputPortCount));
        dto.setActiveRemoteOutputPortCount(Integer.valueOf(activeRemoteOutputPortCount));
        dto.setInactiveRemoteOutputPortCount(Integer.valueOf(inactiveRemoteOutputPortCount));
        dto.setVersionedComponentId((String)group.getVersionedComponentId().orElse(null));
        RemoteProcessGroupCounts counts = group.getCounts();
        if (counts != null) {
            dto.setInputPortCount(Integer.valueOf(counts.getInputPortCount()));
            dto.setOutputPortCount(Integer.valueOf(counts.getOutputPortCount()));
        }
        return dto;
    }

    public FlowBreadcrumbEntity createBreadcrumbEntity(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        FlowBreadcrumbDTO dto = this.createBreadcrumbDto(group);
        PermissionsDTO permissions = this.createPermissionsDto((Authorizable)group);
        FlowBreadcrumbEntity entity = this.entityFactory.createFlowBreadcrumbEntity(dto, permissions);
        if (group.getParent() != null) {
            entity.setParentBreadcrumb(this.createBreadcrumbEntity(group.getParent()));
        }
        return entity;
    }

    private FlowBreadcrumbDTO createBreadcrumbDto(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        FlowBreadcrumbDTO dto = new FlowBreadcrumbDTO();
        dto.setId(group.getIdentifier());
        dto.setName(group.getName());
        VersionControlInformationDTO versionControlInformation = this.createVersionControlInformationDto(group);
        dto.setVersionControlInformation(versionControlInformation);
        return dto;
    }

    public ComponentReferenceDTO createComponentReferenceDto(Authorizable authorizable) {
        if (authorizable == null || !(authorizable instanceof ComponentAuthorizable)) {
            return null;
        }
        ComponentAuthorizable componentAuthorizable = (ComponentAuthorizable)authorizable;
        ComponentReferenceDTO dto = new ComponentReferenceDTO();
        dto.setId(componentAuthorizable.getIdentifier());
        dto.setParentGroupId(componentAuthorizable.getProcessGroupIdentifier());
        dto.setName(authorizable.getResource().getName());
        return dto;
    }

    public AccessPolicySummaryDTO createAccessPolicySummaryDto(AccessPolicy accessPolicy, ComponentReferenceEntity componentReference) {
        if (accessPolicy == null) {
            return null;
        }
        AccessPolicySummaryDTO dto = new AccessPolicySummaryDTO();
        dto.setId(accessPolicy.getIdentifier());
        dto.setResource(accessPolicy.getResource());
        dto.setAction(accessPolicy.getAction().toString());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isAccessPolicyConfigurable((Authorizer)this.authorizer, (AccessPolicy)accessPolicy)));
        dto.setComponentReference(componentReference);
        return dto;
    }

    public AccessPolicyDTO createAccessPolicyDto(AccessPolicy accessPolicy, Set<TenantEntity> userGroups, Set<TenantEntity> users, ComponentReferenceEntity componentReference) {
        if (accessPolicy == null) {
            return null;
        }
        AccessPolicyDTO dto = new AccessPolicyDTO();
        dto.setUserGroups(userGroups);
        dto.setUsers(users);
        dto.setId(accessPolicy.getIdentifier());
        dto.setResource(accessPolicy.getResource());
        dto.setAction(accessPolicy.getAction().toString());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isAccessPolicyConfigurable((Authorizer)this.authorizer, (AccessPolicy)accessPolicy)));
        dto.setComponentReference(componentReference);
        return dto;
    }

    public PermissionsDTO createPermissionsDto(Authorizable authorizable) {
        return this.createPermissionsDto(authorizable, NiFiUserUtils.getNiFiUser());
    }

    public PermissionsDTO createPermissionsDto(Authorizable authorizable, NiFiUser user) {
        PermissionsDTO dto = new PermissionsDTO();
        dto.setCanRead(Boolean.valueOf(authorizable.isAuthorized(this.authorizer, RequestAction.READ, user)));
        dto.setCanWrite(Boolean.valueOf(authorizable.isAuthorized(this.authorizer, RequestAction.WRITE, user)));
        return dto;
    }

    public AffectedComponentEntity createAffectedComponentEntity(ProcessorEntity processorEntity) {
        if (processorEntity == null) {
            return null;
        }
        AffectedComponentEntity component = new AffectedComponentEntity();
        component.setBulletins(processorEntity.getBulletins());
        component.setId(processorEntity.getId());
        component.setPermissions(processorEntity.getPermissions());
        component.setPosition(processorEntity.getPosition());
        component.setRevision(processorEntity.getRevision());
        component.setUri(processorEntity.getUri());
        ProcessorDTO processorDto = processorEntity.getComponent();
        AffectedComponentDTO componentDto = new AffectedComponentDTO();
        if (processorDto == null) {
            componentDto.setId(processorEntity.getId());
            componentDto.setName(processorEntity.getId());
        } else {
            componentDto.setId(processorDto.getId());
            componentDto.setName(processorDto.getName());
            componentDto.setProcessGroupId(processorDto.getParentGroupId());
            componentDto.setReferenceType("PROCESSOR");
            componentDto.setState(processorDto.getState());
            componentDto.setValidationErrors(processorDto.getValidationErrors());
        }
        component.setComponent(componentDto);
        return component;
    }

    public AffectedComponentEntity createAffectedComponentEntity(ProcessGroupEntity groupEntity) {
        if (groupEntity == null) {
            return null;
        }
        AffectedComponentEntity component = new AffectedComponentEntity();
        component.setBulletins(groupEntity.getBulletins());
        component.setId(groupEntity.getId());
        component.setPermissions(groupEntity.getPermissions());
        component.setPosition(groupEntity.getPosition());
        component.setRevision(groupEntity.getRevision());
        component.setUri(groupEntity.getUri());
        component.setReferenceType("STATELESS_GROUP");
        ProcessGroupDTO groupDto = groupEntity.getComponent();
        AffectedComponentDTO componentDto = new AffectedComponentDTO();
        if (groupDto == null) {
            componentDto.setId(groupEntity.getId());
            componentDto.setName(groupEntity.getId());
        } else {
            componentDto.setId(groupDto.getId());
            componentDto.setName(groupDto.getName());
            componentDto.setProcessGroupId(groupDto.getParentGroupId());
            componentDto.setReferenceType("STATELESS_GROUP");
            componentDto.setState(groupDto.getStatelessGroupScheduledState());
            componentDto.setValidationErrors(Collections.emptyList());
        }
        component.setComponent(componentDto);
        return component;
    }

    public AffectedComponentEntity createAffectedComponentEntity(PortEntity portEntity, String referenceType) {
        if (portEntity == null) {
            return null;
        }
        AffectedComponentEntity component = new AffectedComponentEntity();
        component.setBulletins(portEntity.getBulletins());
        component.setId(portEntity.getId());
        component.setPermissions(portEntity.getPermissions());
        component.setPosition(portEntity.getPosition());
        component.setRevision(portEntity.getRevision());
        component.setUri(portEntity.getUri());
        PortDTO portDto = portEntity.getComponent();
        AffectedComponentDTO componentDto = new AffectedComponentDTO();
        if (componentDto == null) {
            componentDto.setId(portEntity.getId());
            componentDto.setName(portEntity.getId());
        } else {
            componentDto.setId(portDto.getId());
            componentDto.setName(portDto.getName());
            componentDto.setProcessGroupId(portDto.getParentGroupId());
            componentDto.setReferenceType(referenceType);
            componentDto.setState(portDto.getState());
            componentDto.setValidationErrors(portDto.getValidationErrors());
        }
        component.setComponent(componentDto);
        return component;
    }

    public AffectedComponentEntity createAffectedComponentEntity(ControllerServiceEntity serviceEntity) {
        if (serviceEntity == null) {
            return null;
        }
        AffectedComponentEntity component = new AffectedComponentEntity();
        component.setBulletins(serviceEntity.getBulletins());
        component.setId(serviceEntity.getId());
        component.setPermissions(serviceEntity.getPermissions());
        component.setPosition(serviceEntity.getPosition());
        component.setRevision(serviceEntity.getRevision());
        component.setUri(serviceEntity.getUri());
        ControllerServiceDTO serviceDto = serviceEntity.getComponent();
        AffectedComponentDTO componentDto = new AffectedComponentDTO();
        if (serviceDto == null) {
            componentDto.setId(serviceEntity.getId());
            componentDto.setName(serviceEntity.getId());
            componentDto.setProcessGroupId(serviceEntity.getParentGroupId());
        } else {
            componentDto.setId(serviceDto.getId());
            componentDto.setName(serviceDto.getName());
            componentDto.setProcessGroupId(serviceDto.getParentGroupId());
            componentDto.setReferenceType("CONTROLLER_SERVICE");
            componentDto.setState(serviceDto.getState());
            componentDto.setValidationErrors(serviceDto.getValidationErrors());
        }
        component.setComponent(componentDto);
        return component;
    }

    public AffectedComponentEntity createAffectedComponentEntity(RemoteProcessGroupPortDTO remotePortDto, String referenceType, RemoteProcessGroupEntity rpgEntity) {
        if (remotePortDto == null) {
            return null;
        }
        AffectedComponentEntity component = new AffectedComponentEntity();
        component.setId(remotePortDto.getId());
        component.setPermissions(rpgEntity.getPermissions());
        component.setRevision(rpgEntity.getRevision());
        component.setUri(rpgEntity.getUri());
        AffectedComponentDTO componentDto = new AffectedComponentDTO();
        componentDto.setId(remotePortDto.getId());
        componentDto.setName(remotePortDto.getName());
        componentDto.setProcessGroupId(remotePortDto.getGroupId());
        componentDto.setReferenceType(referenceType);
        componentDto.setState(remotePortDto.isTransmitting() != false ? "Running" : "Stopped");
        component.setComponent(componentDto);
        return component;
    }

    public AffectedComponentDTO createAffectedComponentDto(ComponentNode component) {
        AffectedComponentDTO dto = new AffectedComponentDTO();
        dto.setId(component.getIdentifier());
        dto.setName(component.getName());
        dto.setProcessGroupId(component.getProcessGroupIdentifier());
        if (component instanceof ProcessorNode) {
            node = (ProcessorNode)component;
            dto.setState(node.getDesiredState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setReferenceType("PROCESSOR");
        } else if (component instanceof ControllerServiceNode) {
            node = (ControllerServiceNode)component;
            dto.setState(node.getState().name());
            dto.setReferenceType("CONTROLLER_SERVICE");
        }
        Collection validationErrors = component.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public ComponentValidationResultDTO createComponentValidationResultDto(ComponentNode component, ValidationState validationResults) {
        ComponentValidationResultDTO dto = new ComponentValidationResultDTO();
        dto.setId(component.getIdentifier());
        dto.setName(component.getName());
        dto.setProcessGroupId(component.getProcessGroupIdentifier());
        if (component instanceof ProcessorNode) {
            node = (ProcessorNode)component;
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setReferenceType("PROCESSOR");
        } else if (component instanceof ControllerServiceNode) {
            node = (ControllerServiceNode)component;
            dto.setState(node.getState().name());
            dto.setReferenceType("CONTROLLER_SERVICE");
        }
        Collection validationErrors = component.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
            dto.setCurrentlyValid(Boolean.valueOf(false));
        } else {
            dto.setCurrentlyValid(Boolean.valueOf(true));
        }
        List resultantValidationErrors = validationResults.getValidationErrors().stream().map(ValidationResult::toString).collect(Collectors.toList());
        dto.setResultantValidationErrors(resultantValidationErrors);
        dto.setResultsValid(Boolean.valueOf(resultantValidationErrors.isEmpty()));
        return dto;
    }

    public ProcessGroupDTO createProcessGroupDto(ProcessGroup group) {
        return this.createProcessGroupDto(group, false);
    }

    public ProcessGroupFlowDTO createProcessGroupFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins, boolean uiOnly) {
        ParameterContext parameterContext;
        ProcessGroupFlowDTO dto = new ProcessGroupFlowDTO();
        dto.setId(group.getIdentifier());
        dto.setLastRefreshed(new Date());
        dto.setBreadcrumb(this.createBreadcrumbEntity(group));
        dto.setFlow(this.createFlowDto(group, groupStatus, revisionManager, getProcessGroupBulletins, uiOnly));
        ProcessGroup parent = group.getParent();
        if (parent != null) {
            dto.setParentGroupId(parent.getIdentifier());
        }
        if ((parameterContext = group.getParameterContext()) != null) {
            dto.setParameterContext(this.entityFactory.createParameterReferenceEntity(this.createParameterContextReference(parameterContext), this.createPermissionsDto((Authorizable)parameterContext)));
        }
        return dto;
    }

    public ParameterContextReferenceDTO createParameterContextReference(ParameterContext parameterContext) {
        if (parameterContext == null) {
            return null;
        }
        ParameterContextReferenceDTO dto = new ParameterContextReferenceDTO();
        dto.setId(parameterContext.getIdentifier());
        dto.setName(parameterContext.getName());
        return dto;
    }

    public FlowDTO createFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, FlowSnippetDTO snippet, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins) {
        List<BulletinEntity> bulletins;
        PortStatusDTO statusDto;
        RevisionDTO revision;
        PortDTO dto;
        PermissionsDTO accessPolicy;
        RevisionDTO revision2;
        ConnectionDTO dto2;
        if (snippet == null) {
            return null;
        }
        FlowDTO flow = new FlowDTO();
        Map<String, ConnectionStatus> connectionStatuses = groupStatus.getConnectionStatus().stream().collect(Collectors.toMap(ConnectionStatus::getId, status -> status));
        for (ConnectionDTO snippetConnection : snippet.getConnections()) {
            Connection connection = group.getConnection(snippetConnection.getId());
            dto2 = this.createConnectionDto(connection);
            revision2 = this.createRevisionDTO(revisionManager.getRevision(connection.getIdentifier()));
            accessPolicy = this.createPermissionsDto((Authorizable)connection);
            ConnectionStatus connectionStatus = connectionStatuses.get(connection.getIdentifier());
            ConnectionStatusDTO statusDto2 = connectionStatus == null ? null : this.createConnectionStatusDto(connectionStatus);
            flow.getConnections().add(this.entityFactory.createConnectionEntity(dto2, revision2, accessPolicy, statusDto2));
        }
        for (Object snippetFunnel : snippet.getFunnels()) {
            Funnel funnel = group.getFunnel(snippetFunnel.getId());
            dto2 = this.createFunnelDto(funnel);
            revision2 = this.createRevisionDTO(revisionManager.getRevision(funnel.getIdentifier()));
            accessPolicy = this.createPermissionsDto((Authorizable)funnel);
            flow.getFunnels().add(this.entityFactory.createFunnelEntity((FunnelDTO)dto2, revision2, accessPolicy));
        }
        Map<String, PortStatus> inputPortStatuses = groupStatus.getInputPortStatus().stream().collect(Collectors.toMap(PortStatus::getId, status -> status));
        for (Object snippetInputPort : snippet.getInputPorts()) {
            Port inputPort = group.getInputPort(snippetInputPort.getId());
            PortDTO dto3 = this.createPortDto(inputPort);
            RevisionDTO revision3 = this.createRevisionDTO(revisionManager.getRevision(inputPort.getIdentifier()));
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)inputPort);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)inputPort));
            PortStatus portStatus = inputPortStatuses.get(inputPort.getIdentifier());
            PortStatusDTO statusDto3 = portStatus == null ? null : this.createPortStatusDto(portStatus);
            List bulletins2 = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPort.getIdentifier()));
            List bulletinEntities = bulletins2.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getInputPorts().add(this.entityFactory.createPortEntity(dto3, revision3, permissions, operatePermissions, statusDto3, bulletinEntities));
        }
        Map<String, PortStatus> outputPortStatuses = groupStatus.getOutputPortStatus().stream().collect(Collectors.toMap(PortStatus::getId, status -> status));
        for (PortDTO snippetOutputPort : snippet.getOutputPorts()) {
            Port outputPort = group.getOutputPort(snippetOutputPort.getId());
            dto = this.createPortDto(outputPort);
            revision = this.createRevisionDTO(revisionManager.getRevision(outputPort.getIdentifier()));
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)outputPort);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)outputPort));
            PortStatus portStatus = outputPortStatuses.get(outputPort.getIdentifier());
            statusDto = portStatus == null ? null : this.createPortStatusDto(portStatus);
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPort.getIdentifier()));
            List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getOutputPorts().add(this.entityFactory.createPortEntity(dto, revision, permissions, operatePermissions, statusDto, bulletinEntities));
        }
        for (Object snippetLabel : snippet.getLabels()) {
            Label label = group.getLabel(snippetLabel.getId());
            dto = this.createLabelDto(label);
            revision = this.createRevisionDTO(revisionManager.getRevision(label.getIdentifier()));
            PermissionsDTO accessPolicy2 = this.createPermissionsDto((Authorizable)label);
            flow.getLabels().add(this.entityFactory.createLabelEntity((LabelDTO)dto, revision, accessPolicy2));
        }
        Map<String, ProcessGroupStatus> groupStatuses = groupStatus.getProcessGroupStatus().stream().collect(Collectors.toMap(ProcessGroupStatus::getId, status -> status));
        for (Object snippetProcessGroup : snippet.getProcessGroups()) {
            ProcessGroup processGroup = group.getProcessGroup(snippetProcessGroup.getId());
            ProcessGroupDTO dto4 = this.createProcessGroupDto(processGroup);
            RevisionDTO revision4 = this.createRevisionDTO(revisionManager.getRevision(processGroup.getIdentifier()));
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)processGroup);
            ProcessGroupStatus childGroupStatus = groupStatuses.get(processGroup.getIdentifier());
            statusDto = childGroupStatus == null ? null : this.createConciseProcessGroupStatusDto(childGroupStatus);
            bulletins = getProcessGroupBulletins.apply(processGroup);
            flow.getProcessGroups().add(this.entityFactory.createProcessGroupEntity(dto4, revision4, permissions, (ProcessGroupStatusDTO)statusDto, bulletins));
        }
        Map<String, ProcessorStatus> processorStatuses = groupStatus.getProcessorStatus().stream().collect(Collectors.toMap(ProcessorStatus::getId, status -> status));
        for (ProcessorDTO snippetProcessor : snippet.getProcessors()) {
            ProcessorNode processor = group.getProcessor(snippetProcessor.getId());
            ProcessorDTO dto5 = this.createProcessorDto(processor);
            RevisionDTO revision5 = this.createRevisionDTO(revisionManager.getRevision(processor.getIdentifier()));
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)processor);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)processor));
            ProcessorStatus processorStatus = processorStatuses.get(processor.getIdentifier());
            ProcessorStatusDTO statusDto4 = processorStatus == null ? null : this.createProcessorStatusDto(processorStatus);
            List bulletins3 = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processor.getIdentifier()));
            List bulletinEntities = bulletins3.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getProcessors().add(this.entityFactory.createProcessorEntity(dto5, revision5, permissions, operatePermissions, statusDto4, bulletinEntities));
        }
        Map<String, RemoteProcessGroupStatus> rpgStatuses = groupStatus.getRemoteProcessGroupStatus().stream().collect(Collectors.toMap(RemoteProcessGroupStatus::getId, status -> status));
        for (RemoteProcessGroupDTO snippetRemoteProcessGroup : snippet.getRemoteProcessGroups()) {
            RemoteProcessGroup remoteProcessGroup = group.getRemoteProcessGroup(snippetRemoteProcessGroup.getId());
            RemoteProcessGroupDTO dto6 = this.createRemoteProcessGroupDto(remoteProcessGroup);
            RevisionDTO revision6 = this.createRevisionDTO(revisionManager.getRevision(remoteProcessGroup.getIdentifier()));
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)remoteProcessGroup);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)remoteProcessGroup));
            RemoteProcessGroupStatus rpgStatus = rpgStatuses.get(remoteProcessGroup.getIdentifier());
            RemoteProcessGroupStatusDTO statusDto5 = rpgStatus == null ? null : this.createRemoteProcessGroupStatusDto(remoteProcessGroup, rpgStatus);
            List bulletins4 = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroup.getIdentifier()));
            List bulletinEntities = bulletins4.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getRemoteProcessGroups().add(this.entityFactory.createRemoteProcessGroupEntity(dto6, revision6, permissions, operatePermissions, statusDto5, bulletinEntities));
        }
        return flow;
    }

    public FlowDTO createFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins, boolean uiOnly) {
        PermissionsDTO permissions;
        RevisionDTO revision;
        ProcessorStatusDTO statusDto;
        FlowDTO dto = new FlowDTO();
        Map<String, ProcessorStatus> processorStatuses = groupStatus.getProcessorStatus().stream().collect(Collectors.toMap(ProcessorStatus::getId, status -> status));
        for (Object procNode : group.getProcessors()) {
            RevisionDTO revision2 = this.createRevisionDTO(revisionManager.getRevision(procNode.getIdentifier()));
            PermissionsDTO permissions2 = this.createPermissionsDto((Authorizable)procNode);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)procNode));
            ProcessorStatus processorStatus = processorStatuses.get(procNode.getIdentifier());
            statusDto = processorStatus == null ? null : this.createProcessorStatusDto(processorStatus);
            List bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(procNode.getIdentifier()));
            List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions2.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getProcessors().add(this.entityFactory.createProcessorEntity(this.createProcessorDto((ProcessorNode)procNode, uiOnly), revision2, permissions2, operatePermissions, statusDto, bulletinEntities));
        }
        Map<String, ConnectionStatus> connectionStatuses = groupStatus.getConnectionStatus().stream().collect(Collectors.toMap(ConnectionStatus::getId, status -> status));
        for (Connection connNode : group.getConnections()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(connNode.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)connNode);
            ConnectionStatus connectionStatus = connectionStatuses.get(connNode.getIdentifier());
            statusDto = connectionStatus == null ? null : this.createConnectionStatusDto(connectionStatus);
            dto.getConnections().add(this.entityFactory.createConnectionEntity(this.createConnectionDto(connNode), revision, permissions, (ConnectionStatusDTO)statusDto));
        }
        for (Label label : group.getLabels()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(label.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)label);
            dto.getLabels().add(this.entityFactory.createLabelEntity(this.createLabelDto(label), revision, permissions));
        }
        for (Object funnel : group.getFunnels()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(funnel.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)funnel);
            dto.getFunnels().add(this.entityFactory.createFunnelEntity(this.createFunnelDto((Funnel)funnel), revision, permissions));
        }
        Map<String, ProcessGroupStatus> groupStatuses = groupStatus.getProcessGroupStatus().stream().collect(Collectors.toMap(ProcessGroupStatus::getId, status -> status));
        for (Object childGroup : group.getProcessGroups()) {
            RevisionDTO revision3 = this.createRevisionDTO(revisionManager.getRevision(childGroup.getIdentifier()));
            PermissionsDTO permissions3 = this.createPermissionsDto((Authorizable)childGroup);
            ProcessGroupStatus childGroupStatus = groupStatuses.get(childGroup.getIdentifier());
            ProcessGroupStatusDTO statusDto2 = childGroupStatus == null ? null : this.createConciseProcessGroupStatusDto(childGroupStatus);
            List<BulletinEntity> bulletins = getProcessGroupBulletins.apply((ProcessGroup)childGroup);
            dto.getProcessGroups().add(this.entityFactory.createProcessGroupEntity(this.createProcessGroupDto((ProcessGroup)childGroup), revision3, permissions3, statusDto2, bulletins));
        }
        Map<String, RemoteProcessGroupStatus> rpgStatuses = groupStatus.getRemoteProcessGroupStatus().stream().collect(Collectors.toMap(RemoteProcessGroupStatus::getId, status -> status));
        for (Object rpg : group.getRemoteProcessGroups()) {
            RevisionDTO revision4 = this.createRevisionDTO(revisionManager.getRevision(rpg.getIdentifier()));
            PermissionsDTO permissions4 = this.createPermissionsDto((Authorizable)rpg);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)rpg));
            RemoteProcessGroupStatus rpgStatus = rpgStatuses.get(rpg.getIdentifier());
            RemoteProcessGroupStatusDTO statusDto3 = rpgStatus == null ? null : this.createRemoteProcessGroupStatusDto((RemoteProcessGroup)rpg, rpgStatus);
            List bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(rpg.getIdentifier()));
            List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions4.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getRemoteProcessGroups().add(this.entityFactory.createRemoteProcessGroupEntity(this.createRemoteProcessGroupDto((RemoteProcessGroup)rpg), revision4, permissions4, operatePermissions, statusDto3, bulletinEntities));
        }
        Map<String, PortStatus> inputPortStatuses = groupStatus.getInputPortStatus().stream().collect(Collectors.toMap(PortStatus::getId, status -> status));
        for (Port inputPort : group.getInputPorts()) {
            RevisionDTO revision5 = this.createRevisionDTO(revisionManager.getRevision(inputPort.getIdentifier()));
            PermissionsDTO permissions5 = this.createPermissionsDto((Authorizable)inputPort);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)inputPort));
            PortStatus portStatus = inputPortStatuses.get(inputPort.getIdentifier());
            PortStatusDTO statusDto4 = portStatus == null ? null : this.createPortStatusDto(portStatus);
            List bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPort.getIdentifier()));
            List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions5.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getInputPorts().add(this.entityFactory.createPortEntity(this.createPortDto(inputPort), revision5, permissions5, operatePermissions, statusDto4, bulletinEntities));
        }
        Map<String, PortStatus> outputPortStatuses = groupStatus.getOutputPortStatus().stream().collect(Collectors.toMap(PortStatus::getId, status -> status));
        for (Port outputPort : group.getOutputPorts()) {
            RevisionDTO revision6 = this.createRevisionDTO(revisionManager.getRevision(outputPort.getIdentifier()));
            PermissionsDTO permissions6 = this.createPermissionsDto((Authorizable)outputPort);
            PermissionsDTO operatePermissions = this.createPermissionsDto((Authorizable)new OperationAuthorizable((Authorizable)outputPort));
            PortStatus portStatus = outputPortStatuses.get(outputPort.getIdentifier());
            PortStatusDTO statusDto5 = portStatus == null ? null : this.createPortStatusDto(portStatus);
            List bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPort.getIdentifier()));
            List bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions6.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getOutputPorts().add(this.entityFactory.createPortEntity(this.createPortDto(outputPort), revision6, permissions6, operatePermissions, statusDto5, bulletinEntities));
        }
        return dto;
    }

    public ProcessGroupDTO createProcessGroupDto(ProcessGroup group, boolean recurse) {
        ProcessGroupDTO dto = this.createConciseProcessGroupDto(group);
        dto.setContents(this.createProcessGroupContentsDto(group, recurse));
        return dto;
    }

    private ProcessGroupDTO createConciseProcessGroupDto(ProcessGroup group) {
        ProcessGroup parentGroup;
        if (group == null) {
            return null;
        }
        ProcessGroupDTO dto = new ProcessGroupDTO();
        dto.setId(group.getIdentifier());
        dto.setPosition(this.createPositionDto(group.getPosition()));
        dto.setComments(group.getComments());
        dto.setName(group.getName());
        dto.setVersionedComponentId((String)group.getVersionedComponentId().orElse(null));
        dto.setVersionControlInformation(this.createVersionControlInformationDto(group));
        dto.setFlowfileConcurrency(group.getFlowFileConcurrency().name());
        dto.setFlowfileOutboundPolicy(group.getFlowFileOutboundPolicy().name());
        dto.setDefaultFlowFileExpiration(group.getDefaultFlowFileExpiration());
        dto.setDefaultBackPressureObjectThreshold(group.getDefaultBackPressureObjectThreshold());
        dto.setDefaultBackPressureDataSizeThreshold(group.getDefaultBackPressureDataSizeThreshold());
        dto.setLogFileSuffix(group.getLogFileSuffix());
        dto.setStatelessGroupScheduledState(group.getStatelessScheduledState().name());
        dto.setExecutionEngine(group.getExecutionEngine().name());
        dto.setMaxConcurrentTasks(Integer.valueOf(group.getMaxConcurrentTasks()));
        dto.setStatelessFlowTimeout(group.getStatelessFlowTimeout());
        ParameterContext parameterContext = group.getParameterContext();
        if (parameterContext != null) {
            dto.setParameterContext(this.entityFactory.createParameterReferenceEntity(this.createParameterContextReference(parameterContext), this.createPermissionsDto((Authorizable)parameterContext)));
        }
        if ((parentGroup = group.getParent()) != null) {
            dto.setParentGroupId(parentGroup.getIdentifier());
        }
        ProcessGroupCounts counts = group.getCounts();
        dto.setRunningCount(Integer.valueOf(counts.getRunningCount()));
        dto.setStoppedCount(Integer.valueOf(counts.getStoppedCount()));
        dto.setInvalidCount(Integer.valueOf(counts.getInvalidCount()));
        dto.setDisabledCount(Integer.valueOf(counts.getDisabledCount()));
        dto.setLocalInputPortCount(Integer.valueOf(counts.getLocalInputPortCount()));
        dto.setLocalOutputPortCount(Integer.valueOf(counts.getLocalOutputPortCount()));
        dto.setPublicInputPortCount(Integer.valueOf(counts.getPublicInputPortCount()));
        dto.setPublicOutputPortCount(Integer.valueOf(counts.getPublicOutputPortCount()));
        dto.setActiveRemotePortCount(Integer.valueOf(counts.getActiveRemotePortCount()));
        dto.setInactiveRemotePortCount(Integer.valueOf(counts.getInactiveRemotePortCount()));
        dto.setUpToDateCount(Integer.valueOf(counts.getUpToDateCount()));
        dto.setLocallyModifiedCount(Integer.valueOf(counts.getLocallyModifiedCount()));
        dto.setStaleCount(Integer.valueOf(counts.getStaleCount()));
        dto.setLocallyModifiedAndStaleCount(Integer.valueOf(counts.getLocallyModifiedAndStaleCount()));
        dto.setSyncFailureCount(Integer.valueOf(counts.getSyncFailureCount()));
        return dto;
    }

    public Set<ComponentDifferenceDTO> createComponentDifferenceDtosForLocalModifications(FlowComparison comparison, VersionedProcessGroup localGroup, FlowManager flowManager) {
        HashMap<ComponentDifferenceDTO, List> differencesByComponent = new HashMap<ComponentDifferenceDTO, List>();
        Map versionedGroups = this.flattenProcessGroups(comparison.getFlowA().getContents());
        for (FlowDifference flowDifference : comparison.getDifferences()) {
            VersionedProcessGroup relevantProcessGroup;
            if (FlowDifferenceFilters.isEnvironmentalChange((FlowDifference)flowDifference, (VersionedProcessGroup)localGroup, (FlowManager)flowManager)) continue;
            VersionedComponent componentA = flowDifference.getComponentA();
            VersionedProcessGroup versionedProcessGroup = relevantProcessGroup = componentA == null ? null : (VersionedProcessGroup)versionedGroups.get(componentA.getGroupIdentifier());
            if (relevantProcessGroup != null && FlowDifferenceFilters.isNewRelationshipAutoTerminatedAndDefaulted((FlowDifference)flowDifference, (VersionedProcessGroup)relevantProcessGroup, (FlowManager)flowManager)) continue;
            ComponentDifferenceDTO componentDiff = this.createComponentDifference(flowDifference);
            List differences = differencesByComponent.computeIfAbsent(componentDiff, key -> new ArrayList());
            DifferenceDTO dto = new DifferenceDTO();
            dto.setDifferenceType(flowDifference.getDifferenceType().getDescription());
            dto.setDifference(flowDifference.getDescription());
            differences.add(dto);
        }
        for (Map.Entry entry : differencesByComponent.entrySet()) {
            ((ComponentDifferenceDTO)entry.getKey()).setDifferences((List)entry.getValue());
        }
        return differencesByComponent.keySet();
    }

    private Map<String, VersionedProcessGroup> flattenProcessGroups(VersionedProcessGroup group) {
        HashMap<String, VersionedProcessGroup> flattened = new HashMap<String, VersionedProcessGroup>();
        this.flattenProcessGroups(group, flattened);
        return flattened;
    }

    private void flattenProcessGroups(VersionedProcessGroup group, Map<String, VersionedProcessGroup> flattened) {
        flattened.put(group.getIdentifier(), group);
        for (VersionedProcessGroup child : group.getProcessGroups()) {
            this.flattenProcessGroups(child, flattened);
        }
    }

    private ComponentDifferenceDTO createComponentDifference(FlowDifference difference) {
        VersionedComponent component = difference.getComponentA();
        if (component == null || difference.getComponentB() instanceof InstantiatedVersionedComponent) {
            component = difference.getComponentB();
        }
        ComponentDifferenceDTO dto = new ComponentDifferenceDTO();
        dto.setComponentName(component.getName());
        dto.setComponentType(component.getComponentType().toString());
        if (component instanceof InstantiatedVersionedComponent) {
            InstantiatedVersionedComponent instantiatedComponent = (InstantiatedVersionedComponent)component;
            dto.setComponentId(instantiatedComponent.getInstanceIdentifier());
            dto.setProcessGroupId(instantiatedComponent.getInstanceGroupId());
        } else {
            dto.setComponentId(component.getIdentifier());
            dto.setProcessGroupId(dto.getProcessGroupId());
        }
        return dto;
    }

    public FlowRegistryBranchDTO createBranchDTO(FlowRegistryBranch branch) {
        FlowRegistryBranchDTO branchDTO = new FlowRegistryBranchDTO();
        branchDTO.setName(branch.getName());
        return branchDTO;
    }

    public VersionControlInformationDTO createVersionControlInformationDto(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        VersionControlInformation versionControlInfo = group.getVersionControlInformation();
        if (versionControlInfo == null) {
            return null;
        }
        VersionControlInformationDTO dto = new VersionControlInformationDTO();
        dto.setGroupId(group.getIdentifier());
        dto.setRegistryId(versionControlInfo.getRegistryIdentifier());
        dto.setRegistryName(versionControlInfo.getRegistryName());
        dto.setBranch(versionControlInfo.getBranch());
        dto.setBucketId(versionControlInfo.getBucketIdentifier());
        dto.setBucketName(versionControlInfo.getBucketName());
        dto.setFlowId(versionControlInfo.getFlowIdentifier());
        dto.setFlowName(versionControlInfo.getFlowName());
        dto.setFlowDescription(versionControlInfo.getFlowDescription());
        dto.setVersion(versionControlInfo.getVersion());
        dto.setStorageLocation(versionControlInfo.getStorageLocation());
        VersionedFlowStatus status = versionControlInfo.getStatus();
        VersionedFlowState state = status.getState();
        dto.setState(state == null ? null : state.name());
        dto.setStateExplanation(status.getStateExplanation());
        return dto;
    }

    public Map<String, String> createVersionControlComponentMappingDto(InstantiatedVersionedProcessGroup group) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put(group.getInstanceIdentifier(), group.getIdentifier());
        group.getProcessors().stream().map(proc -> (InstantiatedVersionedProcessor)proc).forEach(proc -> mapping.put(proc.getInstanceIdentifier(), proc.getIdentifier()));
        group.getFunnels().stream().map(funnel -> (InstantiatedVersionedFunnel)funnel).forEach(funnel -> mapping.put(funnel.getInstanceIdentifier(), funnel.getIdentifier()));
        group.getInputPorts().stream().map(port -> (InstantiatedVersionedPort)port).forEach(port -> mapping.put(port.getInstanceIdentifier(), port.getIdentifier()));
        group.getOutputPorts().stream().map(port -> (InstantiatedVersionedPort)port).forEach(port -> mapping.put(port.getInstanceIdentifier(), port.getIdentifier()));
        group.getControllerServices().stream().map(service -> (InstantiatedVersionedControllerService)service).forEach(service -> mapping.put(service.getInstanceIdentifier(), service.getIdentifier()));
        group.getLabels().stream().map(label -> (InstantiatedVersionedLabel)label).forEach(label -> mapping.put(label.getInstanceIdentifier(), label.getIdentifier()));
        group.getConnections().stream().map(conn -> (InstantiatedVersionedConnection)conn).forEach(conn -> mapping.put(conn.getInstanceIdentifier(), conn.getIdentifier()));
        group.getRemoteProcessGroups().stream().map(rpg -> (InstantiatedVersionedRemoteProcessGroup)rpg).forEach(rpg -> {
            mapping.put(rpg.getInstanceIdentifier(), rpg.getIdentifier());
            if (rpg.getInputPorts() != null) {
                rpg.getInputPorts().stream().map(port -> (InstantiatedVersionedRemoteGroupPort)port).forEach(port -> mapping.put(port.getInstanceIdentifier(), port.getIdentifier()));
            }
            if (rpg.getOutputPorts() != null) {
                rpg.getOutputPorts().stream().map(port -> (InstantiatedVersionedRemoteGroupPort)port).forEach(port -> mapping.put(port.getInstanceIdentifier(), port.getIdentifier()));
            }
        });
        group.getProcessGroups().stream().map(child -> (InstantiatedVersionedProcessGroup)child).forEach(child -> {
            Map childMapping = this.createVersionControlComponentMappingDto(child);
            mapping.putAll(childMapping);
        });
        return mapping;
    }

    private FlowSnippetDTO createProcessGroupContentsDto(ProcessGroup group, boolean recurse) {
        if (group == null) {
            return null;
        }
        FlowSnippetDTO dto = new FlowSnippetDTO();
        for (ProcessorNode procNode : group.getProcessors()) {
            dto.getProcessors().add(this.createProcessorDto(procNode));
        }
        for (Connection connNode : group.getConnections()) {
            dto.getConnections().add(this.createConnectionDto(connNode));
        }
        for (Label label : group.getLabels()) {
            dto.getLabels().add(this.createLabelDto(label));
        }
        for (Funnel funnel : group.getFunnels()) {
            dto.getFunnels().add(this.createFunnelDto(funnel));
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            if (recurse) {
                dto.getProcessGroups().add(this.createProcessGroupDto(childGroup, recurse));
                continue;
            }
            dto.getProcessGroups().add(this.createConciseProcessGroupDto(childGroup));
        }
        for (RemoteProcessGroup remoteProcessGroup : group.getRemoteProcessGroups()) {
            dto.getRemoteProcessGroups().add(this.createRemoteProcessGroupDto(remoteProcessGroup));
        }
        for (Port inputPort : group.getInputPorts()) {
            dto.getInputPorts().add(this.createPortDto(inputPort));
        }
        for (Port outputPort : group.getOutputPorts()) {
            dto.getOutputPorts().add(this.createPortDto(outputPort));
        }
        return dto;
    }

    private boolean isRestricted(Class<?> cls) {
        return cls.isAnnotationPresent(Restricted.class);
    }

    private String getUsageRestriction(Class<?> cls) {
        Restricted restricted = cls.getAnnotation(Restricted.class);
        if (restricted == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)restricted.value())) {
            return null;
        }
        return restricted.value();
    }

    private Set<ExplicitRestrictionDTO> getExplicitRestrictions(Class<?> cls) {
        Restricted restricted = cls.getAnnotation(Restricted.class);
        if (restricted == null) {
            return null;
        }
        Restriction[] restrictions = restricted.restrictions();
        if (restrictions == null || restrictions.length == 0) {
            return null;
        }
        return Arrays.stream(restrictions).map(restriction -> {
            RequiredPermissionDTO requiredPermission = new RequiredPermissionDTO();
            requiredPermission.setId(restriction.requiredPermission().getPermissionIdentifier());
            requiredPermission.setLabel(restriction.requiredPermission().getPermissionLabel());
            ExplicitRestrictionDTO usageRestriction = new ExplicitRestrictionDTO();
            usageRestriction.setRequiredPermission(requiredPermission);
            usageRestriction.setExplanation(restriction.explanation());
            return usageRestriction;
        }).collect(Collectors.toSet());
    }

    private String getDeprecationReason(Class<?> cls) {
        DeprecationNotice deprecationNotice = cls.getAnnotation(DeprecationNotice.class);
        return deprecationNotice == null ? null : deprecationNotice.reason();
    }

    public Set<AffectedComponentEntity> createAffectedComponentEntities(Set<ComponentNode> affectedComponents, RevisionManager revisionManager) {
        return affectedComponents.stream().map(component -> this.createAffectedComponentEntity(component, revisionManager)).collect(Collectors.toSet());
    }

    public AffectedComponentEntity createAffectedComponentEntity(ComponentNode componentNode, RevisionManager revisionManager) {
        boolean authorized;
        AffectedComponentDTO affectedComponent = this.createAffectedComponentDto(componentNode);
        PermissionsDTO permissions = this.createPermissionsDto((Authorizable)componentNode);
        RevisionDTO revision = this.createRevisionDTO(revisionManager.getRevision(componentNode.getIdentifier()));
        ProcessGroupNameDTO groupNameDto = new ProcessGroupNameDTO();
        groupNameDto.setId(componentNode.getProcessGroupIdentifier());
        groupNameDto.setName(componentNode.getProcessGroupIdentifier());
        ProcessGroup processGroup = null;
        if (componentNode instanceof ProcessorNode) {
            processGroup = ((ProcessorNode)componentNode).getProcessGroup();
        } else if (componentNode instanceof ControllerServiceNode) {
            processGroup = ((ControllerServiceNode)componentNode).getProcessGroup();
        }
        if (processGroup != null && (authorized = processGroup.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser()))) {
            groupNameDto.setName(processGroup.getName());
        }
        List bulletins = this.createBulletins(componentNode);
        return this.entityFactory.createAffectedComponentEntity(affectedComponent, revision, permissions, groupNameDto, bulletins);
    }

    private List<BulletinDTO> createBulletins(ComponentNode componentNode) {
        List bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(componentNode.getIdentifier(), componentNode.getProcessGroupIdentifier()));
        return bulletins;
    }

    private boolean isWritable(Collection<AffectedComponentEntity> affectedComponentEntities) {
        for (AffectedComponentEntity affectedComponent : affectedComponentEntities) {
            PermissionsDTO permissions = affectedComponent.getPermissions();
            if (permissions.getCanRead().booleanValue() && permissions.getCanWrite().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private String getCapabilityDescription(Class<?> cls) {
        CapabilityDescription capabilityDesc = cls.getAnnotation(CapabilityDescription.class);
        return capabilityDesc == null ? null : capabilityDesc.value();
    }

    private Set<String> getTags(Class<?> cls) {
        HashSet<String> tags = new HashSet<String>();
        Tags tagsAnnotation = cls.getAnnotation(Tags.class);
        if (tagsAnnotation != null) {
            for (String tag : tagsAnnotation.value()) {
                tags.add(tag);
            }
        }
        if (cls.isAnnotationPresent(Restricted.class)) {
            tags.add("restricted");
        }
        return tags;
    }

    public BundleDTO createBundleDto(BundleCoordinate coordinate) {
        BundleDTO dto = new BundleDTO();
        dto.setGroup(coordinate.getGroup());
        dto.setArtifact(coordinate.getId());
        dto.setVersion(coordinate.getVersion());
        return dto;
    }

    private List<ControllerServiceApiDTO> createControllerServiceApiDto(Class cls) {
        HashSet<Class> serviceApis = new HashSet<Class>();
        if (ControllerService.class.isAssignableFrom(cls)) {
            List interfaces = ClassUtils.getAllInterfaces((Class)cls);
            for (Class i : interfaces) {
                if (!ControllerService.class.isAssignableFrom(i) || ControllerService.class.equals((Object)i)) continue;
                serviceApis.add(i);
            }
            ArrayList<ControllerServiceApiDTO> dtos = new ArrayList<ControllerServiceApiDTO>();
            for (Class serviceApi : serviceApis) {
                Bundle bundle = this.extensionManager.getBundle(serviceApi.getClassLoader());
                BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
                ControllerServiceApiDTO dto = new ControllerServiceApiDTO();
                dto.setType(serviceApi.getName());
                dto.setBundle(this.createBundleDto(bundleCoordinate));
                dtos.add(dto);
            }
            return dtos;
        }
        return null;
    }

    public Set<DocumentedTypeDTO> fromDocumentedTypes(Map<Class, Bundle> classes, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        LinkedHashSet<DocumentedTypeDTO> types = new LinkedHashSet<DocumentedTypeDTO>();
        ArrayList<Class> sortedClasses = new ArrayList<Class>(classes.keySet());
        Collections.sort(sortedClasses, CLASS_NAME_COMPARATOR);
        for (Class cls : sortedClasses) {
            Bundle bundle = classes.get(cls);
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            if (PythonBundle.isPythonCoordinate((BundleCoordinate)coordinate) || bundleGroupFilter != null && !bundleGroupFilter.equals(coordinate.getGroup()) || bundleArtifactFilter != null && !bundleArtifactFilter.equals(coordinate.getId()) || typeFilter != null && !typeFilter.equals(cls.getName())) continue;
            DocumentedTypeDTO dto = new DocumentedTypeDTO();
            dto.setType(cls.getName());
            dto.setBundle(this.createBundleDto(coordinate));
            dto.setControllerServiceApis(this.createControllerServiceApiDto(cls));
            dto.setDescription(this.getCapabilityDescription(cls));
            dto.setRestricted(this.isRestricted(cls));
            dto.setUsageRestriction(this.getUsageRestriction(cls));
            dto.setExplicitRestrictions(this.getExplicitRestrictions(cls));
            dto.setDeprecationReason(this.getDeprecationReason(cls));
            dto.setTags(this.getTags(cls));
            types.add(dto);
        }
        return types;
    }

    private Optional<DocumentedTypeDTO> createDocumentedTypeFromPythonExtension(ExtensionDefinition extensionDefinition, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        BundleCoordinate coordinate = extensionDefinition.getBundle().getBundleDetails().getCoordinate();
        if (bundleGroupFilter != null && !bundleGroupFilter.equals(coordinate.getGroup())) {
            return Optional.empty();
        }
        if (bundleArtifactFilter != null && !bundleArtifactFilter.equals(coordinate.getId())) {
            return Optional.empty();
        }
        if (typeFilter != null && !typeFilter.equals(extensionDefinition.getImplementationClassName())) {
            return Optional.empty();
        }
        DocumentedTypeDTO dto = new DocumentedTypeDTO();
        dto.setType(extensionDefinition.getImplementationClassName());
        BundleDTO bundleDto = new BundleDTO();
        bundleDto.setGroup(coordinate.getGroup());
        bundleDto.setArtifact(coordinate.getId());
        bundleDto.setVersion(extensionDefinition.getVersion());
        dto.setBundle(bundleDto);
        dto.setControllerServiceApis(Collections.emptyList());
        dto.setDescription(extensionDefinition.getDescription());
        dto.setRestricted(false);
        dto.setUsageRestriction(null);
        dto.setExplicitRestrictions(Collections.emptySet());
        dto.setDeprecationReason(null);
        List specified = extensionDefinition.getTags();
        HashSet<String> tags = new HashSet<String>(Arrays.asList("python", "beta", "test"));
        if (specified != null) {
            tags.addAll(specified);
        }
        dto.setTags(tags);
        return Optional.of(dto);
    }

    public Set<DocumentedTypeDTO> fromDocumentedTypes(Set<ExtensionDefinition> extensionDefinitions, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        HashMap<Class, Bundle> classBundles = new HashMap<Class, Bundle>();
        HashSet<ExtensionDefinition> pythonExtensionDefinitions = new HashSet<ExtensionDefinition>();
        for (ExtensionDefinition extensionDefinition : extensionDefinitions) {
            if (PythonBundle.isPythonCoordinate((BundleCoordinate)extensionDefinition.getBundle().getBundleDetails().getCoordinate())) {
                pythonExtensionDefinitions.add(extensionDefinition);
                continue;
            }
            Class cls = this.extensionManager.getClass(extensionDefinition);
            classBundles.put(cls, extensionDefinition.getBundle());
        }
        Set documentedTypes = this.fromDocumentedTypes(classBundles, bundleGroupFilter, bundleArtifactFilter, typeFilter);
        for (ExtensionDefinition extensionDefinition : pythonExtensionDefinitions) {
            Optional optionalDto = this.createDocumentedTypeFromPythonExtension(extensionDefinition, bundleGroupFilter, bundleArtifactFilter, typeFilter);
            optionalDto.ifPresent(documentedTypes::add);
        }
        return documentedTypes;
    }

    public ProcessorDTO createProcessorDto(ProcessorNode node) {
        return this.createProcessorDto(node, false);
    }

    private ProcessorDTO createProcessorDto(ProcessorNode node, boolean uiOnly) {
        if (node == null) {
            return null;
        }
        BundleCoordinate bundleCoordinate = node.getBundleCoordinate();
        List availableBundles = this.extensionManager.getBundles(node.getCanonicalClassName());
        int compatibleBundleCount = 0;
        for (Bundle bundle : availableBundles) {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            boolean compatible = bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
            if (!compatible) continue;
            ++compatibleBundleCount;
        }
        Class processorClass = node.getProcessor().getClass();
        ProcessorDTO dto = new ProcessorDTO();
        dto.setId(node.getIdentifier());
        dto.setPosition(this.createPositionDto(node.getPosition()));
        dto.setStyle(node.getStyle());
        dto.setParentGroupId(node.getProcessGroup().getIdentifier());
        dto.setInputRequirement(node.getInputRequirement().name());
        dto.setPersistsState(Boolean.valueOf(processorClass.isAnnotationPresent(Stateful.class)));
        dto.setSupportsSensitiveDynamicProperties(Boolean.valueOf(node.isSupportsSensitiveDynamicProperties()));
        dto.setRestricted(Boolean.valueOf(node.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(node.isDeprecated()));
        dto.setExecutionNodeRestricted(Boolean.valueOf(node.isExecutionNodeRestricted()));
        dto.setExtensionMissing(Boolean.valueOf(node.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundleCount > 1));
        dto.setVersionedComponentId((String)node.getVersionedComponentId().orElse(null));
        dto.setType(node.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setName(node.getName());
        dto.setState(node.getScheduledState().toString());
        ArrayList<RelationshipDTO> relationships = new ArrayList<RelationshipDTO>();
        for (Relationship rel : node.getRelationships()) {
            RelationshipDTO relationshipDTO = new RelationshipDTO();
            relationshipDTO.setDescription(rel.getDescription());
            relationshipDTO.setName(rel.getName());
            relationshipDTO.setAutoTerminate(Boolean.valueOf(node.isAutoTerminated(rel)));
            relationshipDTO.setRetry(Boolean.valueOf(node.isRelationshipRetried(rel)));
            relationships.add(relationshipDTO);
        }
        relationships.sort((Comparator<RelationshipDTO>)new /* Unavailable Anonymous Inner Class!! */);
        dto.setRelationships(relationships);
        dto.setDescription(this.getCapabilityDescription(node.getClass()));
        dto.setSupportsParallelProcessing(Boolean.valueOf(!node.isTriggeredSerially()));
        dto.setSupportsBatching(Boolean.valueOf(node.isSessionBatchingSupported()));
        dto.setConfig(this.createProcessorConfigDto(node, uiOnly));
        ValidationStatus validationStatus = node.getValidationStatus();
        dto.setValidationStatus(validationStatus.name());
        Collection validationErrors = node.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public BulletinBoardDTO createBulletinBoardDto(List<BulletinEntity> bulletins) {
        Collections.sort(bulletins, new /* Unavailable Anonymous Inner Class!! */);
        BulletinBoardDTO bulletinBoard = new BulletinBoardDTO();
        bulletinBoard.setBulletins(bulletins);
        bulletinBoard.setGenerated(new Date());
        return bulletinBoard;
    }

    public List<BulletinDTO> createBulletinDtos(List<Bulletin> bulletins) {
        ArrayList<BulletinDTO> bulletinDtos = new ArrayList<BulletinDTO>(bulletins.size());
        for (Bulletin bulletin : bulletins) {
            bulletinDtos.add(this.createBulletinDto(bulletin));
        }
        return bulletinDtos;
    }

    public BulletinDTO createBulletinDto(Bulletin bulletin) {
        BulletinDTO dto = new BulletinDTO();
        dto.setId(Long.valueOf(bulletin.getId()));
        dto.setNodeAddress(bulletin.getNodeAddress());
        dto.setTimestamp(bulletin.getTimestamp());
        dto.setGroupId(bulletin.getGroupId());
        dto.setSourceId(bulletin.getSourceId());
        dto.setSourceName(bulletin.getSourceName());
        dto.setCategory(bulletin.getCategory());
        dto.setLevel(bulletin.getLevel());
        dto.setMessage(bulletin.getMessage());
        dto.setSourceType(bulletin.getSourceType().name());
        return dto;
    }

    public ProvenanceNodeDTO createProvenanceEventNodeDTO(ProvenanceEventLineageNode node) {
        ProvenanceNodeDTO dto = new ProvenanceNodeDTO();
        dto.setId(node.getIdentifier());
        dto.setType("EVENT");
        dto.setEventType(node.getEventType().toString());
        dto.setTimestamp(new Date(node.getTimestamp()));
        dto.setMillis(Long.valueOf(node.getTimestamp()));
        dto.setFlowFileUuid(node.getFlowFileUuid());
        dto.setParentUuids(node.getParentUuids());
        dto.setChildUuids(node.getChildUuids());
        return dto;
    }

    public ProvenanceNodeDTO createFlowFileNodeDTO(LineageNode node) {
        ProvenanceNodeDTO dto = new ProvenanceNodeDTO();
        dto.setId(node.getIdentifier());
        dto.setType("FLOWFILE");
        dto.setTimestamp(new Date(node.getTimestamp()));
        dto.setMillis(Long.valueOf(node.getTimestamp()));
        dto.setFlowFileUuid(node.getFlowFileUuid());
        return dto;
    }

    public ProvenanceLinkDTO createProvenanceLinkDTO(LineageEdge edge) {
        LineageNode source = edge.getSource();
        LineageNode target = edge.getDestination();
        ProvenanceLinkDTO dto = new ProvenanceLinkDTO();
        dto.setTimestamp(new Date(target.getTimestamp()));
        dto.setMillis(Long.valueOf(target.getTimestamp()));
        dto.setFlowFileUuid(edge.getUuid());
        dto.setSourceId(source.getIdentifier());
        dto.setTargetId(target.getIdentifier());
        return dto;
    }

    public LineageDTO createLineageDto(ComputeLineageSubmission computeLineageSubmission) {
        LineageDTO dto = new LineageDTO();
        LineageRequestDTO requestDto = new LineageRequestDTO();
        LineageResultsDTO resultsDto = new LineageResultsDTO();
        dto.setRequest(requestDto);
        dto.setResults(resultsDto);
        switch (8.$SwitchMap$org$apache$nifi$provenance$lineage$LineageComputationType[computeLineageSubmission.getLineageComputationType().ordinal()]) {
            case 1: {
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.CHILDREN);
                break;
            }
            case 2: {
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.PARENTS);
                break;
            }
            case 3: {
                Collection uuids = computeLineageSubmission.getLineageFlowFileUuids();
                if (uuids.size() == 1) {
                    requestDto.setUuid((String)uuids.iterator().next());
                }
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.FLOWFILE);
            }
        }
        dto.setId(computeLineageSubmission.getLineageIdentifier());
        dto.setSubmissionTime(computeLineageSubmission.getSubmissionTime());
        ComputeLineageResult results = computeLineageSubmission.getResult();
        dto.setFinished(Boolean.valueOf(results.isFinished()));
        dto.setPercentCompleted(Integer.valueOf(results.getPercentComplete()));
        dto.setExpiration(results.getExpiration());
        List nodes = results.getNodes();
        List edges = results.getEdges();
        ArrayList<ProvenanceNodeDTO> nodeDtos = new ArrayList<ProvenanceNodeDTO>();
        if (results.isFinished()) {
            for (LineageNode node : nodes) {
                switch (8.$SwitchMap$org$apache$nifi$provenance$lineage$LineageNodeType[node.getNodeType().ordinal()]) {
                    case 1: {
                        nodeDtos.add(this.createFlowFileNodeDTO(node));
                        break;
                    }
                    case 2: {
                        nodeDtos.add(this.createProvenanceEventNodeDTO((ProvenanceEventLineageNode)node));
                    }
                }
            }
        }
        resultsDto.setNodes(nodeDtos);
        if (results.getError() != null) {
            HashSet<String> errors = new HashSet<String>();
            errors.add(results.getError());
            resultsDto.setErrors(errors);
        }
        ArrayList<ProvenanceLinkDTO> linkDtos = new ArrayList<ProvenanceLinkDTO>();
        for (LineageEdge edge : edges) {
            linkDtos.add(this.createProvenanceLinkDTO(edge));
        }
        resultsDto.setLinks(linkDtos);
        return dto;
    }

    public SystemDiagnosticsDTO createSystemDiagnosticsDto(SystemDiagnostics sysDiagnostics, DiagnosticLevel diagnosticLevel) {
        SystemDiagnosticsDTO dto = new SystemDiagnosticsDTO();
        SystemDiagnosticsSnapshotDTO snapshot = new SystemDiagnosticsSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setStatsLastRefreshed(new Date(sysDiagnostics.getCreationTimestamp()));
        snapshot.setAvailableProcessors(Integer.valueOf(sysDiagnostics.getAvailableProcessors()));
        snapshot.setProcessorLoadAverage(sysDiagnostics.getProcessorLoadAverage());
        snapshot.setDaemonThreads(Integer.valueOf(sysDiagnostics.getDaemonThreads()));
        snapshot.setTotalThreads(Integer.valueOf(sysDiagnostics.getTotalThreads()));
        snapshot.setMaxHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getMaxHeap()));
        snapshot.setMaxHeapBytes(Long.valueOf(sysDiagnostics.getMaxHeap()));
        snapshot.setTotalHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getTotalHeap()));
        snapshot.setTotalHeapBytes(Long.valueOf(sysDiagnostics.getTotalHeap()));
        snapshot.setUsedHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getUsedHeap()));
        snapshot.setUsedHeapBytes(Long.valueOf(sysDiagnostics.getUsedHeap()));
        snapshot.setFreeHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getFreeHeap()));
        snapshot.setFreeHeapBytes(Long.valueOf(sysDiagnostics.getFreeHeap()));
        if (sysDiagnostics.getHeapUtilization() != -1) {
            snapshot.setHeapUtilization(FormatUtils.formatUtilization((double)sysDiagnostics.getHeapUtilization()));
        }
        snapshot.setMaxNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getMaxNonHeap()));
        snapshot.setMaxNonHeapBytes(Long.valueOf(sysDiagnostics.getMaxNonHeap()));
        snapshot.setTotalNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getTotalNonHeap()));
        snapshot.setTotalNonHeapBytes(Long.valueOf(sysDiagnostics.getTotalNonHeap()));
        snapshot.setUsedNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getUsedNonHeap()));
        snapshot.setUsedNonHeapBytes(Long.valueOf(sysDiagnostics.getUsedNonHeap()));
        snapshot.setFreeNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getFreeNonHeap()));
        snapshot.setFreeNonHeapBytes(Long.valueOf(sysDiagnostics.getFreeNonHeap()));
        if (sysDiagnostics.getNonHeapUtilization() != -1) {
            snapshot.setNonHeapUtilization(FormatUtils.formatUtilization((double)sysDiagnostics.getNonHeapUtilization()));
        }
        SystemDiagnosticsSnapshotDTO.StorageUsageDTO flowFileRepositoryStorageUsageDto = this.createStorageUsageDTO(null, sysDiagnostics.getFlowFileRepositoryStorageUsage());
        snapshot.setFlowFileRepositoryStorageUsage(flowFileRepositoryStorageUsageDto);
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> contentRepositoryStorageUsageDtos = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO>();
        snapshot.setContentRepositoryStorageUsage(contentRepositoryStorageUsageDtos);
        for (Map.Entry entry : sysDiagnostics.getContentRepositoryStorageUsage().entrySet()) {
            contentRepositoryStorageUsageDtos.add(this.createStorageUsageDTO((String)entry.getKey(), (StorageUsage)entry.getValue()));
        }
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> provenanceRepositoryStorageUsageDtos = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO>();
        snapshot.setProvenanceRepositoryStorageUsage(provenanceRepositoryStorageUsageDtos);
        for (Map.Entry entry : sysDiagnostics.getProvenanceRepositoryStorageUsage().entrySet()) {
            provenanceRepositoryStorageUsageDtos.add(this.createStorageUsageDTO((String)entry.getKey(), (StorageUsage)entry.getValue()));
        }
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO> linkedHashSet = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO>();
        snapshot.setGarbageCollection(linkedHashSet);
        for (Map.Entry entry : sysDiagnostics.getGarbageCollection().entrySet()) {
            linkedHashSet.add(this.createGarbageCollectionDTO((String)entry.getKey(), (GarbageCollection)entry.getValue()));
        }
        SystemDiagnosticsSnapshotDTO.VersionInfoDTO versionInfoDTO = this.createVersionInfoDTO();
        snapshot.setVersionInfo(versionInfoDTO);
        snapshot.setUptime(FormatUtils.formatHoursMinutesSeconds((long)sysDiagnostics.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS));
        if (diagnosticLevel == DiagnosticLevel.VERBOSE) {
            ArrayList<SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO> arrayList = new ArrayList<SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO>();
            Map claimantCounts = sysDiagnostics.getClaimantCounts();
            Set destructableClaims = sysDiagnostics.getDestructableClaims();
            if (destructableClaims == null) {
                destructableClaims = Collections.emptySet();
            }
            if (claimantCounts != null) {
                for (Map.Entry entry : claimantCounts.entrySet()) {
                    ResourceClaim claim = (ResourceClaim)entry.getKey();
                    Integer count = (Integer)entry.getValue();
                    boolean destructable = destructableClaims.contains(claim);
                    SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO resourceClaimDto = this.createResourceClaimDTO(claim, count, destructable);
                    arrayList.add(resourceClaimDto);
                }
            }
            arrayList.sort(Comparator.comparing(SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO::getContainer).thenComparing(SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO::getClaimantCount).reversed());
            snapshot.setResourceClaimDetails(arrayList);
        }
        return dto;
    }

    private SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO createResourceClaimDTO(ResourceClaim claim, Integer count, boolean awaitingDestruction) {
        SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO dto = new SystemDiagnosticsSnapshotDTO.ResourceClaimDetailsDTO();
        dto.setContainer(claim.getContainer());
        dto.setSection(claim.getSection());
        dto.setIdentifier(claim.getId());
        dto.setInUse(Boolean.valueOf(claim.isInUse()));
        dto.setWritable(Boolean.valueOf(claim.isWritable()));
        dto.setClaimantCount(count);
        dto.setAwaitingDestruction(Boolean.valueOf(awaitingDestruction));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.StorageUsageDTO createStorageUsageDTO(String identifier, StorageUsage storageUsage) {
        SystemDiagnosticsSnapshotDTO.StorageUsageDTO dto = new SystemDiagnosticsSnapshotDTO.StorageUsageDTO();
        dto.setIdentifier(identifier);
        dto.setFreeSpace(FormatUtils.formatDataSize((double)storageUsage.getFreeSpace()));
        dto.setTotalSpace(FormatUtils.formatDataSize((double)storageUsage.getTotalSpace()));
        dto.setUsedSpace(FormatUtils.formatDataSize((double)storageUsage.getUsedSpace()));
        dto.setFreeSpaceBytes(Long.valueOf(storageUsage.getFreeSpace()));
        dto.setTotalSpaceBytes(Long.valueOf(storageUsage.getTotalSpace()));
        dto.setUsedSpaceBytes(Long.valueOf(storageUsage.getUsedSpace()));
        dto.setUtilization(FormatUtils.formatUtilization((double)storageUsage.getDiskUtilization()));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO createGarbageCollectionDTO(String name, GarbageCollection garbageCollection) {
        SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO dto = new SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO();
        dto.setName(name);
        dto.setCollectionCount(garbageCollection.getCollectionCount());
        dto.setCollectionTime(FormatUtils.formatHoursMinutesSeconds((long)garbageCollection.getCollectionTime(), (TimeUnit)TimeUnit.MILLISECONDS));
        dto.setCollectionMillis(Long.valueOf(garbageCollection.getCollectionTime()));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.VersionInfoDTO createVersionInfoDTO() {
        SystemDiagnosticsSnapshotDTO.VersionInfoDTO dto = new SystemDiagnosticsSnapshotDTO.VersionInfoDTO();
        dto.setJavaVendor(System.getProperty("java.vendor"));
        dto.setJavaVersion(System.getProperty("java.version"));
        dto.setOsName(System.getProperty("os.name"));
        dto.setOsVersion(System.getProperty("os.version"));
        dto.setOsArchitecture(System.getProperty("os.arch"));
        Bundle frameworkBundle = NarClassLoadersHolder.getInstance().getFrameworkBundle();
        if (frameworkBundle != null) {
            BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
            dto.setNiFiVersion(frameworkDetails.getCoordinate().getVersion());
            dto.setBuildTag(frameworkDetails.getBuildTag());
            dto.setBuildRevision(frameworkDetails.getBuildRevision());
            dto.setBuildBranch(frameworkDetails.getBuildBranch());
            dto.setBuildTimestamp(frameworkDetails.getBuildTimestampDate());
        }
        return dto;
    }

    public ResourceDTO createResourceDto(Resource resource) {
        ResourceDTO dto = new ResourceDTO();
        dto.setIdentifier(resource.getIdentifier());
        dto.setName(resource.getName());
        return dto;
    }

    public ProcessorDiagnosticsDTO createProcessorDiagnosticsDto(ProcessorNode procNode, ProcessorStatus procStatus, BulletinRepository bulletinRepo, FlowController flowController, Function<String, ControllerServiceEntity> serviceEntityFactory) {
        ProcessorDiagnosticsDTO procDiagnostics = new ProcessorDiagnosticsDTO();
        procDiagnostics.setClassLoaderDiagnostics(this.createClassLoaderDiagnosticsDto(procNode));
        procDiagnostics.setIncomingConnections(procNode.getIncomingConnections().stream().map(arg_0 -> this.createConnectionDiagnosticsDto(arg_0)).collect(Collectors.toSet()));
        procDiagnostics.setOutgoingConnections(procNode.getConnections().stream().map(arg_0 -> this.createConnectionDiagnosticsDto(arg_0)).collect(Collectors.toSet()));
        procDiagnostics.setJvmDiagnostics(this.createJvmDiagnosticsDto(flowController));
        procDiagnostics.setProcessor(this.createProcessorDto(procNode));
        procDiagnostics.setProcessorStatus(this.createProcessorStatusDto(procStatus));
        procDiagnostics.setThreadDumps(this.createThreadDumpDtos(procNode));
        Set referencedServiceDiagnostics = this.createReferencedServiceDiagnostics(procNode.getEffectivePropertyValues(), flowController.getControllerServiceProvider(), serviceEntityFactory);
        procDiagnostics.setReferencedControllerServices(referencedServiceDiagnostics);
        return procDiagnostics;
    }

    private Set<ControllerServiceDiagnosticsDTO> createReferencedServiceDiagnostics(Map<PropertyDescriptor, String> properties, ControllerServiceProvider serviceProvider, Function<String, ControllerServiceEntity> serviceEntityFactory) {
        HashSet<ControllerServiceDiagnosticsDTO> referencedServiceDiagnostics = new HashSet<ControllerServiceDiagnosticsDTO>();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            ControllerServiceDiagnosticsDTO serviceDiagnostics;
            ControllerServiceNode serviceNode;
            String serviceId;
            PropertyDescriptor descriptor = entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (serviceId = entry.getValue()) == null || (serviceNode = serviceProvider.getControllerServiceNode(serviceId)) == null || (serviceDiagnostics = this.createControllerServiceDiagnosticsDto(serviceNode, serviceEntityFactory, serviceProvider)) == null) continue;
            referencedServiceDiagnostics.add(serviceDiagnostics);
        }
        return referencedServiceDiagnostics;
    }

    public ControllerServiceDiagnosticsDTO createControllerServiceDiagnosticsDto(ControllerServiceNode serviceNode, Function<String, ControllerServiceEntity> serviceEntityFactory, ControllerServiceProvider serviceProvider) {
        ControllerServiceDiagnosticsDTO serviceDiagnostics = new ControllerServiceDiagnosticsDTO();
        ControllerServiceEntity serviceEntity = serviceEntityFactory.apply(serviceNode.getIdentifier());
        serviceDiagnostics.setControllerService(serviceEntity);
        serviceDiagnostics.setClassLoaderDiagnostics(this.createClassLoaderDiagnosticsDto(serviceNode));
        return serviceDiagnostics;
    }

    private ClassLoaderDiagnosticsDTO createClassLoaderDiagnosticsDto(ControllerServiceNode serviceNode) {
        Object componentClassLoader = this.extensionManager.getInstanceClassLoader(serviceNode.getIdentifier());
        if (componentClassLoader == null) {
            componentClassLoader = serviceNode.getControllerServiceImplementation().getClass().getClassLoader();
        }
        return this.createClassLoaderDiagnosticsDto((ClassLoader)componentClassLoader);
    }

    private ClassLoaderDiagnosticsDTO createClassLoaderDiagnosticsDto(ProcessorNode procNode) {
        Object componentClassLoader = this.extensionManager.getInstanceClassLoader(procNode.getIdentifier());
        if (componentClassLoader == null) {
            componentClassLoader = procNode.getProcessor().getClass().getClassLoader();
        }
        return this.createClassLoaderDiagnosticsDto((ClassLoader)componentClassLoader);
    }

    private ClassLoaderDiagnosticsDTO createClassLoaderDiagnosticsDto(ClassLoader classLoader) {
        ClassLoader parentClassLoader;
        ClassLoaderDiagnosticsDTO dto = new ClassLoaderDiagnosticsDTO();
        Bundle bundle = this.extensionManager.getBundle(classLoader);
        if (bundle != null) {
            dto.setBundle(this.createBundleDto(bundle.getBundleDetails().getCoordinate()));
        }
        if ((parentClassLoader = classLoader.getParent()) != null) {
            dto.setParentClassLoader(this.createClassLoaderDiagnosticsDto(parentClassLoader));
        }
        return dto;
    }

    private ConnectionDiagnosticsDTO createConnectionDiagnosticsDto(Connection connection) {
        ConnectionDiagnosticsDTO dto = new ConnectionDiagnosticsDTO();
        dto.setConnection(this.createConnectionDto(connection));
        dto.setAggregateSnapshot(this.createConnectionDiagnosticsSnapshotDto(connection));
        return dto;
    }

    private ConnectionDiagnosticsSnapshotDTO createConnectionDiagnosticsSnapshotDto(Connection connection) {
        ConnectionDiagnosticsSnapshotDTO dto = new ConnectionDiagnosticsSnapshotDTO();
        QueueDiagnostics queueDiagnostics = connection.getFlowFileQueue().getQueueDiagnostics();
        FlowFileQueue queue = connection.getFlowFileQueue();
        QueueSize totalSize = queue.size();
        dto.setTotalByteCount(totalSize.getByteCount());
        dto.setTotalFlowFileCount(totalSize.getObjectCount());
        LocalQueuePartitionDiagnostics localDiagnostics = queueDiagnostics.getLocalQueuePartitionDiagnostics();
        dto.setLocalQueuePartition(this.createLocalQueuePartitionDto(localDiagnostics));
        List remoteDiagnostics = queueDiagnostics.getRemoteQueuePartitionDiagnostics();
        if (remoteDiagnostics != null) {
            List remoteDiagnosticsDtos = remoteDiagnostics.stream().map(arg_0 -> this.createRemoteQueuePartitionDto(arg_0)).collect(Collectors.toList());
            dto.setRemoteQueuePartitions(remoteDiagnosticsDtos);
        }
        return dto;
    }

    private LocalQueuePartitionDTO createLocalQueuePartitionDto(LocalQueuePartitionDiagnostics queueDiagnostics) {
        LocalQueuePartitionDTO dto = new LocalQueuePartitionDTO();
        QueueSize activeSize = queueDiagnostics.getActiveQueueSize();
        dto.setActiveQueueByteCount(activeSize.getByteCount());
        dto.setActiveQueueFlowFileCount(activeSize.getObjectCount());
        QueueSize inFlightSize = queueDiagnostics.getUnacknowledgedQueueSize();
        dto.setInFlightByteCount(inFlightSize.getByteCount());
        dto.setInFlightFlowFileCount(inFlightSize.getObjectCount());
        QueueSize swapSize = queueDiagnostics.getSwapQueueSize();
        dto.setSwapByteCount(swapSize.getByteCount());
        dto.setSwapFlowFileCount(swapSize.getObjectCount());
        dto.setSwapFiles(queueDiagnostics.getSwapFileCount());
        dto.setTotalByteCount(activeSize.getByteCount() + inFlightSize.getByteCount() + swapSize.getByteCount());
        dto.setTotalFlowFileCount(activeSize.getObjectCount() + inFlightSize.getObjectCount() + swapSize.getObjectCount());
        dto.setAllActiveQueueFlowFilesPenalized(Boolean.valueOf(queueDiagnostics.isAllActiveFlowFilesPenalized()));
        dto.setAnyActiveQueueFlowFilesPenalized(Boolean.valueOf(queueDiagnostics.isAnyActiveFlowFilePenalized()));
        return dto;
    }

    private RemoteQueuePartitionDTO createRemoteQueuePartitionDto(RemoteQueuePartitionDiagnostics queueDiagnostics) {
        RemoteQueuePartitionDTO dto = new RemoteQueuePartitionDTO();
        dto.setNodeIdentifier(queueDiagnostics.getNodeIdentifier());
        QueueSize activeSize = queueDiagnostics.getActiveQueueSize();
        dto.setActiveQueueByteCount(activeSize.getByteCount());
        dto.setActiveQueueFlowFileCount(activeSize.getObjectCount());
        QueueSize inFlightSize = queueDiagnostics.getUnacknowledgedQueueSize();
        dto.setInFlightByteCount(inFlightSize.getByteCount());
        dto.setInFlightFlowFileCount(inFlightSize.getObjectCount());
        QueueSize swapSize = queueDiagnostics.getSwapQueueSize();
        dto.setSwapByteCount(swapSize.getByteCount());
        dto.setSwapFlowFileCount(swapSize.getObjectCount());
        dto.setSwapFiles(queueDiagnostics.getSwapFileCount());
        dto.setTotalByteCount(activeSize.getByteCount() + inFlightSize.getByteCount() + swapSize.getByteCount());
        dto.setTotalFlowFileCount(activeSize.getObjectCount() + inFlightSize.getObjectCount() + swapSize.getObjectCount());
        return dto;
    }

    private JVMDiagnosticsDTO createJvmDiagnosticsDto(FlowController flowController) {
        JVMDiagnosticsDTO dto = new JVMDiagnosticsDTO();
        dto.setAggregateSnapshot(this.createJvmDiagnosticsSnapshotDto(flowController));
        dto.setClustered(Boolean.valueOf(flowController.isClustered()));
        dto.setConnected(Boolean.valueOf(flowController.isConnected()));
        return dto;
    }

    private JVMDiagnosticsSnapshotDTO createJvmDiagnosticsSnapshotDto(FlowController flowController) {
        Object utilization;
        double usedPercentage;
        JVMDiagnosticsSnapshotDTO dto = new JVMDiagnosticsSnapshotDTO();
        JVMControllerDiagnosticsSnapshotDTO controllerDiagnosticsDto = new JVMControllerDiagnosticsSnapshotDTO();
        JVMFlowDiagnosticsSnapshotDTO flowDiagnosticsDto = new JVMFlowDiagnosticsSnapshotDTO();
        JVMSystemDiagnosticsSnapshotDTO systemDiagnosticsDto = new JVMSystemDiagnosticsSnapshotDTO();
        dto.setControllerDiagnostics(controllerDiagnosticsDto);
        dto.setFlowDiagnosticsDto(flowDiagnosticsDto);
        dto.setSystemDiagnosticsDto(systemDiagnosticsDto);
        SystemDiagnostics systemDiagnostics = flowController.getSystemDiagnostics();
        Set bundlesLoaded = this.extensionManager.getAllBundles().stream().map(bundle -> bundle.getBundleDetails().getCoordinate()).sorted((a, b) -> a.getCoordinate().compareTo(b.getCoordinate())).map(arg_0 -> this.createBundleDto(arg_0)).collect(Collectors.toCollection(LinkedHashSet::new));
        flowDiagnosticsDto.setActiveTimerDrivenThreads(Integer.valueOf(flowController.getActiveTimerDrivenThreadCount()));
        flowDiagnosticsDto.setBundlesLoaded(bundlesLoaded);
        flowDiagnosticsDto.setTimeZone(System.getProperty("user.timezone"));
        flowDiagnosticsDto.setUptime(FormatUtils.formatHoursMinutesSeconds((long)systemDiagnostics.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS));
        controllerDiagnosticsDto.setClusterCoordinator(Boolean.valueOf(flowController.isClusterCoordinator()));
        controllerDiagnosticsDto.setPrimaryNode(Boolean.valueOf(flowController.isPrimary()));
        controllerDiagnosticsDto.setMaxTimerDrivenThreads(Integer.valueOf(flowController.getMaxTimerDrivenThreadCount()));
        systemDiagnosticsDto.setMaxOpenFileDescriptors(Long.valueOf(systemDiagnostics.getMaxOpenFileHandles()));
        systemDiagnosticsDto.setOpenFileDescriptors(Long.valueOf(systemDiagnostics.getOpenFileHandles()));
        systemDiagnosticsDto.setPhysicalMemoryBytes(Long.valueOf(systemDiagnostics.getTotalPhysicalMemory()));
        systemDiagnosticsDto.setPhysicalMemory(FormatUtils.formatDataSize((double)systemDiagnostics.getTotalPhysicalMemory()));
        NumberFormat percentageFormat = NumberFormat.getPercentInstance();
        percentageFormat.setMaximumFractionDigits(2);
        HashSet<RepositoryUsageDTO> contentRepoUsage = new HashSet<RepositoryUsageDTO>();
        for (Map.Entry entry : systemDiagnostics.getContentRepositoryStorageUsage().entrySet()) {
            String string = (String)entry.getKey();
            StorageUsage storageUsage = (StorageUsage)entry.getValue();
            RepositoryUsageDTO usageDto = new RepositoryUsageDTO();
            usageDto.setName(string);
            usageDto.setFileStoreHash(DigestUtils.sha256Hex((String)flowController.getContentRepoFileStoreName(string)));
            usageDto.setFreeSpace(FormatUtils.formatDataSize((double)storageUsage.getFreeSpace()));
            usageDto.setFreeSpaceBytes(Long.valueOf(storageUsage.getFreeSpace()));
            usageDto.setTotalSpace(FormatUtils.formatDataSize((double)storageUsage.getTotalSpace()));
            usageDto.setTotalSpaceBytes(Long.valueOf(storageUsage.getTotalSpace()));
            double usedPercentage2 = (double)(storageUsage.getTotalSpace() - storageUsage.getFreeSpace()) / (double)storageUsage.getTotalSpace();
            String utilization2 = percentageFormat.format(usedPercentage2);
            usageDto.setUtilization(utilization2);
            contentRepoUsage.add(usageDto);
        }
        HashSet<RepositoryUsageDTO> provRepoUsage = new HashSet<RepositoryUsageDTO>();
        for (Map.Entry entry : systemDiagnostics.getProvenanceRepositoryStorageUsage().entrySet()) {
            String string = (String)entry.getKey();
            StorageUsage usage = (StorageUsage)entry.getValue();
            RepositoryUsageDTO usageDto = new RepositoryUsageDTO();
            usageDto.setName(string);
            usageDto.setFileStoreHash(DigestUtils.sha256Hex((String)flowController.getProvenanceRepoFileStoreName(string)));
            usageDto.setFreeSpace(FormatUtils.formatDataSize((double)usage.getFreeSpace()));
            usageDto.setFreeSpaceBytes(Long.valueOf(usage.getFreeSpace()));
            usageDto.setTotalSpace(FormatUtils.formatDataSize((double)usage.getTotalSpace()));
            usageDto.setTotalSpaceBytes(Long.valueOf(usage.getTotalSpace()));
            usedPercentage = (double)(usage.getTotalSpace() - usage.getFreeSpace()) / (double)usage.getTotalSpace();
            utilization = percentageFormat.format(usedPercentage);
            usageDto.setUtilization((String)utilization);
            provRepoUsage.add(usageDto);
        }
        RepositoryUsageDTO repositoryUsageDTO = new RepositoryUsageDTO();
        for (Map.Entry entry : systemDiagnostics.getProvenanceRepositoryStorageUsage().entrySet()) {
            String repoName = (String)entry.getKey();
            StorageUsage usage = (StorageUsage)entry.getValue();
            repositoryUsageDTO.setName(repoName);
            repositoryUsageDTO.setFileStoreHash(DigestUtils.sha256Hex((String)flowController.getFlowRepoFileStoreName()));
            repositoryUsageDTO.setFreeSpace(FormatUtils.formatDataSize((double)usage.getFreeSpace()));
            repositoryUsageDTO.setFreeSpaceBytes(Long.valueOf(usage.getFreeSpace()));
            repositoryUsageDTO.setTotalSpace(FormatUtils.formatDataSize((double)usage.getTotalSpace()));
            repositoryUsageDTO.setTotalSpaceBytes(Long.valueOf(usage.getTotalSpace()));
            usedPercentage = (double)(usage.getTotalSpace() - usage.getFreeSpace()) / (double)usage.getTotalSpace();
            utilization = percentageFormat.format(usedPercentage);
            repositoryUsageDTO.setUtilization((String)utilization);
        }
        systemDiagnosticsDto.setContentRepositoryStorageUsage(contentRepoUsage);
        systemDiagnosticsDto.setCpuCores(Integer.valueOf(systemDiagnostics.getAvailableProcessors()));
        systemDiagnosticsDto.setCpuLoadAverage(systemDiagnostics.getProcessorLoadAverage());
        systemDiagnosticsDto.setFlowFileRepositoryStorageUsage(repositoryUsageDTO);
        systemDiagnosticsDto.setMaxHeapBytes(Long.valueOf(systemDiagnostics.getMaxHeap()));
        systemDiagnosticsDto.setMaxHeap(FormatUtils.formatDataSize((double)systemDiagnostics.getMaxHeap()));
        systemDiagnosticsDto.setProvenanceRepositoryStorageUsage(provRepoUsage);
        GarbageCollectionHistory garbageCollectionHistory = flowController.getGarbageCollectionHistory();
        ArrayList<GarbageCollectionDiagnosticsDTO> arrayList = new ArrayList<GarbageCollectionDiagnosticsDTO>();
        for (String memoryManager : garbageCollectionHistory.getMemoryManagerNames()) {
            List statuses = garbageCollectionHistory.getGarbageCollectionStatuses(memoryManager);
            ArrayList<GCDiagnosticsSnapshotDTO> gcSnapshots = new ArrayList<GCDiagnosticsSnapshotDTO>();
            for (GarbageCollectionStatus status : statuses) {
                GCDiagnosticsSnapshotDTO snapshotDto = new GCDiagnosticsSnapshotDTO();
                snapshotDto.setTimestamp(status.getTimestamp());
                snapshotDto.setCollectionCount(Long.valueOf(status.getCollectionCount()));
                snapshotDto.setCollectionMillis(Long.valueOf(status.getCollectionMillis()));
                gcSnapshots.add(snapshotDto);
            }
            gcSnapshots.sort(Comparator.comparing(GCDiagnosticsSnapshotDTO::getTimestamp).reversed());
            GarbageCollectionDiagnosticsDTO gcDto = new GarbageCollectionDiagnosticsDTO();
            gcDto.setMemoryManagerName(memoryManager);
            gcDto.setSnapshots(gcSnapshots);
            arrayList.add(gcDto);
        }
        systemDiagnosticsDto.setGarbageCollectionDiagnostics(arrayList);
        return dto;
    }

    private List<ThreadDumpDTO> createThreadDumpDtos(ProcessorNode procNode) {
        ArrayList<ThreadDumpDTO> threadDumps = new ArrayList<ThreadDumpDTO>();
        List activeThreads = procNode.getActiveThreads(ThreadDetails.capture());
        for (ActiveThreadInfo threadInfo : activeThreads) {
            ThreadDumpDTO dto = new ThreadDumpDTO();
            dto.setStackTrace(threadInfo.getStackTrace());
            dto.setThreadActiveMillis(threadInfo.getActiveMillis());
            dto.setThreadName(threadInfo.getThreadName());
            dto.setTaskTerminated(threadInfo.isTerminated());
            threadDumps.add(dto);
        }
        return threadDumps;
    }

    public ProcessorConfigDTO createProcessorConfigDto(ProcessorNode procNode, boolean uiOnly) {
        if (procNode == null) {
            return null;
        }
        ProcessorConfigDTO dto = new ProcessorConfigDTO();
        Processor processor = procNode.getProcessor();
        if (!uiOnly) {
            TreeMap sortedProperties = new TreeMap((o1, o2) -> Collator.getInstance(Locale.US).compare(o1.getName(), o2.getName()));
            sortedProperties.putAll(procNode.getRawPropertyValues());
            LinkedHashMap orderedProperties = new LinkedHashMap();
            List descriptors = processor.getPropertyDescriptors();
            if (descriptors != null && !descriptors.isEmpty()) {
                for (PropertyDescriptor propertyDescriptor : descriptors) {
                    orderedProperties.put(propertyDescriptor, null);
                }
            }
            orderedProperties.putAll(sortedProperties);
            dto.setDescriptors(new LinkedHashMap());
            dto.setProperties(new LinkedHashMap());
            for (Map.Entry entry : orderedProperties.entrySet()) {
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, procNode.getProcessGroup().getIdentifier()));
                String propertyValue = (String)entry.getValue();
                if (propertyValue != null && descriptor.isSensitive()) {
                    propertyValue = SENSITIVE_VALUE_MASK;
                } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                    propertyValue = descriptor.getDefaultValue();
                }
                dto.getProperties().put(descriptor.getName(), propertyValue);
            }
            dto.setAnnotationData(procNode.getAnnotationData());
            HashMap<String, String> defaultConcurrentTasks = new HashMap<String, String>();
            defaultConcurrentTasks.put(SchedulingStrategy.TIMER_DRIVEN.name(), String.valueOf(SchedulingStrategy.TIMER_DRIVEN.getDefaultConcurrentTasks()));
            defaultConcurrentTasks.put(SchedulingStrategy.CRON_DRIVEN.name(), String.valueOf(SchedulingStrategy.CRON_DRIVEN.getDefaultConcurrentTasks()));
            dto.setDefaultConcurrentTasks(defaultConcurrentTasks);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
            hashMap.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
            dto.setDefaultSchedulingPeriod(hashMap);
        }
        dto.setSchedulingPeriod(procNode.getSchedulingPeriod());
        dto.setPenaltyDuration(procNode.getPenalizationPeriod());
        dto.setYieldDuration(procNode.getYieldPeriod());
        dto.setRunDurationMillis(Long.valueOf(procNode.getRunDuration(TimeUnit.MILLISECONDS)));
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(procNode.getMaxConcurrentTasks()));
        dto.setLossTolerant(Boolean.valueOf(procNode.isLossTolerant()));
        dto.setComments(procNode.getComments());
        dto.setBulletinLevel(procNode.getBulletinLevel().name());
        dto.setSchedulingStrategy(procNode.getSchedulingStrategy().name());
        dto.setExecutionNode(procNode.getExecutionNode().name());
        dto.setBackoffMechanism(procNode.getBackoffMechanism().name());
        dto.setMaxBackoffPeriod(procNode.getMaxBackoffPeriod());
        dto.setRetriedRelationships(procNode.getRetriedRelationships());
        dto.setRetryCount(Integer.valueOf(procNode.getRetryCount()));
        Set autoTerminatedRelationships = procNode.getAutoTerminatedRelationships().stream().map(Relationship::getName).collect(Collectors.toSet());
        dto.setAutoTerminatedRelationships(autoTerminatedRelationships);
        return dto;
    }

    public PropertyDescriptorDTO createPropertyDescriptorDto(PropertyDescriptor propertyDescriptor, String groupId) {
        if (propertyDescriptor == null) {
            return null;
        }
        PropertyDescriptorDTO dto = new PropertyDescriptorDTO();
        dto.setName(propertyDescriptor.getName());
        dto.setDisplayName(propertyDescriptor.getDisplayName());
        dto.setRequired(Boolean.valueOf(propertyDescriptor.isRequired()));
        dto.setSensitive(Boolean.valueOf(propertyDescriptor.isSensitive()));
        dto.setDynamic(Boolean.valueOf(propertyDescriptor.isDynamic()));
        dto.setDescription(propertyDescriptor.getDescription());
        dto.setDefaultValue(propertyDescriptor.getDefaultValue());
        dto.setSupportsEl(Boolean.valueOf(propertyDescriptor.isExpressionLanguageSupported()));
        String description = propertyDescriptor.getExpressionLanguageScope().getDescription();
        dto.setExpressionLanguageScope(description);
        if (propertyDescriptor.getControllerServiceDefinition() != null) {
            Class serviceClass = propertyDescriptor.getControllerServiceDefinition();
            Bundle serviceBundle = this.extensionManager.getBundle(serviceClass.getClassLoader());
            dto.setIdentifiesControllerService(serviceClass.getName());
            dto.setIdentifiesControllerServiceBundle(this.createBundleDto(serviceBundle.getBundleDetails().getCoordinate()));
        }
        Class serviceDefinition = propertyDescriptor.getControllerServiceDefinition();
        if (propertyDescriptor.getAllowableValues() == null) {
            if (serviceDefinition == null) {
                dto.setAllowableValues(null);
            } else {
                allowableValues = new ArrayList();
                ArrayList controllerServiceIdentifiers = new ArrayList(this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, groupId));
                Iterator iterator = controllerServiceIdentifiers.iterator();
                while (iterator.hasNext()) {
                    String serviceIdentifier = (String)iterator.next();
                    ControllerServiceNode service = this.controllerServiceProvider.getControllerServiceNode(serviceIdentifier);
                    boolean isServiceAuthorized = service.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                    String displayName = isServiceAuthorized ? service.getName() : serviceIdentifier;
                    AllowableValueDTO allowableValue = new AllowableValueDTO();
                    allowableValue.setDisplayName(displayName);
                    allowableValue.setValue(serviceIdentifier);
                    allowableValues.add(this.entityFactory.createAllowableValueEntity(allowableValue, isServiceAuthorized));
                }
                allowableValues.sort(Comparator.comparing(e -> e.getAllowableValue().getDisplayName()));
                dto.setAllowableValues(allowableValues);
            }
        } else {
            allowableValues = new ArrayList<AllowableValueEntity>();
            for (AllowableValue allowableValue : propertyDescriptor.getAllowableValues()) {
                AllowableValueDTO allowableValueDto = new AllowableValueDTO();
                allowableValueDto.setDisplayName(allowableValue.getDisplayName());
                allowableValueDto.setValue(allowableValue.getValue());
                allowableValueDto.setDescription(allowableValue.getDescription());
                allowableValues.add(this.entityFactory.createAllowableValueEntity(allowableValueDto, true));
            }
            dto.setAllowableValues(allowableValues);
        }
        Set dependencies = propertyDescriptor.getDependencies();
        List dependencyDtos = dependencies.stream().map(arg_0 -> this.createPropertyDependencyDto(arg_0)).collect(Collectors.toList());
        dto.setDependencies(dependencyDtos);
        return dto;
    }

    private PropertyDependencyDTO createPropertyDependencyDto(PropertyDependency dependency) {
        PropertyDependencyDTO dto = new PropertyDependencyDTO();
        dto.setPropertyName(dependency.getPropertyName());
        dto.setDependentValues(dependency.getDependentValues());
        return dto;
    }

    public LabelDTO copy(LabelDTO original) {
        LabelDTO copy = new LabelDTO();
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setLabel(original.getLabel());
        copy.setStyle(this.copy(original.getStyle()));
        copy.setPosition(original.getPosition());
        copy.setWidth(original.getWidth());
        copy.setHeight(original.getHeight());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        copy.setzIndex(original.getzIndex());
        return copy;
    }

    public ControllerServiceDTO copy(ControllerServiceDTO original) {
        ControllerServiceDTO copy = new ControllerServiceDTO();
        copy.setAnnotationData(original.getAnnotationData());
        copy.setControllerServiceApis(original.getControllerServiceApis());
        copy.setComments(original.getComments());
        copy.setCustomUiUrl(original.getCustomUiUrl());
        copy.setDescriptors(this.copy(original.getDescriptors()));
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setName(original.getName());
        copy.setBulletinLevel(original.getBulletinLevel());
        copy.setProperties(this.copy(original.getProperties()));
        copy.setSensitiveDynamicPropertyNames(this.copy(original.getSensitiveDynamicPropertyNames()));
        copy.setReferencingComponents(this.copy(original.getReferencingComponents()));
        copy.setState(original.getState());
        copy.setType(original.getType());
        copy.setBundle(this.copy(original.getBundle()));
        copy.setExtensionMissing(original.getExtensionMissing());
        copy.setMultipleVersionsAvailable(original.getMultipleVersionsAvailable());
        copy.setPersistsState(original.getPersistsState());
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        copy.setValidationStatus(original.getValidationStatus());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        return copy;
    }

    public FunnelDTO copy(FunnelDTO original) {
        FunnelDTO copy = new FunnelDTO();
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setPosition(original.getPosition());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        return copy;
    }

    private <T> List<T> copy(List<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }

    private <T> List<T> copy(Collection<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }

    private <T> Set<T> copy(Set<T> original) {
        if (original == null) {
            return null;
        }
        return new LinkedHashSet<T>(original);
    }

    private <S, T> Map<S, T> copy(Map<S, T> original) {
        if (original == null) {
            return null;
        }
        return new LinkedHashMap<S, T>(original);
    }

    public BundleDTO copy(BundleDTO original) {
        if (original == null) {
            return null;
        }
        BundleDTO copy = new BundleDTO();
        copy.setGroup(original.getGroup());
        copy.setArtifact(original.getArtifact());
        copy.setVersion(original.getVersion());
        return copy;
    }

    public ProcessorDTO copy(ProcessorDTO original) {
        ProcessorDTO copy = new ProcessorDTO();
        copy.setConfig(this.copy(original.getConfig()));
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setDescription(original.getDescription());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setRelationships(this.copy(original.getRelationships()));
        copy.setState(original.getState());
        copy.setStyle(this.copy(original.getStyle()));
        copy.setType(original.getType());
        copy.setBundle(this.copy(original.getBundle()));
        copy.setSupportsParallelProcessing(original.getSupportsParallelProcessing());
        copy.setSupportsBatching(original.getSupportsBatching());
        copy.setSupportsSensitiveDynamicProperties(original.getSupportsSensitiveDynamicProperties());
        copy.setPersistsState(original.getPersistsState());
        copy.setExecutionNodeRestricted(original.isExecutionNodeRestricted());
        copy.setExtensionMissing(original.getExtensionMissing());
        copy.setMultipleVersionsAvailable(original.getMultipleVersionsAvailable());
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        copy.setValidationStatus(original.getValidationStatus());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        return copy;
    }

    private ProcessorConfigDTO copy(ProcessorConfigDTO original) {
        ProcessorConfigDTO copy = new ProcessorConfigDTO();
        copy.setAnnotationData(original.getAnnotationData());
        copy.setAutoTerminatedRelationships(this.copy(original.getAutoTerminatedRelationships()));
        copy.setComments(original.getComments());
        copy.setSchedulingStrategy(original.getSchedulingStrategy());
        copy.setExecutionNode(original.getExecutionNode());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setCustomUiUrl(original.getCustomUiUrl());
        copy.setDescriptors(this.copy(original.getDescriptors()));
        copy.setProperties(this.copy(original.getProperties()));
        copy.setSensitiveDynamicPropertyNames(this.copy(original.getSensitiveDynamicPropertyNames()));
        copy.setSchedulingPeriod(original.getSchedulingPeriod());
        copy.setPenaltyDuration(original.getPenaltyDuration());
        copy.setYieldDuration(original.getYieldDuration());
        copy.setRunDurationMillis(original.getRunDurationMillis());
        copy.setBulletinLevel(original.getBulletinLevel());
        copy.setDefaultConcurrentTasks(original.getDefaultConcurrentTasks());
        copy.setDefaultSchedulingPeriod(original.getDefaultSchedulingPeriod());
        copy.setLossTolerant(original.isLossTolerant());
        copy.setBackoffMechanism(original.getBackoffMechanism());
        copy.setMaxBackoffPeriod(original.getMaxBackoffPeriod());
        copy.setRetryCount(original.getRetryCount());
        copy.setRetriedRelationships(original.getRetriedRelationships());
        return copy;
    }

    public ConnectionDTO copy(ConnectionDTO original) {
        ConnectionDTO copy = new ConnectionDTO();
        copy.setAvailableRelationships(this.copy(original.getAvailableRelationships()));
        copy.setDestination(original.getDestination());
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setSelectedRelationships(this.copy(original.getSelectedRelationships()));
        copy.setFlowFileExpiration(original.getFlowFileExpiration());
        copy.setBackPressureObjectThreshold(original.getBackPressureObjectThreshold());
        copy.setBackPressureDataSizeThreshold(original.getBackPressureDataSizeThreshold());
        copy.setPrioritizers(this.copy(original.getPrioritizers()));
        copy.setSource(original.getSource());
        copy.setzIndex(original.getzIndex());
        copy.setLabelIndex(original.getLabelIndex());
        copy.setBends(this.copy(original.getBends()));
        copy.setLoadBalancePartitionAttribute(original.getLoadBalancePartitionAttribute());
        copy.setLoadBalanceStrategy(original.getLoadBalanceStrategy());
        copy.setLoadBalanceCompression(original.getLoadBalanceCompression());
        copy.setLoadBalanceStatus(original.getLoadBalanceStatus());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        return copy;
    }

    public BulletinDTO copy(BulletinDTO original) {
        BulletinDTO copy = new BulletinDTO();
        copy.setId(original.getId());
        copy.setTimestamp(original.getTimestamp());
        copy.setGroupId(original.getGroupId());
        copy.setSourceId(original.getSourceId());
        copy.setSourceName(original.getSourceName());
        copy.setCategory(original.getCategory());
        copy.setLevel(original.getLevel());
        copy.setMessage(original.getMessage());
        copy.setNodeAddress(original.getNodeAddress());
        copy.setSourceType(original.getSourceType());
        return copy;
    }

    public PortDTO copy(PortDTO original) {
        PortDTO copy = new PortDTO();
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setComments(original.getComments());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setState(original.getState());
        copy.setType(original.getType());
        copy.setTransmitting(original.isTransmitting());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        copy.setVersionedComponentId(original.getVersionedComponentId());
        copy.setAllowRemoteAccess(original.getAllowRemoteAccess());
        copy.setPortFunction(original.getPortFunction());
        return copy;
    }

    public RemoteProcessGroupPortDTO copy(RemoteProcessGroupPortDTO original) {
        RemoteProcessGroupPortDTO copy = new RemoteProcessGroupPortDTO();
        copy.setId(original.getId());
        copy.setTargetId(original.getTargetId());
        copy.setGroupId(original.getGroupId());
        copy.setName(original.getName());
        copy.setComments(original.getComments());
        copy.setConnected(original.isConnected());
        copy.setTargetRunning(original.isTargetRunning());
        copy.setTransmitting(original.isTransmitting());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setUseCompression(original.getUseCompression());
        copy.setExists(original.getExists());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        BatchSettingsDTO batchOrg = original.getBatchSettings();
        if (batchOrg != null) {
            BatchSettingsDTO batchCopy = new BatchSettingsDTO();
            batchCopy.setCount(batchOrg.getCount());
            batchCopy.setSize(batchOrg.getSize());
            batchCopy.setDuration(batchOrg.getDuration());
            copy.setBatchSettings(batchCopy);
        }
        return copy;
    }

    public ProcessGroupDTO copy(ProcessGroupDTO original, boolean deep) {
        ProcessGroupDTO copy = new ProcessGroupDTO();
        copy.setComments(original.getComments());
        copy.setContents(this.copy(original.getContents(), deep));
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setLocalInputPortCount(original.getLocalInputPortCount());
        copy.setPublicInputPortCount(original.getPublicInputPortCount());
        copy.setInvalidCount(original.getInvalidCount());
        copy.setName(original.getName());
        copy.setVersionControlInformation(this.copy(original.getVersionControlInformation()));
        copy.setParameterContext(this.copy(original.getParameterContext()));
        copy.setLocalOutputPortCount(original.getLocalOutputPortCount());
        copy.setPublicOutputPortCount(original.getPublicOutputPortCount());
        copy.setOutputPortCount(original.getOutputPortCount());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        copy.setFlowfileConcurrency(original.getFlowfileConcurrency());
        copy.setFlowfileOutboundPolicy(original.getFlowfileOutboundPolicy());
        copy.setDefaultFlowFileExpiration(original.getDefaultFlowFileExpiration());
        copy.setDefaultBackPressureObjectThreshold(original.getDefaultBackPressureObjectThreshold());
        copy.setDefaultBackPressureDataSizeThreshold(original.getDefaultBackPressureDataSizeThreshold());
        copy.setLogFileSuffix(original.getLogFileSuffix());
        copy.setExecutionEngine(original.getExecutionEngine());
        copy.setMaxConcurrentTasks(original.getMaxConcurrentTasks());
        copy.setStatelessFlowTimeout(original.getStatelessFlowTimeout());
        copy.setRunningCount(original.getRunningCount());
        copy.setStoppedCount(original.getStoppedCount());
        copy.setDisabledCount(original.getDisabledCount());
        copy.setActiveRemotePortCount(original.getActiveRemotePortCount());
        copy.setInactiveRemotePortCount(original.getInactiveRemotePortCount());
        copy.setUpToDateCount(original.getUpToDateCount());
        copy.setLocallyModifiedCount(original.getLocallyModifiedCount());
        copy.setStaleCount(original.getStaleCount());
        copy.setLocallyModifiedAndStaleCount(original.getLocallyModifiedAndStaleCount());
        copy.setSyncFailureCount(original.getSyncFailureCount());
        return copy;
    }

    public ParameterContextReferenceEntity copy(ParameterContextReferenceEntity original) {
        if (original == null) {
            return null;
        }
        ParameterContextReferenceEntity copy = new ParameterContextReferenceEntity();
        copy.setId(original.getId());
        copy.setPermissions(this.copy(original.getPermissions()));
        if (original.getComponent() != null) {
            ParameterContextReferenceDTO dtoOriginal = original.getComponent();
            ParameterContextReferenceDTO dtoCopy = new ParameterContextReferenceDTO();
            dtoCopy.setId(dtoOriginal.getId());
            dtoCopy.setName(dtoOriginal.getName());
            copy.setComponent(dtoCopy);
        }
        return copy;
    }

    public PermissionsDTO copy(PermissionsDTO original) {
        if (original == null) {
            return null;
        }
        PermissionsDTO copy = new PermissionsDTO();
        copy.setCanRead(original.getCanRead());
        copy.setCanWrite(original.getCanWrite());
        return copy;
    }

    public VersionControlInformationDTO copy(VersionControlInformationDTO original) {
        if (original == null) {
            return null;
        }
        VersionControlInformationDTO copy = new VersionControlInformationDTO();
        copy.setRegistryId(original.getRegistryId());
        copy.setRegistryName(original.getRegistryName());
        copy.setBranch(original.getBranch());
        copy.setBucketId(original.getBucketId());
        copy.setBucketName(original.getBucketName());
        copy.setFlowId(original.getFlowId());
        copy.setFlowName(original.getFlowName());
        copy.setFlowDescription(original.getFlowDescription());
        copy.setVersion(original.getVersion());
        copy.setState(original.getState());
        copy.setStateExplanation(original.getStateExplanation());
        copy.setStorageLocation(original.getStorageLocation());
        return copy;
    }

    public RemoteProcessGroupDTO copy(RemoteProcessGroupDTO original) {
        RemoteProcessGroupContentsDTO originalContents = original.getContents();
        RemoteProcessGroupContentsDTO copyContents = new RemoteProcessGroupContentsDTO();
        if (originalContents.getInputPorts() != null) {
            HashSet<RemoteProcessGroupPortDTO> inputPorts = new HashSet<RemoteProcessGroupPortDTO>();
            for (RemoteProcessGroupPortDTO port : originalContents.getInputPorts()) {
                inputPorts.add(this.copy(port));
            }
            copyContents.setInputPorts(inputPorts);
        }
        if (originalContents.getOutputPorts() != null) {
            HashSet<RemoteProcessGroupPortDTO> outputPorts = new HashSet<RemoteProcessGroupPortDTO>();
            for (RemoteProcessGroupPortDTO port : originalContents.getOutputPorts()) {
                outputPorts.add(this.copy(port));
            }
            copyContents.setOutputPorts(outputPorts);
        }
        RemoteProcessGroupDTO copy = new RemoteProcessGroupDTO();
        copy.setComments(original.getComments());
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setCommunicationsTimeout(original.getCommunicationsTimeout());
        copy.setYieldDuration(original.getYieldDuration());
        copy.setName(original.getName());
        copy.setInputPortCount(original.getInputPortCount());
        copy.setOutputPortCount(original.getOutputPortCount());
        copy.setActiveRemoteInputPortCount(original.getActiveRemoteInputPortCount());
        copy.setInactiveRemoteInputPortCount(original.getInactiveRemoteInputPortCount());
        copy.setActiveRemoteOutputPortCount(original.getActiveRemoteOutputPortCount());
        copy.setInactiveRemoteOutputPortCount(original.getInactiveRemoteOutputPortCount());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setTargetUris(original.getTargetUris());
        copy.setTransportProtocol(original.getTransportProtocol());
        copy.setProxyHost(original.getProxyHost());
        copy.setProxyPort(original.getProxyPort());
        copy.setProxyUser(original.getProxyUser());
        copy.setProxyPassword(original.getProxyPassword());
        copy.setLocalNetworkInterface(original.getLocalNetworkInterface());
        copy.setVersionedComponentId(original.getVersionedComponentId());
        copy.setContents(copyContents);
        return copy;
    }

    public ConnectableDTO createConnectableDto(PortDTO port, ConnectableType type) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(port.getParentGroupId());
        connectable.setId(port.getId());
        connectable.setName(port.getName());
        connectable.setType(type.name());
        connectable.setVersionedComponentId(port.getVersionedComponentId());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(ProcessorDTO processor) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(processor.getParentGroupId());
        connectable.setId(processor.getId());
        connectable.setName(processor.getName());
        connectable.setType(ConnectableType.PROCESSOR.name());
        connectable.setVersionedComponentId(processor.getVersionedComponentId());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(FunnelDTO funnel) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(funnel.getParentGroupId());
        connectable.setId(funnel.getId());
        connectable.setType(ConnectableType.FUNNEL.name());
        connectable.setVersionedComponentId(funnel.getVersionedComponentId());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(RemoteProcessGroupPortDTO remoteGroupPort, ConnectableType type) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(remoteGroupPort.getGroupId());
        connectable.setId(remoteGroupPort.getId());
        connectable.setName(remoteGroupPort.getName());
        connectable.setType(type.name());
        connectable.setVersionedComponentId(connectable.getVersionedComponentId());
        return connectable;
    }

    private FlowSnippetDTO copy(FlowSnippetDTO original, boolean deep) {
        FlowSnippetDTO copy = new FlowSnippetDTO();
        LinkedHashSet<ConnectionDTO> connections = new LinkedHashSet<ConnectionDTO>();
        LinkedHashSet<ProcessGroupDTO> groups = new LinkedHashSet<ProcessGroupDTO>();
        LinkedHashSet<PortDTO> inputPorts = new LinkedHashSet<PortDTO>();
        LinkedHashSet<PortDTO> outputPorts = new LinkedHashSet<PortDTO>();
        LinkedHashSet<LabelDTO> labels = new LinkedHashSet<LabelDTO>();
        LinkedHashSet<ProcessorDTO> processors = new LinkedHashSet<ProcessorDTO>();
        LinkedHashSet<RemoteProcessGroupDTO> remoteProcessGroups = new LinkedHashSet<RemoteProcessGroupDTO>();
        LinkedHashSet<FunnelDTO> funnels = new LinkedHashSet<FunnelDTO>();
        LinkedHashSet<ControllerServiceDTO> controllerServices = new LinkedHashSet<ControllerServiceDTO>();
        if (deep) {
            for (ProcessGroupDTO group : original.getProcessGroups()) {
                groups.add(this.copy(group, deep));
            }
            for (PortDTO port : original.getInputPorts()) {
                inputPorts.add(this.copy(port));
            }
            for (PortDTO port : original.getOutputPorts()) {
                outputPorts.add(this.copy(port));
            }
            for (LabelDTO label : original.getLabels()) {
                labels.add(this.copy(label));
            }
            for (ProcessorDTO processor : original.getProcessors()) {
                processors.add(this.copy(processor));
            }
            for (RemoteProcessGroupDTO remoteGroup : original.getRemoteProcessGroups()) {
                remoteProcessGroups.add(this.copy(remoteGroup));
            }
            for (FunnelDTO funnel : original.getFunnels()) {
                funnels.add(this.copy(funnel));
            }
            for (ConnectionDTO connection : original.getConnections()) {
                connections.add(this.copy(connection));
            }
            for (ControllerServiceDTO controllerService : original.getControllerServices()) {
                controllerServices.add(this.copy(controllerService));
            }
        } else {
            if (original.getConnections() != null) {
                connections.addAll(this.copy(original.getConnections()));
            }
            if (original.getProcessGroups() != null) {
                groups.addAll(this.copy(original.getProcessGroups()));
            }
            if (original.getInputPorts() != null) {
                inputPorts.addAll(this.copy(original.getInputPorts()));
            }
            if (original.getOutputPorts() != null) {
                outputPorts.addAll(this.copy(original.getOutputPorts()));
            }
            if (original.getLabels() != null) {
                labels.addAll(this.copy(original.getLabels()));
            }
            if (original.getProcessors() != null) {
                processors.addAll(this.copy(original.getProcessors()));
            }
            if (original.getRemoteProcessGroups() != null) {
                remoteProcessGroups.addAll(this.copy(original.getRemoteProcessGroups()));
            }
            if (original.getFunnels() != null) {
                funnels.addAll(this.copy(original.getFunnels()));
            }
            if (original.getControllerServices() != null) {
                controllerServices.addAll(this.copy(original.getControllerServices()));
            }
        }
        copy.setConnections(connections);
        copy.setProcessGroups(groups);
        copy.setInputPorts(inputPorts);
        copy.setLabels(labels);
        copy.setOutputPorts(outputPorts);
        copy.setProcessors(processors);
        copy.setRemoteProcessGroups(remoteProcessGroups);
        copy.setFunnels(funnels);
        copy.setControllerServices(controllerServices);
        return copy;
    }

    public RevisionDTO createRevisionDTO(FlowModification lastMod) {
        Revision revision = lastMod.getRevision();
        RevisionDTO revisionDTO = new RevisionDTO();
        revisionDTO.setVersion(revision.getVersion());
        revisionDTO.setClientId(revision.getClientId());
        revisionDTO.setLastModifier(lastMod.getLastModifier());
        return revisionDTO;
    }

    public RevisionDTO createRevisionDTO(Revision revision) {
        RevisionDTO dto = new RevisionDTO();
        dto.setVersion(revision.getVersion());
        dto.setClientId(revision.getClientId());
        return dto;
    }

    public NodeDTO createNodeDTO(NodeIdentifier nodeId, NodeConnectionStatus status, NodeHeartbeat nodeHeartbeat, List<NodeEvent> events, Set<String> roles) {
        NodeDTO nodeDto = new NodeDTO();
        nodeDto.setNodeId(nodeId.getId());
        nodeDto.setAddress(nodeId.getApiAddress());
        nodeDto.setApiPort(Integer.valueOf(nodeId.getApiPort()));
        nodeDto.setStatus(status.getState().name());
        nodeDto.setRoles(roles);
        if (status.getConnectionRequestTime() != null) {
            Date connectionRequested = new Date(status.getConnectionRequestTime());
            nodeDto.setConnectionRequested(connectionRequested);
        }
        if (nodeHeartbeat != null) {
            Date heartbeat = new Date(nodeHeartbeat.getTimestamp());
            nodeDto.setHeartbeat(heartbeat);
            nodeDto.setNodeStartTime(new Date(nodeHeartbeat.getSystemStartTime()));
            nodeDto.setActiveThreadCount(Integer.valueOf(nodeHeartbeat.getActiveThreadCount()));
            nodeDto.setQueued(FormatUtils.formatCount((long)nodeHeartbeat.getFlowFileCount()) + " / " + FormatUtils.formatDataSize((double)nodeHeartbeat.getFlowFileBytes()));
            nodeDto.setFlowFileBytes(Long.valueOf(nodeHeartbeat.getFlowFileBytes()));
            nodeDto.setFlowFilesQueued(Integer.valueOf(nodeHeartbeat.getFlowFileCount()));
        }
        ArrayList<NodeEvent> nodeEvents = new ArrayList<NodeEvent>(events);
        Collections.sort(nodeEvents, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<NodeEventDTO> nodeEventDtos = new ArrayList<NodeEventDTO>();
        for (NodeEvent event : nodeEvents) {
            NodeEventDTO nodeEventDto = new NodeEventDTO();
            nodeEventDtos.add(nodeEventDto);
            nodeEventDto.setMessage(event.getMessage());
            nodeEventDto.setCategory(event.getSeverity().name());
            nodeEventDto.setTimestamp(new Date(event.getTimestamp()));
        }
        nodeDto.setEvents(nodeEventDtos);
        return nodeDto;
    }

    public FlowRegistryClientDTO createRegistryDto(FlowRegistryClientNode flowRegistryClientNode) {
        BundleCoordinate bundleCoordinate = flowRegistryClientNode.getBundleCoordinate();
        List<Bundle> compatibleBundles = this.extensionManager.getBundles(flowRegistryClientNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).toList();
        FlowRegistryClientDTO dto = new FlowRegistryClientDTO();
        dto.setId(flowRegistryClientNode.getIdentifier());
        dto.setName(flowRegistryClientNode.getName());
        dto.setDescription(flowRegistryClientNode.getDescription());
        dto.setType(flowRegistryClientNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setAnnotationData(flowRegistryClientNode.getAnnotationData());
        dto.setSupportsSensitiveDynamicProperties(Boolean.valueOf(flowRegistryClientNode.isSupportsSensitiveDynamicProperties()));
        dto.setSupportsBranching(Boolean.valueOf(flowRegistryClientNode.isBranchingSupported()));
        dto.setRestricted(Boolean.valueOf(flowRegistryClientNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(flowRegistryClientNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(flowRegistryClientNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        TreeMap sortedProperties = new TreeMap((o1, o2) -> Collator.getInstance(Locale.US).compare(o1.getName(), o2.getName()));
        sortedProperties.putAll(flowRegistryClientNode.getRawPropertyValues());
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = flowRegistryClientNode.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, null));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        ValidationStatus validationStatus = flowRegistryClientNode.getValidationStatus(1L, TimeUnit.MILLISECONDS);
        dto.setValidationStatus(validationStatus.name());
        Collection collection = flowRegistryClientNode.getValidationErrors();
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : collection) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public void setControllerServiceProvider(ControllerServiceProvider controllerServiceProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public FlowAnalysisRuleDTO createFlowAnalysisRuleDto(FlowAnalysisRuleNode flowAnalysisRuleNode) {
        BundleCoordinate bundleCoordinate = flowAnalysisRuleNode.getBundleCoordinate();
        List compatibleBundles = this.extensionManager.getBundles(flowAnalysisRuleNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        Class flowAnalysisRuleClass = flowAnalysisRuleNode.getFlowAnalysisRule().getClass();
        FlowAnalysisRuleDTO dto = new FlowAnalysisRuleDTO();
        dto.setId(flowAnalysisRuleNode.getIdentifier());
        dto.setEnforcementPolicy(flowAnalysisRuleNode.getEnforcementPolicy().name());
        dto.setName(flowAnalysisRuleNode.getName());
        dto.setType(flowAnalysisRuleNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setState(flowAnalysisRuleNode.getState().name());
        dto.setComments(flowAnalysisRuleNode.getComments());
        dto.setPersistsState(Boolean.valueOf(flowAnalysisRuleClass.isAnnotationPresent(Stateful.class)));
        dto.setSupportsSensitiveDynamicProperties(Boolean.valueOf(flowAnalysisRuleNode.isSupportsSensitiveDynamicProperties()));
        dto.setRestricted(Boolean.valueOf(flowAnalysisRuleNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(flowAnalysisRuleNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(flowAnalysisRuleNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        TreeMap sortedProperties = new TreeMap((o1, o2) -> Collator.getInstance(Locale.US).compare(o1.getName(), o2.getName()));
        sortedProperties.putAll(flowAnalysisRuleNode.getRawPropertyValues());
        FlowAnalysisRule flowAnalysisRule = flowAnalysisRuleNode.getFlowAnalysisRule();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = flowAnalysisRule.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, null));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        ValidationStatus validationStatus = flowAnalysisRuleNode.getValidationStatus(1L, TimeUnit.MILLISECONDS);
        dto.setValidationStatus(validationStatus.name());
        Collection collection = flowAnalysisRuleNode.getValidationErrors();
        if (collection != null && !collection.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : collection) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }
}

