/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.nifi.cluster.manager.exception.ConnectingNodeMutableRequestException;

@Provider
public class ConnectingNodeMutableRequestExceptionMapper
implements ExceptionMapper<ConnectingNodeMutableRequestException> {
    private static final Log logger = LogFactory.getLog(ConnectingNodeMutableRequestExceptionMapper.class);

    public Response toResponse(ConnectingNodeMutableRequestException ex) {
        logger.info((Object)String.format("Unable to service mutable request because a node is connecting to the cluster: %s. Returning %s response.", ex, Response.Status.CONFLICT));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"", (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Unable to service request because at least one node is connecting to the cluster.  When all nodes are finished connecting to the cluster, the flow may be changed.").type("text/plain").build();
    }
}

