/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.SnippetEntity;

@Path(value="/snippets")
@Tag(name="Snippets")
public class SnippetResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private SnippetEntity populateRemainingSnippetEntityContent(SnippetEntity entity) {
        if (entity.getSnippet() != null) {
            this.populateRemainingSnippetContent(entity.getSnippet());
        }
        return entity;
    }

    private SnippetDTO populateRemainingSnippetContent(SnippetDTO snippet) {
        String snippetGroupId = snippet.getParentGroupId();
        snippet.setUri(this.generateResourceUri(new String[]{"process-groups", snippetGroupId, "snippets", snippet.getId()}));
        return snippet;
    }

    private void authorizeSnippetRequest(SnippetDTO snippetRequest, Authorizer authorizer, AuthorizableLookup lookup, RequestAction action) {
        Consumer<Authorizable> authorize = authorizable -> authorizable.authorize(authorizer, action, NiFiUserUtils.getNiFiUser());
        snippetRequest.getProcessGroups().keySet().stream().map(id -> lookup.getProcessGroup(id)).forEach(processGroupAuthorizable -> this.authorizeProcessGroup(processGroupAuthorizable, authorizer, lookup, action, false, false, false, false));
        snippetRequest.getRemoteProcessGroups().keySet().stream().map(id -> lookup.getRemoteProcessGroup(id)).forEach(authorize);
        snippetRequest.getProcessors().keySet().stream().map(id -> lookup.getProcessor(id).getAuthorizable()).forEach(authorize);
        snippetRequest.getInputPorts().keySet().stream().map(id -> lookup.getInputPort(id)).forEach(authorize);
        snippetRequest.getOutputPorts().keySet().stream().map(id -> lookup.getOutputPort(id)).forEach(authorize);
        snippetRequest.getConnections().keySet().stream().map(id -> lookup.getConnection(id).getAuthorizable()).forEach(authorize);
        snippetRequest.getFunnels().keySet().stream().map(id -> lookup.getFunnel(id)).forEach(authorize);
        snippetRequest.getLabels().keySet().stream().map(id -> lookup.getLabel(id)).forEach(authorize);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Creates a snippet. The snippet will be automatically discarded if not used in a subsequent request after 1 minute.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SnippetEntity.class))})}, security={@SecurityRequirement(name="Read or Write - /{component-type}/{uuid} - For every component (all Read or all Write) in the Snippet and their descendant components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createSnippet(@Parameter(description="The snippet configuration details.", required=true) SnippetEntity requestSnippetEntity) {
        if (requestSnippetEntity == null || requestSnippetEntity.getSnippet() == null) {
            throw new IllegalArgumentException("Snippet details must be specified.");
        }
        if (requestSnippetEntity.getSnippet().getId() != null) {
            throw new IllegalArgumentException("Snippet ID cannot be specified.");
        }
        if (requestSnippetEntity.getSnippet().getParentGroupId() == null) {
            throw new IllegalArgumentException("The parent Process Group of the snippet must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestSnippetEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestSnippetEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestSnippetEntity, lookup -> {
            SnippetDTO snippetRequest = requestSnippetEntity.getSnippet();
            try {
                this.authorizeSnippetRequest(snippetRequest, this.authorizer, lookup, RequestAction.READ);
            }
            catch (AccessDeniedException e) {
                this.authorizeSnippetRequest(snippetRequest, this.authorizer, lookup, RequestAction.WRITE);
            }
        }, null, snippetEntity -> {
            snippetEntity.getSnippet().setId(this.generateUuid());
            SnippetEntity entity = this.serviceFacade.createSnippet(snippetEntity.getSnippet());
            this.populateRemainingSnippetEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getSnippet().getUri()), (Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Move's the components in this Snippet into a new Process Group and discards the snippet", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SnippetEntity.class))})}, security={@SecurityRequirement(name="Write Process Group - /process-groups/{uuid}"), @SecurityRequirement(name="Write - /{component-type}/{uuid} - For each component in the Snippet and their descendant components")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateSnippet(@Parameter(description="The snippet id.", required=true) @PathParam(value="id") String snippetId, @Parameter(description="The snippet configuration details.", required=true) SnippetEntity requestSnippetEntity) {
        if (requestSnippetEntity == null || requestSnippetEntity.getSnippet() == null) {
            throw new IllegalArgumentException("Snippet details must be specified.");
        }
        SnippetDTO requestSnippetDTO = requestSnippetEntity.getSnippet();
        if (!snippetId.equals(requestSnippetDTO.getId())) {
            throw new IllegalArgumentException(String.format("The snippet id (%s) in the request body does not equal the snippet id of the requested resource (%s).", requestSnippetDTO.getId(), snippetId));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestSnippetEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestSnippetEntity.isDisconnectedNodeAcknowledged());
        }
        Set requestRevisions = this.serviceFacade.getRevisionsFromSnippet(snippetId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestSnippetEntity, requestRevisions, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            if (requestSnippetDTO.getParentGroupId() != null) {
                lookup.getProcessGroup(requestSnippetDTO.getParentGroupId()).getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
            }
            SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
            this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.WRITE, false, false, false);
            ProcessGroup destinationGroup = lookup.getProcessGroup(requestSnippetDTO.getParentGroupId()).getProcessGroup();
            for (ComponentAuthorizable componentAuthorizable : snippet.getSelectedProcessors()) {
                AuthorizeParameterReference.authorizeParameterReferences((ProcessGroup)destinationGroup, (ComponentAuthorizable)componentAuthorizable, (Authorizer)this.authorizer, (NiFiUser)user);
            }
        }, () -> this.serviceFacade.verifyUpdateSnippet(requestSnippetDTO, requestRevisions.stream().map(Revision::getComponentId).collect(Collectors.toSet())), (revisions, snippetEntity) -> {
            SnippetEntity entity = this.serviceFacade.updateSnippet(revisions, snippetEntity.getSnippet());
            this.populateRemainingSnippetEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes the components in a snippet and discards the snippet", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=SnippetEntity.class))})}, security={@SecurityRequirement(name="Write - /{component-type}/{uuid} - For each component in the Snippet and their descendant components"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteSnippet(@Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The snippet id.", required=true) @PathParam(value="id") String snippetId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ComponentEntity requestEntity = new ComponentEntity();
        requestEntity.setId(snippetId);
        Set requestRevisions = this.serviceFacade.getRevisionsFromSnippet(snippetId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevisions, lookup -> {
            SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
            this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.WRITE, true, false, false);
            snippet.getParentProcessGroup().getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteSnippet(snippetId, requestRevisions.stream().map(rev -> rev.getComponentId()).collect(Collectors.toSet())), (revisions, entity) -> {
            SnippetEntity snippetEntity = this.serviceFacade.deleteSnippet(revisions, entity.getId());
            return this.generateOkResponse((Object)snippetEntity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

