/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/connections")
@Tag(name="Connections")
public class ConnectionResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<ConnectionEntity> populateRemainingConnectionEntitiesContent(Set<ConnectionEntity> connectionEntities) {
        for (ConnectionEntity connectionEntity : connectionEntities) {
            this.populateRemainingConnectionEntityContent(connectionEntity);
        }
        return connectionEntities;
    }

    public ConnectionEntity populateRemainingConnectionEntityContent(ConnectionEntity connectionEntity) {
        connectionEntity.setUri(this.generateResourceUri(new String[]{"connections", connectionEntity.getId()}));
        return connectionEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Gets a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionEntity.class))})}, security={@SecurityRequirement(name="Read Source - /{component-type}/{uuid}"), @SecurityRequirement(name="Read Destination - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getConnection(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable authorizable = lookup.getConnection(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ConnectionEntity entity = this.serviceFacade.getConnection(id);
        this.populateRemainingConnectionEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Updates a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionEntity.class))})}, security={@SecurityRequirement(name="Write Source - /{component-type}/{uuid}"), @SecurityRequirement(name="Write Destination - /{component-type}/{uuid}"), @SecurityRequirement(name="Write New Destination - /{component-type}/{uuid} - if updating Destination"), @SecurityRequirement(name="Write Process Group - /process-groups/{uuid} - if updating Destination")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateConnection(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String id, @Parameter(description="The connection configuration details.", required=true) ConnectionEntity requestConnectionEntity) throws InterruptedException {
        List proposedBends;
        if (requestConnectionEntity == null || requestConnectionEntity.getComponent() == null) {
            throw new IllegalArgumentException("Connection details must be specified.");
        }
        if (requestConnectionEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ConnectionDTO requestConnection = requestConnectionEntity.getComponent();
        if (!id.equals(requestConnection.getId())) {
            throw new IllegalArgumentException(String.format("The connection id (%s) in the request body does not equal the connection id of the requested resource (%s).", requestConnection.getId(), id));
        }
        if (requestConnection.getDestination() != null) {
            if (requestConnection.getDestination().getId() == null) {
                throw new IllegalArgumentException("When specifying a destination component, the destination id is required.");
            }
            if (requestConnection.getDestination().getType() == null) {
                throw new IllegalArgumentException("When specifying a destination component, the type of the destination is required.");
            }
        }
        if ((proposedBends = requestConnection.getBends()) != null) {
            for (PositionDTO proposedBend : proposedBends) {
                if (proposedBend.getX() != null && proposedBend.getY() != null) continue;
                throw new IllegalArgumentException("The x and y coordinate of the each bend must be specified.");
            }
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestConnectionEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestConnectionEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestConnectionEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, requestRevision, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            connAuth.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Connectable currentDestination = connAuth.getDestination();
            if (requestConnection.getDestination() != null && !currentDestination.getIdentifier().equals(requestConnection.getDestination().getId())) {
                try {
                    ConnectableType destinationConnectableType = ConnectableType.valueOf((String)requestConnection.getDestination().getType());
                    Authorizable newDestinationAuthorizable = ConnectableType.REMOTE_INPUT_PORT.equals((Object)destinationConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getDestination().getGroupId()) : lookup.getLocalConnectable(requestConnection.getDestination().getId());
                    newDestinationAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Unrecognized destination type %s. Excepted values are [%s]", requestConnection.getDestination().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
                }
                connAuth.getParentGroup().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyUpdateConnection(requestConnection), (revision, connectionEntity) -> {
            ConnectionDTO connection = connectionEntity.getComponent();
            ConnectionEntity entity = this.serviceFacade.updateConnection(revision, connection);
            this.populateRemainingConnectionEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Deletes a connection", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConnectionEntity.class))})}, security={@SecurityRequirement(name="Write Source - /{component-type}/{uuid}"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}"), @SecurityRequirement(name="Write Destination - /{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteConnection(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        Long clientVersion = version == null ? null : version.getLong();
        Revision requestRevision = new Revision(clientVersion, clientId.getClientId(), id);
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getConnection(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            authorizable.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteConnection(id), (revision, connectionEntity) -> {
            ConnectionEntity entity = this.serviceFacade.deleteConnection(revision, connectionEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

