/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ReportingTaskAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ReportingTaskAuditor.class);
    private static final String NAME = "Name";
    private static final String ANNOTATION_DATA = "Annotation Data";
    private static final String EXTENSION_VERSION = "Extension Version";

    @Around(value="within(org.apache.nifi.web.dao.ReportingTaskDAO+) && execution(org.apache.nifi.controller.ReportingTaskNode createReportingTask(org.apache.nifi.web.api.dto.ReportingTaskDTO))")
    public ReportingTaskNode createReportingTaskAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ReportingTaskNode reportingTask = (ReportingTaskNode)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(reportingTask, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return reportingTask;
    }

    @Around(value="within(org.apache.nifi.web.dao.ReportingTaskDAO+) && execution(org.apache.nifi.controller.ReportingTaskNode updateReportingTask(org.apache.nifi.web.api.dto.ReportingTaskDTO)) && args(reportingTaskDTO) && target(reportingTaskDAO)")
    public Object updateReportingTaskAdvice(ProceedingJoinPoint proceedingJoinPoint, ReportingTaskDTO reportingTaskDTO, ReportingTaskDAO reportingTaskDAO) throws Throwable {
        ReportingTaskNode reportingTask = reportingTaskDAO.getReportingTask(reportingTaskDTO.getId());
        Map values = this.extractConfiguredPropertyValues(reportingTask, reportingTaskDTO);
        ScheduledState scheduledState = reportingTask.getScheduledState();
        ReportingTaskNode updatedReportingTask = (ReportingTaskNode)proceedingJoinPoint.proceed();
        reportingTask = reportingTaskDAO.getReportingTask(updatedReportingTask.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Set sensitiveDynamicPropertyNames = reportingTaskDTO.getSensitiveDynamicPropertyNames() == null ? Collections.emptySet() : reportingTaskDTO.getSensitiveDynamicPropertyNames();
            Map updatedValues = this.extractConfiguredPropertyValues(reportingTask, reportingTaskDTO);
            FlowChangeExtensionDetails taskDetails = new FlowChangeExtensionDetails();
            taskDetails.setType(reportingTask.getComponentType());
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                PropertyDescriptor propertyDescriptor = reportingTask.getPropertyDescriptor(property);
                if (propertyDescriptor != null && (propertyDescriptor.isSensitive() || sensitiveDynamicPropertyNames.contains(property))) {
                    this.deletePreviousValues(propertyDescriptor.getName(), reportingTask.getIdentifier(), logger);
                    if (newValue != null) {
                        newValue = "********";
                    }
                    if (oldValue != null) {
                        oldValue = "********";
                    }
                } else if (ANNOTATION_DATA.equals(property)) {
                    if (newValue != null) {
                        newValue = "<annotation data not shown>";
                    }
                    if (oldValue != null) {
                        oldValue = "<annotation data not shown>";
                    }
                }
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(reportingTask.getIdentifier());
                configurationAction.setSourceName(reportingTask.getName());
                configurationAction.setSourceType(Component.ReportingTask);
                configurationAction.setComponentDetails((ComponentDetails)taskDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            ScheduledState updatedScheduledState = reportingTask.getScheduledState();
            if (scheduledState != updatedScheduledState) {
                FlowChangeAction taskAction = new FlowChangeAction();
                taskAction.setUserIdentity(user.getIdentity());
                taskAction.setTimestamp(new Date());
                taskAction.setSourceId(reportingTask.getIdentifier());
                taskAction.setSourceName(reportingTask.getName());
                taskAction.setSourceType(Component.ReportingTask);
                taskAction.setComponentDetails((ComponentDetails)taskDetails);
                if (ScheduledState.RUNNING.equals((Object)updatedScheduledState)) {
                    taskAction.setOperation(Operation.Start);
                } else if (ScheduledState.DISABLED.equals((Object)updatedScheduledState)) {
                    taskAction.setOperation(Operation.Disable);
                } else if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                    taskAction.setOperation(Operation.Stop);
                } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
                    taskAction.setOperation(Operation.Enable);
                }
                actions.add(taskAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedReportingTask;
    }

    @Around(value="within(org.apache.nifi.web.dao.ReportingTaskDAO+) && execution(void deleteReportingTask(java.lang.String)) && args(reportingTaskId) && target(reportingTaskDAO)")
    public void removeReportingTaskAdvice(ProceedingJoinPoint proceedingJoinPoint, String reportingTaskId, ReportingTaskDAO reportingTaskDAO) throws Throwable {
        ReportingTaskNode reportingTask = reportingTaskDAO.getReportingTask(reportingTaskId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(reportingTask, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(ReportingTaskNode reportingTask, Operation operation) {
        return this.generateAuditRecord(reportingTask, operation, null);
    }

    public Action generateAuditRecord(ReportingTaskNode reportingTask, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeExtensionDetails taskDetails = new FlowChangeExtensionDetails();
            taskDetails.setType(reportingTask.getComponentType());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(reportingTask.getIdentifier());
            action.setSourceName(reportingTask.getName());
            action.setSourceType(Component.ReportingTask);
            action.setComponentDetails((ComponentDetails)taskDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(ReportingTaskNode reportingTask, ReportingTaskDTO reportingTaskDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (reportingTaskDTO.getName() != null) {
            values.put(NAME, reportingTask.getName());
        }
        if (reportingTaskDTO.getAnnotationData() != null) {
            values.put(ANNOTATION_DATA, reportingTask.getAnnotationData());
        }
        if (reportingTaskDTO.getBundle() != null) {
            BundleCoordinate bundle = reportingTask.getBundleCoordinate();
            values.put(EXTENSION_VERSION, this.formatExtensionVersion(reportingTask.getComponentType(), bundle));
        }
        if (reportingTaskDTO.getProperties() != null) {
            Map properties = reportingTaskDTO.getProperties();
            Map configuredProperties = reportingTask.getRawPropertyValues();
            for (String propertyName : properties.keySet()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor.Builder().name(propertyName).build();
                String configuredPropertyValue = (String)configuredProperties.get(propertyDescriptor);
                if (configuredPropertyValue == null) {
                    propertyDescriptor = this.locatePropertyDescriptor(configuredProperties.keySet(), propertyDescriptor);
                    configuredPropertyValue = propertyDescriptor.getDefaultValue();
                }
                values.put(propertyName, configuredPropertyValue);
            }
        }
        return values;
    }

    private PropertyDescriptor locatePropertyDescriptor(Set<PropertyDescriptor> propertyDescriptors, PropertyDescriptor specDescriptor) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.equals((Object)specDescriptor)) continue;
            return propertyDescriptor;
        }
        return specDescriptor;
    }
}

