/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.SnippetEntity;

@Path(value="/snippets")
@Api(value="/snippets", description="Endpoint for accessing dataflow snippets.")
public class SnippetResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private SnippetEntity populateRemainingSnippetEntityContent(SnippetEntity entity) {
        if (entity.getSnippet() != null) {
            this.populateRemainingSnippetContent(entity.getSnippet());
        }
        return entity;
    }

    private SnippetDTO populateRemainingSnippetContent(SnippetDTO snippet) {
        String snippetGroupId = snippet.getParentGroupId();
        snippet.setUri(this.generateResourceUri(new String[]{"process-groups", snippetGroupId, "snippets", snippet.getId()}));
        return snippet;
    }

    private void authorizeSnippetRequest(SnippetDTO snippetRequest, Authorizer authorizer, AuthorizableLookup lookup, RequestAction action) {
        Consumer<Authorizable> authorize = authorizable -> authorizable.authorize(authorizer, action, NiFiUserUtils.getNiFiUser());
        snippetRequest.getProcessGroups().keySet().stream().map(id -> lookup.getProcessGroup(id)).forEach(processGroupAuthorizable -> this.authorizeProcessGroup(processGroupAuthorizable, authorizer, lookup, action, false, false, false, false));
        snippetRequest.getRemoteProcessGroups().keySet().stream().map(id -> lookup.getRemoteProcessGroup(id)).forEach(authorize);
        snippetRequest.getProcessors().keySet().stream().map(id -> lookup.getProcessor(id).getAuthorizable()).forEach(authorize);
        snippetRequest.getInputPorts().keySet().stream().map(id -> lookup.getInputPort(id)).forEach(authorize);
        snippetRequest.getOutputPorts().keySet().stream().map(id -> lookup.getOutputPort(id)).forEach(authorize);
        snippetRequest.getConnections().keySet().stream().map(id -> lookup.getConnection(id).getAuthorizable()).forEach(authorize);
        snippetRequest.getFunnels().keySet().stream().map(id -> lookup.getFunnel(id)).forEach(authorize);
        snippetRequest.getLabels().keySet().stream().map(id -> lookup.getLabel(id)).forEach(authorize);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a snippet. The snippet will be automatically discarded if not used in a subsequent request after 1 minute.", response=SnippetEntity.class, authorizations={@Authorization(value="Read or Write - /{component-type}/{uuid} - For every component (all Read or all Write) in the Snippet and their descendant components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createSnippet(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The snippet configuration details.", required=true) SnippetEntity requestSnippetEntity) {
        if (requestSnippetEntity == null || requestSnippetEntity.getSnippet() == null) {
            throw new IllegalArgumentException("Snippet details must be specified.");
        }
        if (requestSnippetEntity.getSnippet().getId() != null) {
            throw new IllegalArgumentException("Snippet ID cannot be specified.");
        }
        if (requestSnippetEntity.getSnippet().getParentGroupId() == null) {
            throw new IllegalArgumentException("The parent Process Group of the snippet must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestSnippetEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestSnippetEntity, lookup -> {
            SnippetDTO snippetRequest = requestSnippetEntity.getSnippet();
            try {
                this.authorizeSnippetRequest(snippetRequest, this.authorizer, lookup, RequestAction.READ);
            }
            catch (AccessDeniedException e) {
                this.authorizeSnippetRequest(snippetRequest, this.authorizer, lookup, RequestAction.WRITE);
            }
        }, null, snippetEntity -> {
            snippetEntity.getSnippet().setId(this.generateUuid());
            SnippetEntity entity = this.serviceFacade.createSnippet(snippetEntity.getSnippet());
            this.populateRemainingSnippetEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getSnippet().getUri()), (Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Move's the components in this Snippet into a new Process Group and discards the snippet", response=SnippetEntity.class, authorizations={@Authorization(value="Write Process Group - /process-groups/{uuid}", type=""), @Authorization(value="Write - /{component-type}/{uuid} - For each component in the Snippet and their descendant components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateSnippet(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The snippet id.", required=true) @PathParam(value="id") String snippetId, @ApiParam(value="The snippet configuration details.", required=true) SnippetEntity requestSnippetEntity) {
        if (requestSnippetEntity == null || requestSnippetEntity.getSnippet() == null) {
            throw new IllegalArgumentException("Snippet details must be specified.");
        }
        SnippetDTO requestSnippetDTO = requestSnippetEntity.getSnippet();
        if (!snippetId.equals(requestSnippetDTO.getId())) {
            throw new IllegalArgumentException(String.format("The snippet id (%s) in the request body does not equal the snippet id of the requested resource (%s).", requestSnippetDTO.getId(), snippetId));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestSnippetEntity);
        }
        Set requestRevisions = this.serviceFacade.getRevisionsFromSnippet(snippetId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestSnippetEntity, requestRevisions, lookup -> {
            if (requestSnippetDTO.getParentGroupId() != null) {
                lookup.getProcessGroup(requestSnippetDTO.getParentGroupId()).getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
            SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
            this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.WRITE, false, false);
        }, () -> this.serviceFacade.verifyUpdateSnippet(requestSnippetDTO, requestRevisions.stream().map(rev -> rev.getComponentId()).collect(Collectors.toSet())), (revisions, snippetEntity) -> {
            SnippetEntity entity = this.serviceFacade.updateSnippet(revisions, snippetEntity.getSnippet());
            this.populateRemainingSnippetEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes the components in a snippet and discards the snippet", response=SnippetEntity.class, authorizations={@Authorization(value="Write - /{component-type}/{uuid} - For each component in the Snippet and their descendant components", type=""), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteSnippet(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The snippet id.", required=true) @PathParam(value="id") String snippetId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        ComponentEntity requestEntity = new ComponentEntity();
        requestEntity.setId(snippetId);
        Set requestRevisions = this.serviceFacade.getRevisionsFromSnippet(snippetId);
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, requestRevisions, lookup -> {
            SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
            this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.WRITE, true, false);
            snippet.getParentProcessGroup().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteSnippet(snippetId, requestRevisions.stream().map(rev -> rev.getComponentId()).collect(Collectors.toSet())), (revisions, entity) -> {
            SnippetEntity snippetEntity = this.serviceFacade.deleteSnippet(revisions, entity.getId());
            return this.generateOkResponse((Object)snippetEntity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

