/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.logging.NiFiLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerFilter
implements Filter {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(TimerFilter.class));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        long start = System.nanoTime();
        try {
            filterChain.doFilter(req, resp);
        }
        catch (Throwable throwable) {
            long stop = System.nanoTime();
            String requestId = ((HttpServletRequest)req).getHeader("X-RequestTransactionId");
            String replicationHeader = ((HttpServletRequest)req).getHeader("X-Request-Replicated");
            boolean validationPhase = "150-NodeContinue".equals(replicationHeader);
            String requestDescription = validationPhase ? "Validation Phase of Request " + requestId : "Request ID " + requestId;
            logger.debug("{} {} from {} duration for {}: {} millis", new Object[]{request.getMethod(), request.getRequestURL().toString(), req.getRemoteHost(), requestDescription, TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS)});
            throw throwable;
        }
        long stop = System.nanoTime();
        String requestId = ((HttpServletRequest)req).getHeader("X-RequestTransactionId");
        String replicationHeader = ((HttpServletRequest)req).getHeader("X-Request-Replicated");
        boolean validationPhase = "150-NodeContinue".equals(replicationHeader);
        String requestDescription = validationPhase ? "Validation Phase of Request " + requestId : "Request ID " + requestId;
        logger.debug("{} {} from {} duration for {}: {} millis", new Object[]{request.getMethod(), request.getRequestURL().toString(), req.getRemoteHost(), requestDescription, TimeUnit.MILLISECONDS.convert(stop - start, TimeUnit.NANOSECONDS)});
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }
}

