/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.entity.ResourcesEntity;

@Path(value="/resources")
@Api(value="/resources", description="Provides the resources in this NiFi that can have access/authorization policies.")
public class ResourceResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeResource() {
        HashMap<String, String> userContext;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!StringUtils.isBlank((CharSequence)user.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getResourceResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(RequestAction.READ).userContext(userContext).explanationSupplier(() -> "Unable to retrieve resources.").build();
        AuthorizationResult result = this.authorizer.authorize(request);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            throw new AccessDeniedException(result.getExplanation());
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the available resources that support access/authorization policies", response=ResourcesEntity.class, authorizations={@Authorization(value="Read - /resources", type="")})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response getResources() {
        this.authorizeResource();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        List resources = this.serviceFacade.getResources();
        ResourcesEntity entity = new ResourcesEntity();
        entity.setResources(resources);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

