/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.RootGroupPortAuthorizable;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.client.http.TransportProtocolVersionNegotiator;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.exception.NotAuthorizedException;
import org.apache.nifi.remote.exception.RequestExpiredException;
import org.apache.nifi.remote.io.http.HttpCommunicationsSession;
import org.apache.nifi.remote.io.http.HttpServerCommunicationsSession;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.HandshakeProperty;
import org.apache.nifi.remote.protocol.ResponseCode;
import org.apache.nifi.remote.protocol.ServerProtocol;
import org.apache.nifi.remote.protocol.http.HttpFlowFileServerProtocol;
import org.apache.nifi.remote.protocol.http.StandardHttpFlowFileServerProtocol;
import org.apache.nifi.stream.io.ByteArrayOutputStream;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.DataTransferResource;
import org.apache.nifi.web.api.entity.TransactionResultEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/data-transfer")
@Api(value="/data-transfer", description="Supports data transfers with this NiFi using HTTP based site to site")
public class DataTransferResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(DataTransferResource.class);
    public static final String CHECK_SUM = "checksum";
    public static final String RESPONSE_CODE = "responseCode";
    private static final String PORT_TYPE_INPUT = "input-ports";
    private static final String PORT_TYPE_OUTPUT = "output-ports";
    private NiFiServiceFacade serviceFacade;
    private final ApplicationResource.ResponseCreator responseCreator = new ApplicationResource.ResponseCreator((ApplicationResource)this);
    private final VersionNegotiator transportProtocolVersionNegotiator = new TransportProtocolVersionNegotiator(new int[]{1});
    private final HttpRemoteSiteListener transactionManager;
    private final NiFiProperties nifiProperties;

    public DataTransferResource(NiFiProperties nifiProperties) {
        this.nifiProperties = nifiProperties;
        this.transactionManager = HttpRemoteSiteListener.getInstance((NiFiProperties)nifiProperties);
    }

    protected void authorizeDataTransfer(AuthorizableLookup lookup, ResourceType resourceType, String identifier) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!ResourceType.InputPort.equals((Object)resourceType) && !ResourceType.OutputPort.equals((Object)resourceType)) {
            throw new IllegalArgumentException("The resource must be an Input or Output Port.");
        }
        RootGroupPortAuthorizable authorizable = ResourceType.InputPort.equals((Object)resourceType) ? lookup.getRootGroupInputPort(identifier) : lookup.getRootGroupOutputPort(identifier);
        AuthorizationResult authorizationResult = authorizable.checkAuthorization(user);
        if (!AuthorizationResult.Result.Approved.equals((Object)authorizationResult.getResult())) {
            throw new AccessDeniedException(authorizationResult.getExplanation());
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{portType}/{portId}/transactions")
    @ApiOperation(value="Create a transaction to the specified output port or input port", response=TransactionResultEntity.class, authorizations={@Authorization(value="Write - /data-transfer/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response createPortTransaction(@ApiParam(value="The port type.", required=true, allowableValues="input-ports, output-ports") @PathParam(value="portType") String portType, @PathParam(value="portId") String portId, @Context HttpServletRequest req, @Context ServletContext context, @Context UriInfo uriInfo, InputStream inputStream) {
        if (!"input-ports".equals(portType) && !"output-ports".equals(portType)) {
            return this.responseCreator.wrongPortTypeResponse(portType, portId);
        }
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, "input-ports".equals(portType) ? ResourceType.InputPort : ResourceType.OutputPort, portId));
        ValidateRequestResult validationResult = this.validateResult(req, portId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        logger.debug("createPortTransaction request: clientId={}, portType={}, portId={}", (Object)portType, (Object)portId);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        String transactionId = this.transactionManager.createTransaction();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)out, portId, transactionId);
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        try {
            this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            TransactionResultEntity entity = new TransactionResultEntity();
            entity.setResponseCode(ResponseCode.PROPERTIES_OK.getCode());
            entity.setMessage("Handshake properties are valid, and port is running. A transaction is created:" + transactionId);
            return this.responseCreator.locationResponse(uriInfo, portType, portId, transactionId, (Object)entity, Integer.valueOf(transportProtocolVersion), this.transactionManager);
        }
        catch (HandshakeException e) {
            this.transactionManager.cancelTransaction(transactionId);
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (Exception e) {
            this.transactionManager.cancelTransaction(transactionId);
            return this.responseCreator.unexpectedErrorResponse(portId, e);
        }
    }

    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    @Path(value="input-ports/{portId}/transactions/{transactionId}/flow-files")
    @ApiOperation(value="Transfer flow files to the input port", response=String.class, authorizations={@Authorization(value="Write - /data-transfer/input-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response receiveFlowFiles(@ApiParam(value="The input port id.", required=true) @PathParam(value="portId") String portId, @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context ServletContext context, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.InputPort, portId));
        ValidateRequestResult validationResult = this.validateResult(req, portId, transactionId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        logger.debug("receiveFlowFiles request: portId={}", (Object)portId);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)out, portId, transactionId);
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        try {
            HttpFlowFileServerProtocol serverProtocol = this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            int numOfFlowFiles = serverProtocol.getPort().receiveFlowFiles(peer, (ServerProtocol)serverProtocol);
            logger.debug("finished receiving flow files, numOfFlowFiles={}", (Object)numOfFlowFiles);
            if (numOfFlowFiles < 1) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Client should send request when there is data to send. There was no flow file sent.").build();
            }
        }
        catch (HandshakeException e) {
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (NotAuthorizedException e) {
            return this.responseCreator.unauthorizedResponse(e);
        }
        catch (BadRequestException | RequestExpiredException e) {
            return this.responseCreator.badRequestResponse((Exception)e);
        }
        catch (Exception e) {
            return this.responseCreator.unexpectedErrorResponse(portId, e);
        }
        String serverChecksum = ((HttpServerCommunicationsSession)peer.getCommunicationsSession()).getChecksum();
        return this.responseCreator.acceptedResponse(this.transactionManager, (Object)serverChecksum, Integer.valueOf(transportProtocolVersion));
    }

    private HttpFlowFileServerProtocol initiateServerProtocol(HttpServletRequest req, Peer peer, Integer transportProtocolVersion) throws IOException {
        TransportProtocolVersionNegotiator negotiatedTransportProtocolVersion = new TransportProtocolVersionNegotiator(new int[]{transportProtocolVersion});
        StandardVersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{negotiatedTransportProtocolVersion.getTransactionProtocolVersion()});
        String dataTransferUrl = req.getRequestURL().toString();
        ((HttpCommunicationsSession)peer.getCommunicationsSession()).setDataTransferUrl(dataTransferUrl);
        HttpFlowFileServerProtocol serverProtocol = this.getHttpFlowFileServerProtocol((VersionNegotiator)versionNegotiator);
        HttpRemoteSiteListener.getInstance((NiFiProperties)this.nifiProperties).setupServerProtocol(serverProtocol);
        serverProtocol.handshake(peer);
        return serverProtocol;
    }

    HttpFlowFileServerProtocol getHttpFlowFileServerProtocol(VersionNegotiator versionNegotiator) {
        return new StandardHttpFlowFileServerProtocol(versionNegotiator, this.nifiProperties);
    }

    private Peer constructPeer(HttpServletRequest req, InputStream inputStream, OutputStream outputStream, String portId, String transactionId) {
        String clientHostName = req.getRemoteHost();
        try {
            InetAddress clientAddress = InetAddress.getByName(clientHostName);
            clientHostName = clientAddress.getHostName();
        }
        catch (UnknownHostException e) {
            logger.info("Failed to resolve client hostname {}, due to {}", (Object)clientHostName, (Object)e.getMessage());
        }
        int clientPort = req.getRemotePort();
        PeerDescription peerDescription = new PeerDescription(clientHostName, clientPort, req.isSecure());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        String userDn = user == null ? null : user.getIdentity();
        HttpServerCommunicationsSession commSession = new HttpServerCommunicationsSession(inputStream, outputStream, transactionId, userDn);
        boolean useCompression = false;
        String useCompressionStr = req.getHeader("x-nifi-site-to-site-use-compression");
        if (!StringUtils.isEmpty((CharSequence)useCompressionStr) && Boolean.valueOf(useCompressionStr).booleanValue()) {
            useCompression = true;
        }
        String requestExpiration = req.getHeader("x-nifi-site-to-site-request-expiration");
        String batchCount = req.getHeader("x-nifi-site-to-site-batch-count");
        String batchSize = req.getHeader("x-nifi-site-to-site-batch-size");
        String batchDuration = req.getHeader("x-nifi-site-to-site-batch-duration");
        commSession.putHandshakeParam(HandshakeProperty.PORT_IDENTIFIER, portId);
        commSession.putHandshakeParam(HandshakeProperty.GZIP, String.valueOf(useCompression));
        if (!StringUtils.isEmpty((CharSequence)requestExpiration)) {
            commSession.putHandshakeParam(HandshakeProperty.REQUEST_EXPIRATION_MILLIS, requestExpiration);
        }
        if (!StringUtils.isEmpty((CharSequence)batchCount)) {
            commSession.putHandshakeParam(HandshakeProperty.BATCH_COUNT, batchCount);
        }
        if (!StringUtils.isEmpty((CharSequence)batchSize)) {
            commSession.putHandshakeParam(HandshakeProperty.BATCH_SIZE, batchSize);
        }
        if (!StringUtils.isEmpty((CharSequence)batchDuration)) {
            commSession.putHandshakeParam(HandshakeProperty.BATCH_DURATION, batchDuration);
        }
        if (peerDescription.isSecure()) {
            NiFiUser nifiUser = NiFiUserUtils.getNiFiUser();
            logger.debug("initiating peer, nifiUser={}", (Object)nifiUser);
            commSession.setUserDn(nifiUser.getIdentity());
        }
        String peerUrl = "nifi://" + clientHostName + ":" + clientPort;
        String clusterUrl = "nifi://localhost:" + req.getLocalPort();
        return new Peer(peerDescription, (CommunicationsSession)commSession, peerUrl, clusterUrl);
    }

    @DELETE
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Path(value="output-ports/{portId}/transactions/{transactionId}")
    @ApiOperation(value="Commit or cancel the specified transaction", response=TransactionResultEntity.class, authorizations={@Authorization(value="Write - /data-transfer/output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response commitOutputPortTransaction(@ApiParam(value="The response code. Available values are CONFIRM_TRANSACTION(12) or CANCEL_TRANSACTION(15).", required=true) @QueryParam(value="responseCode") Integer responseCode, @ApiParam(value="A checksum calculated at client side using CRC32 to check flow file content integrity. It must match with the value calculated at server side.", required=true) @QueryParam(value="checksum") @DefaultValue(value="") String checksum, @ApiParam(value="The output port id.", required=true) @PathParam(value="portId") String portId, @ApiParam(value="The transaction id.", required=true) @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context ServletContext context, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.OutputPort, portId));
        ValidateRequestResult validationResult = this.validateResult(req, portId, transactionId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        logger.debug("commitOutputPortTransaction request: portId={}, transactionId={}", (Object)portId, (Object)transactionId);
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)out, portId, transactionId);
        TransactionResultEntity entity = new TransactionResultEntity();
        try {
            HttpFlowFileServerProtocol serverProtocol = this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            String inputErrMessage = null;
            if (responseCode == null) {
                inputErrMessage = "responseCode is required.";
            } else if (ResponseCode.CONFIRM_TRANSACTION.getCode() != responseCode.intValue() && ResponseCode.CANCEL_TRANSACTION.getCode() != responseCode.intValue()) {
                inputErrMessage = "responseCode " + responseCode + " is invalid. ";
            }
            if (inputErrMessage != null) {
                entity.setMessage(inputErrMessage);
                entity.setResponseCode(ResponseCode.ABORT.getCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
            if (ResponseCode.CANCEL_TRANSACTION.getCode() == responseCode.intValue()) {
                return this.cancelTransaction(transactionId, entity);
            }
            int flowFileSent = serverProtocol.commitTransferTransaction(peer, checksum);
            entity.setResponseCode(ResponseCode.CONFIRM_TRANSACTION.getCode());
            entity.setFlowFileSent(flowFileSent);
        }
        catch (HandshakeException e) {
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (Exception e) {
            HttpServerCommunicationsSession commsSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
            logger.error("Failed to process the request", (Throwable)e);
            if (ResponseCode.BAD_CHECKSUM.equals((Object)commsSession.getResponseCode())) {
                entity.setResponseCode(commsSession.getResponseCode().getCode());
                entity.setMessage(e.getMessage());
                Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity);
                return this.clusterContext(this.noCache(builder)).build();
            }
            return this.responseCreator.unexpectedErrorResponse(portId, transactionId, e);
        }
        return this.clusterContext(this.noCache(this.setCommonHeaders(Response.ok((Object)entity), Integer.valueOf(transportProtocolVersion), this.transactionManager))).build();
    }

    @DELETE
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Path(value="input-ports/{portId}/transactions/{transactionId}")
    @ApiOperation(value="Commit or cancel the specified transaction", response=TransactionResultEntity.class, authorizations={@Authorization(value="Write - /data-transfer/input-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response commitInputPortTransaction(@ApiParam(value="The response code. Available values are BAD_CHECKSUM(19), CONFIRM_TRANSACTION(12) or CANCEL_TRANSACTION(15).", required=true) @QueryParam(value="responseCode") Integer responseCode, @ApiParam(value="The input port id.", required=true) @PathParam(value="portId") String portId, @ApiParam(value="The transaction id.", required=true) @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context ServletContext context, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.InputPort, portId));
        ValidateRequestResult validationResult = this.validateResult(req, portId, transactionId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        logger.debug("commitInputPortTransaction request: portId={}, transactionId={}, responseCode={}", new Object[]{portId, transactionId, responseCode});
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)out, portId, transactionId);
        TransactionResultEntity entity = new TransactionResultEntity();
        try {
            HttpFlowFileServerProtocol serverProtocol = this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            HttpServerCommunicationsSession commsSession = (HttpServerCommunicationsSession)peer.getCommunicationsSession();
            String inputErrMessage = null;
            if (responseCode == null) {
                inputErrMessage = "responseCode is required.";
            } else if (ResponseCode.BAD_CHECKSUM.getCode() != responseCode.intValue() && ResponseCode.CONFIRM_TRANSACTION.getCode() != responseCode.intValue() && ResponseCode.CANCEL_TRANSACTION.getCode() != responseCode.intValue()) {
                inputErrMessage = "responseCode " + responseCode + " is invalid. ";
            }
            if (inputErrMessage != null) {
                entity.setMessage(inputErrMessage);
                entity.setResponseCode(ResponseCode.ABORT.getCode());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
            if (ResponseCode.CANCEL_TRANSACTION.getCode() == responseCode.intValue()) {
                return this.cancelTransaction(transactionId, entity);
            }
            commsSession.setResponseCode(ResponseCode.fromCode((int)responseCode));
            try {
                int flowFileSent = serverProtocol.commitReceiveTransaction(peer);
                entity.setResponseCode(commsSession.getResponseCode().getCode());
                entity.setFlowFileSent(flowFileSent);
            }
            catch (IOException e) {
                if (ResponseCode.BAD_CHECKSUM.getCode() == responseCode.intValue() && e.getMessage().contains("Received a BadChecksum response")) {
                    entity.setResponseCode(ResponseCode.CANCEL_TRANSACTION.getCode());
                    return this.clusterContext(this.noCache(Response.ok((Object)entity))).build();
                }
                return this.responseCreator.unexpectedErrorResponse(portId, transactionId, (Exception)e);
            }
        }
        catch (HandshakeException e) {
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (Exception e) {
            return this.responseCreator.unexpectedErrorResponse(portId, transactionId, e);
        }
        return this.clusterContext(this.noCache(this.setCommonHeaders(Response.ok((Object)entity), Integer.valueOf(transportProtocolVersion), this.transactionManager))).build();
    }

    private Response cancelTransaction(String transactionId, TransactionResultEntity entity) {
        this.transactionManager.cancelTransaction(transactionId);
        entity.setMessage("Transaction has been canceled.");
        entity.setResponseCode(ResponseCode.CANCEL_TRANSACTION.getCode());
        return Response.ok((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    @Path(value="output-ports/{portId}/transactions/{transactionId}/flow-files")
    @ApiOperation(value="Transfer flow files from the output port", response=StreamingOutput.class, authorizations={@Authorization(value="Write - /data-transfer/output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=200, message="There is no flow file to return."), @ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response transferFlowFiles(@ApiParam(value="The output port id.", required=true) @PathParam(value="portId") String portId, @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context HttpServletResponse res, @Context ServletContext context, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.OutputPort, portId));
        ValidateRequestResult validationResult = this.validateResult(req, portId, transactionId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        logger.debug("transferFlowFiles request: portId={}", (Object)portId);
        ByteArrayOutputStream tempBos = new ByteArrayOutputStream();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)tempBos, portId, transactionId);
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        try {
            HttpFlowFileServerProtocol serverProtocol = this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            1 flowFileContent = new /* Unavailable Anonymous Inner Class!! */;
            return this.responseCreator.acceptedResponse(this.transactionManager, (Object)flowFileContent, Integer.valueOf(transportProtocolVersion));
        }
        catch (HandshakeException e) {
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (Exception e) {
            return this.responseCreator.unexpectedErrorResponse(portId, e);
        }
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="input-ports/{portId}/transactions/{transactionId}")
    @ApiOperation(value="Extend transaction TTL", response=TransactionResultEntity.class, authorizations={@Authorization(value="Write - /data-transfer/input-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response extendInputPortTransactionTTL(@PathParam(value="portId") String portId, @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context HttpServletResponse res, @Context ServletContext context, @Context UriInfo uriInfo, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.InputPort, portId));
        return this.extendPortTransactionTTL("input-ports", portId, transactionId, req, res, context, uriInfo, inputStream);
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="output-ports/{portId}/transactions/{transactionId}")
    @ApiOperation(value="Extend transaction TTL", response=TransactionResultEntity.class, authorizations={@Authorization(value="Write - /data-transfer/output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful."), @ApiResponse(code=503, message="NiFi instance is not ready for serving request, or temporarily overloaded. Retrying the same request later may be successful")})
    public Response extendOutputPortTransactionTTL(@PathParam(value="portId") String portId, @PathParam(value="transactionId") String transactionId, @Context HttpServletRequest req, @Context HttpServletResponse res, @Context ServletContext context, @Context UriInfo uriInfo, InputStream inputStream) {
        this.serviceFacade.authorizeAccess(lookup -> this.authorizeDataTransfer(lookup, ResourceType.OutputPort, portId));
        return this.extendPortTransactionTTL("output-ports", portId, transactionId, req, res, context, uriInfo, inputStream);
    }

    public Response extendPortTransactionTTL(String portType, String portId, String transactionId, HttpServletRequest req, HttpServletResponse res, ServletContext context, UriInfo uriInfo, InputStream inputStream) {
        ValidateRequestResult validationResult = this.validateResult(req, portId, transactionId);
        if (ValidateRequestResult.access$000((ValidateRequestResult)validationResult) != null) {
            return ValidateRequestResult.access$000((ValidateRequestResult)validationResult);
        }
        if (!"input-ports".equals(portType) && !"output-ports".equals(portType)) {
            return this.responseCreator.wrongPortTypeResponse(portType, portId);
        }
        logger.debug("extendOutputPortTransactionTTL request: portType={}, portId={}, transactionId={}", new Object[]{portType, portId, transactionId});
        int transportProtocolVersion = ValidateRequestResult.access$100((ValidateRequestResult)validationResult);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Peer peer = this.constructPeer(req, inputStream, (OutputStream)out, portId, transactionId);
        try {
            this.initiateServerProtocol(req, peer, Integer.valueOf(transportProtocolVersion));
            this.transactionManager.extendTransaction(transactionId);
            TransactionResultEntity entity = new TransactionResultEntity();
            entity.setResponseCode(ResponseCode.CONTINUE_TRANSACTION.getCode());
            entity.setMessage("Extended TTL.");
            return this.clusterContext(this.noCache(this.setCommonHeaders(Response.ok((Object)entity), Integer.valueOf(transportProtocolVersion), this.transactionManager))).build();
        }
        catch (HandshakeException e) {
            return this.responseCreator.handshakeExceptionResponse(e);
        }
        catch (Exception e) {
            return this.responseCreator.unexpectedErrorResponse(portId, transactionId, e);
        }
    }

    private ValidateRequestResult validateResult(HttpServletRequest req, String portId) {
        return this.validateResult(req, portId, null);
    }

    private ValidateRequestResult validateResult(HttpServletRequest req, String portId, String transactionId) {
        ValidateRequestResult result = new ValidateRequestResult(this, null);
        if (!this.properties.isSiteToSiteHttpEnabled().booleanValue()) {
            ValidateRequestResult.access$002((ValidateRequestResult)result, (Response)this.responseCreator.httpSiteToSiteIsNotEnabledResponse());
            return result;
        }
        try {
            ValidateRequestResult.access$102((ValidateRequestResult)result, (Integer)this.negotiateTransportProtocolVersion(req, this.transportProtocolVersionNegotiator));
        }
        catch (BadRequestException e) {
            ValidateRequestResult.access$002((ValidateRequestResult)result, (Response)this.responseCreator.badRequestResponse((Exception)((Object)e)));
            return result;
        }
        if (!StringUtils.isEmpty((CharSequence)transactionId) && !this.transactionManager.isTransactionActive(transactionId)) {
            ValidateRequestResult.access$002((ValidateRequestResult)result, (Response)this.responseCreator.transactionNotFoundResponse(portId, transactionId));
            return result;
        }
        return result;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    static /* synthetic */ Logger access$200() {
        return logger;
    }
}

