/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.util.ComponentIdGenerator;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.ComponentDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnippetUtils {
    private static final Logger logger = LoggerFactory.getLogger(SnippetUtils.class);
    private static final SecureRandom randomGenerator = new SecureRandom();
    private FlowController flowController;
    private DtoFactory dtoFactory;
    private AccessPolicyDAO accessPolicyDAO;

    public FlowSnippetDTO populateFlowSnippet(Snippet snippet, boolean recurse, boolean includeControllerServices, boolean removeInstanceId) {
        FlowSnippetDTO snippetDto = new FlowSnippetDTO(removeInstanceId);
        String groupId = snippet.getParentGroupId();
        ProcessGroup processGroup = this.flowController.getFlowManager().getGroup(groupId);
        if (processGroup == null) {
            throw new IllegalStateException("The parent process group for this snippet could not be found.");
        }
        HashSet allServicesReferenced = new HashSet();
        HashMap<String, ProcessGroupDTO> contentsByGroup = new HashMap<String, ProcessGroupDTO>();
        ProcessGroupDTO highestProcessGroupDTO = this.dtoFactory.createProcessGroupDto(processGroup, recurse);
        contentsByGroup.put(processGroup.getIdentifier(), highestProcessGroupDTO);
        HashSet controllerServices = new HashSet();
        LinkedHashSet<ProcessorDTO> processors = new LinkedHashSet<ProcessorDTO>();
        if (!snippet.getProcessors().isEmpty()) {
            for (Object processorId : snippet.getProcessors().keySet()) {
                ProcessorNode processor = processGroup.getProcessor((String)processorId);
                if (processor == null) {
                    throw new IllegalStateException("A processor in this snippet could not be found.");
                }
                processors.add(this.dtoFactory.createProcessorDto(processor));
                if (!includeControllerServices) continue;
                this.getControllerServices(processor.getEffectivePropertyValues()).stream().filter(allServicesReferenced::add).forEach(svc -> {
                    String svcGroupId = svc.getParentGroupId();
                    String destinationGroupId = contentsByGroup.containsKey(svcGroupId) ? svcGroupId : processGroup.getIdentifier();
                    svc.setParentGroupId(destinationGroupId);
                    controllerServices.add(svc);
                });
            }
        }
        LinkedHashSet<ConnectionDTO> connections = new LinkedHashSet<ConnectionDTO>();
        if (!snippet.getConnections().isEmpty()) {
            for (Object connectionId : snippet.getConnections().keySet()) {
                Connection connection = processGroup.getConnection((String)connectionId);
                if (connection == null) {
                    throw new IllegalStateException("A connection in this snippet could not be found.");
                }
                connections.add(this.dtoFactory.createConnectionDto(connection));
            }
        }
        LinkedHashSet<FunnelDTO> funnels = new LinkedHashSet<FunnelDTO>();
        if (!snippet.getFunnels().isEmpty()) {
            for (Object funnelId : snippet.getFunnels().keySet()) {
                Funnel funnel = processGroup.getFunnel((String)funnelId);
                if (funnel == null) {
                    throw new IllegalStateException("A funnel in this snippet could not be found.");
                }
                funnels.add(this.dtoFactory.createFunnelDto(funnel));
            }
        }
        LinkedHashSet<PortDTO> inputPorts = new LinkedHashSet<PortDTO>();
        if (!snippet.getInputPorts().isEmpty()) {
            for (Object inputPortId : snippet.getInputPorts().keySet()) {
                Port inputPort = processGroup.getInputPort((String)inputPortId);
                if (inputPort == null) {
                    throw new IllegalStateException("An input port in this snippet could not be found.");
                }
                inputPorts.add(this.dtoFactory.createPortDto(inputPort));
            }
        }
        LinkedHashSet<LabelDTO> labels = new LinkedHashSet<LabelDTO>();
        if (!snippet.getLabels().isEmpty()) {
            for (Object labelId : snippet.getLabels().keySet()) {
                Label label = processGroup.getLabel((String)labelId);
                if (label == null) {
                    throw new IllegalStateException("A label in this snippet could not be found.");
                }
                labels.add(this.dtoFactory.createLabelDto(label));
            }
        }
        LinkedHashSet<PortDTO> outputPorts = new LinkedHashSet<PortDTO>();
        if (!snippet.getOutputPorts().isEmpty()) {
            for (String outputPortId : snippet.getOutputPorts().keySet()) {
                Port outputPort = processGroup.getOutputPort(outputPortId);
                if (outputPort == null) {
                    throw new IllegalStateException("An output port in this snippet could not be found.");
                }
                outputPorts.add(this.dtoFactory.createPortDto(outputPort));
            }
        }
        LinkedHashSet<ProcessGroupDTO> processGroups = new LinkedHashSet<ProcessGroupDTO>();
        if (!snippet.getProcessGroups().isEmpty()) {
            Set snippetGroupIds = snippet.getProcessGroups().keySet();
            for (ProcessGroupDTO group : highestProcessGroupDTO.getContents().getProcessGroups()) {
                if (!snippetGroupIds.contains(group.getId())) continue;
                contentsByGroup.put(group.getId(), group);
                this.addChildren(group, contentsByGroup);
            }
            for (String childGroupId : snippet.getProcessGroups().keySet()) {
                ProcessGroup childGroup = processGroup.getProcessGroup(childGroupId);
                if (childGroup == null) {
                    throw new IllegalStateException("A process group in this snippet could not be found.");
                }
                ProcessGroupDTO childGroupDto = (ProcessGroupDTO)contentsByGroup.get(childGroupId);
                HashSet visitedGroupIds = new HashSet();
                this.addControllerServices(childGroup, childGroupDto.getContents(), allServicesReferenced, includeControllerServices, visitedGroupIds, contentsByGroup, processGroup.getIdentifier());
                processGroups.add(childGroupDto);
            }
        }
        LinkedHashSet<RemoteProcessGroupDTO> remoteProcessGroups = new LinkedHashSet<RemoteProcessGroupDTO>();
        if (!snippet.getRemoteProcessGroups().isEmpty()) {
            for (String remoteProcessGroupId : snippet.getRemoteProcessGroups().keySet()) {
                RemoteProcessGroup remoteProcessGroup = processGroup.getRemoteProcessGroup(remoteProcessGroupId);
                if (remoteProcessGroup == null) {
                    throw new IllegalStateException("A remote process group in this snippet could not be found.");
                }
                remoteProcessGroups.add(this.dtoFactory.createRemoteProcessGroupDto(remoteProcessGroup));
            }
        }
        ArrayList<Object> components = new ArrayList<Object>();
        components.addAll(processors);
        components.addAll(connections);
        components.addAll(funnels);
        components.addAll(inputPorts);
        components.addAll(labels);
        components.addAll(outputPorts);
        components.addAll(processGroups);
        components.addAll(remoteProcessGroups);
        this.normalizeCoordinates(components);
        HashSet updatedControllerServices = ((ProcessGroupDTO)contentsByGroup.get(processGroup.getIdentifier())).getContents().getControllerServices();
        if (updatedControllerServices == null) {
            updatedControllerServices = new HashSet();
        }
        updatedControllerServices.addAll(controllerServices);
        snippetDto.setControllerServices(updatedControllerServices);
        snippetDto.setProcessors(processors);
        snippetDto.setConnections(connections);
        snippetDto.setFunnels(funnels);
        snippetDto.setInputPorts(inputPorts);
        snippetDto.setLabels(labels);
        snippetDto.setOutputPorts(outputPorts);
        snippetDto.setProcessGroups(processGroups);
        snippetDto.setRemoteProcessGroups(remoteProcessGroups);
        return snippetDto;
    }

    private void addChildren(ProcessGroupDTO processGroup, Map<String, ProcessGroupDTO> contentByGroupMap) {
        for (ProcessGroupDTO group : processGroup.getContents().getProcessGroups()) {
            contentByGroupMap.put(group.getId(), group);
            this.addChildren(group, contentByGroupMap);
        }
    }

    private void addControllerServices(ProcessGroup group, FlowSnippetDTO contents, Set<ControllerServiceDTO> allServicesReferenced, boolean includeControllerServices, Set<String> visitedGroupIds, Map<String, ProcessGroupDTO> contentsByGroup, String highestGroupId) {
        visitedGroupIds.add(group.getIdentifier());
        for (ProcessorNode procNode : group.getProcessors()) {
            this.getControllerServices(procNode.getEffectivePropertyValues()).stream().filter(allServicesReferenced::add).filter(svc -> includeControllerServices || visitedGroupIds.contains(svc.getParentGroupId())).forEach(svc -> {
                String svcGroupId = svc.getParentGroupId();
                String destinationGroupId = contentsByGroup.containsKey(svcGroupId) ? svcGroupId : highestGroupId;
                svc.setParentGroupId(destinationGroupId);
                FlowSnippetDTO snippetDto = ((ProcessGroupDTO)contentsByGroup.get(destinationGroupId)).getContents();
                if (snippetDto != null) {
                    Set services = snippetDto.getControllerServices();
                    if (services == null) {
                        snippetDto.setControllerServices(Collections.singleton(svc));
                    } else {
                        services.add(svc);
                        snippetDto.setControllerServices(services);
                    }
                }
            });
        }
        for (ControllerServiceNode csNode : group.getControllerServices(false)) {
            ControllerServiceDTO serviceDto;
            if (csNode == null || !allServicesReferenced.add(serviceDto = this.dtoFactory.createControllerServiceDto(csNode))) continue;
            contents.getControllerServices().add(serviceDto);
        }
        Map<String, ProcessGroupDTO> childGroupMap = contents.getProcessGroups().stream().collect(Collectors.toMap(ComponentDTO::getId, childGroupDto -> childGroupDto));
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            ProcessGroupDTO childDto = childGroupMap.get(childGroup.getIdentifier());
            if (childDto == null) continue;
            this.addControllerServices(childGroup, childDto.getContents(), allServicesReferenced, includeControllerServices, visitedGroupIds, contentsByGroup, highestGroupId);
        }
    }

    private Set<ControllerServiceDTO> getControllerServices(Map<PropertyDescriptor, String> componentProperties) {
        HashSet<ControllerServiceDTO> serviceDtos = new HashSet<ControllerServiceDTO>();
        for (Map.Entry<PropertyDescriptor, String> entry : componentProperties.entrySet()) {
            ControllerServiceNode serviceNode;
            String controllerServiceId;
            PropertyDescriptor descriptor = entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (controllerServiceId = entry.getValue()) == null || (serviceNode = this.flowController.getFlowManager().getControllerServiceNode(controllerServiceId)) == null) continue;
            serviceDtos.add(this.dtoFactory.createControllerServiceDto(serviceNode));
            Set recursiveRefs = this.getControllerServices(serviceNode.getEffectivePropertyValues());
            serviceDtos.addAll(recursiveRefs);
        }
        return serviceDtos;
    }

    public FlowSnippetDTO copy(FlowSnippetDTO snippetContents, ProcessGroup group, String idGenerationSeed, boolean isCopy) {
        FlowSnippetDTO snippetCopy = this.copyContentsForGroup(snippetContents, group.getIdentifier(), null, null, idGenerationSeed, isCopy);
        this.resolveNameConflicts(snippetCopy, group);
        this.removeTopLevelVersionedIds(snippetContents);
        return snippetCopy;
    }

    private void removeTopLevelVersionedIds(FlowSnippetDTO snippetContents) {
        this.removeVersionedIds((Collection)snippetContents.getProcessors());
        this.removeVersionedIds((Collection)snippetContents.getLabels());
        this.removeVersionedIds((Collection)snippetContents.getConnections());
        this.removeVersionedIds((Collection)snippetContents.getInputPorts());
        this.removeVersionedIds((Collection)snippetContents.getOutputPorts());
        this.removeVersionedIds((Collection)snippetContents.getRemoteProcessGroups());
        this.removeVersionedIds((Collection)snippetContents.getFunnels());
    }

    private <T extends ComponentDTO> void removeVersionedIds(Collection<T> components) {
        if (components != null) {
            components.forEach(c -> c.setVersionedComponentId(null));
        }
    }

    private void resolveNameConflicts(FlowSnippetDTO snippetContents, ProcessGroup group) {
        String portName;
        ArrayList<String> existingPortNames = new ArrayList<String>();
        for (Port inputPort : group.getInputPorts()) {
            existingPortNames.add(inputPort.getName());
        }
        for (Port outputPort : group.getOutputPorts()) {
            existingPortNames.add(outputPort.getName());
        }
        if (snippetContents.getInputPorts() != null) {
            for (Object portDTO : snippetContents.getInputPorts()) {
                portName = portDTO.getName();
                while (existingPortNames.contains(portName)) {
                    portName = "Copy of " + portName;
                }
                portDTO.setName(portName);
                existingPortNames.add(portDTO.getName());
            }
        }
        if (snippetContents.getOutputPorts() != null) {
            for (Object portDTO : snippetContents.getOutputPorts()) {
                portName = portDTO.getName();
                while (existingPortNames.contains(portName)) {
                    portName = "Copy of " + portName;
                }
                portDTO.setName(portName);
                existingPortNames.add(portDTO.getName());
            }
        }
        HashSet<String> groupNames = new HashSet<String>();
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            groupNames.add(childGroup.getName());
        }
        if (snippetContents.getProcessGroups() != null) {
            for (ProcessGroupDTO groupDTO : snippetContents.getProcessGroups()) {
                if (groupDTO.getVersionControlInformation() == null) {
                    String groupName = groupDTO.getName();
                    while (groupNames.contains(groupName)) {
                        groupName = "Copy of " + groupName;
                    }
                    groupDTO.setName(groupName);
                }
                groupNames.add(groupDTO.getName());
            }
        }
        ArrayList<String> existingLogFileSuffixes = new ArrayList<String>();
        for (ProcessGroup processGroup : group.getProcessGroups()) {
            if (processGroup.getLogFileSuffix() == null) continue;
            existingLogFileSuffixes.add(processGroup.getLogFileSuffix());
        }
        if (snippetContents.getProcessGroups() != null) {
            for (ProcessGroupDTO processGroupDTO : snippetContents.getProcessGroups()) {
                String logFileSuffix = processGroupDTO.getLogFileSuffix();
                if (logFileSuffix == null || logFileSuffix.trim().isEmpty()) continue;
                while (existingLogFileSuffixes.contains(logFileSuffix)) {
                    logFileSuffix = "Copy_of_" + logFileSuffix;
                }
                processGroupDTO.setLogFileSuffix(logFileSuffix);
                existingLogFileSuffixes.add(processGroupDTO.getLogFileSuffix());
            }
        }
    }

    private FlowSnippetDTO copyContentsForGroup(FlowSnippetDTO snippetContents, String groupId, Map<String, ConnectableDTO> parentConnectableMap, Map<String, String> serviceIdMap, String idGenerationSeed, boolean isCopy) {
        FlowSnippetDTO snippetContentsCopy = new FlowSnippetDTO();
        try {
            if (serviceIdMap == null) {
                serviceIdMap = new HashMap<String, String>();
            }
            HashSet<ControllerServiceDTO> services = new HashSet<ControllerServiceDTO>();
            if (snippetContents.getControllerServices() != null) {
                for (ControllerServiceDTO controllerServiceDTO : snippetContents.getControllerServices()) {
                    ControllerServiceDTO service = this.dtoFactory.copy(controllerServiceDTO);
                    service.setId(this.generateId(controllerServiceDTO.getId(), idGenerationSeed, isCopy));
                    service.setState(ControllerServiceState.DISABLED.name());
                    services.add(service);
                    serviceIdMap.put(controllerServiceDTO.getId(), service.getId());
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)controllerServiceDTO.getId(), (String)controllerServiceDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)service.getId(), (String)service.getName()), idGenerationSeed);
                }
            }
            for (ControllerServiceDTO controllerServiceDTO : services) {
                Map properties = controllerServiceDTO.getProperties();
                Map descriptors = controllerServiceDTO.getDescriptors();
                if (properties == null || descriptors == null) continue;
                for (PropertyDescriptorDTO descriptor : descriptors.values()) {
                    String newServiceId;
                    String currentServiceId;
                    if (descriptor.getIdentifiesControllerService() == null || (currentServiceId = (String)properties.get(descriptor.getName())) == null || (newServiceId = serviceIdMap.get(currentServiceId)) == null) continue;
                    properties.put(descriptor.getName(), newServiceId);
                }
            }
            snippetContentsCopy.setControllerServices(services);
            HashSet<Object> labels = new HashSet<Object>();
            if (snippetContents.getLabels() != null) {
                for (LabelDTO labelDTO : snippetContents.getLabels()) {
                    LabelDTO label = this.dtoFactory.copy(labelDTO);
                    label.setId(this.generateId(labelDTO.getId(), idGenerationSeed, isCopy));
                    label.setParentGroupId(groupId);
                    labels.add(label);
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.Label, (String)labelDTO.getId(), (String)labelDTO.getLabel()), ResourceFactory.getComponentResource((ResourceType)ResourceType.Label, (String)label.getId(), (String)label.getLabel()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setLabels(labels);
            HashMap<String, ConnectableDTO> hashMap = new HashMap<String, ConnectableDTO>();
            HashSet<FunnelDTO> funnels = new HashSet<FunnelDTO>();
            if (snippetContents.getFunnels() != null) {
                for (Object funnelDTO : snippetContents.getFunnels()) {
                    FunnelDTO cp = this.dtoFactory.copy((FunnelDTO)funnelDTO);
                    cp.setId(this.generateId(funnelDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    funnels.add(cp);
                    hashMap.put(funnelDTO.getParentGroupId() + "-" + funnelDTO.getId(), this.dtoFactory.createConnectableDto(cp));
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.Funnel, (String)funnelDTO.getId(), (String)funnelDTO.getId()), ResourceFactory.getComponentResource((ResourceType)ResourceType.Funnel, (String)cp.getId(), (String)cp.getId()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setFunnels(funnels);
            HashSet<PortDTO> inputPorts = new HashSet<PortDTO>();
            if (snippetContents.getInputPorts() != null) {
                for (Object portDTO : snippetContents.getInputPorts()) {
                    PortDTO cp = this.dtoFactory.copy((PortDTO)portDTO);
                    cp.setId(this.generateId(portDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    if (portDTO.getState() != null && portDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                        cp.setState(ScheduledState.DISABLED.toString());
                    } else {
                        cp.setState(ScheduledState.STOPPED.toString());
                    }
                    inputPorts.add(cp);
                    ConnectableDTO portConnectable = this.dtoFactory.createConnectableDto(cp, ConnectableType.INPUT_PORT);
                    hashMap.put(portDTO.getParentGroupId() + "-" + portDTO.getId(), portConnectable);
                    if (parentConnectableMap != null) {
                        parentConnectableMap.put(portDTO.getParentGroupId() + "-" + portDTO.getId(), portConnectable);
                    }
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.InputPort, (String)portDTO.getId(), (String)portDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.InputPort, (String)cp.getId(), (String)cp.getName()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setInputPorts(inputPorts);
            HashSet<PortDTO> outputPorts = new HashSet<PortDTO>();
            if (snippetContents.getOutputPorts() != null) {
                for (Object portDTO : snippetContents.getOutputPorts()) {
                    PortDTO cp = this.dtoFactory.copy((PortDTO)portDTO);
                    cp.setId(this.generateId(portDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    if (portDTO.getState() != null && portDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                        cp.setState(ScheduledState.DISABLED.toString());
                    } else {
                        cp.setState(ScheduledState.STOPPED.toString());
                    }
                    outputPorts.add(cp);
                    ConnectableDTO portConnectable = this.dtoFactory.createConnectableDto(cp, ConnectableType.OUTPUT_PORT);
                    hashMap.put(portDTO.getParentGroupId() + "-" + portDTO.getId(), portConnectable);
                    if (parentConnectableMap != null) {
                        parentConnectableMap.put(portDTO.getParentGroupId() + "-" + portDTO.getId(), portConnectable);
                    }
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.OutputPort, (String)portDTO.getId(), (String)portDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.OutputPort, (String)cp.getId(), (String)cp.getName()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setOutputPorts(outputPorts);
            HashSet<ProcessorDTO> processors = new HashSet<ProcessorDTO>();
            if (snippetContents.getProcessors() != null) {
                for (Object processorDTO : snippetContents.getProcessors()) {
                    ProcessorDTO cp = this.dtoFactory.copy((ProcessorDTO)processorDTO);
                    cp.setId(this.generateId(processorDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    if (processorDTO.getState() != null && processorDTO.getState().equals(ScheduledState.DISABLED.toString())) {
                        cp.setState(ScheduledState.DISABLED.toString());
                    } else {
                        cp.setState(ScheduledState.STOPPED.toString());
                    }
                    processors.add(cp);
                    hashMap.put(processorDTO.getParentGroupId() + "-" + processorDTO.getId(), this.dtoFactory.createConnectableDto(cp));
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.Processor, (String)processorDTO.getId(), (String)processorDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.Processor, (String)cp.getId(), (String)cp.getName()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setProcessors(processors);
            this.updateControllerServiceIdentifiers(snippetContentsCopy, serviceIdMap);
            HashSet<ProcessGroupDTO> groups = new HashSet<ProcessGroupDTO>();
            if (snippetContents.getProcessGroups() != null) {
                for (Object groupDTO : snippetContents.getProcessGroups()) {
                    ProcessGroupDTO cp = this.dtoFactory.copy((ProcessGroupDTO)groupDTO, false);
                    cp.setId(this.generateId(groupDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    FlowSnippetDTO contentsCopy = this.copyContentsForGroup(groupDTO.getContents(), cp.getId(), hashMap, serviceIdMap, idGenerationSeed, isCopy);
                    cp.setContents(contentsCopy);
                    groups.add(cp);
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.ProcessGroup, (String)groupDTO.getId(), (String)groupDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.ProcessGroup, (String)cp.getId(), (String)cp.getName()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setProcessGroups(groups);
            HashSet<RemoteProcessGroupDTO> remoteGroups = new HashSet<RemoteProcessGroupDTO>();
            if (snippetContents.getRemoteProcessGroups() != null) {
                for (RemoteProcessGroupDTO remoteGroupDTO : snippetContents.getRemoteProcessGroups()) {
                    String originalId;
                    RemoteProcessGroupDTO cp = this.dtoFactory.copy(remoteGroupDTO);
                    cp.setId(this.generateId(remoteGroupDTO.getId(), idGenerationSeed, isCopy));
                    cp.setParentGroupId(groupId);
                    RemoteProcessGroupContentsDTO contents = cp.getContents();
                    if (contents != null && contents.getInputPorts() != null) {
                        for (RemoteProcessGroupPortDTO remotePort : contents.getInputPorts()) {
                            remotePort.setGroupId(cp.getId());
                            originalId = remotePort.getId();
                            if (remotePort.getTargetId() == null) {
                                remotePort.setTargetId(originalId);
                            }
                            remotePort.setId(this.generateId(remotePort.getId(), idGenerationSeed, isCopy));
                            hashMap.put(remoteGroupDTO.getId() + "-" + originalId, this.dtoFactory.createConnectableDto(remotePort, ConnectableType.REMOTE_INPUT_PORT));
                        }
                    }
                    if (contents != null && contents.getOutputPorts() != null) {
                        for (RemoteProcessGroupPortDTO remotePort : contents.getOutputPorts()) {
                            remotePort.setGroupId(cp.getId());
                            originalId = remotePort.getId();
                            if (remotePort.getTargetId() == null) {
                                remotePort.setTargetId(originalId);
                            }
                            remotePort.setId(this.generateId(remotePort.getId(), idGenerationSeed, isCopy));
                            hashMap.put(remoteGroupDTO.getId() + "-" + originalId, this.dtoFactory.createConnectableDto(remotePort, ConnectableType.REMOTE_OUTPUT_PORT));
                        }
                    }
                    remoteGroups.add(cp);
                    if (!isCopy) continue;
                    this.cloneComponentSpecificPolicies(ResourceFactory.getComponentResource((ResourceType)ResourceType.RemoteProcessGroup, (String)remoteGroupDTO.getId(), (String)remoteGroupDTO.getName()), ResourceFactory.getComponentResource((ResourceType)ResourceType.RemoteProcessGroup, (String)cp.getId(), (String)cp.getName()), idGenerationSeed);
                }
            }
            snippetContentsCopy.setRemoteProcessGroups(remoteGroups);
            HashSet<ConnectionDTO> connections = new HashSet<ConnectionDTO>();
            if (snippetContents.getConnections() != null) {
                for (ConnectionDTO connectionDTO : snippetContents.getConnections()) {
                    ConnectionDTO cp = this.dtoFactory.copy(connectionDTO);
                    ConnectableDTO source = (ConnectableDTO)hashMap.get(cp.getSource().getGroupId() + "-" + cp.getSource().getId());
                    ConnectableDTO destination = (ConnectableDTO)hashMap.get(cp.getDestination().getGroupId() + "-" + cp.getDestination().getId());
                    if (source == null || destination == null) {
                        throw new IllegalArgumentException("The flow snippet contains a Connection that references a component that is not included.");
                    }
                    cp.setId(this.generateId(connectionDTO.getId(), idGenerationSeed, isCopy));
                    cp.setSource(source);
                    cp.setDestination(destination);
                    cp.setParentGroupId(groupId);
                    connections.add(cp);
                }
            }
            snippetContentsCopy.setConnections(connections);
            return snippetContentsCopy;
        }
        catch (Exception e) {
            this.rollbackClonedPolicies(snippetContentsCopy);
            throw e;
        }
    }

    private void cloneComponentSpecificPolicies(Resource originalComponentResource, Resource clonedComponentResource, String idGenerationSeed) {
        if (!this.accessPolicyDAO.supportsConfigurableAuthorizer()) {
            return;
        }
        HashMap<Resource, Resource> resources = new HashMap<Resource, Resource>();
        resources.put(originalComponentResource, clonedComponentResource);
        resources.put(ResourceFactory.getDataResource((Resource)originalComponentResource), ResourceFactory.getDataResource((Resource)clonedComponentResource));
        resources.put(ResourceFactory.getProvenanceDataResource((Resource)originalComponentResource), ResourceFactory.getProvenanceDataResource((Resource)clonedComponentResource));
        resources.put(ResourceFactory.getDataTransferResource((Resource)originalComponentResource), ResourceFactory.getDataTransferResource((Resource)clonedComponentResource));
        resources.put(ResourceFactory.getPolicyResource((Resource)originalComponentResource), ResourceFactory.getPolicyResource((Resource)clonedComponentResource));
        for (Map.Entry entry : resources.entrySet()) {
            Resource originalResource = (Resource)entry.getKey();
            Resource cloneResource = (Resource)entry.getValue();
            for (RequestAction action : RequestAction.values()) {
                AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(action, originalResource.getIdentifier());
                if (accessPolicy == null) continue;
                AccessPolicyDTO cloneAccessPolicy = new AccessPolicyDTO();
                cloneAccessPolicy.setId(this.generateId(accessPolicy.getIdentifier(), idGenerationSeed, true));
                cloneAccessPolicy.setAction(accessPolicy.getAction().toString());
                cloneAccessPolicy.setResource(cloneResource.getIdentifier());
                HashSet users = new HashSet();
                accessPolicy.getUsers().forEach(userId -> {
                    TenantEntity entity = new TenantEntity();
                    entity.setId(userId);
                    users.add(entity);
                });
                cloneAccessPolicy.setUsers(users);
                HashSet groups = new HashSet();
                accessPolicy.getGroups().forEach(groupId -> {
                    TenantEntity entity = new TenantEntity();
                    entity.setId(groupId);
                    groups.add(entity);
                });
                cloneAccessPolicy.setUserGroups(groups);
                this.accessPolicyDAO.createAccessPolicy(cloneAccessPolicy);
            }
        }
    }

    public void rollbackClonedPolicies(FlowSnippetDTO snippet) {
        if (!this.accessPolicyDAO.supportsConfigurableAuthorizer()) {
            return;
        }
        snippet.getControllerServices().forEach(controllerServiceDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.ControllerService, (String)controllerServiceDTO.getId(), (String)controllerServiceDTO.getName())));
        snippet.getFunnels().forEach(funnelDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.Funnel, (String)funnelDTO.getId(), (String)funnelDTO.getId())));
        snippet.getInputPorts().forEach(inputPortDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.InputPort, (String)inputPortDTO.getId(), (String)inputPortDTO.getName())));
        snippet.getLabels().forEach(labelDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.Label, (String)labelDTO.getId(), (String)labelDTO.getLabel())));
        snippet.getOutputPorts().forEach(outputPortDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.OutputPort, (String)outputPortDTO.getId(), (String)outputPortDTO.getName())));
        snippet.getProcessors().forEach(processorDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.Processor, (String)processorDTO.getId(), (String)processorDTO.getName())));
        snippet.getRemoteProcessGroups().forEach(remoteProcessGroupDTO -> this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.RemoteProcessGroup, (String)remoteProcessGroupDTO.getId(), (String)remoteProcessGroupDTO.getName())));
        snippet.getProcessGroups().forEach(processGroupDTO -> {
            this.rollbackClonedPolicy(ResourceFactory.getComponentResource((ResourceType)ResourceType.ProcessGroup, (String)processGroupDTO.getId(), (String)processGroupDTO.getName()));
            if (processGroupDTO.getContents() != null) {
                this.rollbackClonedPolicies(processGroupDTO.getContents());
            }
        });
    }

    private void rollbackClonedPolicy(Resource componentResource) {
        if (!this.accessPolicyDAO.supportsConfigurableAuthorizer()) {
            return;
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        resources.add(componentResource);
        resources.add(ResourceFactory.getDataResource((Resource)componentResource));
        resources.add(ResourceFactory.getProvenanceDataResource((Resource)componentResource));
        resources.add(ResourceFactory.getDataTransferResource((Resource)componentResource));
        resources.add(ResourceFactory.getPolicyResource((Resource)componentResource));
        for (Resource resource : resources) {
            for (RequestAction action : RequestAction.values()) {
                AccessPolicy accessPolicy = this.accessPolicyDAO.getAccessPolicy(action, resource.getIdentifier());
                if (accessPolicy == null) continue;
                try {
                    this.accessPolicyDAO.deleteAccessPolicy(accessPolicy.getIdentifier());
                }
                catch (Exception e) {
                    logger.warn(String.format("Unable to clean up cloned access policy for %s %s after failed copy/paste action.", action, componentResource.getIdentifier()), (Throwable)e);
                }
            }
        }
    }

    private void updateControllerServiceIdentifiers(FlowSnippetDTO snippet, Map<String, String> serviceIdMap) {
        Set processors = snippet.getProcessors();
        if (processors != null) {
            for (ProcessorDTO processor : processors) {
                this.updateControllerServiceIdentifiers(processor.getConfig(), serviceIdMap);
            }
        }
        for (ProcessGroupDTO processGroupDto : snippet.getProcessGroups()) {
            this.updateControllerServiceIdentifiers(processGroupDto.getContents(), serviceIdMap);
        }
    }

    private void updateControllerServiceIdentifiers(ProcessorConfigDTO configDto, Map<String, String> serviceIdMap) {
        if (configDto == null) {
            return;
        }
        Map properties = configDto.getProperties();
        Map descriptors = configDto.getDescriptors();
        if (properties != null && descriptors != null) {
            for (PropertyDescriptorDTO descriptor : descriptors.values()) {
                String currentServiceId;
                if (descriptor.getIdentifiesControllerService() == null || (currentServiceId = (String)properties.get(descriptor.getName())) == null || !serviceIdMap.containsKey(currentServiceId)) continue;
                String newServiceId = serviceIdMap.get(currentServiceId);
                properties.put(descriptor.getName(), newServiceId);
            }
        }
    }

    private String generateId(String currentId, String seed, boolean isCopy) {
        UUID uuid;
        long msb = UUID.fromString(currentId).getMostSignificantBits();
        if (StringUtils.isBlank((CharSequence)seed)) {
            long lsb = randomGenerator.nextLong();
            uuid = isCopy ? ComponentIdGenerator.generateId((long)msb, (long)lsb, (boolean)true) : new UUID(msb, lsb);
        } else {
            UUID seedId = UUID.nameUUIDFromBytes((currentId + seed).getBytes(StandardCharsets.UTF_8));
            uuid = isCopy ? ComponentIdGenerator.generateId((long)seedId.getMostSignificantBits(), (long)seedId.getLeastSignificantBits(), (boolean)false) : new UUID(msb, seedId.getLeastSignificantBits());
        }
        logger.debug("Generating UUID {} from currentId={}, seed={}, isCopy={}", new Object[]{uuid, currentId, seed, isCopy});
        return uuid.toString();
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setAccessPolicyDAO(AccessPolicyDAO accessPolicyDAO) {
        this.accessPolicyDAO = accessPolicyDAO;
    }

    private void normalizeCoordinates(Collection<? extends ComponentDTO> components) {
        ConnectionDTO connection;
        double smallestX = Double.MAX_VALUE;
        double smallestY = Double.MAX_VALUE;
        for (ComponentDTO componentDTO : components) {
            if (componentDTO instanceof ConnectionDTO) {
                connection = (ConnectionDTO)componentDTO;
                for (PositionDTO position : connection.getBends()) {
                    smallestX = Math.min(smallestX, position.getX());
                    smallestY = Math.min(smallestY, position.getY());
                }
                continue;
            }
            smallestX = Math.min(smallestX, componentDTO.getPosition().getX());
            smallestY = Math.min(smallestY, componentDTO.getPosition().getY());
        }
        for (ComponentDTO componentDTO : components) {
            if (componentDTO instanceof ConnectionDTO) {
                connection = (ConnectionDTO)componentDTO;
                for (PositionDTO position : connection.getBends()) {
                    position.setX(Double.valueOf(position.getX() - smallestX));
                    position.setY(Double.valueOf(position.getY() - smallestY));
                }
                continue;
            }
            componentDTO.getPosition().setX(Double.valueOf(componentDTO.getPosition().getX() - smallestX));
            componentDTO.getPosition().setY(Double.valueOf(componentDTO.getPosition().getY() - smallestY));
        }
    }
}

