/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import java.util.Map;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class VariableRegistryMatcher
implements AttributeMatcher<ProcessGroup> {
    private static final String LABEL_NAME = "Variable Name";
    private static final String LABEL_VALUE = "Variable Value";

    public void match(ProcessGroup component, SearchQuery query, List<String> matches) {
        ComponentVariableRegistry variableRegistry = component.getVariableRegistry();
        if (variableRegistry != null) {
            for (Map.Entry entry : variableRegistry.getVariableMap().entrySet()) {
                AttributeMatcher.addIfMatching((String)query.getTerm(), (String)((VariableDescriptor)entry.getKey()).getName(), (String)LABEL_NAME, matches);
                AttributeMatcher.addIfMatching((String)query.getTerm(), (String)((String)entry.getValue()), (String)LABEL_VALUE, matches);
            }
        }
    }
}

