/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import com.sun.jersey.api.client.ClientResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.logging.NiFiLog;
import org.apache.nifi.stream.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientResponseUtils {
    private static final Logger logger = new NiFiLog(LoggerFactory.getLogger(ClientResponseUtils.class));

    public static void drainClientResponse(ClientResponse clientResponse) {
        if (clientResponse != null) {
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(clientResponse.getEntityInputStream());
                IOUtils.copy((InputStream)bis, (OutputStream)new NullOutputStream());
            }
            catch (IOException ioe) {
                try {
                    logger.info("Failed clearing out non-client response buffer due to: " + ioe, (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)bis);
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
    }
}

