/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardReportingTaskDAO;
import org.quartz.CronExpression;

public class StandardReportingTaskDAO
extends ComponentDAO
implements ReportingTaskDAO {
    private ReportingTaskProvider reportingTaskProvider;
    private ComponentStateDAO componentStateDAO;

    private ReportingTaskNode locateReportingTask(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.reportingTaskProvider.getReportingTaskNode(reportingTaskId);
        if (reportingTask == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate reporting task with id '%s'.", reportingTaskId));
        }
        return reportingTask;
    }

    public ReportingTaskNode createReportingTask(ReportingTaskDTO reportingTaskDTO) {
        if (reportingTaskDTO.getType() == null) {
            throw new IllegalArgumentException("The reporting task type must be specified.");
        }
        try {
            ReportingTaskNode reportingTask = this.reportingTaskProvider.createReportingTask(reportingTaskDTO.getType(), reportingTaskDTO.getId(), true);
            this.verifyUpdate(reportingTask, reportingTaskDTO);
            this.configureReportingTask(reportingTask, reportingTaskDTO);
            return reportingTask;
        }
        catch (ReportingTaskInstantiationException rtie) {
            throw new NiFiCoreException(rtie.getMessage(), (Throwable)rtie);
        }
    }

    public ReportingTaskNode getReportingTask(String reportingTaskId) {
        return this.locateReportingTask(reportingTaskId);
    }

    public boolean hasReportingTask(String reportingTaskId) {
        return this.reportingTaskProvider.getReportingTaskNode(reportingTaskId) != null;
    }

    public Set<ReportingTaskNode> getReportingTasks() {
        return this.reportingTaskProvider.getAllReportingTasks();
    }

    public ReportingTaskNode updateReportingTask(ReportingTaskDTO reportingTaskDTO) {
        ScheduledState purposedScheduledState;
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskDTO.getId());
        this.verifyUpdate(reportingTask, reportingTaskDTO);
        this.configureReportingTask(reportingTask, reportingTaskDTO);
        if (this.isNotNull((Object)reportingTaskDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)reportingTaskDTO.getState())).equals((Object)reportingTask.getScheduledState())) {
            try {
                block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                    case 1: {
                        this.reportingTaskProvider.startReportingTask(reportingTask);
                        break;
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[reportingTask.getScheduledState().ordinal()]) {
                            case 1: {
                                this.reportingTaskProvider.stopReportingTask(reportingTask);
                                break block1;
                            }
                            case 2: {
                                this.reportingTaskProvider.enableReportingTask(reportingTask);
                            }
                        }
                        break;
                    }
                    case 2: {
                        this.reportingTaskProvider.disableReportingTask(reportingTask);
                    }
                }
            }
            catch (IllegalStateException | ComponentLifeCycleException ise) {
                throw new NiFiCoreException(ise.getMessage(), ise);
            }
            catch (RejectedExecutionException ree) {
                throw new NiFiCoreException("Unable to schedule all tasks for the specified reporting task.", (Throwable)ree);
            }
            catch (NullPointerException npe) {
                throw new NiFiCoreException("Unable to update reporting task run state.", (Throwable)npe);
            }
            catch (Exception e) {
                throw new NiFiCoreException("Unable to update reporting task run state: " + e, (Throwable)e);
            }
        }
        return reportingTask;
    }

    private List<String> validateProposedConfiguration(ReportingTaskNode reportingTask, ReportingTaskDTO reportingTaskDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        SchedulingStrategy schedulingStrategy = reportingTask.getSchedulingStrategy();
        if (this.isNotNull((Object)reportingTaskDTO.getSchedulingStrategy())) {
            try {
                schedulingStrategy = SchedulingStrategy.valueOf((String)reportingTaskDTO.getSchedulingStrategy());
            }
            catch (IllegalArgumentException iae) {
                validationErrors.add(String.format("Scheduling strategy: Value must be one of [%s]", StringUtils.join((Object[])SchedulingStrategy.values(), (String)", ")));
            }
        }
        if (this.isNotNull((Object)reportingTaskDTO.getSchedulingPeriod())) {
            switch (1.$SwitchMap$org$apache$nifi$scheduling$SchedulingStrategy[schedulingStrategy.ordinal()]) {
                case 1: {
                    Matcher schedulingMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(reportingTaskDTO.getSchedulingPeriod());
                    if (schedulingMatcher.matches()) break;
                    validationErrors.add("Scheduling period is not a valid time duration (ie 30 sec, 5 min)");
                    break;
                }
                case 2: {
                    try {
                        new CronExpression(reportingTaskDTO.getSchedulingPeriod());
                        break;
                    }
                    catch (ParseException pe) {
                        throw new IllegalArgumentException(String.format("Scheduling Period '%s' is not a valid cron expression: %s", reportingTaskDTO.getSchedulingPeriod(), pe.getMessage()));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Scheduling Period is not a valid cron expression: " + reportingTaskDTO.getSchedulingPeriod());
                    }
                }
            }
        }
        return validationErrors;
    }

    public void verifyDelete(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskId);
        reportingTask.verifyCanDelete();
    }

    public void verifyUpdate(ReportingTaskDTO reportingTaskDTO) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskDTO.getId());
        this.verifyUpdate(reportingTask, reportingTaskDTO);
    }

    private void verifyUpdate(ReportingTaskNode reportingTask, ReportingTaskDTO reportingTaskDTO) {
        if (this.isNotNull((Object)reportingTaskDTO.getState())) {
            try {
                ScheduledState purposedScheduledState = ScheduledState.valueOf((String)reportingTaskDTO.getState());
                if (!purposedScheduledState.equals((Object)reportingTask.getScheduledState())) {
                    block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                        case 1: {
                            reportingTask.verifyCanStart();
                            break;
                        }
                        case 3: {
                            switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[reportingTask.getScheduledState().ordinal()]) {
                                case 1: {
                                    reportingTask.verifyCanStop();
                                    break block1;
                                }
                                case 2: {
                                    reportingTask.verifyCanEnable();
                                }
                            }
                            break;
                        }
                        case 2: {
                            reportingTask.verifyCanDisable();
                        }
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(String.format("The specified reporting task state (%s) is not valid. Valid options are 'RUNNING', 'STOPPED', and 'DISABLED'.", reportingTaskDTO.getState()));
            }
        }
        boolean modificationRequest = false;
        if (this.isAnyNotNull(new Object[]{reportingTaskDTO.getName(), reportingTaskDTO.getSchedulingStrategy(), reportingTaskDTO.getSchedulingPeriod(), reportingTaskDTO.getAnnotationData(), reportingTaskDTO.getProperties()})) {
            modificationRequest = true;
            List requestValidation = this.validateProposedConfiguration(reportingTask, reportingTaskDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
        }
        if (modificationRequest) {
            reportingTask.verifyCanUpdate();
        }
    }

    private void configureReportingTask(ReportingTaskNode reportingTask, ReportingTaskDTO reportingTaskDTO) {
        String name = reportingTaskDTO.getName();
        String schedulingStrategy = reportingTaskDTO.getSchedulingStrategy();
        String schedulingPeriod = reportingTaskDTO.getSchedulingPeriod();
        String annotationData = reportingTaskDTO.getAnnotationData();
        String comments = reportingTaskDTO.getComments();
        Map properties = reportingTaskDTO.getProperties();
        if (this.isNotNull((Object)schedulingStrategy)) {
            reportingTask.setSchedulingStrategy(SchedulingStrategy.valueOf((String)schedulingStrategy));
        }
        if (this.isNotNull((Object)name)) {
            reportingTask.setName(name);
        }
        if (this.isNotNull((Object)schedulingPeriod)) {
            reportingTask.setScheduldingPeriod(schedulingPeriod);
        }
        if (this.isNotNull((Object)annotationData)) {
            reportingTask.setAnnotationData(annotationData);
        }
        if (this.isNotNull((Object)comments)) {
            reportingTask.setComments(comments);
        }
        if (this.isNotNull((Object)properties)) {
            for (Map.Entry entry : properties.entrySet()) {
                String propName = (String)entry.getKey();
                String propVal = (String)entry.getValue();
                if (this.isNotNull((Object)propName) && propVal == null) {
                    reportingTask.removeProperty(propName);
                    continue;
                }
                if (!this.isNotNull((Object)propName)) continue;
                reportingTask.setProperty(propName, propVal);
            }
        }
    }

    public void deleteReportingTask(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskId);
        this.reportingTaskProvider.removeReportingTask(reportingTask);
    }

    public StateMap getState(String reportingTaskId, Scope scope) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskId);
        return this.componentStateDAO.getState(reportingTask, scope);
    }

    public void verifyClearState(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskId);
        reportingTask.verifyCanClearState();
    }

    public void clearState(String reportingTaskId) {
        ReportingTaskNode reportingTask = this.locateReportingTask(reportingTaskId);
        this.componentStateDAO.clearState(reportingTask);
    }

    public void setReportingTaskProvider(ReportingTaskProvider reportingTaskProvider) {
        this.reportingTaskProvider = reportingTaskProvider;
    }

    public void setComponentStateDAO(ComponentStateDAO componentStateDAO) {
        this.componentStateDAO = componentStateDAO;
    }
}

