/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.authorization.AbstractPolicyBasedAuthorizer;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.UserDAO;
import org.apache.nifi.web.dao.UserGroupDAO;

public class StandardPolicyBasedAuthorizerDAO
implements AccessPolicyDAO,
UserGroupDAO,
UserDAO {
    private final AbstractPolicyBasedAuthorizer authorizer;
    private final boolean supportsConfigurableAuthorizer;

    public StandardPolicyBasedAuthorizerDAO(Authorizer authorizer) {
        if (authorizer instanceof AbstractPolicyBasedAuthorizer) {
            this.authorizer = (AbstractPolicyBasedAuthorizer)authorizer;
            this.supportsConfigurableAuthorizer = true;
        } else {
            this.authorizer = new /* Unavailable Anonymous Inner Class!! */;
            this.supportsConfigurableAuthorizer = false;
        }
    }

    private AccessPolicy findAccessPolicy(RequestAction requestAction, String resource) {
        return this.authorizer.getAccessPolicies().stream().filter(policy -> policy.getAction().equals((Object)requestAction) && policy.getResource().equals(resource)).findFirst().orElse(null);
    }

    public boolean supportsConfigurableAuthorizer() {
        return this.supportsConfigurableAuthorizer;
    }

    public boolean hasAccessPolicy(String accessPolicyId) {
        return this.authorizer.getAccessPolicy(accessPolicyId) != null;
    }

    public AccessPolicy createAccessPolicy(AccessPolicyDTO accessPolicyDTO) {
        return this.authorizer.addAccessPolicy(this.buildAccessPolicy(accessPolicyDTO.getId(), accessPolicyDTO.getResource(), RequestAction.valueOfValue((String)accessPolicyDTO.getAction()), accessPolicyDTO));
    }

    public AccessPolicy getAccessPolicy(String accessPolicyId) {
        AccessPolicy accessPolicy = this.authorizer.getAccessPolicy(accessPolicyId);
        if (accessPolicy == null) {
            throw new ResourceNotFoundException(String.format("Unable to find access policy with id '%s'.", accessPolicyId));
        }
        return accessPolicy;
    }

    public AccessPolicy getAccessPolicy(RequestAction requestAction, String resource) {
        return this.findAccessPolicy(requestAction, resource);
    }

    public AccessPolicy getAccessPolicy(RequestAction requestAction, Authorizable authorizable) {
        String resource = authorizable.getResource().getIdentifier();
        AccessPolicy accessPolicy = this.findAccessPolicy(requestAction, authorizable.getResource().getIdentifier());
        if (accessPolicy == null) {
            Authorizable parentAuthorizable = authorizable.getParentAuthorizable();
            if (parentAuthorizable == null) {
                throw new ResourceNotFoundException(String.format("Unable to find access policy for %s on %s", requestAction.toString(), resource));
            }
            return this.getAccessPolicy(requestAction, parentAuthorizable);
        }
        return accessPolicy;
    }

    public AccessPolicy updateAccessPolicy(AccessPolicyDTO accessPolicyDTO) {
        AccessPolicy currentAccessPolicy = this.getAccessPolicy(accessPolicyDTO.getId());
        return this.authorizer.updateAccessPolicy(this.buildAccessPolicy(currentAccessPolicy.getIdentifier(), currentAccessPolicy.getResource(), currentAccessPolicy.getAction(), accessPolicyDTO));
    }

    public AccessPolicy deleteAccessPolicy(String accessPolicyId) {
        return this.authorizer.deleteAccessPolicy(this.getAccessPolicy(accessPolicyId));
    }

    private AccessPolicy buildAccessPolicy(String identifier, String resource, RequestAction action, AccessPolicyDTO accessPolicyDTO) {
        Set userGroups = accessPolicyDTO.getUserGroups();
        Set users = accessPolicyDTO.getUsers();
        AccessPolicy.Builder builder = new AccessPolicy.Builder().identifier(identifier).resource(resource);
        if (userGroups != null) {
            builder.addGroups(userGroups.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        if (users != null) {
            builder.addUsers(users.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        builder.action(action);
        return builder.build();
    }

    public boolean hasUserGroup(String userGroupId) {
        return this.authorizer.getGroup(userGroupId) != null;
    }

    public Group createUserGroup(UserGroupDTO userGroupDTO) {
        return this.authorizer.addGroup(this.buildUserGroup(userGroupDTO.getId(), userGroupDTO));
    }

    public Group getUserGroup(String userGroupId) {
        Group userGroup = this.authorizer.getGroup(userGroupId);
        if (userGroup == null) {
            throw new ResourceNotFoundException(String.format("Unable to find user group with id '%s'.", userGroupId));
        }
        return userGroup;
    }

    public Set<Group> getUserGroupsForUser(String userId) {
        return this.authorizer.getGroups().stream().filter(g -> g.getUsers().contains(userId)).collect(Collectors.toSet());
    }

    public Set<AccessPolicy> getAccessPoliciesForUser(String userId) {
        return this.authorizer.getAccessPolicies().stream().filter(p -> {
            if (p.getUsers().contains(userId)) {
                return true;
            }
            return !p.getGroups().stream().filter(g -> this.authorizer.getGroup(g).getUsers().contains(userId)).collect(Collectors.toSet()).isEmpty();
        }).collect(Collectors.toSet());
    }

    public Set<Group> getUserGroups() {
        return this.authorizer.getGroups();
    }

    public Group updateUserGroup(UserGroupDTO userGroupDTO) {
        return this.authorizer.updateGroup(this.buildUserGroup(this.getUserGroup(userGroupDTO.getId()).getIdentifier(), userGroupDTO));
    }

    public Group deleteUserGroup(String userGroupId) {
        return this.authorizer.deleteGroup(this.getUserGroup(userGroupId));
    }

    private Group buildUserGroup(String identifier, UserGroupDTO userGroupDTO) {
        Set users = userGroupDTO.getUsers();
        Group.Builder builder = new Group.Builder().identifier(identifier).name(userGroupDTO.getIdentity());
        if (users != null) {
            builder.addUsers(users.stream().map(ComponentEntity::getId).collect(Collectors.toSet()));
        }
        return builder.build();
    }

    public boolean hasUser(String userId) {
        return this.authorizer.getUser(userId) != null;
    }

    public User createUser(UserDTO userDTO) {
        return this.authorizer.addUser(this.buildUser(userDTO.getId(), userDTO));
    }

    public User getUser(String userId) {
        User user = this.authorizer.getUser(userId);
        if (user == null) {
            throw new ResourceNotFoundException(String.format("Unable to find user with id '%s'.", userId));
        }
        return user;
    }

    public Set<User> getUsers() {
        return this.authorizer.getUsers();
    }

    public User updateUser(UserDTO userDTO) {
        return this.authorizer.updateUser(this.buildUser(this.getUser(userDTO.getId()).getIdentifier(), userDTO));
    }

    public User deleteUser(String userId) {
        User user = this.getUser(userId);
        return this.authorizer.deleteUser(user);
    }

    private User buildUser(String identifier, UserDTO userDTO) {
        User.Builder builder = new User.Builder().identifier(identifier).identity(userDTO.getIdentity());
        return builder.build();
    }
}

