/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.client.http.TransportProtocolVersionNegotiator;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.remote.PeerDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;
import org.apache.nifi.web.api.entity.PeersEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/site-to-site")
@Api(value="/site-to-site", description="Provide access to site to site with this NiFi")
public class SiteToSiteResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(SiteToSiteResource.class);
    private NiFiServiceFacade serviceFacade;
    private ClusterCoordinator clusterCoordinator;
    private Authorizer authorizer;
    private final ApplicationResource.ResponseCreator responseCreator = new ApplicationResource.ResponseCreator((ApplicationResource)this);
    private final VersionNegotiator transportProtocolVersionNegotiator = new TransportProtocolVersionNegotiator(new int[]{1});
    private final HttpRemoteSiteListener transactionManager;

    public SiteToSiteResource(NiFiProperties nifiProperties) {
        this.transactionManager = HttpRemoteSiteListener.getInstance((NiFiProperties)nifiProperties);
    }

    protected void authorizeSiteToSite() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getSiteToSiteResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(RequestAction.READ).build();
        AuthorizationResult result = this.authorizer.authorize(request);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            String message = StringUtils.isNotBlank((CharSequence)result.getExplanation()) ? result.getExplanation() : "Access is denied";
            throw new AccessDeniedException(message);
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the details about this NiFi necessary to communicate via site to site", response=ControllerEntity.class, authorizations={@Authorization(value="Read - /site-to-site", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getSiteToSiteDetails(@Context HttpServletRequest req) {
        this.authorizeSiteToSite();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerDTO controller = this.serviceFacade.getSiteToSiteDetails();
        ControllerEntity entity = new ControllerEntity();
        entity.setController(controller);
        if (StringUtils.isEmpty((CharSequence)req.getHeader("x-nifi-site-to-site-protocol-version"))) {
            logger.debug("Converting result to provide backward compatibility...");
            controller.setRemoteSiteHttpListeningPort(null);
        }
        return this.clusterContext(this.noCache(Response.ok((Object)entity))).build();
    }

    @GET
    @Path(value="/peers")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Returns the available Peers and its status of this NiFi", response=PeersEntity.class, authorizations={@Authorization(value="Read - /site-to-site", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPeers(@Context HttpServletRequest req) {
        Integer transportProtocolVersion;
        this.authorizeSiteToSite();
        if (!this.properties.isSiteToSiteHttpEnabled().booleanValue()) {
            return this.responseCreator.httpSiteToSiteIsNotEnabledResponse();
        }
        try {
            transportProtocolVersion = this.negotiateTransportProtocolVersion(req, this.transportProtocolVersionNegotiator);
        }
        catch (BadRequestException e) {
            return this.responseCreator.badRequestResponse((Exception)((Object)e));
        }
        ArrayList<PeerDTO> peers = new ArrayList<PeerDTO>();
        if (this.properties.isNode()) {
            Set nodeIds = this.clusterCoordinator.getNodeIdentifiers(new NodeConnectionState[]{NodeConnectionState.CONNECTED});
            for (NodeIdentifier nodeId : nodeIds) {
                PeerDTO peer = new PeerDTO();
                String siteToSiteAddress = nodeId.getSiteToSiteAddress();
                peer.setHostname(siteToSiteAddress == null ? nodeId.getApiAddress() : siteToSiteAddress);
                peer.setPort(nodeId.getSiteToSiteHttpApiPort() == null ? nodeId.getApiPort() : nodeId.getSiteToSiteHttpApiPort().intValue());
                peer.setSecure(nodeId.isSiteToSiteSecure());
                peer.setFlowFileCount(0);
                peers.add(peer);
            }
        } else {
            String localName;
            PeerDTO peer = new PeerDTO();
            String remoteInputHost = this.properties.getRemoteInputHost();
            try {
                localName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to get local host name using InetAddress.", (Throwable)e);
                }
                localName = req.getLocalName();
            }
            peer.setHostname(StringUtils.isEmpty((CharSequence)remoteInputHost) ? localName : remoteInputHost);
            peer.setPort(this.properties.getRemoteInputHttpPort().intValue());
            peer.setSecure(this.properties.isSiteToSiteSecure().booleanValue());
            peer.setFlowFileCount(0);
            peers.add(peer);
        }
        PeersEntity entity = new PeersEntity();
        entity.setPeers(peers);
        return this.clusterContext(this.noCache(this.setCommonHeaders(Response.ok((Object)entity), transportProtocolVersion, this.transactionManager))).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        super.setClusterCoordinator(clusterCoordinator);
        this.clusterCoordinator = clusterCoordinator;
    }
}

