/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/output-ports")
@Api(value="/output-ports", description="Endpoint for managing an Output Port.")
public class OutputPortResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<PortEntity> populateRemainingOutputPortEntitiesContent(Set<PortEntity> outputPortEntities) {
        for (PortEntity outputPortEntity : outputPortEntities) {
            this.populateRemainingOutputPortEntityContent(outputPortEntity);
        }
        return outputPortEntities;
    }

    public PortEntity populateRemainingOutputPortEntityContent(PortEntity outputPortEntity) {
        outputPortEntity.setUri(this.generateResourceUri(new String[]{"output-ports", outputPortEntity.getId()}));
        return outputPortEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets an output port", response=PortEntity.class, authorizations={@Authorization(value="Read - /output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputPort(@ApiParam(value="The output port id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable outputPort = lookup.getOutputPort(id);
            outputPort.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PortEntity entity = this.serviceFacade.getOutputPort(id);
        this.populateRemainingOutputPortEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates an output port", response=PortEntity.class, authorizations={@Authorization(value="Write - /output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The output port id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The output port configuration details.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Output port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        PortDTO requestPortDTO = requestPortEntity.getComponent();
        if (!id.equals(requestPortDTO.getId())) {
            throw new IllegalArgumentException(String.format("The output port id (%s) in the request body does not equal the output port id of the requested resource (%s).", requestPortDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestPortEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getOutputPort(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateOutputPort(requestPortDTO), (revision, portEntity) -> {
            PortDTO portDTO = portEntity.getComponent();
            PortEntity entity = this.serviceFacade.updateOutputPort(revision, portDTO);
            this.populateRemainingOutputPortEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes an output port", response=PortEntity.class, authorizations={@Authorization(value="Write - /output-ports/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The output port id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        PortEntity requestPortEntity = new PortEntity();
        requestPortEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, requestRevision, lookup -> {
            Authorizable outputPort = lookup.getOutputPort(id);
            outputPort.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteOutputPort(id), (revision, portEntity) -> {
            PortEntity entity = this.serviceFacade.deleteOutputPort(revision, portEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

