/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.FlowFileQueueResource;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowFileEntity;
import org.apache.nifi.web.api.entity.ListingRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;

@Path(value="/flowfile-queues")
@Api(value="/flowfile-queues", description="Endpoint for managing a FlowFile Queue.")
public class FlowFileQueueResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public ListingRequestDTO populateRemainingFlowFileListingContent(String connectionId, ListingRequestDTO flowFileListing) {
        flowFileListing.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "listing-requests", flowFileListing.getId()}));
        if (flowFileListing.getFlowFileSummaries() != null) {
            for (FlowFileSummaryDTO flowFile : flowFileListing.getFlowFileSummaries()) {
                this.populateRemainingFlowFileContent(connectionId, flowFile);
            }
        }
        return flowFileListing;
    }

    public FlowFileSummaryDTO populateRemainingFlowFileContent(String connectionId, FlowFileSummaryDTO flowFile) {
        flowFile.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "flowfiles", flowFile.getUuid()}));
        return flowFile;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/flowfiles/{flowfile-uuid}")
    @ApiOperation(value="Gets a FlowFile from a Connection.", authorizations={@Authorization(value="Read Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlowFile(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The flowfile uuid.", required=true) @PathParam(value="flowfile-uuid") String flowFileUuid, @ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        FlowFileDTO flowfileDto = this.serviceFacade.getFlowFile(connectionId, flowFileUuid);
        this.populateRemainingFlowFileContent(connectionId, (FlowFileSummaryDTO)flowfileDto);
        FlowFileEntity entity = new FlowFileEntity();
        entity.setFlowFile(flowfileDto);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/flowfiles/{flowfile-uuid}/content")
    @ApiOperation(value="Gets the content for a FlowFile in a Connection.", authorizations={@Authorization(value="Read Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response downloadFlowFileContent(@ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The flowfile uuid.", required=true) @PathParam(value="flowfile-uuid") String flowFileUuid, @ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        String uri = this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "flowfiles", flowFileUuid, "content"});
        DownloadableContent content = this.serviceFacade.getContent(connectionId, flowFileUuid, uri);
        1 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests")
    @ApiOperation(value="Lists the contents of the queue in this connection.", response=ListingRequestEntity.class, authorizations={@Authorization(value="Read Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=202, message="The request has been accepted. A HTTP response header will contain the URI where the response can be polled."), @ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createFlowFileListing(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyListQueue(id), connectionEntity -> {
            String listingRequestId = this.generateUuid();
            ListingRequestDTO listingRequest = this.serviceFacade.createFlowFileListingRequest(connectionEntity.getId(), listingRequestId);
            this.populateRemainingFlowFileListingContent(connectionEntity.getId(), listingRequest);
            ListingRequestEntity entity = new ListingRequestEntity();
            entity.setListingRequest(listingRequest);
            URI location = URI.create(listingRequest.getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests/{listing-request-id}")
    @ApiOperation(value="Gets the current status of a listing request for the specified connection.", response=ListingRequestEntity.class, authorizations={@Authorization(value="Read Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getListingRequest(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The listing request id.", required=true) @PathParam(value="listing-request-id") String listingRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ListingRequestDTO listingRequest = this.serviceFacade.getFlowFileListingRequest(connectionId, listingRequestId);
        this.populateRemainingFlowFileListingContent(connectionId, listingRequest);
        ListingRequestEntity entity = new ListingRequestEntity();
        entity.setListingRequest(listingRequest);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests/{listing-request-id}")
    @ApiOperation(value="Cancels and/or removes a request to list the contents of this connection.", response=DropRequestEntity.class, authorizations={@Authorization(value="Read Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteListingRequest(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The listing request id.", required=true) @PathParam(value="listing-request-id") String listingRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new ListingEntity(connectionId, listingRequestId), lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, null, listingEntity -> {
            ListingRequestDTO listingRequest = this.serviceFacade.deleteFlowFileListingRequest(listingEntity.getConnectionId(), listingEntity.getListingRequestId());
            listingRequest.setFlowFileSummaries(null);
            this.populateRemainingFlowFileListingContent(listingEntity.getConnectionId(), listingRequest);
            ListingRequestEntity entity = new ListingRequestEntity();
            entity.setListingRequest(listingRequest);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests")
    @ApiOperation(value="Creates a request to drop the contents of the queue in this connection.", response=DropRequestEntity.class, authorizations={@Authorization(value="Write Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=202, message="The request has been accepted. A HTTP response header will contain the URI where the response can be polled."), @ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createDropRequest(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, connectionEntity -> {
            String dropRequestId = this.generateUuid();
            DropRequestDTO dropRequest = this.serviceFacade.createFlowFileDropRequest(connectionEntity.getId(), dropRequestId);
            dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionEntity.getId(), "drop-requests", dropRequest.getId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            URI location = URI.create(dropRequest.getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests/{drop-request-id}")
    @ApiOperation(value="Gets the current status of a drop request for the specified connection.", response=DropRequestEntity.class, authorizations={@Authorization(value="Write Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getDropRequest(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        DropRequestDTO dropRequest = this.serviceFacade.getFlowFileDropRequest(connectionId, dropRequestId);
        dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "drop-requests", dropRequestId}));
        DropRequestEntity entity = new DropRequestEntity();
        entity.setDropRequest(dropRequest);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests/{drop-request-id}")
    @ApiOperation(value="Cancels and/or removes a request to drop the contents of this connection.", response=DropRequestEntity.class, authorizations={@Authorization(value="Write Source Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeDropRequest(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String connectionId, @ApiParam(value="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new DropEntity(connectionId, dropRequestId), lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = lookup.getData(connAuth.getSource().getIdentifier());
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, dropEntity -> {
            DropRequestDTO dropRequest = this.serviceFacade.deleteFlowFileDropRequest(dropEntity.getConnectionId(), dropEntity.getDropRequestId());
            dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", dropEntity.getConnectionId(), "drop-requests", dropEntity.getDropRequestId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

