/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/connections")
@Api(value="/connections", description="Endpoint for managing a Connection.")
public class ConnectionResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<ConnectionEntity> populateRemainingConnectionEntitiesContent(Set<ConnectionEntity> connectionEntities) {
        for (ConnectionEntity connectionEntity : connectionEntities) {
            this.populateRemainingConnectionEntityContent(connectionEntity);
        }
        return connectionEntities;
    }

    public ConnectionEntity populateRemainingConnectionEntityContent(ConnectionEntity connectionEntity) {
        connectionEntity.setUri(this.generateResourceUri(new String[]{"connections", connectionEntity.getId()}));
        return connectionEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Gets a connection", response=ConnectionEntity.class, authorizations={@Authorization(value="Read Source - /{component-type}/{uuid}", type=""), @Authorization(value="Read Destination - /{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnection(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable authorizable = lookup.getConnection(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ConnectionEntity entity = this.serviceFacade.getConnection(id);
        this.populateRemainingConnectionEntityContent(entity);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Updates a connection", response=ConnectionEntity.class, authorizations={@Authorization(value="Write Source - /{component-type}/{uuid}", type=""), @Authorization(value="Write Destination - /{component-type}/{uuid}", type=""), @Authorization(value="Write New Destination - /{component-type}/{uuid} - if updating Destination", type=""), @Authorization(value="Write Process Group - /process-groups/{uuid} - if updating Destination", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateConnection(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The connection configuration details.", required=true) ConnectionEntity requestConnectionEntity) throws InterruptedException {
        if (requestConnectionEntity == null || requestConnectionEntity.getComponent() == null) {
            throw new IllegalArgumentException("Connection details must be specified.");
        }
        if (requestConnectionEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ConnectionDTO requestConnection = requestConnectionEntity.getComponent();
        if (!id.equals(requestConnection.getId())) {
            throw new IllegalArgumentException(String.format("The connection id (%s) in the request body does not equal the connection id of the requested resource (%s).", requestConnection.getId(), id));
        }
        if (requestConnection.getDestination() != null && requestConnection.getDestination().getId() == null) {
            throw new IllegalArgumentException("When specifying a destination component, the destination id is required.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestConnectionEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestConnectionEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, requestRevision, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            connAuth.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Connectable currentDestination = connAuth.getDestination();
            if (requestConnection.getDestination() != null && currentDestination.getIdentifier().equals(requestConnection.getDestination().getId())) {
                Authorizable newDestinationAuthorizable = lookup.getConnectable(requestConnection.getDestination().getId());
                newDestinationAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
                connAuth.getParentGroup().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyUpdateConnection(requestConnection), (revision, connectionEntity) -> {
            ConnectionDTO connection = connectionEntity.getComponent();
            ConnectionEntity entity = this.serviceFacade.updateConnection(revision, connection);
            this.populateRemainingConnectionEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Deletes a connection", response=ConnectionEntity.class, authorizations={@Authorization(value="Write Source - /{component-type}/{uuid}", type=""), @Authorization(value="Write Destination - /{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteConnection(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        Long clientVersion = version == null ? null : version.getLong();
        Revision requestRevision = new Revision(clientVersion, clientId.getClientId(), id);
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getConnection(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteConnection(id), (revision, connectionEntity) -> {
            ConnectionEntity entity = this.serviceFacade.deleteConnection(revision, connectionEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

