/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Map;
import java.util.Objects;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ControllerServiceReferencingComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.web.ResourceNotFoundException;

public final class AuthorizeControllerServiceReference {
    public static void authorizeControllerServiceReferences(Map<String, String> proposedProperties, ControllerServiceReferencingComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup) {
        if (proposedProperties != null) {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            for (Map.Entry<String, String> entry : proposedProperties.entrySet()) {
                String proposedValue;
                String currentValue;
                String propertyName = entry.getKey();
                PropertyDescriptor propertyDescriptor = authorizable.getPropertyDescriptor(propertyName);
                if (propertyDescriptor.getControllerServiceDefinition() == null || Objects.equals(currentValue = authorizable.getValue(propertyDescriptor), proposedValue = entry.getValue())) continue;
                if (currentValue != null) {
                    try {
                        Authorizable currentServiceAuthorizable = lookup.getControllerService(currentValue).getAuthorizable();
                        currentServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
                    }
                    catch (ResourceNotFoundException currentServiceAuthorizable) {
                        // empty catch block
                    }
                }
                if (proposedValue == null) continue;
                Authorizable newServiceAuthorizable = lookup.getControllerService(proposedValue).getAuthorizable();
                newServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
            }
        }
    }
}

