/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.timebuffer;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.util.timebuffer.EntityAccess;

public class TimedBuffer<T> {
    private final int numBins;
    private final EntitySum<T>[] bins;
    private final EntityAccess<T> entityAccess;
    private final TimeUnit binPrecision;

    public TimedBuffer(TimeUnit binPrecision, int numBins, EntityAccess<T> accessor) {
        this.binPrecision = binPrecision;
        this.numBins = numBins + 1;
        this.bins = new EntitySum[this.numBins];
        for (int i = 0; i < this.numBins; ++i) {
            this.bins[i] = new EntitySum<T>(binPrecision, numBins, accessor);
        }
        this.entityAccess = accessor;
    }

    public T add(T entity) {
        int binIdx = (int)(this.binPrecision.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS) % (long)this.numBins);
        EntitySum<T> sum = this.bins[binIdx];
        return sum.addOrReset(entity);
    }

    public T getAggregateValue(long sinceEpochMillis) {
        int startBinIdx = (int)(this.binPrecision.convert(sinceEpochMillis, TimeUnit.MILLISECONDS) % (long)this.numBins);
        Object total = null;
        for (int i = 0; i < this.numBins; ++i) {
            int binIdx = (startBinIdx + i) % this.numBins;
            EntitySum<T> bin = this.bins[binIdx];
            if (bin.isExpired()) continue;
            total = this.entityAccess.aggregate(total, bin.getValue());
        }
        return total;
    }

    private static class EntitySum<S> {
        private final EntityAccess<S> entityAccess;
        private final AtomicReference<S> ref = new AtomicReference();
        private final TimeUnit binPrecision;
        private final int numConfiguredBins;

        public EntitySum(TimeUnit binPrecision, int numConfiguredBins, EntityAccess<S> aggregator) {
            this.binPrecision = binPrecision;
            this.entityAccess = aggregator;
            this.numConfiguredBins = numConfiguredBins;
        }

        private S add(S event) {
            S newValue;
            S value;
            while (!this.ref.compareAndSet(value = this.ref.get(), newValue = this.entityAccess.aggregate(value, event))) {
            }
            return newValue;
        }

        public S getValue() {
            return this.ref.get();
        }

        public boolean isExpired() {
            long maxExpectedTimePeriod = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(this.numConfiguredBins, this.binPrecision);
            S curValue = this.ref.get();
            return this.entityAccess.getTimestamp(curValue) < maxExpectedTimePeriod;
        }

        public S addOrReset(S event) {
            long maxExpectedTimePeriod = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, this.binPrecision);
            S curValue = this.ref.get();
            if (this.entityAccess.getTimestamp(curValue) < maxExpectedTimePeriod) {
                this.ref.compareAndSet(curValue, this.entityAccess.createNew());
            }
            return this.add(event);
        }
    }
}

