/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.update.attributes.serde;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.nifi.security.xml.XmlUtils;
import org.apache.nifi.update.attributes.Criteria;
import org.apache.nifi.update.attributes.FlowFilePolicy;
import org.apache.nifi.update.attributes.Rule;

public class CriteriaSerDe {
    private static final JAXBContext JAXB_CONTEXT;

    public static String serialize(Criteria criteria) {
        StringWriter writer = new StringWriter();
        try {
            CriteriaBinding binding = new CriteriaBinding();
            binding.setFlowFilePolicy(criteria.getFlowFilePolicy());
            binding.setRules(criteria.getRules());
            Marshaller marshaller = JAXB_CONTEXT.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)binding, (Writer)writer);
        }
        catch (JAXBException jaxbe) {
            throw new IllegalArgumentException(jaxbe);
        }
        return writer.toString();
    }

    public static Criteria deserialize(String string) {
        Criteria criteria = null;
        if (string != null && !string.trim().equals("")) {
            try {
                Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
                XMLStreamReader xsr = XmlUtils.createSafeReader((InputStream)new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)));
                JAXBElement element = unmarshaller.unmarshal(xsr, CriteriaBinding.class);
                CriteriaBinding binding = (CriteriaBinding)element.getValue();
                criteria = new Criteria(binding.getFlowFilePolicy(), binding.getRules());
            }
            catch (JAXBException | XMLStreamException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return criteria;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{CriteriaBinding.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Could not create JAXB Context for UpdateAttribute", e);
        }
    }

    @XmlRootElement(name="criteria")
    private static class CriteriaBinding {
        private List<Rule> rules = null;
        private FlowFilePolicy flowFilePolicy = FlowFilePolicy.USE_CLONE;

        private CriteriaBinding() {
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public void setRules(List<Rule> rules) {
            this.rules = rules;
        }

        public FlowFilePolicy getFlowFilePolicy() {
            return this.flowFilePolicy;
        }

        public void setFlowFilePolicy(FlowFilePolicy flowFilePolicy) {
            this.flowFilePolicy = flowFilePolicy;
        }
    }
}

