/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.FlowRegistryBucketDTO;
import org.apache.nifi.web.api.entity.FlowRegistryBucketsEntity;

public class RegistryBucketsResult
extends AbstractWritableResult<FlowRegistryBucketsEntity> {
    final FlowRegistryBucketsEntity bucketsEntity;

    public RegistryBucketsResult(ResultType resultType, FlowRegistryBucketsEntity bucketsEntity) {
        super(resultType);
        this.bucketsEntity = Objects.requireNonNull(bucketsEntity);
    }

    @Override
    public FlowRegistryBucketsEntity getResult() {
        return this.bucketsEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        Set buckets = this.bucketsEntity.getBuckets();
        if (buckets == null || buckets.isEmpty()) {
            return;
        }
        List<FlowRegistryBucketDTO> bucketsDTO = buckets.stream().map(b -> b.getBucket()).sorted(Comparator.comparing(FlowRegistryBucketDTO::getName)).toList();
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Description", 11, 40, true).build();
        for (int i = 0; i < bucketsDTO.size(); ++i) {
            FlowRegistryBucketDTO bucket = bucketsDTO.get(i);
            table.addRow("" + (i + 1), bucket.getName(), bucket.getId(), bucket.getDescription() == null ? "" : bucket.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

