/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.tenant;

import com.opencsv.CSVParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.registry.authorization.Tenant;

public final class TenantHelper {
    private TenantHelper() {
    }

    public static <T extends Tenant> Set<Tenant> selectExistingTenants(String names, String ids, List<T> allTenants) throws IOException {
        CSVParser csvParser = new CSVParser();
        HashSet<String> nameSet = new HashSet<String>(Arrays.asList(csvParser.parseLine(Optional.ofNullable(names).orElse(""))));
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(csvParser.parseLine(Optional.ofNullable(ids).orElse(""))));
        Set<Tenant> existingTenants = allTenants.stream().filter(tenant -> nameSet.contains(tenant.getIdentity()) || idSet.contains(tenant.getIdentifier())).collect(Collectors.toSet());
        return existingTenants;
    }
}

