/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.pg;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessGroupClient;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;
import org.apache.nifi.web.api.entity.DropRequestEntity;

public class PGEmptyQueues
extends AbstractNiFiCommand<VoidResult> {
    public static final int MAX_ITERATIONS = 20;
    public static final long DELAY_MS = 1000L;

    public PGEmptyQueues() {
        super("pg-empty-queues", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Empty all queues, recursively, in the specified Process Group. It is recommended to first use pg-stop.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.PG_ID.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException {
        String pgId = this.getRequiredArg(properties, CommandOption.PG_ID);
        ProcessGroupClient pgClient = client.getProcessGroupClient();
        DropRequestEntity requestEntity = pgClient.emptyQueues(pgId);
        String requestId = requestEntity.getDropRequest().getId();
        for (int iterations = 1; !requestEntity.getDropRequest().isFinished().booleanValue() && iterations < 20; ++iterations) {
            if (this.shouldPrint(properties)) {
                this.println("Emptying queues, currently at " + requestEntity.getDropRequest().getPercentCompleted() + "% (" + iterations + " of 20)...");
            }
            this.sleep(1000L);
            requestEntity = pgClient.getEmptyQueuesRequest(pgId, requestId);
        }
        if (this.shouldPrint(properties)) {
            if (requestEntity.getDropRequest().isFinished().booleanValue()) {
                this.println("Drop request completed. Deleted: " + requestEntity.getDropRequest().getDropped());
            } else {
                this.println("Drop request didn't complete yet. Thus far, deleted: " + requestEntity.getDropRequest().getDropped());
            }
        }
        return VoidResult.getInstance();
    }

    private boolean shouldPrint(Properties properties) {
        return this.isInteractive() || this.isVerbose(properties);
    }

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

