/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.ReferenceResolver;
import org.apache.nifi.toolkit.cli.api.Referenceable;
import org.apache.nifi.toolkit.cli.api.ResolvedReference;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class VersionedFlowsResult
extends AbstractWritableResult<List<VersionedFlow>>
implements Referenceable {
    private final List<VersionedFlow> versionedFlows;

    public VersionedFlowsResult(ResultType resultType, List<VersionedFlow> flows) {
        super(resultType);
        this.versionedFlows = flows;
        Validate.notNull(this.versionedFlows);
        this.versionedFlows.sort(Comparator.comparing(BucketItem::getName));
    }

    @Override
    public List<VersionedFlow> getResult() {
        return this.versionedFlows;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.versionedFlows.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Description", 11, 40, true).build();
        for (int i = 0; i < this.versionedFlows.size(); ++i) {
            VersionedFlow flow = this.versionedFlows.get(i);
            table.addRow(String.valueOf(i + 1), flow.getName(), flow.getIdentifier(), flow.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ReferenceResolver createReferenceResolver(Context context) {
        final HashMap backRefs = new HashMap();
        AtomicInteger position = new AtomicInteger(0);
        this.versionedFlows.forEach(f -> backRefs.put(position.incrementAndGet(), f));
        return new ReferenceResolver(){

            @Override
            public ResolvedReference resolve(CommandOption option, Integer position) {
                VersionedFlow versionedFlow = (VersionedFlow)backRefs.get(position);
                if (versionedFlow != null) {
                    if (option != null && option == CommandOption.BUCKET_ID) {
                        return new ResolvedReference(option, position, versionedFlow.getBucketName(), versionedFlow.getBucketIdentifier());
                    }
                    return new ResolvedReference(option, position, versionedFlow.getName(), versionedFlow.getIdentifier());
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return backRefs.isEmpty();
            }
        };
    }
}

