/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.Command;
import org.apache.nifi.toolkit.cli.api.CommandGroup;
import org.apache.nifi.toolkit.cli.api.Context;

public abstract class AbstractCommandGroup
implements CommandGroup {
    private final String name;
    private PrintStream output;
    private List<Command> commands;

    public AbstractCommandGroup(String name) {
        this.name = name;
        Validate.notBlank((CharSequence)this.name);
    }

    @Override
    public final void initialize(Context context) {
        Validate.notNull((Object)context);
        this.output = context.getOutput();
        this.commands = Collections.unmodifiableList(this.createCommands());
        this.commands.stream().forEach(c -> c.initialize(context));
    }

    protected abstract List<Command> createCommands();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Command> getCommands() {
        return this.commands;
    }

    @Override
    public void printUsage(boolean verbose) {
        if (verbose) {
            PrintWriter printWriter = new PrintWriter(this.output);
            int width = 80;
            HelpFormatter hf = new HelpFormatter();
            hf.setWidth(80);
            this.commands.stream().forEach(c -> {
                hf.printWrapped(printWriter, 80, "-------------------------------------------------------------------------------");
                hf.printWrapped(printWriter, 80, "COMMAND: " + this.getName() + " " + c.getName());
                hf.printWrapped(printWriter, 80, "");
                hf.printWrapped(printWriter, 80, "- " + c.getDescription());
                hf.printWrapped(printWriter, 80, "");
                if (c.isReferencable()) {
                    hf.printWrapped(printWriter, 80, "PRODUCES BACK-REFERENCES");
                    hf.printWrapped(printWriter, 80, "");
                }
            });
            printWriter.flush();
        } else {
            this.commands.stream().forEach(c -> this.output.println("\t" + this.getName() + " " + c.getName()));
        }
        this.output.flush();
    }
}

