/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client.nifi.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.impl.client.nifi.NiFiClientException;
import org.apache.nifi.toolkit.cli.impl.client.nifi.ProcessorClient;
import org.apache.nifi.toolkit.cli.impl.client.nifi.impl.AbstractJerseyClient;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusEntity;

public class JerseyProcessorClient
extends AbstractJerseyClient
implements ProcessorClient {
    private final WebTarget processGroupTarget;
    private final WebTarget processorTarget;

    public JerseyProcessorClient(WebTarget baseTarget) {
        this(baseTarget, Collections.emptyMap());
    }

    public JerseyProcessorClient(WebTarget baseTarget, Map<String, String> headers) {
        super(headers);
        this.processGroupTarget = baseTarget.path("/process-groups/{pgId}");
        this.processorTarget = baseTarget.path("/processors/{id}");
    }

    @Override
    public ProcessorEntity createProcessor(String parentGroupdId, ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)parentGroupdId)) {
            throw new IllegalArgumentException("Parent process group id cannot be null or blank");
        }
        if (processorEntity == null) {
            throw new IllegalArgumentException("Processor entity cannot be null");
        }
        return this.executeAction("Error creating Processor", () -> {
            WebTarget target = this.processGroupTarget.path("/processors").resolveTemplate("pgId", (Object)parentGroupdId);
            return (ProcessorEntity)this.getRequestBuilder(target).post(Entity.entity((Object)processorEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity getProcessor(String processorId) throws NiFiClientException, IOException {
        if (StringUtils.isBlank((CharSequence)processorId)) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error retrieving status of Processor", () -> {
            WebTarget target = this.processorTarget.resolveTemplate("id", (Object)processorId);
            return (ProcessorEntity)this.getRequestBuilder(target).get(ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity updateProcessor(ProcessorEntity entity) throws NiFiClientException, IOException {
        if (entity == null) {
            throw new IllegalArgumentException("Processor entity cannot be null");
        }
        return this.executeAction("Error updating Processor", () -> {
            WebTarget target = this.processorTarget.resolveTemplate("id", (Object)entity.getId());
            return (ProcessorEntity)this.getRequestBuilder(target).put(Entity.entity((Object)entity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity startProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "RUNNING", clientId, version);
    }

    @Override
    public ProcessorEntity startProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.startProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    @Override
    public ProcessorEntity stopProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "STOPPED", clientId, version);
    }

    @Override
    public ProcessorEntity stopProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.stopProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    @Override
    public ProcessorEntity disableProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        return this.updateProcessorState(processorId, "DISABLED", clientId, version);
    }

    @Override
    public ProcessorEntity disableProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.disableProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    @Override
    public ProcessorEntity deleteProcessor(String processorId, String clientId, long version) throws NiFiClientException, IOException {
        if (processorId == null) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error deleting Processor", () -> {
            WebTarget target = this.processorTarget.queryParam("version", new Object[]{version}).queryParam("clientId", new Object[]{clientId}).resolveTemplate("id", (Object)processorId);
            return (ProcessorEntity)this.getRequestBuilder(target).delete(ProcessorEntity.class);
        });
    }

    @Override
    public ProcessorEntity deleteProcessor(ProcessorEntity processorEntity) throws NiFiClientException, IOException {
        return this.deleteProcessor(processorEntity.getId(), processorEntity.getRevision().getClientId(), processorEntity.getRevision().getVersion());
    }

    private ProcessorEntity updateProcessorState(String processorId, String desiredState, String clientId, long version) throws NiFiClientException, IOException {
        if (processorId == null) {
            throw new IllegalArgumentException("Processor ID cannot be null");
        }
        return this.executeAction("Error starting Processor", () -> {
            WebTarget target = this.processorTarget.path("/run-status").resolveTemplate("id", (Object)processorId);
            ProcessorRunStatusEntity runStatusEntity = new ProcessorRunStatusEntity();
            runStatusEntity.setState(desiredState);
            RevisionDTO revisionDto = new RevisionDTO();
            revisionDto.setClientId(clientId);
            revisionDto.setVersion(Long.valueOf(version));
            runStatusEntity.setRevision(revisionDto);
            return (ProcessorEntity)this.getRequestBuilder(target).put(Entity.entity((Object)runStatusEntity, (MediaType)MediaType.APPLICATION_JSON_TYPE), ProcessorEntity.class);
        });
    }
}

