/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.toolkit.cli.api.Session;
import org.apache.nifi.toolkit.cli.api.SessionException;

public class PersistentSession
implements Session {
    private final File persistenceFile;
    private final Session wrappedSession;

    public PersistentSession(File persistenceFile, Session wrappedSession) {
        this.persistenceFile = persistenceFile;
        this.wrappedSession = wrappedSession;
        Validate.notNull((Object)persistenceFile);
        Validate.notNull((Object)wrappedSession);
    }

    @Override
    public String getNiFiClientID() {
        return this.wrappedSession.getNiFiClientID();
    }

    @Override
    public synchronized void set(String variable, String value) throws SessionException {
        this.wrappedSession.set(variable, value);
        this.saveSession();
    }

    @Override
    public synchronized String get(String variable) throws SessionException {
        return this.wrappedSession.get(variable);
    }

    @Override
    public synchronized void remove(String variable) throws SessionException {
        this.wrappedSession.remove(variable);
        this.saveSession();
    }

    @Override
    public synchronized void clear() throws SessionException {
        this.wrappedSession.clear();
        this.saveSession();
    }

    @Override
    public synchronized Set<String> keys() throws SessionException {
        return this.wrappedSession.keys();
    }

    @Override
    public synchronized void printVariables(PrintStream output) throws SessionException {
        this.wrappedSession.printVariables(output);
    }

    private void saveSession() throws SessionException {
        try (FileOutputStream out = new FileOutputStream(this.persistenceFile);){
            Properties properties = new Properties();
            for (String variable : this.wrappedSession.keys()) {
                String value = this.wrappedSession.get(variable);
                properties.setProperty(variable, value);
            }
            properties.store(out, null);
            out.flush();
        }
        catch (Exception e) {
            throw new SessionException("Error saving session: " + e.getMessage(), e);
        }
    }

    public synchronized void loadSession() throws SessionException {
        this.wrappedSession.clear();
        try (FileInputStream in = new FileInputStream(this.persistenceFile);){
            Properties properties = new Properties();
            properties.load(in);
            for (String propName : properties.stringPropertyNames()) {
                String propValue = properties.getProperty(propName);
                this.wrappedSession.set(propName, propValue);
            }
        }
        catch (Exception e) {
            throw new SessionException("Error loading session: " + e.getMessage(), e);
        }
    }
}

