/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.diff.ComponentDifference;
import org.apache.nifi.registry.diff.ComponentDifferenceGroup;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class VersionedFlowDifferenceResult
extends AbstractWritableResult<VersionedFlowDifference> {
    private final VersionedFlowDifference flowDifference;

    public VersionedFlowDifferenceResult(ResultType resultType, VersionedFlowDifference flowDifference) {
        super(resultType);
        this.flowDifference = (VersionedFlowDifference)Validate.notNull((Object)flowDifference);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Table table = new Table.Builder().column("#", 3, 3, false).column("Component Name", 20, 40, false).column("Change Type", 20, 40, true).column("Difference", 40, 60, true).build();
        ArrayList differenceGroups = new ArrayList(this.flowDifference.getComponentDifferenceGroups() == null ? Collections.emptyList() : this.flowDifference.getComponentDifferenceGroups());
        differenceGroups.sort(Comparator.comparing(ComponentDifferenceGroup::getComponentName));
        int differenceCount = 1;
        for (ComponentDifferenceGroup differenceGroup : differenceGroups) {
            String componentName = differenceGroup.getComponentName();
            ArrayList<ComponentDifference> componentDifferences = new ArrayList<ComponentDifference>(differenceGroup.getDifferences());
            componentDifferences.sort(Comparator.comparing(ComponentDifference::getDifferenceType));
            for (ComponentDifference componentDifference : componentDifferences) {
                String changeType = componentDifference.getDifferenceType();
                String changeDescription = componentDifference.getChangeDescription();
                table.addRow(String.valueOf(differenceCount++), componentName, changeType, changeDescription);
            }
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public VersionedFlowDifference getResult() {
        return this.flowDifference;
    }
}

